import java.lang
import java.util
import java.util.concurrent
import typing



_Op__V = typing.TypeVar('_Op__V')  # <V>
class Op(typing.Generic[_Op__V]):
    def eval(self) -> _Op__V: ...
    def getSources(self) -> java.util.List['Op'[typing.Any]]: ...
    def newKey(self) -> 'OpCache.Key'[_Op__V]: ...
    def update(self) -> None: ...

_OpCache__Key__V = typing.TypeVar('_OpCache__Key__V')  # <V>
class OpCache:
    def __init__(self): ...
    def clear(self) -> None: ...
    _get_0__V = typing.TypeVar('_get_0__V')  # <V>
    _get_1__V = typing.TypeVar('_get_1__V')  # <V>
    @typing.overload
    def get(self, key: 'OpCache.Key'[_get_0__V]) -> _get_0__V: ...
    @typing.overload
    def get(self, key: 'OpCache.Key'[_get_1__V], opObserver: 'OpObserver'[_get_1__V]) -> _get_1__V: ...
    _getFuture__V = typing.TypeVar('_getFuture__V')  # <V>
    def getFuture(self, key: 'OpCache.Key'[_getFuture__V], opObserver: 'OpObserver'[_getFuture__V]) -> java.util.concurrent.Future[_getFuture__V]: ...
    _getIfDone__V = typing.TypeVar('_getIfDone__V')  # <V>
    def getIfDone(self, key: 'OpCache.Key'[_getIfDone__V]) -> _getIfDone__V: ...
    class Key(typing.Generic[_OpCache__Key__V]):
        op: Op = ...
        version: int = ...
        deps: java.util.List = ...
        def __init__(self, op: Op[_OpCache__Key__V], int: int): ...
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...

class OpFailedException(java.lang.Exception):
    def __init__(self): ...

_OpObserver__V = typing.TypeVar('_OpObserver__V')  # <V>
class OpObserver(typing.Generic[_OpObserver__V]):
    def cancelled(self, op: Op[_OpObserver__V], cancellationException: java.util.concurrent.CancellationException) -> None: ...
    def failed(self, op: Op[_OpObserver__V], executionException: java.util.concurrent.ExecutionException) -> None: ...
    def interrupted(self, op: Op[_OpObserver__V], interruptedException: java.lang.InterruptedException) -> None: ...
    def succeeded(self, op: Op[_OpObserver__V], v: _OpObserver__V) -> None: ...

_AbstractOpImpl__V = typing.TypeVar('_AbstractOpImpl__V')  # <V>
class AbstractOpImpl(Op[_AbstractOpImpl__V], typing.Generic[_AbstractOpImpl__V]):
    def __init__(self, opCache: OpCache): ...
    def eval(self) -> _AbstractOpImpl__V: ...
    @typing.overload
    def get(self) -> _AbstractOpImpl__V: ...
    @typing.overload
    def get(self, opObserver: OpObserver[_AbstractOpImpl__V]) -> _AbstractOpImpl__V: ...
    def getFuture(self, opObserver: OpObserver[_AbstractOpImpl__V]) -> java.util.concurrent.Future[_AbstractOpImpl__V]: ...
    def getSources(self) -> java.util.List[Op[typing.Any]]: ...
    def newKey(self) -> OpCache.Key[_AbstractOpImpl__V]: ...
    def update(self) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("VASSAL.tools.opcache")``.

    AbstractOpImpl: typing.Type[AbstractOpImpl]
    Op: typing.Type[Op]
    OpCache: typing.Type[OpCache]
    OpFailedException: typing.Type[OpFailedException]
    OpObserver: typing.Type[OpObserver]
