import datetime
import java.io
import java.lang
import java.time.chrono
import java.time.format
import java.time.temporal
import java.time.zone
import java.util
import java.util.stream
import typing



class Clock:
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def fixed(instant: typing.Union['Instant', datetime.datetime], zoneId: 'ZoneId') -> 'Clock': ...
    def getZone(self) -> 'ZoneId': ...
    def hashCode(self) -> int: ...
    def instant(self) -> 'Instant': ...
    def millis(self) -> int: ...
    @staticmethod
    def offset(clock: 'Clock', duration: 'Duration') -> 'Clock': ...
    @staticmethod
    def system(zoneId: 'ZoneId') -> 'Clock': ...
    @staticmethod
    def systemDefaultZone() -> 'Clock': ...
    @staticmethod
    def systemUTC() -> 'Clock': ...
    @staticmethod
    def tick(clock: 'Clock', duration: 'Duration') -> 'Clock': ...
    @staticmethod
    def tickMillis(zoneId: 'ZoneId') -> 'Clock': ...
    @staticmethod
    def tickMinutes(zoneId: 'ZoneId') -> 'Clock': ...
    @staticmethod
    def tickSeconds(zoneId: 'ZoneId') -> 'Clock': ...
    def withZone(self, zoneId: 'ZoneId') -> 'Clock': ...

class DateTimeException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class DayOfWeek(java.lang.Enum['DayOfWeek'], java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster):
    MONDAY: typing.ClassVar['DayOfWeek'] = ...
    TUESDAY: typing.ClassVar['DayOfWeek'] = ...
    WEDNESDAY: typing.ClassVar['DayOfWeek'] = ...
    THURSDAY: typing.ClassVar['DayOfWeek'] = ...
    FRIDAY: typing.ClassVar['DayOfWeek'] = ...
    SATURDAY: typing.ClassVar['DayOfWeek'] = ...
    SUNDAY: typing.ClassVar['DayOfWeek'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    def minus(self, long: int) -> 'DayOfWeek': ...
    @staticmethod
    def of(int: int) -> 'DayOfWeek': ...
    def plus(self, long: int) -> 'DayOfWeek': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'DayOfWeek': ...
    @staticmethod
    def values() -> typing.List['DayOfWeek']: ...

class Duration(java.time.temporal.TemporalAmount, java.lang.Comparable['Duration'], java.io.Serializable):
    ZERO: typing.ClassVar['Duration'] = ...
    def abs(self) -> 'Duration': ...
    def addTo(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @staticmethod
    def between(temporal: java.time.temporal.Temporal, temporal2: java.time.temporal.Temporal) -> 'Duration': ...
    def compareTo(self, duration: 'Duration') -> int: ...
    @typing.overload
    def dividedBy(self, long: int) -> 'Duration': ...
    @typing.overload
    def dividedBy(self, duration: 'Duration') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def get(self, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def getNano(self) -> int: ...
    def getSeconds(self) -> int: ...
    def getUnits(self) -> java.util.List[java.time.temporal.TemporalUnit]: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    @typing.overload
    def minus(self, duration: 'Duration') -> 'Duration': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    def minusDays(self, long: int) -> 'Duration': ...
    def minusHours(self, long: int) -> 'Duration': ...
    def minusMillis(self, long: int) -> 'Duration': ...
    def minusMinutes(self, long: int) -> 'Duration': ...
    def minusNanos(self, long: int) -> 'Duration': ...
    def minusSeconds(self, long: int) -> 'Duration': ...
    def multipliedBy(self, long: int) -> 'Duration': ...
    def negated(self) -> 'Duration': ...
    @staticmethod
    def of(long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    @staticmethod
    def ofDays(long: int) -> 'Duration': ...
    @staticmethod
    def ofHours(long: int) -> 'Duration': ...
    @staticmethod
    def ofMillis(long: int) -> 'Duration': ...
    @staticmethod
    def ofMinutes(long: int) -> 'Duration': ...
    @staticmethod
    def ofNanos(long: int) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def ofSeconds(long: int) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def ofSeconds(long: int, long2: int) -> 'Duration': ...
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'Duration': ...
    @typing.overload
    def plus(self, duration: 'Duration') -> 'Duration': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    def plusDays(self, long: int) -> 'Duration': ...
    def plusHours(self, long: int) -> 'Duration': ...
    def plusMillis(self, long: int) -> 'Duration': ...
    def plusMinutes(self, long: int) -> 'Duration': ...
    def plusNanos(self, long: int) -> 'Duration': ...
    def plusSeconds(self, long: int) -> 'Duration': ...
    def subtractFrom(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def toDays(self) -> int: ...
    def toDaysPart(self) -> int: ...
    def toHours(self) -> int: ...
    def toHoursPart(self) -> int: ...
    def toMillis(self) -> int: ...
    def toMillisPart(self) -> int: ...
    def toMinutes(self) -> int: ...
    def toMinutesPart(self) -> int: ...
    def toNanos(self) -> int: ...
    def toNanosPart(self) -> int: ...
    def toSeconds(self) -> int: ...
    def toSecondsPart(self) -> int: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    def withNanos(self, int: int) -> 'Duration': ...
    def withSeconds(self, long: int) -> 'Duration': ...

class Instant(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['Instant'], java.io.Serializable):
    EPOCH: typing.ClassVar['Instant'] = ...
    MIN: typing.ClassVar['Instant'] = ...
    MAX: typing.ClassVar['Instant'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atOffset(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def atZone(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    def compareTo(self, instant: typing.Union['Instant', datetime.datetime]) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getEpochSecond(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getNano(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, instant: typing.Union['Instant', datetime.datetime]) -> bool: ...
    def isBefore(self, instant: typing.Union['Instant', datetime.datetime]) -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Instant': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Instant': ...
    def minusMillis(self, long: int) -> 'Instant': ...
    def minusNanos(self, long: int) -> 'Instant': ...
    def minusSeconds(self, long: int) -> 'Instant': ...
    @typing.overload
    @staticmethod
    def now() -> 'Instant': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'Instant': ...
    @staticmethod
    def ofEpochMilli(long: int) -> 'Instant': ...
    @typing.overload
    @staticmethod
    def ofEpochSecond(long: int) -> 'Instant': ...
    @typing.overload
    @staticmethod
    def ofEpochSecond(long: int, long2: int) -> 'Instant': ...
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'Instant': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Instant': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Instant': ...
    def plusMillis(self, long: int) -> 'Instant': ...
    def plusNanos(self, long: int) -> 'Instant': ...
    def plusSeconds(self, long: int) -> 'Instant': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochMilli(self) -> int: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'Instant': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class LocalDate(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.time.chrono.ChronoLocalDate, java.io.Serializable):
    MIN: typing.ClassVar['LocalDate'] = ...
    MAX: typing.ClassVar['LocalDate'] = ...
    EPOCH: typing.ClassVar['LocalDate'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @typing.overload
    def atStartOfDay(self) -> 'LocalDateTime': ...
    @typing.overload
    def atStartOfDay(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    @typing.overload
    def atTime(self, int: int, int2: int) -> 'LocalDateTime': ...
    @typing.overload
    def atTime(self, int: int, int2: int, int3: int) -> 'LocalDateTime': ...
    @typing.overload
    def atTime(self, int: int, int2: int, int3: int, int4: int) -> 'LocalDateTime': ...
    @typing.overload
    def atTime(self, localTime: 'LocalTime') -> 'LocalDateTime': ...
    @typing.overload
    def atTime(self, offsetTime: 'OffsetTime') -> 'OffsetDateTime': ...
    def compareTo(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> int: ...
    @typing.overload
    def datesUntil(self, localDate: 'LocalDate') -> java.util.stream.Stream['LocalDate']: ...
    @typing.overload
    def datesUntil(self, localDate: 'LocalDate', period: 'Period') -> java.util.stream.Stream['LocalDate']: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getChronology(self) -> java.time.chrono.IsoChronology: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getEra(self) -> java.time.chrono.IsoEra: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMonth(self) -> 'Month': ...
    def getMonthValue(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> bool: ...
    def isBefore(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> bool: ...
    def isEqual(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> bool: ...
    def isLeapYear(self) -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDate': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDate': ...
    def minusDays(self, long: int) -> 'LocalDate': ...
    def minusMonths(self, long: int) -> 'LocalDate': ...
    def minusWeeks(self, long: int) -> 'LocalDate': ...
    def minusYears(self, long: int) -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def now() -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int) -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def of(int: int, month: 'Month', int2: int) -> 'LocalDate': ...
    @staticmethod
    def ofEpochDay(long: int) -> 'LocalDate': ...
    @staticmethod
    def ofInstant(instant: typing.Union[Instant, datetime.datetime], zoneId: 'ZoneId') -> 'LocalDate': ...
    @staticmethod
    def ofYearDay(int: int, int2: int) -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'LocalDate': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'LocalDate': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDate': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDate': ...
    def plusDays(self, long: int) -> 'LocalDate': ...
    def plusMonths(self, long: int) -> 'LocalDate': ...
    def plusWeeks(self, long: int) -> 'LocalDate': ...
    def plusYears(self, long: int) -> 'LocalDate': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochDay(self) -> int: ...
    def toEpochSecond(self, localTime: 'LocalTime', zoneOffset: 'ZoneOffset') -> int: ...
    def toString(self) -> str: ...
    @typing.overload
    def until(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> 'Period': ...
    @typing.overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'LocalDate': ...
    def withDayOfYear(self, int: int) -> 'LocalDate': ...
    def withMonth(self, int: int) -> 'LocalDate': ...
    def withYear(self, int: int) -> 'LocalDate': ...

class LocalDateTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.time.chrono.ChronoLocalDateTime[LocalDate], java.io.Serializable):
    MIN: typing.ClassVar['LocalDateTime'] = ...
    MAX: typing.ClassVar['LocalDateTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atOffset(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def atZone(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    def compareTo(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[typing.Any]) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getMonth(self) -> 'Month': ...
    def getMonthValue(self) -> int: ...
    def getNano(self) -> int: ...
    def getSecond(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[typing.Any]) -> bool: ...
    def isBefore(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[typing.Any]) -> bool: ...
    def isEqual(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[typing.Any]) -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDateTime': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDateTime': ...
    def minusDays(self, long: int) -> 'LocalDateTime': ...
    def minusHours(self, long: int) -> 'LocalDateTime': ...
    def minusMinutes(self, long: int) -> 'LocalDateTime': ...
    def minusMonths(self, long: int) -> 'LocalDateTime': ...
    def minusNanos(self, long: int) -> 'LocalDateTime': ...
    def minusSeconds(self, long: int) -> 'LocalDateTime': ...
    def minusWeeks(self, long: int) -> 'LocalDateTime': ...
    def minusYears(self, long: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def now() -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int, int5: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, month: 'Month', int2: int, int3: int, int4: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, month: 'Month', int2: int, int3: int, int4: int, int5: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, month: 'Month', int2: int, int3: int, int4: int, int5: int, int6: int) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def of(localDate: LocalDate, localTime: 'LocalTime') -> 'LocalDateTime': ...
    @staticmethod
    def ofEpochSecond(long: int, int: int, zoneOffset: 'ZoneOffset') -> 'LocalDateTime': ...
    @staticmethod
    def ofInstant(instant: typing.Union[Instant, datetime.datetime], zoneId: 'ZoneId') -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'LocalDateTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'LocalDateTime': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDateTime': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDateTime': ...
    def plusDays(self, long: int) -> 'LocalDateTime': ...
    def plusHours(self, long: int) -> 'LocalDateTime': ...
    def plusMinutes(self, long: int) -> 'LocalDateTime': ...
    def plusMonths(self, long: int) -> 'LocalDateTime': ...
    def plusNanos(self, long: int) -> 'LocalDateTime': ...
    def plusSeconds(self, long: int) -> 'LocalDateTime': ...
    def plusWeeks(self, long: int) -> 'LocalDateTime': ...
    def plusYears(self, long: int) -> 'LocalDateTime': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toLocalDate(self) -> LocalDate: ...
    def toLocalTime(self) -> 'LocalTime': ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDateTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'LocalDateTime': ...
    def withDayOfYear(self, int: int) -> 'LocalDateTime': ...
    def withHour(self, int: int) -> 'LocalDateTime': ...
    def withMinute(self, int: int) -> 'LocalDateTime': ...
    def withMonth(self, int: int) -> 'LocalDateTime': ...
    def withNano(self, int: int) -> 'LocalDateTime': ...
    def withSecond(self, int: int) -> 'LocalDateTime': ...
    def withYear(self, int: int) -> 'LocalDateTime': ...

class LocalTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['LocalTime'], java.io.Serializable):
    MIN: typing.ClassVar['LocalTime'] = ...
    MAX: typing.ClassVar['LocalTime'] = ...
    MIDNIGHT: typing.ClassVar['LocalTime'] = ...
    NOON: typing.ClassVar['LocalTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDate(self, localDate: LocalDate) -> LocalDateTime: ...
    def atOffset(self, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    def compareTo(self, localTime: 'LocalTime') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getNano(self) -> int: ...
    def getSecond(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, localTime: 'LocalTime') -> bool: ...
    def isBefore(self, localTime: 'LocalTime') -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalTime': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalTime': ...
    def minusHours(self, long: int) -> 'LocalTime': ...
    def minusMinutes(self, long: int) -> 'LocalTime': ...
    def minusNanos(self, long: int) -> 'LocalTime': ...
    def minusSeconds(self, long: int) -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def now() -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int) -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int) -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int) -> 'LocalTime': ...
    @staticmethod
    def ofInstant(instant: typing.Union[Instant, datetime.datetime], zoneId: 'ZoneId') -> 'LocalTime': ...
    @staticmethod
    def ofNanoOfDay(long: int) -> 'LocalTime': ...
    @staticmethod
    def ofSecondOfDay(long: int) -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'LocalTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'LocalTime': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalTime': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalTime': ...
    def plusHours(self, long: int) -> 'LocalTime': ...
    def plusMinutes(self, long: int) -> 'LocalTime': ...
    def plusNanos(self, long: int) -> 'LocalTime': ...
    def plusSeconds(self, long: int) -> 'LocalTime': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochSecond(self, localDate: LocalDate, zoneOffset: 'ZoneOffset') -> int: ...
    def toNanoOfDay(self) -> int: ...
    def toSecondOfDay(self) -> int: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withHour(self, int: int) -> 'LocalTime': ...
    def withMinute(self, int: int) -> 'LocalTime': ...
    def withNano(self, int: int) -> 'LocalTime': ...
    def withSecond(self, int: int) -> 'LocalTime': ...

class Month(java.lang.Enum['Month'], java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster):
    JANUARY: typing.ClassVar['Month'] = ...
    FEBRUARY: typing.ClassVar['Month'] = ...
    MARCH: typing.ClassVar['Month'] = ...
    APRIL: typing.ClassVar['Month'] = ...
    MAY: typing.ClassVar['Month'] = ...
    JUNE: typing.ClassVar['Month'] = ...
    JULY: typing.ClassVar['Month'] = ...
    AUGUST: typing.ClassVar['Month'] = ...
    SEPTEMBER: typing.ClassVar['Month'] = ...
    OCTOBER: typing.ClassVar['Month'] = ...
    NOVEMBER: typing.ClassVar['Month'] = ...
    DECEMBER: typing.ClassVar['Month'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def firstDayOfYear(self, boolean: bool) -> int: ...
    def firstMonthOfQuarter(self) -> 'Month': ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    def length(self, boolean: bool) -> int: ...
    def maxLength(self) -> int: ...
    def minLength(self) -> int: ...
    def minus(self, long: int) -> 'Month': ...
    @staticmethod
    def of(int: int) -> 'Month': ...
    def plus(self, long: int) -> 'Month': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'Month': ...
    @staticmethod
    def values() -> typing.List['Month']: ...

class MonthDay(java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster, java.lang.Comparable['MonthDay'], java.io.Serializable):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atYear(self, int: int) -> LocalDate: ...
    def compareTo(self, monthDay: 'MonthDay') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, monthDay: 'MonthDay') -> bool: ...
    def isBefore(self, monthDay: 'MonthDay') -> bool: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    def isValidYear(self, int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def now() -> 'MonthDay': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'MonthDay': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'MonthDay': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int) -> 'MonthDay': ...
    @typing.overload
    @staticmethod
    def of(month: Month, int: int) -> 'MonthDay': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'MonthDay': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'MonthDay': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    def withDayOfMonth(self, int: int) -> 'MonthDay': ...
    def withMonth(self, int: int) -> 'MonthDay': ...

class OffsetDateTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['OffsetDateTime'], java.io.Serializable):
    MIN: typing.ClassVar['OffsetDateTime'] = ...
    MAX: typing.ClassVar['OffsetDateTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atZoneSameInstant(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    def atZoneSimilarLocal(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    def compareTo(self, offsetDateTime: 'OffsetDateTime') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def getNano(self) -> int: ...
    def getOffset(self) -> 'ZoneOffset': ...
    def getSecond(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, offsetDateTime: 'OffsetDateTime') -> bool: ...
    def isBefore(self, offsetDateTime: 'OffsetDateTime') -> bool: ...
    def isEqual(self, offsetDateTime: 'OffsetDateTime') -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetDateTime': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetDateTime': ...
    def minusDays(self, long: int) -> 'OffsetDateTime': ...
    def minusHours(self, long: int) -> 'OffsetDateTime': ...
    def minusMinutes(self, long: int) -> 'OffsetDateTime': ...
    def minusMonths(self, long: int) -> 'OffsetDateTime': ...
    def minusNanos(self, long: int) -> 'OffsetDateTime': ...
    def minusSeconds(self, long: int) -> 'OffsetDateTime': ...
    def minusWeeks(self, long: int) -> 'OffsetDateTime': ...
    def minusYears(self, long: int) -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def now() -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def of(localDate: LocalDate, localTime: LocalTime, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def of(localDateTime: LocalDateTime, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @staticmethod
    def ofInstant(instant: typing.Union[Instant, datetime.datetime], zoneId: 'ZoneId') -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'OffsetDateTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'OffsetDateTime': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetDateTime': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetDateTime': ...
    def plusDays(self, long: int) -> 'OffsetDateTime': ...
    def plusHours(self, long: int) -> 'OffsetDateTime': ...
    def plusMinutes(self, long: int) -> 'OffsetDateTime': ...
    def plusMonths(self, long: int) -> 'OffsetDateTime': ...
    def plusNanos(self, long: int) -> 'OffsetDateTime': ...
    def plusSeconds(self, long: int) -> 'OffsetDateTime': ...
    def plusWeeks(self, long: int) -> 'OffsetDateTime': ...
    def plusYears(self, long: int) -> 'OffsetDateTime': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    @staticmethod
    def timeLineOrder() -> java.util.Comparator['OffsetDateTime']: ...
    def toEpochSecond(self) -> int: ...
    def toInstant(self) -> Instant: ...
    def toLocalDate(self) -> LocalDate: ...
    def toLocalDateTime(self) -> LocalDateTime: ...
    def toLocalTime(self) -> LocalTime: ...
    def toOffsetTime(self) -> 'OffsetTime': ...
    def toString(self) -> str: ...
    def toZonedDateTime(self) -> 'ZonedDateTime': ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetDateTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'OffsetDateTime': ...
    def withDayOfYear(self, int: int) -> 'OffsetDateTime': ...
    def withHour(self, int: int) -> 'OffsetDateTime': ...
    def withMinute(self, int: int) -> 'OffsetDateTime': ...
    def withMonth(self, int: int) -> 'OffsetDateTime': ...
    def withNano(self, int: int) -> 'OffsetDateTime': ...
    def withOffsetSameInstant(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def withOffsetSameLocal(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def withSecond(self, int: int) -> 'OffsetDateTime': ...
    def withYear(self, int: int) -> 'OffsetDateTime': ...

class OffsetTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['OffsetTime'], java.io.Serializable):
    MIN: typing.ClassVar['OffsetTime'] = ...
    MAX: typing.ClassVar['OffsetTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDate(self, localDate: LocalDate) -> OffsetDateTime: ...
    def compareTo(self, offsetTime: 'OffsetTime') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getNano(self) -> int: ...
    def getOffset(self) -> 'ZoneOffset': ...
    def getSecond(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, offsetTime: 'OffsetTime') -> bool: ...
    def isBefore(self, offsetTime: 'OffsetTime') -> bool: ...
    def isEqual(self, offsetTime: 'OffsetTime') -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetTime': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetTime': ...
    def minusHours(self, long: int) -> 'OffsetTime': ...
    def minusMinutes(self, long: int) -> 'OffsetTime': ...
    def minusNanos(self, long: int) -> 'OffsetTime': ...
    def minusSeconds(self, long: int) -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def now() -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def of(localTime: LocalTime, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    @staticmethod
    def ofInstant(instant: typing.Union[Instant, datetime.datetime], zoneId: 'ZoneId') -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'OffsetTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'OffsetTime': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetTime': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetTime': ...
    def plusHours(self, long: int) -> 'OffsetTime': ...
    def plusMinutes(self, long: int) -> 'OffsetTime': ...
    def plusNanos(self, long: int) -> 'OffsetTime': ...
    def plusSeconds(self, long: int) -> 'OffsetTime': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochSecond(self, localDate: LocalDate) -> int: ...
    def toLocalTime(self) -> LocalTime: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withHour(self, int: int) -> 'OffsetTime': ...
    def withMinute(self, int: int) -> 'OffsetTime': ...
    def withNano(self, int: int) -> 'OffsetTime': ...
    def withOffsetSameInstant(self, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    def withOffsetSameLocal(self, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    def withSecond(self, int: int) -> 'OffsetTime': ...

class Period(java.time.chrono.ChronoPeriod, java.io.Serializable):
    ZERO: typing.ClassVar['Period'] = ...
    def addTo(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @staticmethod
    def between(localDate: LocalDate, localDate2: LocalDate) -> 'Period': ...
    def equals(self, object: typing.Any) -> bool: ...
    def get(self, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def getChronology(self) -> java.time.chrono.IsoChronology: ...
    def getDays(self) -> int: ...
    def getMonths(self) -> int: ...
    def getUnits(self) -> java.util.List[java.time.temporal.TemporalUnit]: ...
    def getYears(self) -> int: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Period': ...
    def minusDays(self, long: int) -> 'Period': ...
    def minusMonths(self, long: int) -> 'Period': ...
    def minusYears(self, long: int) -> 'Period': ...
    def multipliedBy(self, int: int) -> 'Period': ...
    def negated(self) -> 'Period': ...
    def normalized(self) -> 'Period': ...
    @staticmethod
    def of(int: int, int2: int, int3: int) -> 'Period': ...
    @staticmethod
    def ofDays(int: int) -> 'Period': ...
    @staticmethod
    def ofMonths(int: int) -> 'Period': ...
    @staticmethod
    def ofWeeks(int: int) -> 'Period': ...
    @staticmethod
    def ofYears(int: int) -> 'Period': ...
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'Period': ...
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Period': ...
    def plusDays(self, long: int) -> 'Period': ...
    def plusMonths(self, long: int) -> 'Period': ...
    def plusYears(self, long: int) -> 'Period': ...
    def subtractFrom(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def toString(self) -> str: ...
    def toTotalMonths(self) -> int: ...
    def withDays(self, int: int) -> 'Period': ...
    def withMonths(self, int: int) -> 'Period': ...
    def withYears(self, int: int) -> 'Period': ...

class Year(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['Year'], java.io.Serializable):
    MIN_VALUE: typing.ClassVar[int] = ...
    MAX_VALUE: typing.ClassVar[int] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDay(self, int: int) -> LocalDate: ...
    @typing.overload
    def atMonth(self, int: int) -> 'YearMonth': ...
    @typing.overload
    def atMonth(self, month: Month) -> 'YearMonth': ...
    def atMonthDay(self, monthDay: MonthDay) -> LocalDate: ...
    def compareTo(self, year: 'Year') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, year: 'Year') -> bool: ...
    def isBefore(self, year: 'Year') -> bool: ...
    @typing.overload
    def isLeap(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isLeap(long: int) -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def isValidMonthDay(self, monthDay: MonthDay) -> bool: ...
    def length(self) -> int: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Year': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Year': ...
    def minusYears(self, long: int) -> 'Year': ...
    @typing.overload
    @staticmethod
    def now() -> 'Year': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'Year': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'Year': ...
    @staticmethod
    def of(int: int) -> 'Year': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'Year': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'Year': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Year': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Year': ...
    def plusYears(self, long: int) -> 'Year': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class YearMonth(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['YearMonth'], java.io.Serializable):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDay(self, int: int) -> LocalDate: ...
    def atEndOfMonth(self) -> LocalDate: ...
    def compareTo(self, yearMonth: 'YearMonth') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, yearMonth: 'YearMonth') -> bool: ...
    def isBefore(self, yearMonth: 'YearMonth') -> bool: ...
    def isLeapYear(self) -> bool: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def isValidDay(self, int: int) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'YearMonth': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'YearMonth': ...
    def minusMonths(self, long: int) -> 'YearMonth': ...
    def minusYears(self, long: int) -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def now() -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def now(zoneId: 'ZoneId') -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int) -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def of(int: int, month: Month) -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'YearMonth': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'YearMonth': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'YearMonth': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'YearMonth': ...
    def plusMonths(self, long: int) -> 'YearMonth': ...
    def plusYears(self, long: int) -> 'YearMonth': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withMonth(self, int: int) -> 'YearMonth': ...
    def withYear(self, int: int) -> 'YearMonth': ...

class ZoneId(java.io.Serializable):
    SHORT_IDS: typing.ClassVar[java.util.Map] = ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def getAvailableZoneIds() -> java.util.Set[str]: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getId(self) -> str: ...
    def getRules(self) -> java.time.zone.ZoneRules: ...
    def hashCode(self) -> int: ...
    def normalized(self) -> 'ZoneId': ...
    @typing.overload
    @staticmethod
    def of(string: str) -> 'ZoneId': ...
    @typing.overload
    @staticmethod
    def of(string: str, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]]) -> 'ZoneId': ...
    @staticmethod
    def ofOffset(string: str, zoneOffset: 'ZoneOffset') -> 'ZoneId': ...
    @staticmethod
    def systemDefault() -> 'ZoneId': ...
    def toString(self) -> str: ...

class ZonedDateTime(java.time.temporal.Temporal, java.time.chrono.ChronoZonedDateTime[LocalDate], java.io.Serializable):
    def equals(self, object: typing.Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def getNano(self) -> int: ...
    def getOffset(self) -> 'ZoneOffset': ...
    def getSecond(self) -> int: ...
    def getYear(self) -> int: ...
    def getZone(self) -> ZoneId: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @typing.overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ZonedDateTime': ...
    @typing.overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ZonedDateTime': ...
    def minusDays(self, long: int) -> 'ZonedDateTime': ...
    def minusHours(self, long: int) -> 'ZonedDateTime': ...
    def minusMinutes(self, long: int) -> 'ZonedDateTime': ...
    def minusMonths(self, long: int) -> 'ZonedDateTime': ...
    def minusNanos(self, long: int) -> 'ZonedDateTime': ...
    def minusSeconds(self, long: int) -> 'ZonedDateTime': ...
    def minusWeeks(self, long: int) -> 'ZonedDateTime': ...
    def minusYears(self, long: int) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def now() -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def now(clock: Clock) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def now(zoneId: ZoneId) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def of(int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def of(localDate: LocalDate, localTime: LocalTime, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def of(localDateTime: LocalDateTime, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def ofInstant(instant: typing.Union[Instant, datetime.datetime], zoneId: ZoneId) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def ofInstant(localDateTime: LocalDateTime, zoneOffset: 'ZoneOffset', zoneId: ZoneId) -> 'ZonedDateTime': ...
    @staticmethod
    def ofLocal(localDateTime: LocalDateTime, zoneId: ZoneId, zoneOffset: 'ZoneOffset') -> 'ZonedDateTime': ...
    @staticmethod
    def ofStrict(localDateTime: LocalDateTime, zoneOffset: 'ZoneOffset', zoneId: ZoneId) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str]) -> 'ZonedDateTime': ...
    @typing.overload
    @staticmethod
    def parse(charSequence: typing.Union[java.lang.CharSequence, str], dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'ZonedDateTime': ...
    @typing.overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ZonedDateTime': ...
    @typing.overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ZonedDateTime': ...
    def plusDays(self, long: int) -> 'ZonedDateTime': ...
    def plusHours(self, long: int) -> 'ZonedDateTime': ...
    def plusMinutes(self, long: int) -> 'ZonedDateTime': ...
    def plusMonths(self, long: int) -> 'ZonedDateTime': ...
    def plusNanos(self, long: int) -> 'ZonedDateTime': ...
    def plusSeconds(self, long: int) -> 'ZonedDateTime': ...
    def plusWeeks(self, long: int) -> 'ZonedDateTime': ...
    def plusYears(self, long: int) -> 'ZonedDateTime': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toLocalDate(self) -> LocalDate: ...
    def toLocalDateTime(self) -> LocalDateTime: ...
    def toLocalTime(self) -> LocalTime: ...
    def toOffsetDateTime(self) -> OffsetDateTime: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'ZonedDateTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'ZonedDateTime': ...
    def withDayOfYear(self, int: int) -> 'ZonedDateTime': ...
    def withEarlierOffsetAtOverlap(self) -> 'ZonedDateTime': ...
    def withFixedOffsetZone(self) -> 'ZonedDateTime': ...
    def withHour(self, int: int) -> 'ZonedDateTime': ...
    def withLaterOffsetAtOverlap(self) -> 'ZonedDateTime': ...
    def withMinute(self, int: int) -> 'ZonedDateTime': ...
    def withMonth(self, int: int) -> 'ZonedDateTime': ...
    def withNano(self, int: int) -> 'ZonedDateTime': ...
    def withSecond(self, int: int) -> 'ZonedDateTime': ...
    def withYear(self, int: int) -> 'ZonedDateTime': ...
    def withZoneSameInstant(self, zoneId: ZoneId) -> 'ZonedDateTime': ...
    def withZoneSameLocal(self, zoneId: ZoneId) -> 'ZonedDateTime': ...

class ZoneOffset(ZoneId, java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster, java.lang.Comparable['ZoneOffset'], java.io.Serializable):
    UTC: typing.ClassVar['ZoneOffset'] = ...
    MIN: typing.ClassVar['ZoneOffset'] = ...
    MAX: typing.ClassVar['ZoneOffset'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def compareTo(self, zoneOffset: 'ZoneOffset') -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getId(self) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getRules(self) -> java.time.zone.ZoneRules: ...
    def getTotalSeconds(self) -> int: ...
    def hashCode(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @typing.overload
    @staticmethod
    def of(string: str) -> ZoneId: ...
    @typing.overload
    @staticmethod
    def of(string: str, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]]) -> ZoneId: ...
    @typing.overload
    @staticmethod
    def of(string: str) -> 'ZoneOffset': ...
    @staticmethod
    def ofHours(int: int) -> 'ZoneOffset': ...
    @staticmethod
    def ofHoursMinutes(int: int, int2: int) -> 'ZoneOffset': ...
    @staticmethod
    def ofHoursMinutesSeconds(int: int, int2: int, int3: int) -> 'ZoneOffset': ...
    @staticmethod
    def ofTotalSeconds(int: int) -> 'ZoneOffset': ...
    _query__R = typing.TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: typing.Union[java.time.temporal.TemporalQuery[_query__R], typing.Callable[[java.time.temporal.TemporalAccessor], _query__R]]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.time")``.

    Clock: typing.Type[Clock]
    DateTimeException: typing.Type[DateTimeException]
    DayOfWeek: typing.Type[DayOfWeek]
    Duration: typing.Type[Duration]
    Instant: typing.Type[Instant]
    LocalDate: typing.Type[LocalDate]
    LocalDateTime: typing.Type[LocalDateTime]
    LocalTime: typing.Type[LocalTime]
    Month: typing.Type[Month]
    MonthDay: typing.Type[MonthDay]
    OffsetDateTime: typing.Type[OffsetDateTime]
    OffsetTime: typing.Type[OffsetTime]
    Period: typing.Type[Period]
    Year: typing.Type[Year]
    YearMonth: typing.Type[YearMonth]
    ZoneId: typing.Type[ZoneId]
    ZoneOffset: typing.Type[ZoneOffset]
    ZonedDateTime: typing.Type[ZonedDateTime]
    chrono: java.time.chrono.__module_protocol__
    format: java.time.format.__module_protocol__
    temporal: java.time.temporal.__module_protocol__
    zone: java.time.zone.__module_protocol__
