# coding: utf-8

"""
    Contabo API


    OpenAPI spec version: 1.0.0
    Contact: support@contabo.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pfruck_contabo.api_client import ApiClient


class SnapshotsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_snapshot(self, body, x_request_id, instance_id, **kwargs):  # noqa: E501
        """Create a new instance snapshot  # noqa: E501

        Create a new snapshot for instance, with name and description attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot(body, x_request_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSnapshotRequest body: (required)
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: CreateSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_snapshot_with_http_info(body, x_request_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_snapshot_with_http_info(body, x_request_id, instance_id, **kwargs)  # noqa: E501
            return data

    def create_snapshot_with_http_info(self, body, x_request_id, instance_id, **kwargs):  # noqa: E501
        """Create a new instance snapshot  # noqa: E501

        Create a new snapshot for instance, with name and description attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_with_http_info(body, x_request_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSnapshotRequest body: (required)
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: CreateSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_request_id', 'instance_id', 'x_trace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_snapshot`")  # noqa: E501
        # verify the required parameter 'x_request_id' is set
        if ('x_request_id' not in params or
                params['x_request_id'] is None):
            raise ValueError("Missing the required parameter `x_request_id` when calling `create_snapshot`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `create_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['x-request-id'] = params['x_request_id']  # noqa: E501
        if 'x_trace_id' in params:
            header_params['x-trace-id'] = params['x_trace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/compute/instances/{instanceId}/snapshots', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot(self, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Delete existing snapshot by id  # noqa: E501

        Delete existing instance snapshot by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot(x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_with_http_info(self, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Delete existing snapshot by id  # noqa: E501

        Delete existing instance snapshot by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id', 'instance_id', 'snapshot_id', 'x_trace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_request_id' is set
        if ('x_request_id' not in params or
                params['x_request_id'] is None):
            raise ValueError("Missing the required parameter `x_request_id` when calling `delete_snapshot`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `delete_snapshot`")  # noqa: E501
        # verify the required parameter 'snapshot_id' is set
        if ('snapshot_id' not in params or
                params['snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_id` when calling `delete_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'snapshot_id' in params:
            path_params['snapshotId'] = params['snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['x-request-id'] = params['x_request_id']  # noqa: E501
        if 'x_trace_id' in params:
            header_params['x-trace-id'] = params['x_trace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/compute/instances/{instanceId}/snapshots/{snapshotId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_snapshot(self, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Retrieve a specific snapshot by id  # noqa: E501

        Get all attributes for a specific snapshot  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_snapshot(x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: FindSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
            return data

    def retrieve_snapshot_with_http_info(self, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Retrieve a specific snapshot by id  # noqa: E501

        Get all attributes for a specific snapshot  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: FindSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id', 'instance_id', 'snapshot_id', 'x_trace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_request_id' is set
        if ('x_request_id' not in params or
                params['x_request_id'] is None):
            raise ValueError("Missing the required parameter `x_request_id` when calling `retrieve_snapshot`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `retrieve_snapshot`")  # noqa: E501
        # verify the required parameter 'snapshot_id' is set
        if ('snapshot_id' not in params or
                params['snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_id` when calling `retrieve_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'snapshot_id' in params:
            path_params['snapshotId'] = params['snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['x-request-id'] = params['x_request_id']  # noqa: E501
        if 'x_trace_id' in params:
            header_params['x-trace-id'] = params['x_trace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/compute/instances/{instanceId}/snapshots/{snapshotId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FindSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_snapshot_list(self, x_request_id, instance_id, **kwargs):  # noqa: E501
        """List snapshots  # noqa: E501

        List and filter all your snapshots for a specific instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_snapshot_list(x_request_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :param int page: Number of page to be fetched.
        :param int size: Number of elements per page.
        :param list[str] order_by: Specify fields and ordering (ASC for ascending, DESC for descending) in following format `field:ASC|DESC`.
        :param str name: Filter as substring match for snapshots names.
        :return: ListSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_snapshot_list_with_http_info(x_request_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_snapshot_list_with_http_info(x_request_id, instance_id, **kwargs)  # noqa: E501
            return data

    def retrieve_snapshot_list_with_http_info(self, x_request_id, instance_id, **kwargs):  # noqa: E501
        """List snapshots  # noqa: E501

        List and filter all your snapshots for a specific instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_snapshot_list_with_http_info(x_request_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :param int page: Number of page to be fetched.
        :param int size: Number of elements per page.
        :param list[str] order_by: Specify fields and ordering (ASC for ascending, DESC for descending) in following format `field:ASC|DESC`.
        :param str name: Filter as substring match for snapshots names.
        :return: ListSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id', 'instance_id', 'x_trace_id', 'page', 'size', 'order_by', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_snapshot_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_request_id' is set
        if ('x_request_id' not in params or
                params['x_request_id'] is None):
            raise ValueError("Missing the required parameter `x_request_id` when calling `retrieve_snapshot_list`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `retrieve_snapshot_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
            collection_formats['orderBy'] = 'multi'  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['x-request-id'] = params['x_request_id']  # noqa: E501
        if 'x_trace_id' in params:
            header_params['x-trace-id'] = params['x_trace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/compute/instances/{instanceId}/snapshots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rollback_snapshot(self, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Rollback the instance to a specific snapshot by id  # noqa: E501

        Rollback instance to a specific snapshot. The snapshot must be the latest one in order to be able to restore it, otherwise you will receive an error informing you that the snapshot is not the latest  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rollback_snapshot(x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: RollbackSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rollback_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rollback_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
            return data

    def rollback_snapshot_with_http_info(self, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Rollback the instance to a specific snapshot by id  # noqa: E501

        Rollback instance to a specific snapshot. The snapshot must be the latest one in order to be able to restore it, otherwise you will receive an error informing you that the snapshot is not the latest  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rollback_snapshot_with_http_info(x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: RollbackSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id', 'instance_id', 'snapshot_id', 'x_trace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rollback_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_request_id' is set
        if ('x_request_id' not in params or
                params['x_request_id'] is None):
            raise ValueError("Missing the required parameter `x_request_id` when calling `rollback_snapshot`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `rollback_snapshot`")  # noqa: E501
        # verify the required parameter 'snapshot_id' is set
        if ('snapshot_id' not in params or
                params['snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_id` when calling `rollback_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'snapshot_id' in params:
            path_params['snapshotId'] = params['snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['x-request-id'] = params['x_request_id']  # noqa: E501
        if 'x_trace_id' in params:
            header_params['x-trace-id'] = params['x_trace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/compute/instances/{instanceId}/snapshots/{snapshotId}/rollback', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RollbackSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snapshot(self, body, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Update specific snapshot by id  # noqa: E501

        Update attributes of a snapshot. You may only specify the attributes you want to change. If an attribute is not set, it will retain its original value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot(body, x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateSnapshotRequest body: (required)
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: UpdateSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snapshot_with_http_info(body, x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snapshot_with_http_info(body, x_request_id, instance_id, snapshot_id, **kwargs)  # noqa: E501
            return data

    def update_snapshot_with_http_info(self, body, x_request_id, instance_id, snapshot_id, **kwargs):  # noqa: E501
        """Update specific snapshot by id  # noqa: E501

        Update attributes of a snapshot. You may only specify the attributes you want to change. If an attribute is not set, it will retain its original value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_with_http_info(body, x_request_id, instance_id, snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateSnapshotRequest body: (required)
        :param str x_request_id: [Uuid4](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_4_(random)) to identify individual requests for support cases. You can use [uuidgenerator](https://www.uuidgenerator.net/version4) to generate them manually. (required)
        :param int instance_id: The identifier of the instance (required)
        :param str snapshot_id: The identifier of the snapshot (required)
        :param str x_trace_id: Identifier to trace group of requests.
        :return: UpdateSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_request_id', 'instance_id', 'snapshot_id', 'x_trace_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_snapshot`")  # noqa: E501
        # verify the required parameter 'x_request_id' is set
        if ('x_request_id' not in params or
                params['x_request_id'] is None):
            raise ValueError("Missing the required parameter `x_request_id` when calling `update_snapshot`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `update_snapshot`")  # noqa: E501
        # verify the required parameter 'snapshot_id' is set
        if ('snapshot_id' not in params or
                params['snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_id` when calling `update_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'snapshot_id' in params:
            path_params['snapshotId'] = params['snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['x-request-id'] = params['x_request_id']  # noqa: E501
        if 'x_trace_id' in params:
            header_params['x-trace-id'] = params['x_trace_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/compute/instances/{instanceId}/snapshots/{snapshotId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
