# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${PYPI_VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class LogsPayload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'client_id': 'str',
        'execution_id': 'str',
        'follow': 'bool',
        'job_id': 'str',
        'with_history': 'bool'
    }

    attribute_map = {
        'client_id': 'ClientID',
        'execution_id': 'ExecutionID',
        'follow': 'Follow',
        'job_id': 'JobID',
        'with_history': 'WithHistory'
    }

    def __init__(self, client_id=None, execution_id=None, follow=None, job_id=None, with_history=None):  # noqa: E501
        """LogsPayload - a model defined in Swagger"""  # noqa: E501
        self._client_id = None
        self._execution_id = None
        self._follow = None
        self._job_id = None
        self._with_history = None
        self.discriminator = None
        self.client_id = client_id
        self.execution_id = execution_id
        if follow is not None:
            self.follow = follow
        self.job_id = job_id
        if with_history is not None:
            self.with_history = with_history

    @property
    def client_id(self):
        """Gets the client_id of this LogsPayload.  # noqa: E501

        the id of the client that is requesting the logs  # noqa: E501

        :return: The client_id of this LogsPayload.  # noqa: E501
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this LogsPayload.

        the id of the client that is requesting the logs  # noqa: E501

        :param client_id: The client_id of this LogsPayload.  # noqa: E501
        :type: str
        """
        if client_id is None:
            raise ValueError("Invalid value for `client_id`, must not be `None`")  # noqa: E501

        self._client_id = client_id

    @property
    def execution_id(self):
        """Gets the execution_id of this LogsPayload.  # noqa: E501

        the execution to be shown  # noqa: E501

        :return: The execution_id of this LogsPayload.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this LogsPayload.

        the execution to be shown  # noqa: E501

        :param execution_id: The execution_id of this LogsPayload.  # noqa: E501
        :type: str
        """
        if execution_id is None:
            raise ValueError("Invalid value for `execution_id`, must not be `None`")  # noqa: E501

        self._execution_id = execution_id

    @property
    def follow(self):
        """Gets the follow of this LogsPayload.  # noqa: E501

        whether the logs should be followed after the current logs are shown  # noqa: E501

        :return: The follow of this LogsPayload.  # noqa: E501
        :rtype: bool
        """
        return self._follow

    @follow.setter
    def follow(self, follow):
        """Sets the follow of this LogsPayload.

        whether the logs should be followed after the current logs are shown  # noqa: E501

        :param follow: The follow of this LogsPayload.  # noqa: E501
        :type: bool
        """

        self._follow = follow

    @property
    def job_id(self):
        """Gets the job_id of this LogsPayload.  # noqa: E501

        the job id of the job to be shown  # noqa: E501

        :return: The job_id of this LogsPayload.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this LogsPayload.

        the job id of the job to be shown  # noqa: E501

        :param job_id: The job_id of this LogsPayload.  # noqa: E501
        :type: str
        """
        if job_id is None:
            raise ValueError("Invalid value for `job_id`, must not be `None`")  # noqa: E501

        self._job_id = job_id

    @property
    def with_history(self):
        """Gets the with_history of this LogsPayload.  # noqa: E501

        whether the logs history is required  # noqa: E501

        :return: The with_history of this LogsPayload.  # noqa: E501
        :rtype: bool
        """
        return self._with_history

    @with_history.setter
    def with_history(self, with_history):
        """Sets the with_history of this LogsPayload.

        whether the logs history is required  # noqa: E501

        :param with_history: The with_history of this LogsPayload.  # noqa: E501
        :type: bool
        """

        self._with_history = with_history

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LogsPayload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LogsPayload):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
