"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const kms = require("@aws-cdk/aws-kms");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-sns-sqs');
stack.templateOptions.description = 'Integration Test for aws-sns-sqs with SNS managed KMS key';
// Definitions
// Retrieve SNS managed key to encrypt the SNS Topic
const snsManagedKey = kms.Alias.fromAliasName(stack, 'sns-managed-key', 'alias/aws/sns');
// Create customer managed KMS CMK to encrypt the SQS Queue
const sqsEncryptionKeyProps = {
    enableKeyRotation: true
};
const sqsEncryptionKey = new kms.Key(stack, 'ImportedSQSEncryptionKey', sqsEncryptionKeyProps);
// Create the SNS to SQS construct
const props = {
    topicProps: {
        masterKey: snsManagedKey
    },
    queueProps: {
        encryptionMasterKey: sqsEncryptionKey
    },
    enableEncryptionWithCustomerManagedKey: false
};
new lib_1.SnsToSqs(stack, 'test-sns-sqs', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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