import logging
import board
import adafruit_bh1750
from threading import Thread
from time import sleep


class LightSensor:

    def __init__(self, sampling_rate_sec: int = 1, smoothing_window_sec: int = 15):
        self.smoothing_window_sec = smoothing_window_sec
        self.sampling_rate_sec = sampling_rate_sec
        self.measures = list()
        i2c = board.I2C()
        self.sensor = adafruit_bh1750.BH1750(i2c)
        logging.info("light sensor connected")

    def listen(self, listener, refreshing_rate_sec:int=1):
        Thread(target=self.__listen, args=(listener,refreshing_rate_sec), daemon=True).start()

    def __listen(self, listener, refreshing_rate_sec):
        loop = 0
        while True:
            try:
                self.measures.append(self.sensor.lux)
                while len(self.measures) > self.smoothing_window_sec:
                    self.measures.pop(0)
                loop +=1
                if loop > refreshing_rate_sec:
                    loop = 0
                    sorted_measures = sorted(self.measures)
                    median = sorted_measures[int(len(sorted_measures) * 0.5)]
                    listener(int(median))
            except Exception as e:
                print("error occurred", e)
            sleep(self.sampling_rate_sec)


def show(lux):
    print(lux)

lightSensor = LightSensor()
lightSensor.listen(show)

sleep(100000)