"""Window1D implementation."""
from typing import Sequence, TypeVar
import numpy as np

T = TypeVar("T", np.ndarray, list)


def window1d(
    input_array: Sequence[T],
    size: int,
    shift: int = 1,
    stride: int = 1,
) -> list[Sequence[T]]:
    """Creates a windowed dataset from a sequence.

    Function drops remainder and only includes full size windows.

    Args:
        input_array: sequence.
        size: size of the sliding window.
        shift: number of positions the window
            is shifted to the right each iteration.
        stride: number of positions between elements in the window.
    Return:
        list of generated windows.
    """
    # Calculate the number of windows that can be created
    num_windows = (len(input_array) - ((size - 1) * stride + 1)) // shift + 1

    windows = []

    for i in range(0, num_windows * shift, shift):
        window = input_array[i : i + size * stride : stride]
        windows.append(window)

    return windows
