from functools import wraps
from typing import TypeVar, ParamSpec, Callable

from yajirushi import Arrow, arrow

P_ = ParamSpec('P_')
R_ = TypeVar('R_')


def star_arrow(func: Callable[P_, R_]) -> Arrow[P_, R_]:
    @wraps(func)
    def star(value: P_) -> R_:
        return func(*value)
    return arrow(star)
