"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DetectorModel = exports.EventEvaluation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
/**
 * Information about the order in which events are evaluated and how actions are executed.
 */
var EventEvaluation;
(function (EventEvaluation) {
    /**
     * When setting to BATCH, variables within a state are updated and events within a state are
     * performed only after all event conditions are evaluated.
     */
    EventEvaluation["BATCH"] = "BATCH";
    /**
     * When setting to SERIAL, variables are updated and event conditions are evaluated in the order
     * that the events are defined.
     */
    EventEvaluation["SERIAL"] = "SERIAL";
})(EventEvaluation || (exports.EventEvaluation = EventEvaluation = {}));
/**
 * Defines an AWS IoT Events detector model in this stack.
 */
class DetectorModel extends core_1.Resource {
    /**
     * Import an existing detector model.
     */
    static fromDetectorModelName(scope, id, detectorModelName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.detectorModelName = detectorModelName;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.detectorModelName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_DetectorModelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DetectorModel);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (!props.initialState._onEnterEventsHaveAtLeastOneCondition()) {
            throw new Error('Detector Model must have at least one Input with a condition');
        }
        const role = props.role ?? new iam.Role(this, 'DetectorModelRole', {
            assumedBy: new iam.ServicePrincipal('iotevents.amazonaws.com'),
        });
        const resource = new aws_iotevents_1.CfnDetectorModel(this, 'Resource', {
            detectorModelName: this.physicalName,
            detectorModelDescription: props.description,
            evaluationMethod: props.evaluationMethod,
            key: props.detectorKey,
            detectorModelDefinition: {
                initialStateName: props.initialState.stateName,
                states: props.initialState._collectStateJsons(this, { role }, new Set()),
            },
            roleArn: role.roleArn,
        });
        this.detectorModelName = this.getResourceNameAttribute(resource.ref);
    }
}
exports.DetectorModel = DetectorModel;
_a = JSII_RTTI_SYMBOL_1;
DetectorModel[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.DetectorModel", version: "2.181.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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