"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
class InputBase extends core_1.Resource {
    grantWrite(grantee) {
        return this.grant(grantee, 'iotevents:BatchPutMessage');
    }
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions,
            resourceArns: [this.inputArn],
        });
    }
}
/**
 * Defines an AWS IoT Events input in this stack.
 */
class Input extends InputBase {
    /**
     * Import an existing input.
     */
    static fromInputName(scope, id, inputName) {
        return new class Import extends InputBase {
            constructor() {
                super(...arguments);
                this.inputName = inputName;
                this.inputArn = this.stack.formatArn({
                    service: 'iotevents',
                    resource: 'input',
                    resourceName: inputName,
                });
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.inputName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_InputProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Input);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.attributeJsonPaths.length === 0) {
            throw new Error('attributeJsonPaths property cannot be empty');
        }
        const resource = new aws_iotevents_1.CfnInput(this, 'Resource', {
            inputName: this.physicalName,
            inputDefinition: {
                attributes: props.attributeJsonPaths.map(path => ({ jsonPath: path })),
            },
        });
        this.inputName = this.getResourceNameAttribute(resource.ref);
        this.inputArn = this.getResourceArnAttribute(arnForInput(resource.ref), {
            service: 'iotevents',
            resource: 'input',
            resourceName: this.physicalName,
        });
    }
}
exports.Input = Input;
_a = JSII_RTTI_SYMBOL_1;
Input[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.Input", version: "2.181.1-alpha.0" };
function arnForInput(inputName) {
    return `arn:${core_1.Aws.PARTITION}:iotevents:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:input/${inputName}`;
}
//# sourceMappingURL=data:application/json;base64,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