"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersistentVolumeMode = exports.PersistentVolumeAccessMode = exports.PersistentVolumeClaim = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
class ImportedPersistentVolumeClaim extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this._name = name;
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubePersistentVolumeClaim.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubePersistentVolumeClaim.GVK.kind;
    }
}
/**
 * A PersistentVolumeClaim (PVC) is a request for storage by a user.
 * It is similar to a Pod. Pods consume node resources and PVCs consume PV resources.
 * Pods can request specific levels of resources (CPU and Memory).
 * Claims can request specific size and access modes
 */
class PersistentVolumeClaim extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'persistentvolumeclaims';
        this.storage = props.storage;
        this.volumeMode = props.volumeMode ?? PersistentVolumeMode.FILE_SYSTEM;
        this.storageClassName = props.storageClassName;
        this._accessModes = props.accessModes;
        if (props.volume) {
            this.bind(props.volume);
        }
        this.apiObject = new k8s.KubePersistentVolumeClaim(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
    }
    /**
     * Imports a pvc from the cluster as a reference.
     */
    static fromClaimName(scope, id, claimName) {
        return new ImportedPersistentVolumeClaim(scope, id, claimName);
    }
    /**
     * Access modes requirement of this claim.
     */
    get accessModes() {
        return this._accessModes ? [...this._accessModes] : undefined;
    }
    /**
     * PV this claim is bound to. Undefined means the claim is not bound
     * to any specific volume.
     */
    get volume() {
        return this._volume;
    }
    /**
     * Bind a claim to a specific volume.
     * Note that you must also bind the volume to the claim.
     *
     * @see https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
     *
     * @param vol The PV to bind to.
     */
    bind(vol) {
        if (this._volume && this._volume.name !== vol.name) {
            throw new Error(`Cannot bind claim '${this.name}' to volume '${vol.name}' since it is already bound to volume '${this._volume.name}'`);
        }
        this._volume = vol;
    }
    /**
     * @internal
     */
    _toKube() {
        const storage = this.storage ? k8s.Quantity.fromString(this.storage.toGibibytes() + 'Gi') : undefined;
        return {
            volumeName: this.volume ? this.volume.name : undefined,
            accessModes: this.accessModes?.map(a => a.toString()),
            resources: storage ? { requests: { storage } } : undefined,
            volumeMode: this.volumeMode,
            storageClassName: this.storageClassName,
        };
    }
}
exports.PersistentVolumeClaim = PersistentVolumeClaim;
_a = JSII_RTTI_SYMBOL_1;
PersistentVolumeClaim[_a] = { fqn: "cdk8s-plus-23.PersistentVolumeClaim", version: "2.0.0-rc.49" };
/**
 * Access Modes.
 */
var PersistentVolumeAccessMode;
(function (PersistentVolumeAccessMode) {
    /**
     * The volume can be mounted as read-write by a single node.
     * ReadWriteOnce access mode still can allow multiple pods to access
     * the volume when the pods are running on the same node.
     */
    PersistentVolumeAccessMode["READ_WRITE_ONCE"] = "ReadWriteOnce";
    /**
     * The volume can be mounted as read-only by many nodes.
     */
    PersistentVolumeAccessMode["READ_ONLY_MANY"] = "ReadOnlyMany";
    /**
     * The volume can be mounted as read-write by many nodes.
     */
    PersistentVolumeAccessMode["READ_WRITE_MANY"] = "ReadWriteMany";
    /**
     * The volume can be mounted as read-write by a single Pod.
     * Use ReadWriteOncePod access mode if you want to ensure that
     * only one pod across whole cluster can read that PVC or write to it.
     * This is only supported for CSI volumes and Kubernetes version 1.22+.
     */
    PersistentVolumeAccessMode["READ_WRITE_ONCE_POD"] = "ReadWriteOncePod";
})(PersistentVolumeAccessMode = exports.PersistentVolumeAccessMode || (exports.PersistentVolumeAccessMode = {}));
/**
 * Volume Modes.
 */
var PersistentVolumeMode;
(function (PersistentVolumeMode) {
    /**
     * Volume is ounted into Pods into a directory.
     * If the volume is backed by a block device and the device is empty,
     * Kubernetes creates a filesystem on the device before mounting it
     * for the first time.
     */
    PersistentVolumeMode["FILE_SYSTEM"] = "Filesystem";
    /**
     * Use a volume as a raw block device. Such volume is presented into a Pod as a block device,
     * without any filesystem on it. This mode is useful to provide a Pod the fastest possible way
     * to access a volume, without any filesystem layer between the Pod
     * and the volume. On the other hand, the application running in
     * the Pod must know how to handle a raw block device
     */
    PersistentVolumeMode["BLOCK"] = "Block";
})(PersistentVolumeMode = exports.PersistentVolumeMode || (exports.PersistentVolumeMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHZjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3B2Yy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUE4QztBQUM5QywyQ0FBdUM7QUFDdkMsK0JBQStCO0FBQy9CLHFDQUFxQztBQXNFckMsTUFBTSw2QkFBOEIsU0FBUSxzQkFBUztJQUluRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLElBQVk7UUFDcEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztJQUNwQixDQUFDO0lBRUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFFRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxHQUFHLENBQUMseUJBQXlCLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQztJQUN0RCxDQUFDO0lBRUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUVELElBQVcsSUFBSTtRQUNiLE9BQU8sR0FBRyxDQUFDLHlCQUF5QixDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUM7SUFDaEQsQ0FBQztDQUVGO0FBRUQ7Ozs7O0dBS0c7QUFDSCxNQUFhLHFCQUFzQixTQUFRLElBQUksQ0FBQyxRQUFRO0lBbUN0RCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFvQyxFQUFHO1FBQ3RGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUF0QkgsaUJBQVksR0FBRyx3QkFBd0IsQ0FBQztRQXdCdEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsSUFBSSxvQkFBb0IsQ0FBQyxXQUFXLENBQUM7UUFDdkUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFFdEMsSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFO1lBQ2hCLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1NBQ3pCO1FBRUQsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLEdBQUcsQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ25FLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixJQUFJLEVBQUUsWUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQztTQUNsRCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBakREOztPQUVHO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxTQUFpQjtRQUN6RSxPQUFPLElBQUksNkJBQTZCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBOENEOztPQUVHO0lBQ0gsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ2hFLENBQUM7SUFFRDs7O09BR0c7SUFDSCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7O09BT0c7SUFDSSxJQUFJLENBQUMsR0FBeUI7UUFDbkMsSUFBSSxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxLQUFLLEdBQUcsQ0FBQyxJQUFJLEVBQUU7WUFDbEQsTUFBTSxJQUFJLEtBQUssQ0FBQyxzQkFBc0IsSUFBSSxDQUFDLElBQUksZ0JBQWdCLEdBQUcsQ0FBQyxJQUFJLDBDQUEwQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLENBQUM7U0FDeEk7UUFDRCxJQUFJLENBQUMsT0FBTyxHQUFHLEdBQUcsQ0FBQztJQUNyQixDQUFDO0lBRUQ7O09BRUc7SUFDSSxPQUFPO1FBQ1osTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO1FBQ3RHLE9BQU87WUFDTCxVQUFVLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDdEQsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQ3JELFNBQVMsRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsUUFBUSxFQUFFLEVBQUUsT0FBTyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsU0FBUztZQUMxRCxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtTQUN4QyxDQUFDO0lBQ0osQ0FBQzs7QUEvRkgsc0RBaUdDOzs7QUFFRDs7R0FFRztBQUNILElBQVksMEJBMkJYO0FBM0JELFdBQVksMEJBQTBCO0lBRXBDOzs7O09BSUc7SUFDSCwrREFBaUMsQ0FBQTtJQUVqQzs7T0FFRztJQUNILDZEQUErQixDQUFBO0lBRS9COztPQUVHO0lBQ0gsK0RBQWlDLENBQUE7SUFFakM7Ozs7O09BS0c7SUFDSCxzRUFBd0MsQ0FBQTtBQUUxQyxDQUFDLEVBM0JXLDBCQUEwQixHQUExQixrQ0FBMEIsS0FBMUIsa0NBQTBCLFFBMkJyQztBQUVEOztHQUVHO0FBQ0gsSUFBWSxvQkFrQlg7QUFsQkQsV0FBWSxvQkFBb0I7SUFFOUI7Ozs7O09BS0c7SUFDSCxrREFBMEIsQ0FBQTtJQUUxQjs7Ozs7O09BTUc7SUFDSCx1Q0FBZSxDQUFBO0FBQ2pCLENBQUMsRUFsQlcsb0JBQW9CLEdBQXBCLDRCQUFvQixLQUFwQiw0QkFBb0IsUUFrQi9CIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2l6ZSwgQXBpT2JqZWN0LCBMYXp5IH0gZnJvbSAnY2RrOHMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBiYXNlIGZyb20gJy4vYmFzZSc7XG5pbXBvcnQgKiBhcyBrOHMgZnJvbSAnLi9pbXBvcnRzL2s4cyc7XG5pbXBvcnQgKiBhcyBwdiBmcm9tICcuL3B2JztcblxuLyoqXG4gKiBDb250cmFjdCBvZiBhIGBQZXJzaXN0ZW50Vm9sdW1lQ2xhaW1gLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElQZXJzaXN0ZW50Vm9sdW1lQ2xhaW0gZXh0ZW5kcyBiYXNlLklSZXNvdXJjZSB7XG5cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBgUGVyc2lzdGVudFZvbHVtZUNsYWltYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBQZXJzaXN0ZW50Vm9sdW1lQ2xhaW1Qcm9wcyBleHRlbmRzIGJhc2UuUmVzb3VyY2VQcm9wcyB7XG5cbiAgLyoqXG4gICAqIENvbnRhaW5zIHRoZSBhY2Nlc3MgbW9kZXMgdGhlIHZvbHVtZSBzaG91bGQgc3VwcG9ydC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2t1YmVybmV0ZXMuaW8vZG9jcy9jb25jZXB0cy9zdG9yYWdlL3BlcnNpc3RlbnQtdm9sdW1lcyNhY2Nlc3MtbW9kZXMtMVxuICAgKiBAZGVmYXVsdCAtIE5vIGFjY2VzcyBtb2RlcyByZXF1aXJlbWVudC5cbiAgICovXG4gIHJlYWRvbmx5IGFjY2Vzc01vZGVzPzogUGVyc2lzdGVudFZvbHVtZUFjY2Vzc01vZGVbXTtcblxuICAvKipcbiAgICogTWluaW11bSBzdG9yYWdlIHNpemUgdGhlIHZvbHVtZSBzaG91bGQgaGF2ZS5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2t1YmVybmV0ZXMuaW8vZG9jcy9jb25jZXB0cy9zdG9yYWdlL3BlcnNpc3RlbnQtdm9sdW1lcyNyZXNvdXJjZXNcbiAgICogQGRlZmF1bHQgLSBObyBzdG9yYWdlIHJlcXVpcmVtZW50LlxuICAgKi9cbiAgcmVhZG9ubHkgc3RvcmFnZT86IFNpemU7XG5cbiAgLyoqXG4gICAqIE5hbWUgb2YgdGhlIFN0b3JhZ2VDbGFzcyByZXF1aXJlZCBieSB0aGUgY2xhaW0uXG4gICAqIFdoZW4gdGhpcyBwcm9wZXJ0eSBpcyBub3Qgc2V0LCB0aGUgYmVoYXZpb3IgaXMgYXMgZm9sbG93czpcbiAgICpcbiAgICogLSBJZiB0aGUgYWRtaXNzaW9uIHBsdWdpbiBpcyB0dXJuZWQgb24sIHRoZSBzdG9yYWdlIGNsYXNzIG1hcmtlZCBhcyBkZWZhdWx0IHdpbGwgYmUgdXNlZC5cbiAgICogLSBJZiB0aGUgYWRtaXNzaW9uIHBsdWdpbiBpcyB0dXJuZWQgb2ZmLCB0aGUgcHZjIGNhbiBvbmx5IGJlIGJvdW5kIHRvIHZvbHVtZXMgd2l0aG91dCBhIHN0b3JhZ2UgY2xhc3MuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvY29uY2VwdHMvc3RvcmFnZS9wZXJzaXN0ZW50LXZvbHVtZXMjY2xhc3MtMVxuICAgKiBAZGVmYXVsdCAtIE5vdCBzZXQuXG4gICAqL1xuICByZWFkb25seSBzdG9yYWdlQ2xhc3NOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBEZWZpbmVzIHdoYXQgdHlwZSBvZiB2b2x1bWUgaXMgcmVxdWlyZWQgYnkgdGhlIGNsYWltLlxuICAgKlxuICAgKiBAZGVmYXVsdCBWb2x1bWVNb2RlLkZJTEVfU1lTVEVNXG4gICAqL1xuICByZWFkb25seSB2b2x1bWVNb2RlPzogUGVyc2lzdGVudFZvbHVtZU1vZGU7XG5cbiAgLyoqXG4gICAqIFRoZSBQZXJzaXN0ZW50Vm9sdW1lIGJhY2tpbmcgdGhpcyBjbGFpbS5cbiAgICpcbiAgICogVGhlIGNvbnRyb2wgcGxhbmUgc3RpbGwgY2hlY2tzIHRoYXQgc3RvcmFnZSBjbGFzcywgYWNjZXNzIG1vZGVzLFxuICAgKiBhbmQgcmVxdWVzdGVkIHN0b3JhZ2Ugc2l6ZSBvbiB0aGUgdm9sdW1lIGFyZSB2YWxpZC5cbiAgICpcbiAgICogTm90ZSB0aGF0IGluIG9yZGVyIHRvIGd1YXJhbnRlZSBhIHByb3BlciBiaW5kaW5nLCB0aGUgdm9sdW1lIHNob3VsZFxuICAgKiBhbHNvIGRlZmluZSBhIGBjbGFpbVJlZmAgcmVmZXJyaW5nIHRvIHRoaXMgY2xhaW0uIE90aGVyd2lzZSwgdGhlIHZvbHVtZSBtYXkgYmVcbiAgICogY2xhaW1lZCBiZSBvdGhlciBwdmMncyBiZWZvcmUgaXQgZ2V0cyBhIGNoYW5jZSB0byBiaW5kIHRvIHRoaXMgb25lLlxuICAgKlxuICAgKiBJZiB0aGUgdm9sdW1lIGlzIG1hbmFnZWQgKGkuZSBub3QgaW1wb3J0ZWQpLCB5b3UgY2FuIHVzZSBgcHYuY2xhaW0oKWAgdG8gZWFzaWx5XG4gICAqIGNyZWF0ZSBhIGJpLWRpcmVjdGlvbmFsIGJvdW5kZWQgY2xhaW0uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvY29uY2VwdHMvc3RvcmFnZS9wZXJzaXN0ZW50LXZvbHVtZXMvI2JpbmRpbmcuXG4gICAqIEBkZWZhdWx0IC0gTm8gc3BlY2lmaWMgdm9sdW1lIGJpbmRpbmcuXG4gICAqL1xuICByZWFkb25seSB2b2x1bWU/OiBwdi5JUGVyc2lzdGVudFZvbHVtZTtcblxufVxuXG5jbGFzcyBJbXBvcnRlZFBlcnNpc3RlbnRWb2x1bWVDbGFpbSBleHRlbmRzIENvbnN0cnVjdCBpbXBsZW1lbnRzIElQZXJzaXN0ZW50Vm9sdW1lQ2xhaW0ge1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgX25hbWU6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBuYW1lOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMuX25hbWUgPSBuYW1lO1xuICB9XG5cbiAgcHVibGljIGdldCBuYW1lKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGFwaVZlcnNpb24oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gazhzLkt1YmVQZXJzaXN0ZW50Vm9sdW1lQ2xhaW0uR1ZLLmFwaVZlcnNpb247XG4gIH1cblxuICBwdWJsaWMgZ2V0IGFwaUdyb3VwKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuICcnO1xuICB9XG5cbiAgcHVibGljIGdldCBraW5kKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGs4cy5LdWJlUGVyc2lzdGVudFZvbHVtZUNsYWltLkdWSy5raW5kO1xuICB9XG5cbn1cblxuLyoqXG4gKiBBIFBlcnNpc3RlbnRWb2x1bWVDbGFpbSAoUFZDKSBpcyBhIHJlcXVlc3QgZm9yIHN0b3JhZ2UgYnkgYSB1c2VyLlxuICogSXQgaXMgc2ltaWxhciB0byBhIFBvZC4gUG9kcyBjb25zdW1lIG5vZGUgcmVzb3VyY2VzIGFuZCBQVkNzIGNvbnN1bWUgUFYgcmVzb3VyY2VzLlxuICogUG9kcyBjYW4gcmVxdWVzdCBzcGVjaWZpYyBsZXZlbHMgb2YgcmVzb3VyY2VzIChDUFUgYW5kIE1lbW9yeSkuXG4gKiBDbGFpbXMgY2FuIHJlcXVlc3Qgc3BlY2lmaWMgc2l6ZSBhbmQgYWNjZXNzIG1vZGVzXG4gKi9cbmV4cG9ydCBjbGFzcyBQZXJzaXN0ZW50Vm9sdW1lQ2xhaW0gZXh0ZW5kcyBiYXNlLlJlc291cmNlIGltcGxlbWVudHMgSVBlcnNpc3RlbnRWb2x1bWVDbGFpbSB7XG5cbiAgLyoqXG4gICAqIEltcG9ydHMgYSBwdmMgZnJvbSB0aGUgY2x1c3RlciBhcyBhIHJlZmVyZW5jZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUNsYWltTmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjbGFpbU5hbWU6IHN0cmluZyk6IElQZXJzaXN0ZW50Vm9sdW1lQ2xhaW0ge1xuICAgIHJldHVybiBuZXcgSW1wb3J0ZWRQZXJzaXN0ZW50Vm9sdW1lQ2xhaW0oc2NvcGUsIGlkLCBjbGFpbU5hbWUpO1xuICB9XG5cbiAgLyoqXG4gICAqIEBzZWUgYmFzZS5SZXNvdXJjZS5hcGlPYmplY3RcbiAgICovXG4gIHByb3RlY3RlZCByZWFkb25seSBhcGlPYmplY3Q6IEFwaU9iamVjdDtcblxuICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2VUeXBlID0gJ3BlcnNpc3RlbnR2b2x1bWVjbGFpbXMnO1xuXG4gIC8qKlxuICAgKiBTdG9yYWdlIHJlcXVpcmVtZW50IG9mIHRoaXMgY2xhaW0uXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgc3RvcmFnZT86IFNpemU7XG5cbiAgLyoqXG4gICAqIFZvbHVtZSBtb2RlIHJlcXVpcmVtZW50IG9mIHRoaXMgY2xhaW0uXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdm9sdW1lTW9kZTogUGVyc2lzdGVudFZvbHVtZU1vZGU7XG5cbiAgLyoqXG4gICAqIFN0b3JhZ2UgY2xhc3MgcmVxdWlybWVudCBvZiB0aGlzIGNsYWltLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHN0b3JhZ2VDbGFzc05hbWU/OiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSByZWFkb25seSBfYWNjZXNzTW9kZXM/OiBQZXJzaXN0ZW50Vm9sdW1lQWNjZXNzTW9kZVtdO1xuXG4gIHByaXZhdGUgX3ZvbHVtZT86IHB2LklQZXJzaXN0ZW50Vm9sdW1lO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUGVyc2lzdGVudFZvbHVtZUNsYWltUHJvcHMgPSB7IH0pIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5zdG9yYWdlID0gcHJvcHMuc3RvcmFnZTtcbiAgICB0aGlzLnZvbHVtZU1vZGUgPSBwcm9wcy52b2x1bWVNb2RlID8/IFBlcnNpc3RlbnRWb2x1bWVNb2RlLkZJTEVfU1lTVEVNO1xuICAgIHRoaXMuc3RvcmFnZUNsYXNzTmFtZSA9IHByb3BzLnN0b3JhZ2VDbGFzc05hbWU7XG4gICAgdGhpcy5fYWNjZXNzTW9kZXMgPSBwcm9wcy5hY2Nlc3NNb2RlcztcblxuICAgIGlmIChwcm9wcy52b2x1bWUpIHtcbiAgICAgIHRoaXMuYmluZChwcm9wcy52b2x1bWUpO1xuICAgIH1cblxuICAgIHRoaXMuYXBpT2JqZWN0ID0gbmV3IGs4cy5LdWJlUGVyc2lzdGVudFZvbHVtZUNsYWltKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIG1ldGFkYXRhOiBwcm9wcy5tZXRhZGF0YSxcbiAgICAgIHNwZWM6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5fdG9LdWJlKCkgfSksXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQWNjZXNzIG1vZGVzIHJlcXVpcmVtZW50IG9mIHRoaXMgY2xhaW0uXG4gICAqL1xuICBwdWJsaWMgZ2V0IGFjY2Vzc01vZGVzKCk6IFBlcnNpc3RlbnRWb2x1bWVBY2Nlc3NNb2RlW10gfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLl9hY2Nlc3NNb2RlcyA/IFsuLi50aGlzLl9hY2Nlc3NNb2Rlc10gOiB1bmRlZmluZWQ7XG4gIH1cblxuICAvKipcbiAgICogUFYgdGhpcyBjbGFpbSBpcyBib3VuZCB0by4gVW5kZWZpbmVkIG1lYW5zIHRoZSBjbGFpbSBpcyBub3QgYm91bmRcbiAgICogdG8gYW55IHNwZWNpZmljIHZvbHVtZS5cbiAgICovXG4gIHB1YmxpYyBnZXQgdm9sdW1lKCk6IHB2LklQZXJzaXN0ZW50Vm9sdW1lIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fdm9sdW1lO1xuICB9XG5cbiAgLyoqXG4gICAqIEJpbmQgYSBjbGFpbSB0byBhIHNwZWNpZmljIHZvbHVtZS5cbiAgICogTm90ZSB0aGF0IHlvdSBtdXN0IGFsc28gYmluZCB0aGUgdm9sdW1lIHRvIHRoZSBjbGFpbS5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2t1YmVybmV0ZXMuaW8vZG9jcy9jb25jZXB0cy9zdG9yYWdlL3BlcnNpc3RlbnQtdm9sdW1lcy8jYmluZGluZ1xuICAgKlxuICAgKiBAcGFyYW0gdm9sIFRoZSBQViB0byBiaW5kIHRvLlxuICAgKi9cbiAgcHVibGljIGJpbmQodm9sOiBwdi5JUGVyc2lzdGVudFZvbHVtZSkge1xuICAgIGlmICh0aGlzLl92b2x1bWUgJiYgdGhpcy5fdm9sdW1lLm5hbWUgIT09IHZvbC5uYW1lKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCBiaW5kIGNsYWltICcke3RoaXMubmFtZX0nIHRvIHZvbHVtZSAnJHt2b2wubmFtZX0nIHNpbmNlIGl0IGlzIGFscmVhZHkgYm91bmQgdG8gdm9sdW1lICcke3RoaXMuX3ZvbHVtZS5uYW1lfSdgKTtcbiAgICB9XG4gICAgdGhpcy5fdm9sdW1lID0gdm9sO1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF90b0t1YmUoKTogazhzLlBlcnNpc3RlbnRWb2x1bWVDbGFpbVNwZWMge1xuICAgIGNvbnN0IHN0b3JhZ2UgPSB0aGlzLnN0b3JhZ2UgPyBrOHMuUXVhbnRpdHkuZnJvbVN0cmluZyh0aGlzLnN0b3JhZ2UudG9HaWJpYnl0ZXMoKSArICdHaScpIDogdW5kZWZpbmVkO1xuICAgIHJldHVybiB7XG4gICAgICB2b2x1bWVOYW1lOiB0aGlzLnZvbHVtZSA/IHRoaXMudm9sdW1lLm5hbWUgOiB1bmRlZmluZWQsXG4gICAgICBhY2Nlc3NNb2RlczogdGhpcy5hY2Nlc3NNb2Rlcz8ubWFwKGEgPT4gYS50b1N0cmluZygpKSxcbiAgICAgIHJlc291cmNlczogc3RvcmFnZSA/IHsgcmVxdWVzdHM6IHsgc3RvcmFnZSB9IH0gOiB1bmRlZmluZWQsXG4gICAgICB2b2x1bWVNb2RlOiB0aGlzLnZvbHVtZU1vZGUsXG4gICAgICBzdG9yYWdlQ2xhc3NOYW1lOiB0aGlzLnN0b3JhZ2VDbGFzc05hbWUsXG4gICAgfTtcbiAgfVxuXG59XG5cbi8qKlxuICogQWNjZXNzIE1vZGVzLlxuICovXG5leHBvcnQgZW51bSBQZXJzaXN0ZW50Vm9sdW1lQWNjZXNzTW9kZSB7XG5cbiAgLyoqXG4gICAqIFRoZSB2b2x1bWUgY2FuIGJlIG1vdW50ZWQgYXMgcmVhZC13cml0ZSBieSBhIHNpbmdsZSBub2RlLlxuICAgKiBSZWFkV3JpdGVPbmNlIGFjY2VzcyBtb2RlIHN0aWxsIGNhbiBhbGxvdyBtdWx0aXBsZSBwb2RzIHRvIGFjY2Vzc1xuICAgKiB0aGUgdm9sdW1lIHdoZW4gdGhlIHBvZHMgYXJlIHJ1bm5pbmcgb24gdGhlIHNhbWUgbm9kZS5cbiAgICovXG4gIFJFQURfV1JJVEVfT05DRSA9ICdSZWFkV3JpdGVPbmNlJyxcblxuICAvKipcbiAgICogVGhlIHZvbHVtZSBjYW4gYmUgbW91bnRlZCBhcyByZWFkLW9ubHkgYnkgbWFueSBub2Rlcy5cbiAgICovXG4gIFJFQURfT05MWV9NQU5ZID0gJ1JlYWRPbmx5TWFueScsXG5cbiAgLyoqXG4gICAqIFRoZSB2b2x1bWUgY2FuIGJlIG1vdW50ZWQgYXMgcmVhZC13cml0ZSBieSBtYW55IG5vZGVzLlxuICAgKi9cbiAgUkVBRF9XUklURV9NQU5ZID0gJ1JlYWRXcml0ZU1hbnknLFxuXG4gIC8qKlxuICAgKiBUaGUgdm9sdW1lIGNhbiBiZSBtb3VudGVkIGFzIHJlYWQtd3JpdGUgYnkgYSBzaW5nbGUgUG9kLlxuICAgKiBVc2UgUmVhZFdyaXRlT25jZVBvZCBhY2Nlc3MgbW9kZSBpZiB5b3Ugd2FudCB0byBlbnN1cmUgdGhhdFxuICAgKiBvbmx5IG9uZSBwb2QgYWNyb3NzIHdob2xlIGNsdXN0ZXIgY2FuIHJlYWQgdGhhdCBQVkMgb3Igd3JpdGUgdG8gaXQuXG4gICAqIFRoaXMgaXMgb25seSBzdXBwb3J0ZWQgZm9yIENTSSB2b2x1bWVzIGFuZCBLdWJlcm5ldGVzIHZlcnNpb24gMS4yMisuXG4gICAqL1xuICBSRUFEX1dSSVRFX09OQ0VfUE9EID0gJ1JlYWRXcml0ZU9uY2VQb2QnXG5cbn1cblxuLyoqXG4gKiBWb2x1bWUgTW9kZXMuXG4gKi9cbmV4cG9ydCBlbnVtIFBlcnNpc3RlbnRWb2x1bWVNb2RlIHtcblxuICAvKipcbiAgICogVm9sdW1lIGlzIG91bnRlZCBpbnRvIFBvZHMgaW50byBhIGRpcmVjdG9yeS5cbiAgICogSWYgdGhlIHZvbHVtZSBpcyBiYWNrZWQgYnkgYSBibG9jayBkZXZpY2UgYW5kIHRoZSBkZXZpY2UgaXMgZW1wdHksXG4gICAqIEt1YmVybmV0ZXMgY3JlYXRlcyBhIGZpbGVzeXN0ZW0gb24gdGhlIGRldmljZSBiZWZvcmUgbW91bnRpbmcgaXRcbiAgICogZm9yIHRoZSBmaXJzdCB0aW1lLlxuICAgKi9cbiAgRklMRV9TWVNURU0gPSAnRmlsZXN5c3RlbScsXG5cbiAgLyoqXG4gICAqIFVzZSBhIHZvbHVtZSBhcyBhIHJhdyBibG9jayBkZXZpY2UuIFN1Y2ggdm9sdW1lIGlzIHByZXNlbnRlZCBpbnRvIGEgUG9kIGFzIGEgYmxvY2sgZGV2aWNlLFxuICAgKiB3aXRob3V0IGFueSBmaWxlc3lzdGVtIG9uIGl0LiBUaGlzIG1vZGUgaXMgdXNlZnVsIHRvIHByb3ZpZGUgYSBQb2QgdGhlIGZhc3Rlc3QgcG9zc2libGUgd2F5XG4gICAqIHRvIGFjY2VzcyBhIHZvbHVtZSwgd2l0aG91dCBhbnkgZmlsZXN5c3RlbSBsYXllciBiZXR3ZWVuIHRoZSBQb2RcbiAgICogYW5kIHRoZSB2b2x1bWUuIE9uIHRoZSBvdGhlciBoYW5kLCB0aGUgYXBwbGljYXRpb24gcnVubmluZyBpblxuICAgKiB0aGUgUG9kIG11c3Qga25vdyBob3cgdG8gaGFuZGxlIGEgcmF3IGJsb2NrIGRldmljZVxuICAgKi9cbiAgQkxPQ0sgPSAnQmxvY2snXG59XG4iXX0=