![JQVMap](http://jqvmap.com/img/logo.png "JQVMap")

Contributing to JQVMap
===

Please review the following if you intend to submit an issue or pull request.  Not following the guidelines below most likely means your submission will be rejected.

Reporting an Issue
---

**ATTENTION:** While creating tickets is the only way to assign a task to be completed, it is equally important to not flood the development team with tickets that are not actually necessary ( might be a duplicate, already being worked on, not actually an issue, etc ).  So before you create a ticket, please check that your issue has not already been reported.

#### Creating a New Issue

To submit a ticket, visit the project's repo on [Github](https://github.com/manifestinteractive/jqvmap), select the **Issues** tab in the right column,  and click the green **New issue** button.

**Please use our [Ticket Template](https://github.com/manifestinteractive/culture/blob/master/templates/ticket-template.md) to make sure you are entering all the information we will need to complete the item you are about to create.**

Map Specific Issues
---

So you want to create your own maps, or change some existing ones.  Awesome.  Make sure to check out the `./create` folder for details on how to do this.

Making Code Changes
---

All source code for this project is contained in the `./src` folder.  Do not make any changes to the javascript files in the `./dist` folder, these are automatically generated by the `grunt build` terminal command.  Any Pull Requests that were not generated using the following Grunt Terminal Commands will be automatically rejected in order to maintain structural integrity of this project.

#### Requirements

* [Node.js v0.10](http://nodejs.org/) ( For Application Development )

Grunt Terminal Commands:
---

You can use the following build commands via terminal:

#### Build for Distribution:

The following command will Concat JS files and generate minified files for Distribution.

This is the most common command you will want to use and is required to view any changes you made in a browser.

```bash
grunt build
```

#### Create a Major Release:

The following will:

1. Increase the build's major number ( e.g. v __1__.0.1 => v __2__.0.0 )
2. Build & Package Distribution Files
3. Perform a git commit

```bash
grunt release-major
```

#### Create a Minor Release:

The following will:

1. Increase the build's minor number ( e.g. v 1.__0__.1 => v 1.__1__.0 )
2. Build & Package Distribution Files
3. Perform a git commit

```bash
grunt release-minor
```

#### Create a Release Patch:

The following will:

1. Increase the build's patch number ( e.g. v 1.1.__1__ => v 1.1.__2__ )
2. Build & Package Distribution Files
3. Perform a git commit

```bash
grunt release-patch
```

Submitting a Pull Request
---

Code will not be merged into the master branch unless it has been submitted as a Pull Request.

All Pull Requests must be reviewed by one of your peers before it can be merged into master.

#### Creating a Pull Request Assumes:

1. You have read and understand our [Coding Culture](https://github.com/manifestinteractive/culture)
2. You are working off a git branch named after a corresponding Github ticket
3. You have merged in the latest master branch and resolved all merge conflicts

#### Create Pull Request:

1. Commit and push your Github ticket branch using [Git Best Practices](https://github.com/manifestinteractive/culture/blob/master/docs/git-best-practices.md)
2. Visit the project's repo on [Github](https://github.com/manifestinteractive/jqvmap) and click **Compare & pull request**
3. Add a Title that briefly explains the PR
4. Use the text from our [Pull Request Template](https://github.com/manifestinteractive/culture/blob/master/templates/pr-template.md) as the base of your PR comment
5. Update the PR comment to complete as much information as you can provide
6. Add a Label of **Ready for Code Review**
7. Click **Create pull request**

#### Review Pull Request:

1. Visit the PR you are being asked to review
2. Before starting your PR Review, remove the Label **Ready for Review** and add the Label **In Code Review**
3. Review the **Files changed** tab and add any inline comments ( click line number ) you have feedback with
4. Add any overall feedback as a new comment on the main **Conversation** tab
5. Once code review is complete, check off the items in the **PR Reviewer** once you have completed them
6. If the PR fails, remove the Label **In Code Review** and select a new label showing what action is needed
7. If the PR Passes, remove all Labels and click **Merge pull request**
8. If you are 100% certain you will never need that branch again, you can delete the branch after merging into master
9. Contact the PR Author and let them know the results of your review
10. Stay on top of any PR's you are reviewing until they are able to be successfully merged into master
