# generated by datamodel-codegen:
#   filename:  features.json
#   timestamp: 2025-04-15T21:45:14+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import Field, RootModel, ConfigDict


class Features(EidosModel):
    """
    GeoJSON schemas
    """


class Point(EidosModel):
    """
    Point Model
    """

    coordinates: List[Union[float, int]] = Field(..., title="Coordinates")
    type: Literal["Point"] = Field("Point", title="Type")


class MultiPoint(EidosModel):
    """
    MultiPoint Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=1, title="Coordinates"
    )
    type: Literal["MultiPoint"] = Field("MultiPoint", title="Type")


class LineString(EidosModel):
    """
    LineString Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=2, title="Coordinates"
    )
    type: Literal["LineString"] = Field("LineString", title="Type")


class Coordinate(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class MultiLineString(EidosModel):
    """
    MultiLineString Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title="Coordinates")
    type: Literal["MultiLineString"] = Field("MultiLineString", title="Type")


class Polygon(EidosModel):
    """
    Polygon Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title="Coordinates")
    type: Literal["Polygon"] = Field("Polygon", title="Type")


class Coordinate2Item(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class Coordinate2(RootModel[List[Coordinate2Item]]):
    root: List[Coordinate2Item]


class MultiPolygon(EidosModel):
    """
    MultiPolygon Model
    """

    coordinates: List[Coordinate2] = Field(..., min_length=1, title="Coordinates")
    type: Literal["MultiPolygon"] = Field("MultiPolygon", title="Type")


class GeometryCollection(EidosModel):
    """
    GeometryCollection Model
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    type: Literal["GeometryCollection"] = Field("GeometryCollection", title="Type")
    geometries: List[
        Union[Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon]
    ] = Field(..., title="Geometries")


class Type(str, Enum):
    Feature = "Feature"


class Feature(EidosModel):
    """
    Feature Model
    """

    type: Optional[Type] = Field(None, title="Type")
    geometry: Optional[
        Union[
            Point,
            MultiPoint,
            LineString,
            MultiLineString,
            Polygon,
            MultiPolygon,
            GeometryCollection,
        ]
    ] = Field(None, title="Geometry")
    properties: Optional[Dict[str, Any]] = Field(None, title="Properties")
    id: Optional[str] = Field(None, title="Id")
    bbox: Optional[List[Union[float, int]]] = Field(None, title="Bbox")
