# generated by datamodel-codegen:
#   filename:  node/document.json
#   timestamp: 2025-05-20T08:49:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict


class JustifyContent(str, Enum):
    """
    Justify content
    """

    left = 'left'
    center = 'center'
    right = 'right'


class DocumentStyle(EidosModel):
    """
    Document style overrides
    """

    fontSize: Optional[str] = '12px'
    """
    Font size
    """
    fontFamily: Optional[str] = 'Arial'
    """
    Font family
    """
    fontColor: Optional[str] = '#000'
    """
    Font color
    """
    lineHeight: Optional[str] = '1.5em'
    """
    Line height
    """
    backgroundColor: Optional[str] = '#fff0'
    """
    Background color
    """
    padding: Optional[str] = '10px'
    """
    Padding
    """
    margin: Optional[str] = '0'
    """
    Margin
    """
    justifyContent: Optional[JustifyContent] = 'left'
    """
    Justify content
    """


class Document(EidosModel):
    """
    Specification for document node
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    """
    Unique id of the node
    """
    nodeType: Literal['document'] = 'document'
    content: str
    """
    Document content as templated markdown
    """
    style: Optional[DocumentStyle] = None
