# generated by datamodel-codegen:
#   filename:  node/grid.json
#   timestamp: 2025-05-20T08:49:01+00:00

from __future__ import annotations

from typing import List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict

from . import document, plot, world


class GridSize(EidosModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cols: int
    """
    Number of columns in grid
    """
    rows: int
    """
    Number of rows in grid
    """


class GridLayoutItem(EidosModel):
    """
    Positioning of node in grid layout
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    w: int
    """
    Width in columns
    """
    h: int
    """
    height in rows
    """
    x: int
    """
    Origin in columns
    """
    y: int
    """
    Origin in rows from top
    """


class Grid(EidosModel):
    """
    EIDOS grid node specifications
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    """
    Unique id of the node
    """
    nodeType: Literal['grid'] = 'grid'
    gridSize: GridSize
    gridLayout: Optional[List[GridLayoutItem]] = None
    children: List[Union[world.World, plot.Plot, document.Document]]
