# generated by datamodel-codegen:
#   filename:  node/world.json
#   timestamp: 2025-05-20T08:49:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel

from .. import state as state_1


class LayerSpec(EidosModel):
    """
    Layer specification
    """

    layerType: str
    """
    Type of layer
    """


class BaseLayerPreset(str, Enum):
    """
    Base layer type
    """

    oceanum = 'oceanum'
    terrain = 'terrain'


class ViewType(str, Enum):
    """
    Type of world view
    """

    map = 'map'
    globe = 'globe'


class View(EidosModel):
    """
    State of the map view
    """

    viewType: Optional[ViewType] = 'map'
    """
    Type of world view
    """
    longitude: float
    """
    Longitude of view center
    """
    latitude: float
    """
    Latitude of view center
    """
    pitch: Optional[float] = 0
    """
    Pitch angle of view
    """
    bearing: Optional[float] = 0
    """
    Bearing angle of view
    """
    maxZoom: Optional[float] = 20
    """
    Maximum zoom level
    """
    zoom: Optional[float] = 0
    """
    Zoom level
    """
    maxPitch: Optional[float] = 60
    """
    Maximum pitch angle
    """


class Colormap(EidosModel):
    """
    Scale and domain argument for chroma.scale
    """

    scale: Optional[Union[List[str], str]] = None
    domain: Optional[List[Union[float, str]]] = None


class Color(RootModel[Union[List[float], str]]):
    root: Union[List[float], str] = Field(..., title='Color definition')


class Visibility(str, Enum):
    """
    When to show labels
    """

    always = 'always'
    click = 'click'
    hover = 'hover'


class Label(EidosModel):
    """
    Label properties
    """

    format: Optional[str] = None
    """
    Label format string as templated markdown. {{value}} if the layer value
    """
    visibility: Optional[Visibility] = None
    """
    When to show labels
    """
    activeOnly: Optional[bool] = None
    """
    Only show labels for active layer
    """


class HoverInfo(EidosModel):
    """
    Properties for tooltip shown on hover
    """

    template: str
    """
    Tooltip as Handlebars template. The picked object is passed as the render context.
    """


class StyleAccessorString(RootModel[str]):
    root: str = Field(..., title='Style accessor constant string')
    """
    Constant value
    """


class StyleAccessorNumber(RootModel[float]):
    root: float = Field(..., title='Style accessor constant number')
    """
    Constant value
    """


class StyleAccessorArray(RootModel[List[float]]):
    """
    Array of constant values
    """

    root: List[float] = Field(..., title='Style accessor constant array')
    """
    Array of constant values
    """


class StyleAccessorFunction(EidosModel):
    """
    Accessor function
    """

    function: Optional[str] = None
    """
    Accessor function identifier
    """
    args: Optional[List[str]] = None
    """
    Arguments for accessor function
    """


class Type(str, Enum):
    """
    Control type
    """

    points = 'points'
    polygon = 'polygon'
    bbox = 'bbox'
    radius = 'radius'
    drop = 'drop'
    measure = 'measure'


class CursorOffset(EidosModel):
    """
    Cursor offset
    """

    x: Optional[float] = 0
    y: Optional[float] = 0


class Icon(EidosModel):
    """
    Icon URLs
    """

    default: str
    """
    Default icon URL
    """
    hover: Optional[str] = None
    """
    Active hover icon URL
    """
    dark: Optional[str] = None
    """
    Dark theme icon URL
    """
    cursorOffset: Optional[CursorOffset] = None
    """
    Cursor offset
    """


class Control(EidosModel):
    """
    Control properties
    """

    type: Type
    """
    Control type
    """
    id: str
    """
    Control id
    """
    active: Optional[bool] = None
    """
    Control active state
    """
    disabled: Optional[bool] = None
    """
    Control disabled state
    """
    state: Optional[Dict[str, Any]] = None
    """
    Control state
    """
    icon: Optional[Icon] = None
    """
    Icon URLs
    """
    tooltip: Optional[str] = None
    """
    Tooltip text
    """
    config: Optional[Dict[str, Any]] = None


class Orientation(str, Enum):
    horizontal = 'horizontal'
    vertical = 'vertical'


class ControlGroup(EidosModel):
    """
    Control group
    """

    id: str
    """
    Control group id
    """
    orientation: Optional[Orientation] = None
    controls: List[Control]
    """
    Control list
    """
    visible: Optional[bool] = True
    """
    Visibility of control group
    """


class LayerSelector(EidosModel):
    """
    Layer selector
    """

    open: Optional[bool] = True
    """
    Visibility of layer selector
    """


class Legend1(EidosModel):
    """
    Legend properties
    """

    labels: Optional[List[Union[str, float]]] = None
    """
    Legend labels
    """


class Legend(RootModel[Union[Legend1, bool]]):
    root: Union[Legend1, bool] = Field(..., title='Legend definition')
    """
    Legend properties
    """


class WorldLayer(EidosModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    """
    Unique id of layer
    """
    name: Optional[str] = None
    """
    Human readable name of layer
    """
    nodeType: Literal['worldlayer']
    dataId: Optional[str] = None
    """
    Name of data
    """
    label: Optional[Label] = None
    visible: Optional[bool] = True
    """
    Layer is visible
    """
    showWith: Optional[List] = []
    """
    Other layers than can be shown at same time as this layer
    """
    linked: Optional[str] = None
    """
    Linked layer id which controls this layer visibility
    """
    hoverInfo: Optional[HoverInfo] = None
    layerSpec: LayerSpec
    minZoom: Optional[float] = 0
    """
    Minimum zoom level at which layer is visible
    """
    maxZoom: Optional[float] = 20
    """
    Maximum zoom level at which layer is visible
    """


class BaseLayer(RootModel[Union[BaseLayerPreset, Dict[str, Any]]]):
    root: Union[BaseLayerPreset, Dict[str, Any]]


class StyleAccessor(
    RootModel[
        Union[
            StyleAccessorString,
            StyleAccessorNumber,
            StyleAccessorFunction,
            StyleAccessorArray,
        ]
    ]
):
    root: Union[
        StyleAccessorString,
        StyleAccessorNumber,
        StyleAccessorFunction,
        StyleAccessorArray,
    ] = Field(..., title='Style accessor definition')
    """
    Style properties
    """


class World(EidosModel):
    """
    Specification for world view environmental interaction and display
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    """
    Unique id of the node
    """
    nodeType: Literal['world'] = 'world'
    children: Optional[List[WorldLayer]] = None
    """
    Layers displayed on this map
    """
    baseLayer: Optional[BaseLayer] = None
    viewState: Optional[View] = None
    currentTime: Optional[state_1.CurrentTime] = None
    currentContext: Optional[state_1.CurrentContext] = None
    timeControl: Optional[state_1.TimeControl] = None
    layerSelector: Optional[Union[bool, LayerSelector]] = None
    mapControls: Optional[List[ControlGroup]] = None
    """
    Map controls
    """
