# generated by datamodel-codegen:
#   filename:  node/worldlayer/scenegraph.json
#   timestamp: 2025-05-20T08:49:01+00:00

from __future__ import annotations

from typing import Any, Dict, Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field

from .. import world


class Gltf(EidosModel):
    """
    name or URLs of GLTF model keyed to data property
    """

    model_config = ConfigDict(
        extra='allow',
    )
    field_default: str = Field(..., alias='_default')


class Scenegraph(EidosModel):
    key: Optional[str] = Field(None, title='Scenegraph key')
    """
    Data field to use as key for scenegraph model
    """
    gltf: Gltf = Field(..., title='GLTF models')
    """
    name or URLs of GLTF model keyed to data property
    """


class ScenegraphLayerDatakeys(EidosModel):
    """
    Mapping from data variables to geometry
    """

    model_config = ConfigDict(
        extra='allow',
    )
    x: str
    y: str
    z: Optional[str] = 'z'
    roll: Optional[str] = 'roll'
    pitch: Optional[str] = 'pitch'
    yaw: Optional[str] = 'yaw'
    xoffset: Optional[str] = 'xoffset'
    yoffset: Optional[str] = 'yoffset'
    zoffset: Optional[str] = 'zoffset'
    xscale: Optional[str] = 'xscale'
    yscale: Optional[str] = 'yscale'
    zscale: Optional[str] = 'zscale'


class ScenegraphLayerSpec(EidosModel):
    """
    Specification for Scenegraph layer
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    layerType: Literal['scenegraph']
    datakeys: ScenegraphLayerDatakeys
    colormap: Optional[world.Colormap] = None
    scenegraph: Optional[Scenegraph] = None
    style: Optional[Dict[str, Any]] = None
