# generated by datamodel-codegen:
#   filename:  node/worldlayer/track.json
#   timestamp: 2025-05-20T08:49:01+00:00

from __future__ import annotations

from typing import Any, Dict, Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field

from .. import world


class Track(EidosModel):
    key: Optional[str] = Field(None, title='Track key')
    """
    Data field to use as key for grouping tracks
    """
    history: Optional[str] = Field('PT1H', title='Track history')
    """
    Length of previous positions to show (ISO8601 period)
    """


class TrackLayerDatakeys(EidosModel):
    """
    Mapping from data variables to lon,lat and time
    """

    model_config = ConfigDict(
        extra='allow',
    )
    x: str
    y: str
    t: str


class TrackLayerSpec(EidosModel):
    """
    Specification for Track overlay layer
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    layerType: Literal['track']
    datakeys: TrackLayerDatakeys
    colormap: Optional[world.Colormap] = None
    style: Optional[Dict[str, Any]] = None
    track: Track
    legend: Optional[world.Legend] = None
