# generated by datamodel-codegen:
#   filename:  theme.json
#   timestamp: 2025-05-20T08:49:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from oceanum.eidos._basemodel import EidosModel


class Preset(str, Enum):
    """
    Color scheme for the view
    """

    default = 'default'
    dark = 'dark'


class EidosStyle(EidosModel):
    primaryColor: Optional[str] = '#0d2d3f'
    """
    Primary color of the view
    """
    secondaryColor: Optional[str] = '#a9dce0'
    """
    Secondary color of the view
    """
    accentColor: Optional[str] = '#b84528'
    """
    Accent color of the view
    """
    backgroundColor: Optional[str] = '#ffffff'
    """
    Background color of the view
    """
    textColor: Optional[str] = '#212529'
    """
    Text color of the view
    """
    fontFamily: Optional[str] = (
        'system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", "Noto Sans", "Liberation Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"'
    )
    """
    Font family of the view
    """
    fontSize: Optional[str] = '1rem'
    """
    Font size of the view
    """
    textFontWeight: Optional[float] = 400
    """
    Font weight of the text
    """
    textLineHeight: Optional[float] = 1.5
    """
    Line height of the text
    """
    textAlign: Optional[str] = 'left'
    """
    Text alignment of the view
    """
    borderWidth: Optional[str] = '1px'
    """
    Width of the border
    """
    borderStyle: Optional[str] = 'solid'
    """
    Style of the border
    """
    borderRadius: Optional[str] = 0.375
    """
    Radius of the border
    """
    titleSize: Optional[str] = '2.0rem'
    """
    Size of the title
    """


class EidosTheme(EidosModel):
    preset: Optional[Preset] = 'default'
    """
    Color scheme for the view
    """
    style: Optional[EidosStyle] = None
