# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import base_t
from . import job_definition_t

__all__: list[str] = [
    "InvocationContext",
    "InvocationContextBase",
    "InvocationContextCron",
    "InvocationContextManual",
    "InvocationContextType",
    "InvocationContextWebhook",
    "QueuedJob",
    "QueuedJobPayload",
    "QueuedJobResult",
]


# DO NOT MODIFY -- This file is generated by type_spec
class InvocationContextType(StrEnum):
    CRON = "cron"
    MANUAL = "manual"
    WEBHOOK = "webhook"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.InvocationContextBase",
)
@dataclasses.dataclass(kw_only=True)
class InvocationContextBase:
    type: InvocationContextType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.InvocationContextCron",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class InvocationContextCron(InvocationContextBase):
    type: typing.Literal[InvocationContextType.CRON] = InvocationContextType.CRON


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.InvocationContextManual",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class InvocationContextManual(InvocationContextBase):
    type: typing.Literal[InvocationContextType.MANUAL] = InvocationContextType.MANUAL


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.InvocationContextWebhook",
    unconverted_values={"webhook_payload"},
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class InvocationContextWebhook(InvocationContextBase):
    type: typing.Literal[InvocationContextType.WEBHOOK] = InvocationContextType.WEBHOOK
    webhook_payload: base_t.JsonValue


# DO NOT MODIFY -- This file is generated by type_spec
InvocationContext = typing.Annotated[
    InvocationContextCron | InvocationContextManual | InvocationContextWebhook,
    serial_union_annotation(
    named_type_path="sdk.queued_job.InvocationContext",
        discriminator="type",
        discriminator_map={
            "cron": InvocationContextCron,
            "manual": InvocationContextManual,
            "webhook": InvocationContextWebhook,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.QueuedJobPayload",
)
@dataclasses.dataclass(kw_only=True)
class QueuedJobPayload:
    invocation_context: InvocationContext


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.QueuedJobResult",
)
@dataclasses.dataclass(kw_only=True)
class QueuedJobResult:
    queued_job_uuid: str
    job_result: job_definition_t.JobResult


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.queued_job.QueuedJob",
)
@dataclasses.dataclass(kw_only=True)
class QueuedJob:
    queued_job_uuid: str
    job_ref_name: str
    num_attempts: int
    submitted_at: datetime.datetime
    payload: QueuedJobPayload
# DO NOT MODIFY -- This file is generated by type_spec
