from typing import Any, Protocol, runtime_checkable, Tuple, Self, Union

class Element:
    @property
    def tag_name(self) -> str: ...
    @property
    def attributes(self) -> dict[str, str]: ...
    @property
    def removed(self) -> bool: ...
    def get_attribute(self, name: str) -> str | None: ...
    def has_attribute(self, name: str) -> bool: ...
    def set_attribute(self, name: str, value: str) -> None: ...

    # Pythonic alias
    def remove_attribute(self, name: str) -> None: ...
    def before(self, content: str, text: bool = True) -> None: ...
    def after(self, content: str, text: bool = True) -> None: ...

class Comment:
    @property
    def text(self) -> str: ...
    def set_text(self, value: str) -> None: ...
    @property
    def removed(self) -> bool: ...
    def remove(self) -> None: ...
    def before(self, content: str, text: bool = True) -> None: ...
    def after(self, content: str, text: bool = True) -> None: ...

class TextChunk:
    @property
    def text(self) -> str: ...
    def set_text(self, value: str) -> None: ...
    @property
    def removed(self) -> bool: ...
    def remove(self) -> None: ...
    @property
    def last_in_text_node(self) -> bool: ...
    def before(self, content: str, text: bool = True) -> None: ...
    def after(self, content: str, text: bool = True) -> None: ...

@runtime_checkable
class ElementEntryHandler(Protocol):
    def element(self, el: Element) -> Any: ...

@runtime_checkable
class CommentEntryHandler(Protocol):
    def comments(self, c: Comment) -> Any: ...

@runtime_checkable
class TextEntryHandler(Protocol):
    def text(self, t: TextChunk) -> Any: ...

ElementHandler = Union[ElementEntryHandler, CommentEntryHandler, TextEntryHandler]

class HTMLRewriter:
    def __init__(self) -> None: ...
    def on(self, selector: str, element_handler: ElementHandler) -> Self: ...
    def transform(self, html: str | bytes) -> bytes: ...

__all__: Tuple[str, ...] = [
    "Element",
    "Comment",
    "TextChunk",
    "HTMLRewriter",
    "ElementHandler",
]
