"""coBib - the Console Bibliography.

[![coBib](https://gitlab.com/cobib/cobib/-/raw/master/docs/logo/cobib_logo.svg)](https://cobib.gitlab.io/cobib/cobib.html)

.. include:: ../../README.md
   :start-after: # coBib
"""

import subprocess
from pathlib import Path

__version__ = "6.0.1"

if (Path(__file__).parent.parent.parent / ".git").exists():  # pragma: no branch
    # if installed from source, append HEAD commit SHA to version info as metadata
    with subprocess.Popen(["git", "rev-parse", "HEAD"], stdout=subprocess.PIPE) as proc:
        git_revision, _ = proc.communicate()
    __version__ += "+" + git_revision.decode("utf-8")[:7]
