cobib-review(1) -- review entries
=================================

## SYNOPSIS

`cobib review` [`-c|--context`] [`-r|--resume` _SHA_] [`-d|--done` _LABEL_ ...] [`-s|--selection`] [_FIELD_ ...] [`--`] [_FILTER_ ...]

## DESCRIPTION

Reviews entries of the database.
Rather than manually searching for and inspecting entries individually or figuring out clever bulk modifications (see *cobib-modify(1)*) this command provides an interactive review process.
This is especially helpful as your knowledge of your database changes and develops over time.

In its simplest form, the entire database can be reviewed:
```bash
$ cobib review
```

Since this can be quite a lot of information to review all at once, the review can be narrowed down using filters (see *cobib-filter(7)*).
For example, the following command reviews all entries from the year 2023:
```bash
$ cobib review -- ++year 2023
```
Just like with other commands, a manual selection of labels can also be used:
```bash
$ cobib review --selection -- Label1 Label2 ...
```

Additionally, it is also possible to narrow the review down to one or more fields rather than the entire entries:
```bash
$ cobib review tags -- ++year 2023  # review the tags of entries from the year 2023
$ cobib review ENTRYTYPE year       # review the ENTRYTYPE and year of all entries
```
When narrowing down the review like above, the preview only shows the selected fields.
It is possible to request more context interactively (see below) or via the `--context` option.

### How it works

For every entry being reviewed, the contents (possibly narrowed down to the selected _fields_) and an interactive prompt are presented.
The following actions are possible:

  * `edit`:
    Opens the entry using `config.commands.edit.editor` for editing.

  * `done`:
    Completes the review of _this_ entry.

  * `skip`:
    Skips the review of _this_ entry.
    This differs from `done` since this entry will come up again in a future continuation of this review.

  * `context`:
    Requests additional context and updates the preview to contain all the information stored in the entry.
    This is only available when `--context` was _NOT_ already set and when the review has been narrowed to one or more specific _fields_.

  * `finish`:
    Closes the review process (even if some entries and have not been reviewed yet) and saves the progress to the database.
    This allows performing reviews in smaller chunks via the `--resume` option (when the git integration (see *cobib-git(7)*) is enabled).

  * `inline`:
    Performs an in-line edit of a specific field (i.e. without having to open the entry in an external editor).
    When reviewing a single _field_, simply typing `inline` will edit that one.
    When reviewing more than one _field_, specify which field to edit in-line using `inline <field>`.
    This is a highly experimental feature so please be aware of bugs and report any issues or suggestions online: https://gitlab.com/cobib/cobib/-/issues/new

### Resuming a previously started review

A review can be finished early via the `finish` action (see above).
When this is done and the git integration (see *cobib-git(7)*) is enabled, one can continue the review where left using the `--resume` option.
This option takes a git commit identifier as its argument.
If it is certain, that the last auto-commit was that of a review, one can simply use `HEAD` like so:
```bash
$ cobib review --resume HEAD
```
Otherwise, one should find the SHA of the auto-commit generated by the review command.

When resuming a previously started review, all filters and command-line options are preserved.
Additionally, all entries that were completed using the `done` action, will not be shown again.
However, entries on which the `skip` action was used before, will now show up again.

## OPTIONS

  * `-c`, `--context`:
    Previews the entire entry data during the review process even if one or more _FIELD_ arguments were supplied.
    This disables the `context` action from the interactive menu (since it is automatically enabled by this option).

  * `-r`, `--resume`=_SHA_:
    Specifies a git commit identifier of a previous review auto-commit from which to resume.
    This requires the git integration (see *cobib-git(7)*) to be enabled.

  * `-d`, `--done`=_LABEL_ ...:
    Specifies a list of labels to exclude from the review even if they would match the _FILTER_ criteria.
    This is not necessarily super useful on its own, but simply exposes the internal mechanism of the `--resume` option.

  * `-s`, `--selection`:
    Switches from the *cobib-filter(7)* mechanism to interpreting the _FILTER_ arguments as a list of plain entry labels.
    This is not necessarily super useful for using from the command-line, but integrates well with the visual selection in the *cobib-tui(7)*!

## EXAMPLES

Simple reviews of the entire database:
```bash
$ cobib review
$ cobib review --resume HEAD
$ cobib review --done Label1 Label2
```

Review of a subset of the database:
```bash
$ cobib review -- -x ++year 2023 ++year 2024
```

Review of specific fields:
```bash
$ cobib review author tags
```

Review of specific fields of a subset of the database:
```bash
$ cobib review tags -- ++tags new  # review the tags of all entries with the `new` tag
```

## SEE ALSO

*cobib(1)*, *cobib-commands(7)*, *cobib-filter(7)*, *cobib-git(7)*

[//]: # ( vim: set ft=markdown tw=0: )
