"""For is_shared disallow nullable

Revision ID: be56dc0fb760
Revises: 680c64565f9d
Create Date: 2024-05-31 17:44:17.975779

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy.ext.declarative import declarative_base
from zou.migrations.utils.base import BaseMixin


# revision identifiers, used by Alembic.
revision = "be56dc0fb760"
down_revision = "680c64565f9d"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    base = declarative_base()

    class SearchFilter(base, BaseMixin):
        """
        Filters allow to store quick search on a list: asset list, shot list,
        sequence list, todo-list...
        """

        __tablename__ = "search_filter"
        list_type = sa.Column(sa.String(80), nullable=False, index=True)
        entity_type = sa.Column(sa.String(80))
        name = sa.Column(sa.String(200), nullable=False, default="")
        search_query = sa.Column(sa.String(500), nullable=False, default="")
        is_shared = sa.Column(
            sa.Boolean,
            default=False,
            nullable=True,
        )

    class SearchFilterGroup(base, BaseMixin):
        """
        Groups are used to store search filters into sections.
        """

        __tablename__ = "search_filter_group"
        list_type = sa.Column(sa.String(80), nullable=False, index=True)
        entity_type = sa.Column(sa.String(80))
        name = sa.Column(sa.String(200), nullable=False, default="")
        color = sa.Column(sa.String(8), nullable=False, default="")
        is_shared = sa.Column(
            sa.Boolean,
            default=False,
            nullable=True,
        )

    bind = op.get_bind()
    session = orm.Session(bind=bind)
    session.query(SearchFilter).where(SearchFilter.is_shared == None).update(
        {SearchFilter.is_shared: False}
    )
    session.query(SearchFilterGroup).where(
        SearchFilterGroup.is_shared == None
    ).update({SearchFilterGroup.is_shared: False})
    session.commit()

    with op.batch_alter_table("search_filter", schema=None) as batch_op:
        batch_op.alter_column(
            "is_shared",
            existing_type=sa.BOOLEAN(),
            server_default=sa.sql.expression.false(),
            nullable=False,
        )

    with op.batch_alter_table("search_filter_group", schema=None) as batch_op:
        batch_op.alter_column(
            "is_shared",
            existing_type=sa.BOOLEAN(),
            server_default=sa.sql.expression.false(),
            nullable=False,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("search_filter_group", schema=None) as batch_op:
        batch_op.alter_column(
            "is_shared", existing_type=sa.BOOLEAN(), nullable=True
        )

    with op.batch_alter_table("search_filter", schema=None) as batch_op:
        batch_op.alter_column(
            "is_shared", existing_type=sa.BOOLEAN(), nullable=True
        )

    # ### end Alembic commands ###
