"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunctionProvider = void 0;
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
class EdgeFunctionProvider extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const cr = new custom_resources_1.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'SSM',
                action: 'getParameter',
                parameters: {
                    Name: props.parameter.parameterName,
                },
                region: 'us-east-1',
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(Date.now().toString()),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.parameter.parameterArn],
            }),
        });
        this.lambdaFunction = aws_lambda_1.Function.fromFunctionArn(this, 'Function', cr.getResponseField('Parameter.Value'));
    }
}
exports.EdgeFunctionProvider = EdgeFunctionProvider;
//# sourceMappingURL=data:application/json;base64,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