"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaAtEdgeParameter = void 0;
const retrieve_lambda_at_edge_1 = require("./retrieve-lambda-at-edge");
class LambdaAtEdgeParameter {
    constructor(eventType, parameter) {
        this.eventType = eventType;
        this.parameter = parameter;
    }
    retrieve(scope) {
        const { currentVersion } = new retrieve_lambda_at_edge_1.RetrieveLambdaAtEdge(scope, 'Retrieve', {
            parameter: this.parameter,
        });
        return {
            eventType: this.eventType,
            lambdaFunction: currentVersion,
        };
    }
}
exports.LambdaAtEdgeParameter = LambdaAtEdgeParameter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWF0LWVkZ2UtcGFyYW1ldGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2xhbWJkYS1hdC1lZGdlLXBhcmFtZXRlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFPQSx1RUFBaUU7QUFFakUsTUFBYSxxQkFBcUI7SUFDaEMsWUFDbUIsU0FBOEIsRUFDOUIsU0FBMkI7UUFEM0IsY0FBUyxHQUFULFNBQVMsQ0FBcUI7UUFDOUIsY0FBUyxHQUFULFNBQVMsQ0FBa0I7SUFDM0MsQ0FBQztJQUVHLFFBQVEsQ0FBQyxLQUFnQjtRQUM5QixNQUFNLEVBQUUsY0FBYyxFQUFFLEdBQUcsSUFBSSw4Q0FBb0IsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO1lBQ3JFLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztTQUMxQixDQUFDLENBQUM7UUFFSCxPQUFPO1lBQ0wsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGNBQWMsRUFBRSxjQUFjO1NBQy9CLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFoQkQsc0RBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQge1xuICBMYW1iZGFGdW5jdGlvbkFzc29jaWF0aW9uLFxuICBMYW1iZGFFZGdlRXZlbnRUeXBlLFxufSBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWRmcm9udCc7XG5pbXBvcnQgeyBJU3RyaW5nUGFyYW1ldGVyIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNzbSc7XG5cbmltcG9ydCB7IFJldHJpZXZlTGFtYmRhQXRFZGdlIH0gZnJvbSAnLi9yZXRyaWV2ZS1sYW1iZGEtYXQtZWRnZSc7XG5cbmV4cG9ydCBjbGFzcyBMYW1iZGFBdEVkZ2VQYXJhbWV0ZXIge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IGV2ZW50VHlwZTogTGFtYmRhRWRnZUV2ZW50VHlwZSxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHBhcmFtZXRlcjogSVN0cmluZ1BhcmFtZXRlcixcbiAgKSB7fVxuXG4gIHB1YmxpYyByZXRyaWV2ZShzY29wZTogQ29uc3RydWN0KTogTGFtYmRhRnVuY3Rpb25Bc3NvY2lhdGlvbiB7XG4gICAgY29uc3QgeyBjdXJyZW50VmVyc2lvbiB9ID0gbmV3IFJldHJpZXZlTGFtYmRhQXRFZGdlKHNjb3BlLCAnUmV0cmlldmUnLCB7XG4gICAgICBwYXJhbWV0ZXI6IHRoaXMucGFyYW1ldGVyLFxuICAgIH0pO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGV2ZW50VHlwZTogdGhpcy5ldmVudFR5cGUsXG4gICAgICBsYW1iZGFGdW5jdGlvbjogY3VycmVudFZlcnNpb24sXG4gICAgfTtcbiAgfVxufVxuIl19