"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WithConfiguration = exports.LogLevel = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
var LogLevel;
(function (LogLevel) {
    LogLevel["NONE"] = "none";
    LogLevel["INFO"] = "info";
    LogLevel["WARN"] = "warn";
    LogLevel["ERROR"] = "error";
    LogLevel["DEBUG"] = "debug";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
class WithConfiguration extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resourceType = 'Custom::WithConfiguration';
        const handler = new aws_lambda_1.SingletonFunction(this, 'Handler', {
            uuid: 'cloudcomponents-cdk-lambda-at-edge-pattern-with-configuration',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'with-configuration')),
            handler: 'index.handler',
            lambdaPurpose: resourceType,
            timeout: core_1.Duration.minutes(5),
        });
        handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['lambda:GetFunction', 'lambda:UpdateFunctionCode'],
            resources: [props.function.functionArn],
        }));
        const cr = new core_1.CustomResource(this, 'WithConfiguration', {
            serviceToken: handler.functionArn,
            resourceType,
            properties: {
                Region: 'us-east-1',
                FunctionName: props.function.functionName,
                Configuration: JSON.stringify(props.configuration, null, 2),
            },
        });
        this.lambdaFunction = aws_lambda_1.Version.fromVersionArn(this, 'Version', cr.getAttString('FunctionArn'));
    }
}
exports.WithConfiguration = WithConfiguration;
//# sourceMappingURL=data:application/json;base64,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