/*
 * Decompiled with CFR 0.152.
 */
package org.ray.api;

import java.util.List;
import java.util.concurrent.Callable;
import org.ray.api.RayCall;
import org.ray.api.RayObject;
import org.ray.api.WaitResult;
import org.ray.api.id.ObjectId;
import org.ray.api.id.UniqueId;
import org.ray.api.runtime.RayRuntime;
import org.ray.api.runtime.RayRuntimeFactory;
import org.ray.api.runtimecontext.RuntimeContext;

public final class Ray
extends RayCall {
    private static RayRuntime runtime = null;

    public static void init() {
        try {
            Class<?> clz = Class.forName("org.ray.runtime.DefaultRayRuntimeFactory");
            RayRuntimeFactory factory = (RayRuntimeFactory)clz.newInstance();
            Ray.init(factory);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Ray runtime.", e);
        }
    }

    public static synchronized void init(RayRuntimeFactory factory) {
        if (runtime == null) {
            runtime = factory.createRayRuntime();
            Runtime.getRuntime().addShutdownHook(new Thread(Ray::shutdown));
        }
    }

    public static void shutdown() {
        if (runtime != null) {
            runtime.shutdown();
            runtime = null;
        }
    }

    public static <T> RayObject<T> put(T obj) {
        return runtime.put(obj);
    }

    public static <T> T get(ObjectId objectId) {
        return runtime.get(objectId);
    }

    public static <T> List<T> get(List<ObjectId> objectIds) {
        return runtime.get(objectIds);
    }

    public static <T> WaitResult<T> wait(List<RayObject<T>> waitList, int numReturns, int timeoutMs) {
        return runtime.wait(waitList, numReturns, timeoutMs);
    }

    public static <T> WaitResult<T> wait(List<RayObject<T>> waitList, int numReturns) {
        return runtime.wait(waitList, numReturns, Integer.MAX_VALUE);
    }

    public static <T> WaitResult<T> wait(List<RayObject<T>> waitList) {
        return runtime.wait(waitList, waitList.size(), Integer.MAX_VALUE);
    }

    public static Object getAsyncContext() {
        return runtime.getAsyncContext();
    }

    public static void setAsyncContext(Object asyncContext) {
        runtime.setAsyncContext(asyncContext);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        return runtime.wrapRunnable(runnable);
    }

    public static Callable wrapCallable(Callable callable) {
        return runtime.wrapCallable(callable);
    }

    public static RayRuntime internal() {
        return runtime;
    }

    public static void setResource(UniqueId nodeId, String resourceName, double capacity) {
        runtime.setResource(resourceName, capacity, nodeId);
    }

    public static void setResource(String resourceName, double capacity) {
        runtime.setResource(resourceName, capacity, UniqueId.NIL);
    }

    public static RuntimeContext getRuntimeContext() {
        return runtime.getRuntimeContext();
    }
}

