/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime;

import org.ray.api.runtime.RayRuntime;
import org.ray.api.runtime.RayRuntimeFactory;
import org.ray.runtime.RayDevRuntime;
import org.ray.runtime.RayMultiWorkerNativeRuntime;
import org.ray.runtime.RayNativeRuntime;
import org.ray.runtime.config.RayConfig;
import org.ray.runtime.config.RunMode;
import org.ray.runtime.functionmanager.FunctionManager;
import org.ray.runtime.generated.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRayRuntimeFactory
implements RayRuntimeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRayRuntimeFactory.class);

    @Override
    public RayRuntime createRayRuntime() {
        RayConfig rayConfig = RayConfig.getInstance();
        try {
            FunctionManager functionManager = new FunctionManager(rayConfig.jobResourcePath);
            RayRuntime runtime = rayConfig.runMode == RunMode.SINGLE_PROCESS ? new RayDevRuntime(rayConfig, functionManager) : (rayConfig.workerMode == Common.WorkerType.DRIVER ? new RayNativeRuntime(rayConfig, functionManager) : new RayMultiWorkerNativeRuntime(rayConfig, functionManager));
            return runtime;
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize ray runtime", e);
            throw new RuntimeException("Failed to initialize ray runtime", e);
        }
    }
}

