/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.gcs;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.ray.api.Checkpointable;
import org.ray.api.id.ActorId;
import org.ray.api.id.BaseId;
import org.ray.api.id.JobId;
import org.ray.api.id.TaskId;
import org.ray.api.id.UniqueId;
import org.ray.api.runtimecontext.NodeInfo;
import org.ray.runtime.gcs.RedisClient;
import org.ray.runtime.generated.Gcs;
import org.ray.runtime.util.IdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsClient {
    private static Logger LOGGER = LoggerFactory.getLogger(GcsClient.class);
    private RedisClient primary;
    private List<RedisClient> shards;

    public GcsClient(String redisAddress, String redisPassword) {
        this.primary = new RedisClient(redisAddress, redisPassword);
        int numShards = 0;
        try {
            numShards = Integer.valueOf(this.primary.get("NumRedisShards", null));
            Preconditions.checkState(numShards > 0, String.format("Expected at least one Redis shards, found %d.", numShards));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get number of redis shards.", e);
        }
        List<byte[]> shardAddresses = this.primary.lrange("RedisShards".getBytes(), 0L, -1L);
        Preconditions.checkState(shardAddresses.size() == numShards);
        this.shards = shardAddresses.stream().map(address -> new RedisClient(new String((byte[])address), redisPassword)).collect(Collectors.toList());
    }

    public List<NodeInfo> getAllNodeInfo() {
        String prefix = Gcs.TablePrefix.CLIENT.toString();
        byte[] key = ArrayUtils.addAll(prefix.getBytes(), UniqueId.NIL.getBytes());
        List<byte[]> results = this.primary.lrange(key, 0L, -1L);
        if (results == null) {
            return new ArrayList<NodeInfo>();
        }
        HashMap<UniqueId, NodeInfo> nodes = new HashMap<UniqueId, NodeInfo>();
        for (byte[] byArray : results) {
            NodeInfo nodeInfo;
            Preconditions.checkNotNull(byArray);
            Gcs.GcsNodeInfo data = null;
            try {
                data = Gcs.GcsNodeInfo.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Received invalid protobuf data from GCS.");
            }
            UniqueId nodeId = UniqueId.fromByteBuffer(data.getNodeId().asReadOnlyByteBuffer());
            if (data.getState() == Gcs.GcsNodeInfo.GcsNodeState.ALIVE) {
                nodeInfo = new NodeInfo(nodeId, data.getNodeManagerAddress(), data.getNodeManagerHostname(), true, new HashMap<String, Double>());
                nodes.put(nodeId, nodeInfo);
                continue;
            }
            nodeInfo = new NodeInfo(nodeId, ((NodeInfo)nodes.get((Object)nodeId)).nodeAddress, ((NodeInfo)nodes.get((Object)nodeId)).nodeHostname, false, new HashMap<String, Double>());
            nodes.put(nodeId, nodeInfo);
        }
        for (Map.Entry entry : nodes.entrySet()) {
            if (!((NodeInfo)entry.getValue()).isAlive) continue;
            ((NodeInfo)entry.getValue()).resources.putAll(this.getResourcesForClient((UniqueId)entry.getKey()));
        }
        return new ArrayList<NodeInfo>(nodes.values());
    }

    private Map<String, Double> getResourcesForClient(UniqueId clientId) {
        String prefix = Gcs.TablePrefix.NODE_RESOURCE.toString();
        byte[] key = ArrayUtils.addAll(prefix.getBytes(), clientId.getBytes());
        Map<byte[], byte[]> results = this.primary.hgetAll(key);
        HashMap<String, Double> resources = new HashMap<String, Double>();
        for (Map.Entry<byte[], byte[]> entry : results.entrySet()) {
            Gcs.ResourceTableData resourceTableData;
            String resourceName = new String(entry.getKey());
            try {
                resourceTableData = Gcs.ResourceTableData.parseFrom(entry.getValue());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Received invalid protobuf data from GCS.");
            }
            resources.put(resourceName, resourceTableData.getResourceCapacity());
        }
        return resources;
    }

    public boolean actorExists(ActorId actorId) {
        byte[] key = ArrayUtils.addAll(Gcs.TablePrefix.ACTOR.toString().getBytes(), actorId.getBytes());
        return this.primary.exists(key);
    }

    public boolean rayletTaskExistsInGcs(TaskId taskId) {
        byte[] key = ArrayUtils.addAll(Gcs.TablePrefix.RAYLET_TASK.toString().getBytes(), taskId.getBytes());
        RedisClient client = this.getShardClient(taskId);
        return client.exists(key);
    }

    public List<Checkpointable.Checkpoint> getCheckpointsForActor(ActorId actorId) {
        ArrayList<Checkpointable.Checkpoint> checkpoints = new ArrayList<Checkpointable.Checkpoint>();
        String prefix = Gcs.TablePrefix.ACTOR_CHECKPOINT_ID.toString();
        byte[] key = ArrayUtils.addAll(prefix.getBytes(), actorId.getBytes());
        RedisClient client = this.getShardClient(actorId);
        byte[] result = client.get(key);
        if (result != null) {
            int i;
            Gcs.ActorCheckpointIdData data = null;
            try {
                data = Gcs.ActorCheckpointIdData.parseFrom(result);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Received invalid protobuf data from GCS.");
            }
            UniqueId[] checkpointIds = new UniqueId[data.getCheckpointIdsCount()];
            for (i = 0; i < checkpointIds.length; ++i) {
                checkpointIds[i] = UniqueId.fromByteBuffer(data.getCheckpointIds(i).asReadOnlyByteBuffer());
            }
            for (i = 0; i < checkpointIds.length; ++i) {
                checkpoints.add(new Checkpointable.Checkpoint(checkpointIds[i], data.getTimestamps(i)));
            }
        }
        checkpoints.sort((x, y) -> Long.compare(y.timestamp, x.timestamp));
        return checkpoints;
    }

    public JobId nextJobId() {
        int jobCounter = (int)this.primary.incr("JobCounter".getBytes());
        return JobId.fromInt(jobCounter);
    }

    private RedisClient getShardClient(BaseId key) {
        return this.shards.get((int)Long.remainderUnsigned(IdUtil.murmurHashCode(key), this.shards.size()));
    }
}

