/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.object;

import java.util.Arrays;
import org.ray.api.exception.RayActorException;
import org.ray.api.exception.RayTaskException;
import org.ray.api.exception.RayWorkerException;
import org.ray.api.exception.UnreconstructableException;
import org.ray.api.id.ObjectId;
import org.ray.runtime.generated.Gcs;
import org.ray.runtime.object.NativeRayObject;
import org.ray.runtime.util.Serializer;

public class ObjectSerializer {
    private static final byte[] WORKER_EXCEPTION_META = String.valueOf(Gcs.ErrorType.WORKER_DIED.getNumber()).getBytes();
    private static final byte[] ACTOR_EXCEPTION_META = String.valueOf(Gcs.ErrorType.ACTOR_DIED.getNumber()).getBytes();
    private static final byte[] UNRECONSTRUCTABLE_EXCEPTION_META = String.valueOf(Gcs.ErrorType.OBJECT_UNRECONSTRUCTABLE.getNumber()).getBytes();
    private static final byte[] TASK_EXECUTION_EXCEPTION_META = String.valueOf(Gcs.ErrorType.TASK_EXECUTION_EXCEPTION.getNumber()).getBytes();
    private static final byte[] RAW_TYPE_META = "RAW".getBytes();

    public static Object deserialize(NativeRayObject nativeRayObject, ObjectId objectId, ClassLoader classLoader) {
        byte[] meta = nativeRayObject.metadata;
        byte[] data = nativeRayObject.data;
        if (meta != null && meta.length > 0) {
            if (Arrays.equals(meta, RAW_TYPE_META)) {
                return data;
            }
            if (Arrays.equals(meta, WORKER_EXCEPTION_META)) {
                return new RayWorkerException();
            }
            if (Arrays.equals(meta, ACTOR_EXCEPTION_META)) {
                return new RayActorException();
            }
            if (Arrays.equals(meta, UNRECONSTRUCTABLE_EXCEPTION_META)) {
                return new UnreconstructableException(objectId);
            }
            if (Arrays.equals(meta, TASK_EXECUTION_EXCEPTION_META)) {
                return Serializer.decode(data, classLoader);
            }
            throw new IllegalArgumentException("Unrecognized metadata " + Arrays.toString(meta));
        }
        return Serializer.decode(data, classLoader);
    }

    public static NativeRayObject serialize(Object object) {
        if (object instanceof NativeRayObject) {
            return (NativeRayObject)object;
        }
        if (object instanceof byte[]) {
            return new NativeRayObject((byte[])object, RAW_TYPE_META);
        }
        if (object instanceof RayTaskException) {
            return new NativeRayObject(Serializer.encode(object), TASK_EXECUTION_EXCEPTION_META);
        }
        return new NativeRayObject(Serializer.encode(object), null);
    }
}

