/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.config;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;
import org.ray.streaming.runtime.config.Config;
import org.ray.streaming.runtime.config.global.CommonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingGlobalConfig
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingGlobalConfig.class);
    public final CommonConfig commonConfig;
    public final Map<String, String> configMap;

    public StreamingGlobalConfig(Map<String, String> conf) {
        this.configMap = new HashMap<String, String>(conf);
        this.commonConfig = ConfigFactory.create(CommonConfig.class, conf);
        this.globalConfig2Map();
    }

    public String toString() {
        return this.configMap.toString();
    }

    private void globalConfig2Map() {
        try {
            this.configMap.putAll(this.config2Map(this.commonConfig));
        }
        catch (Exception e) {
            LOG.error("Couldn't convert global config to a map.", e);
        }
    }

    protected Map<String, String> config2Map(org.aeonbits.owner.Config config) throws ClassNotFoundException {
        Method[] methods;
        HashMap<String, String> result = new HashMap<String, String>();
        Class<?> proxyClazz = Class.forName(config.getClass().getName());
        Class<?>[] proxyInterfaces = proxyClazz.getInterfaces();
        Class<?> configInterface = null;
        for (Class<?> proxyInterface : proxyInterfaces) {
            if (!Config.class.isAssignableFrom(proxyInterface)) continue;
            configInterface = proxyInterface;
            break;
        }
        Preconditions.checkArgument(configInterface != null, "Can not get config interface.");
        for (Method method : methods = configInterface.getMethods()) {
            Object value;
            Config.Key ownerKeyAnnotation = method.getAnnotation(Config.Key.class);
            if (ownerKeyAnnotation == null) continue;
            String ownerKeyAnnotationValue = ownerKeyAnnotation.value();
            try {
                value = method.invoke((Object)config, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Can not get value by method invoking for config key: {}. So use default value instead.", (Object)ownerKeyAnnotationValue);
                String defaultValue = method.getAnnotation(Config.DefaultValue.class).value();
                value = defaultValue;
            }
            result.put(ownerKeyAnnotationValue, value + "");
        }
        return result;
    }
}

