/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ray.api.RayActor;
import org.ray.api.id.ActorId;
import org.ray.streaming.runtime.config.master.ResourceConfig;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionEdge;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertexState;
import org.ray.streaming.runtime.core.resource.Slot;
import org.ray.streaming.runtime.master.JobRuntimeContext;
import org.ray.streaming.runtime.worker.JobWorker;

public class ExecutionVertex
implements Serializable {
    private final int vertexId;
    private final int vertexIndex;
    private final String vertexName;
    private final Map<String, Double> resources;
    private ExecutionVertexState state = ExecutionVertexState.TO_ADD;
    private Slot slot;
    private RayActor<JobWorker> workerActor;
    private List<ExecutionEdge> inputEdges = new ArrayList<ExecutionEdge>();
    private List<ExecutionEdge> outputEdges = new ArrayList<ExecutionEdge>();

    public ExecutionVertex(int jobVertexId, int index, ExecutionJobVertex executionJobVertex) {
        this.vertexId = this.generateExecutionVertexId(jobVertexId, index);
        this.vertexIndex = index;
        this.vertexName = executionJobVertex.getJobVertexName() + "-" + this.vertexIndex;
        this.resources = this.generateResources(executionJobVertex.getRuntimeContext());
    }

    private int generateExecutionVertexId(int jobVertexId, int index) {
        return jobVertexId * 100000 + index;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public int getVertexIndex() {
        return this.vertexIndex;
    }

    public ExecutionVertexState getState() {
        return this.state;
    }

    public void setState(ExecutionVertexState state) {
        this.state = state;
    }

    public boolean is2Add() {
        return this.state == ExecutionVertexState.TO_ADD;
    }

    public boolean isRunning() {
        return this.state == ExecutionVertexState.RUNNING;
    }

    public boolean is2Delete() {
        return this.state == ExecutionVertexState.TO_DEL;
    }

    public RayActor<JobWorker> getWorkerActor() {
        return this.workerActor;
    }

    public ActorId getWorkerActorId() {
        return this.workerActor.getId();
    }

    public void setWorkerActor(RayActor<JobWorker> workerActor) {
        this.workerActor = workerActor;
    }

    public List<ExecutionEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public List<ExecutionEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public Map<String, Double> getResources() {
        return this.resources;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public void setSlot(Slot slot) {
        this.slot = slot;
    }

    public void setSlotIfNotExist(Slot slot) {
        if (null == this.slot) {
            this.slot = slot;
        }
    }

    private Map<String, Double> generateResources(JobRuntimeContext runtimeContext) {
        HashMap<String, Double> resourceMap = new HashMap<String, Double>();
        ResourceConfig resourceConfig = runtimeContext.getConf().masterConfig.resourceConfig;
        if (resourceConfig.isTaskCpuResourceLimit()) {
            resourceMap.put("CPU", resourceConfig.taskCpuResource());
        }
        if (resourceConfig.isTaskMemResourceLimit()) {
            resourceMap.put("MEM", resourceConfig.taskMemResource());
        }
        return resourceMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("vertexId", this.vertexId).add("vertexIndex", this.vertexIndex).add("vertexName", this.vertexName).add("resources", this.resources).add("state", this.state).add("slot", this.slot).add("workerActor", this.workerActor).toString();
    }
}

