/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.python;

import com.google.common.io.BaseEncoding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.FloatValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;

public class MsgPackSerializer {
    public byte[] serialize(Object obj) {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        this.serialize(obj, packer);
        return packer.toByteArray();
    }

    private void serialize(Object obj, MessageBufferPacker packer) {
        block13: {
            try {
                if (obj == null) {
                    packer.packNil();
                    break block13;
                }
                Class<?> clz = obj.getClass();
                if (clz == Boolean.class) {
                    packer.packBoolean((Boolean)obj);
                    break block13;
                }
                if (clz == Integer.class) {
                    packer.packInt((Integer)obj);
                    break block13;
                }
                if (clz == Long.class) {
                    packer.packLong((Long)obj);
                    break block13;
                }
                if (clz == Double.class) {
                    packer.packDouble((Double)obj);
                    break block13;
                }
                if (clz == byte[].class) {
                    byte[] bytes = (byte[])obj;
                    packer.packBinaryHeader(bytes.length);
                    packer.writePayload(bytes);
                    break block13;
                }
                if (clz == String.class) {
                    packer.packString((String)obj);
                    break block13;
                }
                if (obj instanceof Collection) {
                    Collection collection = (Collection)obj;
                    packer.packArrayHeader(collection.size());
                    for (Object o : collection) {
                        this.serialize(o, packer);
                    }
                    break block13;
                }
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    packer.packMapHeader(map.size());
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o;
                        Map.Entry e = o = iterator.next();
                        this.serialize(e.getKey(), packer);
                        this.serialize(e.getValue(), packer);
                    }
                    break block13;
                }
                throw new UnsupportedOperationException("Unsupported type " + clz);
            }
            catch (Exception e) {
                throw new RuntimeException("Serialize error for object " + obj, e);
            }
        }
    }

    public Object deserialize(byte[] bytes) {
        try {
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker(bytes);
            return this.deserialize(unpacker.unpackValue());
        }
        catch (Exception e) {
            String hex = BaseEncoding.base16().lowerCase().encode(bytes);
            throw new RuntimeException("Deserialize error: " + hex, e);
        }
    }

    private Object deserialize(Value value) {
        switch (value.getValueType()) {
            case NIL: {
                return null;
            }
            case BOOLEAN: {
                return value.asBooleanValue().getBoolean();
            }
            case INTEGER: {
                IntegerValue iv = value.asIntegerValue();
                if (iv.isInIntRange()) {
                    return iv.toInt();
                }
                if (iv.isInLongRange()) {
                    return iv.toLong();
                }
                return iv.toBigInteger();
            }
            case FLOAT: {
                FloatValue fv = value.asFloatValue();
                return fv.toDouble();
            }
            case STRING: {
                return value.asStringValue().asString();
            }
            case BINARY: {
                return value.asBinaryValue().asByteArray();
            }
            case ARRAY: {
                ArrayValue arrayValue = value.asArrayValue();
                ArrayList<Object> list = new ArrayList<Object>(arrayValue.size());
                for (Value elem : arrayValue) {
                    list.add(this.deserialize(elem));
                }
                return list;
            }
            case MAP: {
                MapValue mapValue = value.asMapValue();
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (Map.Entry<Value, Value> entry : mapValue.entrySet()) {
                    map.put(this.deserialize(entry.getKey()), this.deserialize(entry.getValue()));
                }
                return map;
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + (Object)((Object)value.getValueType()));
    }
}

