/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.Hashing;
import redis.clients.util.Sharded;

public class BinaryShardedJedis
extends Sharded<Jedis, JedisShardInfo>
implements BinaryJedisCommands {
    public BinaryShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    public void disconnect() {
        for (Jedis jedis : this.getAllShards()) {
            try {
                jedis.quit();
            }
            catch (JedisConnectionException jedisConnectionException) {
                // empty catch block
            }
            try {
                jedis.disconnect();
            }
            catch (JedisConnectionException jedisConnectionException) {}
        }
    }

    protected Jedis create(JedisShardInfo shard) {
        return new Jedis(shard);
    }

    @Override
    public String set(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value);
    }

    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value, nxxx);
    }

    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value, nxxx, expx, time);
    }

    @Override
    public byte[] get(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    @Override
    public Boolean exists(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    @Override
    public String type(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpire(key, milliseconds);
    }

    @Override
    @Deprecated
    public Long pexpire(String key, long milliseconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpire(key, milliseconds);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long ttl(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value);
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value);
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value);
    }

    @Override
    public Long decrBy(byte[] key, long integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, integer);
    }

    @Override
    public Long decr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    @Override
    public Long del(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.del(key);
    }

    @Override
    public Long incrBy(byte[] key, long integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, integer);
    }

    @Override
    public Double incrByFloat(byte[] key, double integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrByFloat(key, integer);
    }

    @Override
    public Long incr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value);
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start, end);
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field, value);
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field, value);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field, value);
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrByFloat(key, field, value);
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field);
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, fields);
    }

    @Override
    public Long hlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    @Override
    public Collection<byte[]> hvals(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, strings);
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, strings);
    }

    @Override
    public Long strlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.strlen(key);
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpushx(key, string);
    }

    @Override
    public Long persist(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.persist(key);
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpushx(key, string);
    }

    @Override
    public Long llen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start, end);
    }

    @Override
    public String ltrim(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start, end);
    }

    @Override
    public byte[] lindex(byte[] key, long index) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index);
    }

    @Override
    public String lset(byte[] key, long index, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index, value);
    }

    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count, value);
    }

    @Override
    public byte[] lpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    @Override
    public byte[] rpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, members);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    @Override
    public Long srem(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, members);
    }

    @Override
    public byte[] spop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key, count);
    }

    @Override
    public Long scard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    @Override
    public byte[] srandmember(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    public List srandmember(byte[] key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key, count);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member, params);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers, params);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start, end);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, members);
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, score, member);
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, score, member, params);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start, end);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start, end);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Long zcard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(byte[] key, double min2, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min2, max);
    }

    @Override
    public Long zcount(byte[] key, byte[] min2, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min2, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max, offset, count);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max, offset, count);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min2);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min2, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min2, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min2, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min2, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min2);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min2, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min2, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min2, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min2, offset, count);
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start, end);
    }

    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, start, end);
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, start, end);
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min2, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zlexcount(key, min2, max);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min2, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByLex(key, min2, max);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min2, byte[] max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByLex(key, min2, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByLex(key, max, min2);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min2, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByLex(key, max, min2, offset, count);
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min2, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByLex(key, min2, max);
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value);
    }

    @Deprecated
    public List<Object> pipelined(ShardedJedisPipeline shardedJedisPipeline) {
        shardedJedisPipeline.setShardedJedis(this);
        shardedJedisPipeline.execute();
        return shardedJedisPipeline.getResults();
    }

    public ShardedJedisPipeline pipelined() {
        ShardedJedisPipeline pipeline = new ShardedJedisPipeline();
        pipeline.setShardedJedis(this);
        return pipeline;
    }

    public Long objectRefcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectRefcount(key);
    }

    public byte[] objectEncoding(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectEncoding(key);
    }

    public Long objectIdletime(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectIdletime(key);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value);
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getbit(key, offset);
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setrange(key, offset, value);
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getrange(key, startOffset, endOffset);
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        Jedis j = (Jedis)this.getShard(key);
        return j.move(key, dbIndex);
    }

    @Override
    public byte[] echo(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.echo(arg);
    }

    @Override
    public List<byte[]> brpop(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.brpop(arg);
    }

    @Override
    public List<byte[]> blpop(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.blpop(arg);
    }

    @Override
    public Long bitcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key);
    }

    @Override
    public Long bitcount(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key, start, end);
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfadd(key, elements);
    }

    @Override
    public long pfcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfcount(key);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2, unit);
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geohash(key, members);
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geopos(key, members);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit, param);
    }
}

