#!/bin/bash

rm -f last_checkpoint.out
pkill -f cartpole_server.py
sleep 1

if [ -f cartpole_server.py ]; then
    basedir="."
else
    basedir="rllib/examples/serving"  # In bazel.
fi

(python $basedir/cartpole_server.py --run=DQN 2>&1 | grep -v 200) &
pid=$!

echo "Waiting for server to start"
while ! curl localhost:9900; do   
  sleep 1
done

sleep 2
python $basedir/cartpole_client.py --stop-at-reward=100 --inference-mode=remote
kill $pid

