# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at https://mozilla.org/MPL/2.0/.
# SPDX-License-Identifier: MPL-2.0

from GridCalEngine.IO.base.units import UnitMultiplier, UnitSymbol
from GridCalEngine.IO.cim.cgmes.base import Base
from GridCalEngine.IO.cim.cgmes.cgmes_enums import cgmesProfile


class IdentifiedObject(Base):
	def __init__(self, rdfid, tpe, resources=list(), class_replacements=dict()):
		Base.__init__(self, rdfid=rdfid, tpe=tpe, resources=resources, class_replacements=class_replacements)

		self.description: str = None
		self.energyIdentCodeEic: str = None
		self.mRID: str = rdfid
		self.name: str = None
		self.shortName: str = None

		self.register_property(
			name='description',
			class_type=str,
			multiplier=UnitMultiplier.none,
			unit=UnitSymbol.none,
			description='''The description is a free human readable text describing or naming the object. It may be non unique and may not correlate to a naming hierarchy.''',
			profiles=[]
		)
		self.register_property(
			name='energyIdentCodeEic',
			class_type=str,
			multiplier=UnitMultiplier.none,
			unit=UnitSymbol.none,
			description='''The attribute is used for an exchange of the EIC code (Energy identification Code). The length of the string is 16 characters as defined by the EIC code.
References: 
<ul>
	<li>Local issuing offices for EIC: <a href="https://www.entsoe.eu/publications/edi-library/links-to-eic-websites/"><font color="#0000ff"><u>https://www.entsoe.eu/publications/edi-library/links-to-eic-websites/</u></font></a> </li>
	<li>EIC description: <a href="https://www.entsoe.eu/index.php?id=73&amp;libCat=eic"><font color="#0000ff"><u>https://www.entsoe.eu/index.php?id=73&amp;libCat=eic</u></font></a> .</li>
</ul>''',
			profiles=[]
		)
		self.register_property(
			name='mRID',
			class_type=str,
			multiplier=UnitMultiplier.none,
			unit=UnitSymbol.none,
			description='''Master resource identifier issued by a model authority. The mRID is globally unique within an exchange context. Global uniqueness is easily achieved by using a UUID,  as specified in RFC 4122, for the mRID.  The use of UUID is strongly recommended.
For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition 1, the mRID is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.''',
			profiles=[]
		)
		self.register_property(
			name='name',
			class_type=str,
			multiplier=UnitMultiplier.none,
			unit=UnitSymbol.none,
			description='''The name is any free human readable and possibly non unique text naming the object.''',
			profiles=[]
		)
		self.register_property(
			name='shortName',
			class_type=str,
			multiplier=UnitMultiplier.none,
			unit=UnitSymbol.none,
			description='''The attribute is used for an exchange of a human readable short name with length of the string 12 characters maximum.''',
			profiles=[]
		)
