
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "llvm"

@_ods_cext.register_operation(_Dialect)
class AShrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.ashr"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def ashr(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AShrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AbsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.abs"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, is_int_min_poison, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["is_int_min_poison"] = (is_int_min_poison if (
    isinstance(is_int_min_poison, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(is_int_min_poison, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def is_int_min_poison(self):
    return self.operation.attributes["is_int_min_poison"]

  @is_int_min_poison.setter
  def is_int_min_poison(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["is_int_min_poison"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_abs(res, in_, is_int_min_poison, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AbsOp(res=res, in_=in_, is_int_min_poison=is_int_min_poison, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, overflowFlags, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def add(lhs, rhs, overflow_flags, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AddOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddrSpaceCastOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.addrspacecast"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def addrspacecast(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AddrSpaceCastOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AddressOfOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.addressof"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, global_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["global_name"] = (global_name if (
    isinstance(global_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(global_name, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def global_name(self):
    return self.operation.attributes["global_name"]

  @global_name.setter
  def global_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["global_name"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_addressof(res, global_name, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AddressOfOp(res=res, global_name=global_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AllocaOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.alloca"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arraySize, elem_type, *, alignment=None, inalloca=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arraySize))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    attributes["elem_type"] = (elem_type if (
    isinstance(elem_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(elem_type, context=_ods_context))
    if bool(inalloca): attributes["inalloca"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arraySize(self):
    return self.operation.operands[0]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def elem_type(self):
    return self.operation.attributes["elem_type"]

  @elem_type.setter
  def elem_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["elem_type"] = value

  @builtins.property
  def inalloca(self):
    return "inalloca" in self.operation.attributes

  @inalloca.setter
  def inalloca(self, value):
    if bool(value):
      self.operation.attributes["inalloca"] = _ods_ir.UnitAttr.get()
    elif "inalloca" in self.operation.attributes:
      del self.operation.attributes["inalloca"]

  @inalloca.deleter
  def inalloca(self):
    del self.operation.attributes["inalloca"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def alloca(res, array_size, elem_type, *, alignment=None, inalloca=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AllocaOp(res=res, arraySize=array_size, elem_type=elem_type, alignment=alignment, inalloca=inalloca, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.and"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def and_(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AndOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Annotation(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.annotation"

  _ODS_REGIONS = (0, True)

  def __init__(self, integer, annotation, fileName, line, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(integer))
    operands.append(_get_op_result_or_value(annotation))
    operands.append(_get_op_result_or_value(fileName))
    operands.append(_get_op_result_or_value(line))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def integer(self):
    return self.operation.operands[0]

  @builtins.property
  def annotation(self):
    return self.operation.operands[1]

  @builtins.property
  def fileName(self):
    return self.operation.operands[2]

  @builtins.property
  def line(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_annotation(integer, annotation, file_name, line, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(Annotation(integer=integer, annotation=annotation, fileName=file_name, line=line, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssumeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.assume"

  _ODS_REGIONS = (0, True)

  def __init__(self, cond, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(cond))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.operands[0]

def intr_assume(cond, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssumeOp(cond=cond, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicCmpXchgOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.cmpxchg"

  _ODS_REGIONS = (0, True)

  def __init__(self, ptr, cmp, val, success_ordering, failure_ordering, *, syncscope=None, alignment=None, weak=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(cmp))
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["success_ordering"] = (success_ordering if (
    isinstance(success_ordering, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(success_ordering, context=_ods_context))
    attributes["failure_ordering"] = (failure_ordering if (
    isinstance(failure_ordering, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(failure_ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        isinstance(syncscope, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(weak): attributes["weak"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def cmp(self):
    return self.operation.operands[1]

  @builtins.property
  def val(self):
    return self.operation.operands[2]

  @builtins.property
  def success_ordering(self):
    return self.operation.attributes["success_ordering"]

  @success_ordering.setter
  def success_ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["success_ordering"] = value

  @builtins.property
  def failure_ordering(self):
    return self.operation.attributes["failure_ordering"]

  @failure_ordering.setter
  def failure_ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["failure_ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def weak(self):
    return "weak" in self.operation.attributes

  @weak.setter
  def weak(self, value):
    if bool(value):
      self.operation.attributes["weak"] = _ods_ir.UnitAttr.get()
    elif "weak" in self.operation.attributes:
      del self.operation.attributes["weak"]

  @weak.deleter
  def weak(self):
    del self.operation.attributes["weak"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def cmpxchg(ptr, cmp, val, success_ordering, failure_ordering, *, syncscope=None, alignment=None, weak=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AtomicCmpXchgOp(ptr=ptr, cmp=cmp, val=val, success_ordering=success_ordering, failure_ordering=failure_ordering, syncscope=syncscope, alignment=alignment, weak=weak, volatile_=volatile_, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AtomicRMWOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.atomicrmw"

  _ODS_REGIONS = (0, True)

  def __init__(self, bin_op, ptr, val, ordering, *, syncscope=None, alignment=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["bin_op"] = (bin_op if (
    isinstance(bin_op, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicBinOp')) else
      _ods_ir.AttrBuilder.get('AtomicBinOp')(bin_op, context=_ods_context))
    attributes["ordering"] = (ordering if (
    isinstance(ordering, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        isinstance(syncscope, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def bin_op(self):
    return self.operation.attributes["bin_op"]

  @bin_op.setter
  def bin_op(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["bin_op"] = value

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def atomicrmw(bin_op, ptr, val, ordering, *, syncscope=None, alignment=None, volatile_=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AtomicRMWOp(bin_op=bin_op, ptr=ptr, val=val, ordering=ordering, syncscope=syncscope, alignment=alignment, volatile_=volatile_, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BitReverseOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.bitreverse"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_bitreverse(in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(BitReverseOp(in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def bitcast(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(BitcastOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.br"

  _ODS_REGIONS = (0, True)

  def __init__(self, destOperands, dest, *, loop_annotation=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(destOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if loop_annotation is not None: attributes["loop_annotation"] = (loop_annotation if (
        isinstance(loop_annotation, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LoopAnnotationAttr')) else
          _ods_ir.AttrBuilder.get('LoopAnnotationAttr')(loop_annotation, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(dest)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def destOperands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def loop_annotation(self):
    if "loop_annotation" not in self.operation.attributes:
      return None
    return self.operation.attributes["loop_annotation"]

  @loop_annotation.setter
  def loop_annotation(self, value):
    if value is not None:
      self.operation.attributes["loop_annotation"] = value
    elif "loop_annotation" in self.operation.attributes:
      del self.operation.attributes["loop_annotation"]

  @loop_annotation.deleter
  def loop_annotation(self):
    del self.operation.attributes["loop_annotation"]

def br(dest_operands, dest, *, loop_annotation=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BrOp(destOperands=dest_operands, dest=dest, loop_annotation=loop_annotation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ByteSwapOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.bswap"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_bswap(in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ByteSwapOp(in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CallIntrinsicOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.call_intrinsic"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, intrin, args, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["intrin"] = (intrin if (
    isinstance(intrin, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(intrin, context=_ods_context))
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    if results_ is not None: results.append(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def intrin(self):
    return self.operation.attributes["intrin"]

  @intrin.setter
  def intrin(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["intrin"] = value

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def results_(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def call_intrinsic(results_, intrin, args, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CallIntrinsicOp(results_=results_, intrin=intrin, args=args, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CallOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.call"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee_operands, *, callee_type=None, callee=None, fastmathFlags=None, branch_weights=None, CConv=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(callee_operands))
    _ods_context = _ods_get_default_loc_context(loc)
    if callee_type is not None: attributes["callee_type"] = (callee_type if (
        isinstance(callee_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_797')) else
          _ods_ir.AttrBuilder.get('anonymous_797')(callee_type, context=_ods_context))
    if callee is not None: attributes["callee"] = (callee if (
        isinstance(callee, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        isinstance(branch_weights, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    if CConv is not None: attributes["CConv"] = (CConv if (
        isinstance(CConv, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CConv')) else
          _ods_ir.AttrBuilder.get('CConv')(CConv, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    if result is not None: results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def callee_operands(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee_type(self):
    if "callee_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee_type"]

  @callee_type.setter
  def callee_type(self, value):
    if value is not None:
      self.operation.attributes["callee_type"] = value
    elif "callee_type" in self.operation.attributes:
      del self.operation.attributes["callee_type"]

  @callee_type.deleter
  def callee_type(self):
    del self.operation.attributes["callee_type"]

  @builtins.property
  def callee(self):
    if "callee" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is not None:
      self.operation.attributes["callee"] = value
    elif "callee" in self.operation.attributes:
      del self.operation.attributes["callee"]

  @callee.deleter
  def callee(self):
    del self.operation.attributes["callee"]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

  @builtins.property
  def CConv(self):
    return self.operation.attributes["CConv"]

  @CConv.setter
  def CConv(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["CConv"] = value

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def result(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def call(result, callee_operands, *, callee_type=None, callee=None, fastmath_flags=None, branch_weights=None, c_conv=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CallOp(result=result, callee_operands=callee_operands, callee_type=callee_type, callee=callee, fastmathFlags=fastmath_flags, branch_weights=branch_weights, CConv=c_conv, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ComdatOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.comdat"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def comdat(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ComdatOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ComdatSelectorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.comdat_selector"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, comdat, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["comdat"] = (comdat if (
    isinstance(comdat, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Comdat')) else
      _ods_ir.AttrBuilder.get('Comdat')(comdat, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def comdat(self):
    return self.operation.attributes["comdat"]

  @comdat.setter
  def comdat(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["comdat"] = value

def comdat_selector(sym_name, comdat, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ComdatSelectorOp(sym_name=sym_name, comdat=comdat, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CondBrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.cond_br"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, trueDestOperands, falseDestOperands, trueDest, falseDest, *, branch_weights=None, loop_annotation=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(condition))
    operands.append(_get_op_results_or_values(trueDestOperands))
    operands.append(_get_op_results_or_values(falseDestOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        isinstance(branch_weights, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    if loop_annotation is not None: attributes["loop_annotation"] = (loop_annotation if (
        isinstance(loop_annotation, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LoopAnnotationAttr')) else
          _ods_ir.AttrBuilder.get('LoopAnnotationAttr')(loop_annotation, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(trueDest)
    _ods_successors.append(falseDest)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def condition(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def trueDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def falseDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

  @builtins.property
  def loop_annotation(self):
    if "loop_annotation" not in self.operation.attributes:
      return None
    return self.operation.attributes["loop_annotation"]

  @loop_annotation.setter
  def loop_annotation(self, value):
    if value is not None:
      self.operation.attributes["loop_annotation"] = value
    elif "loop_annotation" in self.operation.attributes:
      del self.operation.attributes["loop_annotation"]

  @loop_annotation.deleter
  def loop_annotation(self):
    del self.operation.attributes["loop_annotation"]

def cond_br(condition, true_dest_operands, false_dest_operands, true_dest, false_dest, *, branch_weights=None, loop_annotation=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CondBrOp(condition=condition, trueDestOperands=true_dest_operands, falseDestOperands=false_dest_operands, trueDest=true_dest, falseDest=false_dest, branch_weights=branch_weights, loop_annotation=loop_annotation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AnyAttr')) else
      _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_constant(res, value, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConstantOp(res=res, value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstrainedFPTruncIntr(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.experimental.constrained.fptrunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg_0, roundingmode, fpExceptionBehavior, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg_0))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["roundingmode"] = (roundingmode if (
    isinstance(roundingmode, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ValidRoundingModeAttr')) else
      _ods_ir.AttrBuilder.get('ValidRoundingModeAttr')(roundingmode, context=_ods_context))
    attributes["fpExceptionBehavior"] = (fpExceptionBehavior if (
    isinstance(fpExceptionBehavior, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FPExceptionBehaviorAttr')) else
      _ods_ir.AttrBuilder.get('FPExceptionBehaviorAttr')(fpExceptionBehavior, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg_0(self):
    return self.operation.operands[0]

  @builtins.property
  def roundingmode(self):
    return self.operation.attributes["roundingmode"]

  @roundingmode.setter
  def roundingmode(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["roundingmode"] = value

  @builtins.property
  def fpExceptionBehavior(self):
    return self.operation.attributes["fpExceptionBehavior"]

  @fpExceptionBehavior.setter
  def fpExceptionBehavior(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fpExceptionBehavior"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_experimental_constrained_fptrunc(res, arg_0, roundingmode, fp_exception_behavior, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConstrainedFPTruncIntr(res=res, arg_0=arg_0, roundingmode=roundingmode, fpExceptionBehavior=fp_exception_behavior, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CopySignOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.copysign"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_copysign(a, b, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CopySignOp(a=a, b=b, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroAlignOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.align"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_align(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroAlignOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroBeginOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.begin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, token, mem, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(token))
    operands.append(_get_op_result_or_value(mem))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def token(self):
    return self.operation.operands[0]

  @builtins.property
  def mem(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_begin(res, token, mem, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroBeginOp(res=res, token=token, mem=mem, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroEndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.end"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, handle, unwind, retvals, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(handle))
    operands.append(_get_op_result_or_value(unwind))
    operands.append(_get_op_result_or_value(retvals))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def handle(self):
    return self.operation.operands[0]

  @builtins.property
  def unwind(self):
    return self.operation.operands[1]

  @builtins.property
  def retvals(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_end(res, handle, unwind, retvals, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroEndOp(res=res, handle=handle, unwind=unwind, retvals=retvals, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroFreeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.free"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, id, handle, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(id))
    operands.append(_get_op_result_or_value(handle))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def id(self):
    return self.operation.operands[0]

  @builtins.property
  def handle(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_free(res, id, handle, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroFreeOp(res=res, id=id, handle=handle, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroIdOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.id"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, align, promise, coroaddr, fnaddrs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(align))
    operands.append(_get_op_result_or_value(promise))
    operands.append(_get_op_result_or_value(coroaddr))
    operands.append(_get_op_result_or_value(fnaddrs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def align(self):
    return self.operation.operands[0]

  @builtins.property
  def promise(self):
    return self.operation.operands[1]

  @builtins.property
  def coroaddr(self):
    return self.operation.operands[2]

  @builtins.property
  def fnaddrs(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_id(res, align, promise, coroaddr, fnaddrs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroIdOp(res=res, align=align, promise=promise, coroaddr=coroaddr, fnaddrs=fnaddrs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroPromiseOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.promise"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, handle, align, from_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(handle))
    operands.append(_get_op_result_or_value(align))
    operands.append(_get_op_result_or_value(from_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def handle(self):
    return self.operation.operands[0]

  @builtins.property
  def align(self):
    return self.operation.operands[1]

  @builtins.property
  def from_(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_promise(res, handle, align, from_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroPromiseOp(res=res, handle=handle, align=align, from_=from_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroResumeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.resume"

  _ODS_REGIONS = (0, True)

  def __init__(self, handle, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(handle))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def handle(self):
    return self.operation.operands[0]

def intr_coro_resume(handle, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CoroResumeOp(handle=handle, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroSaveOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.save"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, handle, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(handle))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def handle(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_save(res, handle, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroSaveOp(res=res, handle=handle, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.size"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_size(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroSizeOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoroSuspendOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.coro.suspend"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, save, final, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(save))
    operands.append(_get_op_result_or_value(final))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def save(self):
    return self.operation.operands[0]

  @builtins.property
  def final(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_coro_suspend(res, save, final, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CoroSuspendOp(res=res, save=save, final=final, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CosOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.cos"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_cos(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CosOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CountLeadingZerosOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ctlz"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, is_zero_poison, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["is_zero_poison"] = (is_zero_poison if (
    isinstance(is_zero_poison, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(is_zero_poison, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def is_zero_poison(self):
    return self.operation.attributes["is_zero_poison"]

  @is_zero_poison.setter
  def is_zero_poison(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["is_zero_poison"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ctlz(res, in_, is_zero_poison, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CountLeadingZerosOp(res=res, in_=in_, is_zero_poison=is_zero_poison, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CountTrailingZerosOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.cttz"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, is_zero_poison, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["is_zero_poison"] = (is_zero_poison if (
    isinstance(is_zero_poison, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(is_zero_poison, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def is_zero_poison(self):
    return self.operation.attributes["is_zero_poison"]

  @is_zero_poison.setter
  def is_zero_poison(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["is_zero_poison"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_cttz(res, in_, is_zero_poison, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CountTrailingZerosOp(res=res, in_=in_, is_zero_poison=is_zero_poison, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CtPopOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ctpop"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ctpop(in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CtPopOp(in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DbgDeclareOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.dbg.declare"

  _ODS_REGIONS = (0, True)

  def __init__(self, addr, varInfo, *, locationExpr=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(addr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["varInfo"] = (varInfo if (
    isinstance(varInfo, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LLVM_DILocalVariableAttr')) else
      _ods_ir.AttrBuilder.get('LLVM_DILocalVariableAttr')(varInfo, context=_ods_context))
    if locationExpr is not None: attributes["locationExpr"] = (locationExpr if (
        isinstance(locationExpr, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_DIExpressionAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_DIExpressionAttr')(locationExpr, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def addr(self):
    return self.operation.operands[0]

  @builtins.property
  def varInfo(self):
    return self.operation.attributes["varInfo"]

  @varInfo.setter
  def varInfo(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["varInfo"] = value

  @builtins.property
  def locationExpr(self):
    return self.operation.attributes["locationExpr"]

  @locationExpr.setter
  def locationExpr(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["locationExpr"] = value

def intr_dbg_declare(addr, var_info, *, location_expr=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DbgDeclareOp(addr=addr, varInfo=var_info, locationExpr=location_expr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DbgLabelOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.dbg.label"

  _ODS_REGIONS = (0, True)

  def __init__(self, label, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["label"] = (label if (
    isinstance(label, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LLVM_DILabelAttr')) else
      _ods_ir.AttrBuilder.get('LLVM_DILabelAttr')(label, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def label(self):
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["label"] = value

def intr_dbg_label(label, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DbgLabelOp(label=label, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DbgValueOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.dbg.value"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, varInfo, *, locationExpr=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["varInfo"] = (varInfo if (
    isinstance(varInfo, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LLVM_DILocalVariableAttr')) else
      _ods_ir.AttrBuilder.get('LLVM_DILocalVariableAttr')(varInfo, context=_ods_context))
    if locationExpr is not None: attributes["locationExpr"] = (locationExpr if (
        isinstance(locationExpr, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_DIExpressionAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_DIExpressionAttr')(locationExpr, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def varInfo(self):
    return self.operation.attributes["varInfo"]

  @varInfo.setter
  def varInfo(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["varInfo"] = value

  @builtins.property
  def locationExpr(self):
    return self.operation.attributes["locationExpr"]

  @locationExpr.setter
  def locationExpr(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["locationExpr"] = value

def intr_dbg_value(value, var_info, *, location_expr=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DbgValueOp(value=value, varInfo=var_info, locationExpr=location_expr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DebugTrap(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.debugtrap"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def intr_debugtrap(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DebugTrap(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class EhTypeidForOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.eh.typeid.for"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, type_info, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(type_info))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def type_info(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_eh_typeid_for(res, type_info, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(EhTypeidForOp(res=res, type_info=type_info, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Exp2Op(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.exp2"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_exp2(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(Exp2Op(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExpOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.exp"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_exp(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExpOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExpectOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.expect"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, expected, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(expected))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def expected(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_expect(val, expected, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExpectOp(val=val, expected=expected, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExpectWithProbabilityOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.expect.with.probability"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, expected, prob, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(expected))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["prob"] = (prob if (
    isinstance(prob, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('F64Attr')) else
      _ods_ir.AttrBuilder.get('F64Attr')(prob, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def expected(self):
    return self.operation.operands[1]

  @builtins.property
  def prob(self):
    return self.operation.attributes["prob"]

  @prob.setter
  def prob(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["prob"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_expect_with_probability(val, expected, prob, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExpectWithProbabilityOp(val=val, expected=expected, prob=prob, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractElementOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.extractelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def position(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def extractelement(vector, position, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExtractElementOp(vector=vector, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExtractValueOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.extractvalue"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, container, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(container))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["position"] = (position if (
    isinstance(position, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(position, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def container(self):
    return self.operation.operands[0]

  @builtins.property
  def position(self):
    return self.operation.attributes["position"]

  @position.setter
  def position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["position"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def extractvalue(res, container, position, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ExtractValueOp(res=res, container=container, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FAbsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.fabs"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_fabs(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FAbsOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fadd"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fadd(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FAddOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FCeilOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ceil"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ceil(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FCeilOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FCmpOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fcmp"

  _ODS_REGIONS = (0, True)

  def __init__(self, predicate, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    isinstance(predicate, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FCmpPredicate')) else
      _ods_ir.AttrBuilder.get('FCmpPredicate')(predicate, context=_ods_context))
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def predicate(self):
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fcmp(predicate, lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FCmpOp(predicate=predicate, lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fdiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fdiv(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FDivOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FFloorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.floor"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_floor(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FFloorOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FMAOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.fma"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, c, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    operands.append(_get_op_result_or_value(c))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def c(self):
    return self.operation.operands[2]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_fma(a, b, c, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FMAOp(a=a, b=b, c=c, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FMulAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.fmuladd"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, c, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    operands.append(_get_op_result_or_value(c))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def c(self):
    return self.operation.operands[2]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_fmuladd(a, b, c, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FMulAddOp(a=a, b=b, c=c, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FMulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fmul(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FMulOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FNegOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fneg"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fneg(operand, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FNegOp(operand=operand, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fpext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fpext(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FPExtOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPToSIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fptosi"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fptosi(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FPToSIOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPToUIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fptoui"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fptoui(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FPToUIOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FPTruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fptrunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fptrunc(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FPTruncOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FRemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.frem"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def frem(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FRemOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FSubOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fsub"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def fsub(lhs, rhs, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FSubOp(lhs=lhs, rhs=rhs, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FTruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.trunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_trunc(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FTruncOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FenceOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.fence"

  _ODS_REGIONS = (0, True)

  def __init__(self, ordering, *, syncscope=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ordering"] = (ordering if (
    isinstance(ordering, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
      _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        isinstance(syncscope, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

def fence(ordering, *, syncscope=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FenceOp(ordering=ordering, syncscope=syncscope, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FreezeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.freeze"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def freeze(val, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FreezeOp(val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FshlOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.fshl"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, c, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    operands.append(_get_op_result_or_value(c))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def c(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_fshl(a, b, c, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FshlOp(a=a, b=b, c=c, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FshrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.fshr"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, c, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    operands.append(_get_op_result_or_value(c))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def c(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_fshr(a, b, c, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FshrOp(a=a, b=b, c=c, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GEPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.getelementptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, base, dynamicIndices, rawConstantIndices, elem_type, *, inbounds=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.extend(_get_op_results_or_values(dynamicIndices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rawConstantIndices"] = (rawConstantIndices if (
    isinstance(rawConstantIndices, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(rawConstantIndices, context=_ods_context))
    attributes["elem_type"] = (elem_type if (
    isinstance(elem_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(elem_type, context=_ods_context))
    if bool(inbounds): attributes["inbounds"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamicIndices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def rawConstantIndices(self):
    return self.operation.attributes["rawConstantIndices"]

  @rawConstantIndices.setter
  def rawConstantIndices(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rawConstantIndices"] = value

  @builtins.property
  def elem_type(self):
    return self.operation.attributes["elem_type"]

  @elem_type.setter
  def elem_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["elem_type"] = value

  @builtins.property
  def inbounds(self):
    return "inbounds" in self.operation.attributes

  @inbounds.setter
  def inbounds(self, value):
    if bool(value):
      self.operation.attributes["inbounds"] = _ods_ir.UnitAttr.get()
    elif "inbounds" in self.operation.attributes:
      del self.operation.attributes["inbounds"]

  @inbounds.deleter
  def inbounds(self):
    del self.operation.attributes["inbounds"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def getelementptr(res, base, dynamic_indices, raw_constant_indices, elem_type, *, inbounds=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(GEPOp(res=res, base=base, dynamicIndices=dynamic_indices, rawConstantIndices=raw_constant_indices, elem_type=elem_type, inbounds=inbounds, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GetActiveLaneMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.get.active.lane.mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, base, n, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(base))
    operands.append(_get_op_result_or_value(n))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def base(self):
    return self.operation.operands[0]

  @builtins.property
  def n(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_get_active_lane_mask(res, base, n, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(GetActiveLaneMaskOp(res=res, base=base, n=n, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalCtorsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.global_ctors"

  _ODS_REGIONS = (0, True)

  def __init__(self, ctors, priorities, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ctors"] = (ctors if (
    isinstance(ctors, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefArrayAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefArrayAttr')(ctors, context=_ods_context))
    attributes["priorities"] = (priorities if (
    isinstance(priorities, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I32ArrayAttr')(priorities, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ctors(self):
    return self.operation.attributes["ctors"]

  @ctors.setter
  def ctors(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ctors"] = value

  @builtins.property
  def priorities(self):
    return self.operation.attributes["priorities"]

  @priorities.setter
  def priorities(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["priorities"] = value

def mlir_global_ctors(ctors, priorities, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalCtorsOp(ctors=ctors, priorities=priorities, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalDtorsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.global_dtors"

  _ODS_REGIONS = (0, True)

  def __init__(self, dtors, priorities, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dtors"] = (dtors if (
    isinstance(dtors, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefArrayAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefArrayAttr')(dtors, context=_ods_context))
    attributes["priorities"] = (priorities if (
    isinstance(priorities, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('I32ArrayAttr')(priorities, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dtors(self):
    return self.operation.attributes["dtors"]

  @dtors.setter
  def dtors(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dtors"] = value

  @builtins.property
  def priorities(self):
    return self.operation.attributes["priorities"]

  @priorities.setter
  def priorities(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["priorities"] = value

def mlir_global_dtors(dtors, priorities, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalDtorsOp(dtors=dtors, priorities=priorities, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GlobalOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.global"

  _ODS_REGIONS = (1, True)

  def __init__(self, global_type, sym_name, linkage, *, constant=None, dso_local=None, thread_local_=None, value=None, alignment=None, addr_space=None, unnamed_addr=None, section=None, comdat=None, dbg_expr=None, visibility_=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["global_type"] = (global_type if (
    isinstance(global_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(global_type, context=_ods_context))
    if bool(constant): attributes["constant"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(sym_name, context=_ods_context))
    attributes["linkage"] = (linkage if (
    isinstance(linkage, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Linkage')) else
      _ods_ir.AttrBuilder.get('Linkage')(linkage, context=_ods_context))
    if bool(dso_local): attributes["dso_local"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(thread_local_): attributes["thread_local_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if value is not None: attributes["value"] = (value if (
        isinstance(value, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyAttr')) else
          _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if addr_space is not None: attributes["addr_space"] = (addr_space if (
        isinstance(addr_space, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(addr_space, context=_ods_context))
    if unnamed_addr is not None: attributes["unnamed_addr"] = (unnamed_addr if (
        isinstance(unnamed_addr, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UnnamedAddr')) else
          _ods_ir.AttrBuilder.get('UnnamedAddr')(unnamed_addr, context=_ods_context))
    if section is not None: attributes["section"] = (section if (
        isinstance(section, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(section, context=_ods_context))
    if comdat is not None: attributes["comdat"] = (comdat if (
        isinstance(comdat, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefAttr')(comdat, context=_ods_context))
    if dbg_expr is not None: attributes["dbg_expr"] = (dbg_expr if (
        isinstance(dbg_expr, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_DIGlobalVariableExpressionAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_DIGlobalVariableExpressionAttr')(dbg_expr, context=_ods_context))
    if visibility_ is not None: attributes["visibility_"] = (visibility_ if (
        isinstance(visibility_, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Visibility')) else
          _ods_ir.AttrBuilder.get('Visibility')(visibility_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def global_type(self):
    return self.operation.attributes["global_type"]

  @global_type.setter
  def global_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["global_type"] = value

  @builtins.property
  def constant(self):
    return "constant" in self.operation.attributes

  @constant.setter
  def constant(self, value):
    if bool(value):
      self.operation.attributes["constant"] = _ods_ir.UnitAttr.get()
    elif "constant" in self.operation.attributes:
      del self.operation.attributes["constant"]

  @constant.deleter
  def constant(self):
    del self.operation.attributes["constant"]

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def linkage(self):
    return self.operation.attributes["linkage"]

  @linkage.setter
  def linkage(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["linkage"] = value

  @builtins.property
  def dso_local(self):
    return "dso_local" in self.operation.attributes

  @dso_local.setter
  def dso_local(self, value):
    if bool(value):
      self.operation.attributes["dso_local"] = _ods_ir.UnitAttr.get()
    elif "dso_local" in self.operation.attributes:
      del self.operation.attributes["dso_local"]

  @dso_local.deleter
  def dso_local(self):
    del self.operation.attributes["dso_local"]

  @builtins.property
  def thread_local_(self):
    return "thread_local_" in self.operation.attributes

  @thread_local_.setter
  def thread_local_(self, value):
    if bool(value):
      self.operation.attributes["thread_local_"] = _ods_ir.UnitAttr.get()
    elif "thread_local_" in self.operation.attributes:
      del self.operation.attributes["thread_local_"]

  @thread_local_.deleter
  def thread_local_(self):
    del self.operation.attributes["thread_local_"]

  @builtins.property
  def value(self):
    if "value" not in self.operation.attributes:
      return None
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is not None:
      self.operation.attributes["value"] = value
    elif "value" in self.operation.attributes:
      del self.operation.attributes["value"]

  @value.deleter
  def value(self):
    del self.operation.attributes["value"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def addr_space(self):
    return self.operation.attributes["addr_space"]

  @addr_space.setter
  def addr_space(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["addr_space"] = value

  @builtins.property
  def unnamed_addr(self):
    if "unnamed_addr" not in self.operation.attributes:
      return None
    return self.operation.attributes["unnamed_addr"]

  @unnamed_addr.setter
  def unnamed_addr(self, value):
    if value is not None:
      self.operation.attributes["unnamed_addr"] = value
    elif "unnamed_addr" in self.operation.attributes:
      del self.operation.attributes["unnamed_addr"]

  @unnamed_addr.deleter
  def unnamed_addr(self):
    del self.operation.attributes["unnamed_addr"]

  @builtins.property
  def section(self):
    if "section" not in self.operation.attributes:
      return None
    return self.operation.attributes["section"]

  @section.setter
  def section(self, value):
    if value is not None:
      self.operation.attributes["section"] = value
    elif "section" in self.operation.attributes:
      del self.operation.attributes["section"]

  @section.deleter
  def section(self):
    del self.operation.attributes["section"]

  @builtins.property
  def comdat(self):
    if "comdat" not in self.operation.attributes:
      return None
    return self.operation.attributes["comdat"]

  @comdat.setter
  def comdat(self, value):
    if value is not None:
      self.operation.attributes["comdat"] = value
    elif "comdat" in self.operation.attributes:
      del self.operation.attributes["comdat"]

  @comdat.deleter
  def comdat(self):
    del self.operation.attributes["comdat"]

  @builtins.property
  def dbg_expr(self):
    return self.operation.attributes["dbg_expr"]

  @dbg_expr.setter
  def dbg_expr(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dbg_expr"] = value

  @builtins.property
  def visibility_(self):
    return self.operation.attributes["visibility_"]

  @visibility_.setter
  def visibility_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["visibility_"] = value

  @builtins.property
  def initializer(self):
    return self.regions[0]

def mlir_global(global_type, sym_name, linkage, *, constant=None, dso_local=None, thread_local_=None, value=None, alignment=None, addr_space=None, unnamed_addr=None, section=None, comdat=None, dbg_expr=None, visibility_=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalOp(global_type=global_type, sym_name=sym_name, linkage=linkage, constant=constant, dso_local=dso_local, thread_local_=thread_local_, value=value, alignment=alignment, addr_space=addr_space, unnamed_addr=unnamed_addr, section=section, comdat=comdat, dbg_expr=dbg_expr, visibility_=visibility_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ICmpOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.icmp"

  _ODS_REGIONS = (0, True)

  def __init__(self, predicate, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    isinstance(predicate, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ICmpPredicate')) else
      _ods_ir.AttrBuilder.get('ICmpPredicate')(predicate, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def predicate(self):
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def icmp(predicate, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ICmpOp(predicate=predicate, lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InlineAsmOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.inline_asm"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, operands_, asm_string, constraints, *, has_side_effects=None, is_align_stack=None, asm_dialect=None, operand_attrs=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["asm_string"] = (asm_string if (
    isinstance(asm_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(asm_string, context=_ods_context))
    attributes["constraints"] = (constraints if (
    isinstance(constraints, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(constraints, context=_ods_context))
    if bool(has_side_effects): attributes["has_side_effects"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(is_align_stack): attributes["is_align_stack"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if asm_dialect is not None: attributes["asm_dialect"] = (asm_dialect if (
        isinstance(asm_dialect, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AsmATTOrIntel')) else
          _ods_ir.AttrBuilder.get('AsmATTOrIntel')(asm_dialect, context=_ods_context))
    if operand_attrs is not None: attributes["operand_attrs"] = (operand_attrs if (
        isinstance(operand_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(operand_attrs, context=_ods_context))
    if res is not None: results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def asm_string(self):
    return self.operation.attributes["asm_string"]

  @asm_string.setter
  def asm_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["asm_string"] = value

  @builtins.property
  def constraints(self):
    return self.operation.attributes["constraints"]

  @constraints.setter
  def constraints(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["constraints"] = value

  @builtins.property
  def has_side_effects(self):
    return "has_side_effects" in self.operation.attributes

  @has_side_effects.setter
  def has_side_effects(self, value):
    if bool(value):
      self.operation.attributes["has_side_effects"] = _ods_ir.UnitAttr.get()
    elif "has_side_effects" in self.operation.attributes:
      del self.operation.attributes["has_side_effects"]

  @has_side_effects.deleter
  def has_side_effects(self):
    del self.operation.attributes["has_side_effects"]

  @builtins.property
  def is_align_stack(self):
    return "is_align_stack" in self.operation.attributes

  @is_align_stack.setter
  def is_align_stack(self, value):
    if bool(value):
      self.operation.attributes["is_align_stack"] = _ods_ir.UnitAttr.get()
    elif "is_align_stack" in self.operation.attributes:
      del self.operation.attributes["is_align_stack"]

  @is_align_stack.deleter
  def is_align_stack(self):
    del self.operation.attributes["is_align_stack"]

  @builtins.property
  def asm_dialect(self):
    if "asm_dialect" not in self.operation.attributes:
      return None
    return self.operation.attributes["asm_dialect"]

  @asm_dialect.setter
  def asm_dialect(self, value):
    if value is not None:
      self.operation.attributes["asm_dialect"] = value
    elif "asm_dialect" in self.operation.attributes:
      del self.operation.attributes["asm_dialect"]

  @asm_dialect.deleter
  def asm_dialect(self):
    del self.operation.attributes["asm_dialect"]

  @builtins.property
  def operand_attrs(self):
    if "operand_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["operand_attrs"]

  @operand_attrs.setter
  def operand_attrs(self, value):
    if value is not None:
      self.operation.attributes["operand_attrs"] = value
    elif "operand_attrs" in self.operation.attributes:
      del self.operation.attributes["operand_attrs"]

  @operand_attrs.deleter
  def operand_attrs(self):
    del self.operation.attributes["operand_attrs"]

  @builtins.property
  def res(self):
    return None if len(self.operation.results) < 1 else self.operation.results[0]

def inline_asm(res, operands_, asm_string, constraints, *, has_side_effects=None, is_align_stack=None, asm_dialect=None, operand_attrs=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InlineAsmOp(res=res, operands_=operands_, asm_string=asm_string, constraints=constraints, has_side_effects=has_side_effects, is_align_stack=is_align_stack, asm_dialect=asm_dialect, operand_attrs=operand_attrs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InsertElementOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.insertelement"

  _ODS_REGIONS = (0, True)

  def __init__(self, vector, value, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vector))
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(position))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vector(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.operands[1]

  @builtins.property
  def position(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def insertelement(vector, value, position, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InsertElementOp(vector=vector, value=value, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InsertValueOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.insertvalue"

  _ODS_REGIONS = (0, True)

  def __init__(self, container, value, position, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(container))
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["position"] = (position if (
    isinstance(position, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(position, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def container(self):
    return self.operation.operands[0]

  @builtins.property
  def value(self):
    return self.operation.operands[1]

  @builtins.property
  def position(self):
    return self.operation.attributes["position"]

  @position.setter
  def position(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["position"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def insertvalue(container, value, position, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InsertValueOp(container=container, value=value, position=position, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IntToPtrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.inttoptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def inttoptr(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IntToPtrOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InvariantEndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.invariant.end"

  _ODS_REGIONS = (0, True)

  def __init__(self, start, size, ptr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(start))
    operands.append(_get_op_result_or_value(ptr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["size"] = (size if (
    isinstance(size, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(size, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def start(self):
    return self.operation.operands[0]

  @builtins.property
  def ptr(self):
    return self.operation.operands[1]

  @builtins.property
  def size(self):
    return self.operation.attributes["size"]

  @size.setter
  def size(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["size"] = value

def intr_invariant_end(start, size, ptr, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(InvariantEndOp(start=start, size=size, ptr=ptr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InvariantStartOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.invariant.start"

  _ODS_REGIONS = (0, True)

  def __init__(self, size, ptr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["size"] = (size if (
    isinstance(size, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(size, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def size(self):
    return self.operation.attributes["size"]

  @size.setter
  def size(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["size"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_invariant_start(size, ptr, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InvariantStartOp(size=size, ptr=ptr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InvokeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.invoke"

  _ODS_OPERAND_SEGMENTS = [-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee_operands, normalDestOperands, unwindDestOperands, normalDest, unwindDest, *, callee_type=None, callee=None, branch_weights=None, CConv=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(callee_operands))
    operands.append(_get_op_results_or_values(normalDestOperands))
    operands.append(_get_op_results_or_values(unwindDestOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if callee_type is not None: attributes["callee_type"] = (callee_type if (
        isinstance(callee_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_797')) else
          _ods_ir.AttrBuilder.get('anonymous_797')(callee_type, context=_ods_context))
    if callee is not None: attributes["callee"] = (callee if (
        isinstance(callee, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        isinstance(branch_weights, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    if CConv is not None: attributes["CConv"] = (CConv if (
        isinstance(CConv, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CConv')) else
          _ods_ir.AttrBuilder.get('CConv')(CConv, context=_ods_context))
    results.extend(result)
    _ods_successors = []
    _ods_successors.append(normalDest)
    _ods_successors.append(unwindDest)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def callee_operands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def normalDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def unwindDestOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def callee_type(self):
    if "callee_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee_type"]

  @callee_type.setter
  def callee_type(self, value):
    if value is not None:
      self.operation.attributes["callee_type"] = value
    elif "callee_type" in self.operation.attributes:
      del self.operation.attributes["callee_type"]

  @callee_type.deleter
  def callee_type(self):
    del self.operation.attributes["callee_type"]

  @builtins.property
  def callee(self):
    if "callee" not in self.operation.attributes:
      return None
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is not None:
      self.operation.attributes["callee"] = value
    elif "callee" in self.operation.attributes:
      del self.operation.attributes["callee"]

  @callee.deleter
  def callee(self):
    del self.operation.attributes["callee"]

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

  @builtins.property
  def CConv(self):
    return self.operation.attributes["CConv"]

  @CConv.setter
  def CConv(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["CConv"] = value

def invoke(result, callee_operands, normal_dest_operands, unwind_dest_operands, normal_dest, unwind_dest, *, callee_type=None, callee=None, branch_weights=None, c_conv=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InvokeOp(result=result, callee_operands=callee_operands, normalDestOperands=normal_dest_operands, unwindDestOperands=unwind_dest_operands, normalDest=normal_dest, unwindDest=unwind_dest, callee_type=callee_type, callee=callee, branch_weights=branch_weights, CConv=c_conv, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IsConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.is.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_is_constant(val, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IsConstantOp(val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IsFPClass(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.is.fpclass"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, bit, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["bit"] = (bit if (
    isinstance(bit, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(bit, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def bit(self):
    return self.operation.attributes["bit"]

  @bit.setter
  def bit(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["bit"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_is_fpclass(res, in_, bit, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IsFPClass(res=res, in_=in_, bit=bit, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LLVMFuncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, function_type, *, sym_visibility=None, linkage=None, dso_local=None, CConv=None, comdat=None, personality=None, garbageCollector=None, passthrough=None, arg_attrs=None, res_attrs=None, function_entry_count=None, memory=None, visibility_=None, arm_streaming=None, arm_locally_streaming=None, arm_streaming_compatible=None, arm_new_za=None, arm_in_za=None, arm_out_za=None, arm_inout_za=None, arm_preserves_za=None, section=None, unnamed_addr=None, alignment=None, vscale_range=None, frame_pointer=None, target_cpu=None, target_features=None, unsafe_fp_math=None, no_infs_fp_math=None, no_nans_fp_math=None, approx_func_fp_math=None, no_signed_zeros_fp_math=None, no_inline=None, always_inline=None, optimize_none=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(sym_name, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        isinstance(sym_visibility, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    attributes["function_type"] = (function_type if (
    isinstance(function_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_797')) else
      _ods_ir.AttrBuilder.get('anonymous_797')(function_type, context=_ods_context))
    if linkage is not None: attributes["linkage"] = (linkage if (
        isinstance(linkage, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Linkage')) else
          _ods_ir.AttrBuilder.get('Linkage')(linkage, context=_ods_context))
    if bool(dso_local): attributes["dso_local"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if CConv is not None: attributes["CConv"] = (CConv if (
        isinstance(CConv, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CConv')) else
          _ods_ir.AttrBuilder.get('CConv')(CConv, context=_ods_context))
    if comdat is not None: attributes["comdat"] = (comdat if (
        isinstance(comdat, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('SymbolRefAttr')(comdat, context=_ods_context))
    if personality is not None: attributes["personality"] = (personality if (
        isinstance(personality, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
          _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(personality, context=_ods_context))
    if garbageCollector is not None: attributes["garbageCollector"] = (garbageCollector if (
        isinstance(garbageCollector, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(garbageCollector, context=_ods_context))
    if passthrough is not None: attributes["passthrough"] = (passthrough if (
        isinstance(passthrough, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(passthrough, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    if function_entry_count is not None: attributes["function_entry_count"] = (function_entry_count if (
        isinstance(function_entry_count, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(function_entry_count, context=_ods_context))
    if memory is not None: attributes["memory"] = (memory if (
        isinstance(memory, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_MemoryEffectsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_MemoryEffectsAttr')(memory, context=_ods_context))
    if visibility_ is not None: attributes["visibility_"] = (visibility_ if (
        isinstance(visibility_, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Visibility')) else
          _ods_ir.AttrBuilder.get('Visibility')(visibility_, context=_ods_context))
    if bool(arm_streaming): attributes["arm_streaming"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_locally_streaming): attributes["arm_locally_streaming"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_streaming_compatible): attributes["arm_streaming_compatible"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_new_za): attributes["arm_new_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_in_za): attributes["arm_in_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_out_za): attributes["arm_out_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_inout_za): attributes["arm_inout_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(arm_preserves_za): attributes["arm_preserves_za"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if section is not None: attributes["section"] = (section if (
        isinstance(section, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(section, context=_ods_context))
    if unnamed_addr is not None: attributes["unnamed_addr"] = (unnamed_addr if (
        isinstance(unnamed_addr, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('UnnamedAddr')) else
          _ods_ir.AttrBuilder.get('UnnamedAddr')(unnamed_addr, context=_ods_context))
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if vscale_range is not None: attributes["vscale_range"] = (vscale_range if (
        isinstance(vscale_range, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_VScaleRangeAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_VScaleRangeAttr')(vscale_range, context=_ods_context))
    if frame_pointer is not None: attributes["frame_pointer"] = (frame_pointer if (
        isinstance(frame_pointer, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('FramePointerKindAttr')) else
          _ods_ir.AttrBuilder.get('FramePointerKindAttr')(frame_pointer, context=_ods_context))
    if target_cpu is not None: attributes["target_cpu"] = (target_cpu if (
        isinstance(target_cpu, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(target_cpu, context=_ods_context))
    if target_features is not None: attributes["target_features"] = (target_features if (
        isinstance(target_features, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TargetFeaturesAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TargetFeaturesAttr')(target_features, context=_ods_context))
    if unsafe_fp_math is not None: attributes["unsafe_fp_math"] = (unsafe_fp_math if (
        isinstance(unsafe_fp_math, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(unsafe_fp_math, context=_ods_context))
    if no_infs_fp_math is not None: attributes["no_infs_fp_math"] = (no_infs_fp_math if (
        isinstance(no_infs_fp_math, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(no_infs_fp_math, context=_ods_context))
    if no_nans_fp_math is not None: attributes["no_nans_fp_math"] = (no_nans_fp_math if (
        isinstance(no_nans_fp_math, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(no_nans_fp_math, context=_ods_context))
    if approx_func_fp_math is not None: attributes["approx_func_fp_math"] = (approx_func_fp_math if (
        isinstance(approx_func_fp_math, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(approx_func_fp_math, context=_ods_context))
    if no_signed_zeros_fp_math is not None: attributes["no_signed_zeros_fp_math"] = (no_signed_zeros_fp_math if (
        isinstance(no_signed_zeros_fp_math, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(no_signed_zeros_fp_math, context=_ods_context))
    if bool(no_inline): attributes["no_inline"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(always_inline): attributes["always_inline"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(optimize_none): attributes["optimize_none"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def sym_visibility(self):
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def function_type(self):
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def linkage(self):
    return self.operation.attributes["linkage"]

  @linkage.setter
  def linkage(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["linkage"] = value

  @builtins.property
  def dso_local(self):
    return "dso_local" in self.operation.attributes

  @dso_local.setter
  def dso_local(self, value):
    if bool(value):
      self.operation.attributes["dso_local"] = _ods_ir.UnitAttr.get()
    elif "dso_local" in self.operation.attributes:
      del self.operation.attributes["dso_local"]

  @dso_local.deleter
  def dso_local(self):
    del self.operation.attributes["dso_local"]

  @builtins.property
  def CConv(self):
    return self.operation.attributes["CConv"]

  @CConv.setter
  def CConv(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["CConv"] = value

  @builtins.property
  def comdat(self):
    if "comdat" not in self.operation.attributes:
      return None
    return self.operation.attributes["comdat"]

  @comdat.setter
  def comdat(self, value):
    if value is not None:
      self.operation.attributes["comdat"] = value
    elif "comdat" in self.operation.attributes:
      del self.operation.attributes["comdat"]

  @comdat.deleter
  def comdat(self):
    del self.operation.attributes["comdat"]

  @builtins.property
  def personality(self):
    if "personality" not in self.operation.attributes:
      return None
    return self.operation.attributes["personality"]

  @personality.setter
  def personality(self, value):
    if value is not None:
      self.operation.attributes["personality"] = value
    elif "personality" in self.operation.attributes:
      del self.operation.attributes["personality"]

  @personality.deleter
  def personality(self):
    del self.operation.attributes["personality"]

  @builtins.property
  def garbageCollector(self):
    if "garbageCollector" not in self.operation.attributes:
      return None
    return self.operation.attributes["garbageCollector"]

  @garbageCollector.setter
  def garbageCollector(self, value):
    if value is not None:
      self.operation.attributes["garbageCollector"] = value
    elif "garbageCollector" in self.operation.attributes:
      del self.operation.attributes["garbageCollector"]

  @garbageCollector.deleter
  def garbageCollector(self):
    del self.operation.attributes["garbageCollector"]

  @builtins.property
  def passthrough(self):
    if "passthrough" not in self.operation.attributes:
      return None
    return self.operation.attributes["passthrough"]

  @passthrough.setter
  def passthrough(self, value):
    if value is not None:
      self.operation.attributes["passthrough"] = value
    elif "passthrough" in self.operation.attributes:
      del self.operation.attributes["passthrough"]

  @passthrough.deleter
  def passthrough(self):
    del self.operation.attributes["passthrough"]

  @builtins.property
  def arg_attrs(self):
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self):
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def function_entry_count(self):
    if "function_entry_count" not in self.operation.attributes:
      return None
    return self.operation.attributes["function_entry_count"]

  @function_entry_count.setter
  def function_entry_count(self, value):
    if value is not None:
      self.operation.attributes["function_entry_count"] = value
    elif "function_entry_count" in self.operation.attributes:
      del self.operation.attributes["function_entry_count"]

  @function_entry_count.deleter
  def function_entry_count(self):
    del self.operation.attributes["function_entry_count"]

  @builtins.property
  def memory(self):
    if "memory" not in self.operation.attributes:
      return None
    return self.operation.attributes["memory"]

  @memory.setter
  def memory(self, value):
    if value is not None:
      self.operation.attributes["memory"] = value
    elif "memory" in self.operation.attributes:
      del self.operation.attributes["memory"]

  @memory.deleter
  def memory(self):
    del self.operation.attributes["memory"]

  @builtins.property
  def visibility_(self):
    return self.operation.attributes["visibility_"]

  @visibility_.setter
  def visibility_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["visibility_"] = value

  @builtins.property
  def arm_streaming(self):
    return "arm_streaming" in self.operation.attributes

  @arm_streaming.setter
  def arm_streaming(self, value):
    if bool(value):
      self.operation.attributes["arm_streaming"] = _ods_ir.UnitAttr.get()
    elif "arm_streaming" in self.operation.attributes:
      del self.operation.attributes["arm_streaming"]

  @arm_streaming.deleter
  def arm_streaming(self):
    del self.operation.attributes["arm_streaming"]

  @builtins.property
  def arm_locally_streaming(self):
    return "arm_locally_streaming" in self.operation.attributes

  @arm_locally_streaming.setter
  def arm_locally_streaming(self, value):
    if bool(value):
      self.operation.attributes["arm_locally_streaming"] = _ods_ir.UnitAttr.get()
    elif "arm_locally_streaming" in self.operation.attributes:
      del self.operation.attributes["arm_locally_streaming"]

  @arm_locally_streaming.deleter
  def arm_locally_streaming(self):
    del self.operation.attributes["arm_locally_streaming"]

  @builtins.property
  def arm_streaming_compatible(self):
    return "arm_streaming_compatible" in self.operation.attributes

  @arm_streaming_compatible.setter
  def arm_streaming_compatible(self, value):
    if bool(value):
      self.operation.attributes["arm_streaming_compatible"] = _ods_ir.UnitAttr.get()
    elif "arm_streaming_compatible" in self.operation.attributes:
      del self.operation.attributes["arm_streaming_compatible"]

  @arm_streaming_compatible.deleter
  def arm_streaming_compatible(self):
    del self.operation.attributes["arm_streaming_compatible"]

  @builtins.property
  def arm_new_za(self):
    return "arm_new_za" in self.operation.attributes

  @arm_new_za.setter
  def arm_new_za(self, value):
    if bool(value):
      self.operation.attributes["arm_new_za"] = _ods_ir.UnitAttr.get()
    elif "arm_new_za" in self.operation.attributes:
      del self.operation.attributes["arm_new_za"]

  @arm_new_za.deleter
  def arm_new_za(self):
    del self.operation.attributes["arm_new_za"]

  @builtins.property
  def arm_in_za(self):
    return "arm_in_za" in self.operation.attributes

  @arm_in_za.setter
  def arm_in_za(self, value):
    if bool(value):
      self.operation.attributes["arm_in_za"] = _ods_ir.UnitAttr.get()
    elif "arm_in_za" in self.operation.attributes:
      del self.operation.attributes["arm_in_za"]

  @arm_in_za.deleter
  def arm_in_za(self):
    del self.operation.attributes["arm_in_za"]

  @builtins.property
  def arm_out_za(self):
    return "arm_out_za" in self.operation.attributes

  @arm_out_za.setter
  def arm_out_za(self, value):
    if bool(value):
      self.operation.attributes["arm_out_za"] = _ods_ir.UnitAttr.get()
    elif "arm_out_za" in self.operation.attributes:
      del self.operation.attributes["arm_out_za"]

  @arm_out_za.deleter
  def arm_out_za(self):
    del self.operation.attributes["arm_out_za"]

  @builtins.property
  def arm_inout_za(self):
    return "arm_inout_za" in self.operation.attributes

  @arm_inout_za.setter
  def arm_inout_za(self, value):
    if bool(value):
      self.operation.attributes["arm_inout_za"] = _ods_ir.UnitAttr.get()
    elif "arm_inout_za" in self.operation.attributes:
      del self.operation.attributes["arm_inout_za"]

  @arm_inout_za.deleter
  def arm_inout_za(self):
    del self.operation.attributes["arm_inout_za"]

  @builtins.property
  def arm_preserves_za(self):
    return "arm_preserves_za" in self.operation.attributes

  @arm_preserves_za.setter
  def arm_preserves_za(self, value):
    if bool(value):
      self.operation.attributes["arm_preserves_za"] = _ods_ir.UnitAttr.get()
    elif "arm_preserves_za" in self.operation.attributes:
      del self.operation.attributes["arm_preserves_za"]

  @arm_preserves_za.deleter
  def arm_preserves_za(self):
    del self.operation.attributes["arm_preserves_za"]

  @builtins.property
  def section(self):
    if "section" not in self.operation.attributes:
      return None
    return self.operation.attributes["section"]

  @section.setter
  def section(self, value):
    if value is not None:
      self.operation.attributes["section"] = value
    elif "section" in self.operation.attributes:
      del self.operation.attributes["section"]

  @section.deleter
  def section(self):
    del self.operation.attributes["section"]

  @builtins.property
  def unnamed_addr(self):
    if "unnamed_addr" not in self.operation.attributes:
      return None
    return self.operation.attributes["unnamed_addr"]

  @unnamed_addr.setter
  def unnamed_addr(self, value):
    if value is not None:
      self.operation.attributes["unnamed_addr"] = value
    elif "unnamed_addr" in self.operation.attributes:
      del self.operation.attributes["unnamed_addr"]

  @unnamed_addr.deleter
  def unnamed_addr(self):
    del self.operation.attributes["unnamed_addr"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def vscale_range(self):
    if "vscale_range" not in self.operation.attributes:
      return None
    return self.operation.attributes["vscale_range"]

  @vscale_range.setter
  def vscale_range(self, value):
    if value is not None:
      self.operation.attributes["vscale_range"] = value
    elif "vscale_range" in self.operation.attributes:
      del self.operation.attributes["vscale_range"]

  @vscale_range.deleter
  def vscale_range(self):
    del self.operation.attributes["vscale_range"]

  @builtins.property
  def frame_pointer(self):
    if "frame_pointer" not in self.operation.attributes:
      return None
    return self.operation.attributes["frame_pointer"]

  @frame_pointer.setter
  def frame_pointer(self, value):
    if value is not None:
      self.operation.attributes["frame_pointer"] = value
    elif "frame_pointer" in self.operation.attributes:
      del self.operation.attributes["frame_pointer"]

  @frame_pointer.deleter
  def frame_pointer(self):
    del self.operation.attributes["frame_pointer"]

  @builtins.property
  def target_cpu(self):
    if "target_cpu" not in self.operation.attributes:
      return None
    return self.operation.attributes["target_cpu"]

  @target_cpu.setter
  def target_cpu(self, value):
    if value is not None:
      self.operation.attributes["target_cpu"] = value
    elif "target_cpu" in self.operation.attributes:
      del self.operation.attributes["target_cpu"]

  @target_cpu.deleter
  def target_cpu(self):
    del self.operation.attributes["target_cpu"]

  @builtins.property
  def target_features(self):
    if "target_features" not in self.operation.attributes:
      return None
    return self.operation.attributes["target_features"]

  @target_features.setter
  def target_features(self, value):
    if value is not None:
      self.operation.attributes["target_features"] = value
    elif "target_features" in self.operation.attributes:
      del self.operation.attributes["target_features"]

  @target_features.deleter
  def target_features(self):
    del self.operation.attributes["target_features"]

  @builtins.property
  def unsafe_fp_math(self):
    if "unsafe_fp_math" not in self.operation.attributes:
      return None
    return self.operation.attributes["unsafe_fp_math"]

  @unsafe_fp_math.setter
  def unsafe_fp_math(self, value):
    if value is not None:
      self.operation.attributes["unsafe_fp_math"] = value
    elif "unsafe_fp_math" in self.operation.attributes:
      del self.operation.attributes["unsafe_fp_math"]

  @unsafe_fp_math.deleter
  def unsafe_fp_math(self):
    del self.operation.attributes["unsafe_fp_math"]

  @builtins.property
  def no_infs_fp_math(self):
    if "no_infs_fp_math" not in self.operation.attributes:
      return None
    return self.operation.attributes["no_infs_fp_math"]

  @no_infs_fp_math.setter
  def no_infs_fp_math(self, value):
    if value is not None:
      self.operation.attributes["no_infs_fp_math"] = value
    elif "no_infs_fp_math" in self.operation.attributes:
      del self.operation.attributes["no_infs_fp_math"]

  @no_infs_fp_math.deleter
  def no_infs_fp_math(self):
    del self.operation.attributes["no_infs_fp_math"]

  @builtins.property
  def no_nans_fp_math(self):
    if "no_nans_fp_math" not in self.operation.attributes:
      return None
    return self.operation.attributes["no_nans_fp_math"]

  @no_nans_fp_math.setter
  def no_nans_fp_math(self, value):
    if value is not None:
      self.operation.attributes["no_nans_fp_math"] = value
    elif "no_nans_fp_math" in self.operation.attributes:
      del self.operation.attributes["no_nans_fp_math"]

  @no_nans_fp_math.deleter
  def no_nans_fp_math(self):
    del self.operation.attributes["no_nans_fp_math"]

  @builtins.property
  def approx_func_fp_math(self):
    if "approx_func_fp_math" not in self.operation.attributes:
      return None
    return self.operation.attributes["approx_func_fp_math"]

  @approx_func_fp_math.setter
  def approx_func_fp_math(self, value):
    if value is not None:
      self.operation.attributes["approx_func_fp_math"] = value
    elif "approx_func_fp_math" in self.operation.attributes:
      del self.operation.attributes["approx_func_fp_math"]

  @approx_func_fp_math.deleter
  def approx_func_fp_math(self):
    del self.operation.attributes["approx_func_fp_math"]

  @builtins.property
  def no_signed_zeros_fp_math(self):
    if "no_signed_zeros_fp_math" not in self.operation.attributes:
      return None
    return self.operation.attributes["no_signed_zeros_fp_math"]

  @no_signed_zeros_fp_math.setter
  def no_signed_zeros_fp_math(self, value):
    if value is not None:
      self.operation.attributes["no_signed_zeros_fp_math"] = value
    elif "no_signed_zeros_fp_math" in self.operation.attributes:
      del self.operation.attributes["no_signed_zeros_fp_math"]

  @no_signed_zeros_fp_math.deleter
  def no_signed_zeros_fp_math(self):
    del self.operation.attributes["no_signed_zeros_fp_math"]

  @builtins.property
  def no_inline(self):
    return "no_inline" in self.operation.attributes

  @no_inline.setter
  def no_inline(self, value):
    if bool(value):
      self.operation.attributes["no_inline"] = _ods_ir.UnitAttr.get()
    elif "no_inline" in self.operation.attributes:
      del self.operation.attributes["no_inline"]

  @no_inline.deleter
  def no_inline(self):
    del self.operation.attributes["no_inline"]

  @builtins.property
  def always_inline(self):
    return "always_inline" in self.operation.attributes

  @always_inline.setter
  def always_inline(self, value):
    if bool(value):
      self.operation.attributes["always_inline"] = _ods_ir.UnitAttr.get()
    elif "always_inline" in self.operation.attributes:
      del self.operation.attributes["always_inline"]

  @always_inline.deleter
  def always_inline(self):
    del self.operation.attributes["always_inline"]

  @builtins.property
  def optimize_none(self):
    return "optimize_none" in self.operation.attributes

  @optimize_none.setter
  def optimize_none(self, value):
    if bool(value):
      self.operation.attributes["optimize_none"] = _ods_ir.UnitAttr.get()
    elif "optimize_none" in self.operation.attributes:
      del self.operation.attributes["optimize_none"]

  @optimize_none.deleter
  def optimize_none(self):
    del self.operation.attributes["optimize_none"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(sym_name, function_type, *, sym_visibility=None, linkage=None, dso_local=None, c_conv=None, comdat=None, personality=None, garbage_collector=None, passthrough=None, arg_attrs=None, res_attrs=None, function_entry_count=None, memory=None, visibility_=None, arm_streaming=None, arm_locally_streaming=None, arm_streaming_compatible=None, arm_new_za=None, arm_in_za=None, arm_out_za=None, arm_inout_za=None, arm_preserves_za=None, section=None, unnamed_addr=None, alignment=None, vscale_range=None, frame_pointer=None, target_cpu=None, target_features=None, unsafe_fp_math=None, no_infs_fp_math=None, no_nans_fp_math=None, approx_func_fp_math=None, no_signed_zeros_fp_math=None, no_inline=None, always_inline=None, optimize_none=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(LLVMFuncOp(sym_name=sym_name, function_type=function_type, sym_visibility=sym_visibility, linkage=linkage, dso_local=dso_local, CConv=c_conv, comdat=comdat, personality=personality, garbageCollector=garbage_collector, passthrough=passthrough, arg_attrs=arg_attrs, res_attrs=res_attrs, function_entry_count=function_entry_count, memory=memory, visibility_=visibility_, arm_streaming=arm_streaming, arm_locally_streaming=arm_locally_streaming, arm_streaming_compatible=arm_streaming_compatible, arm_new_za=arm_new_za, arm_in_za=arm_in_za, arm_out_za=arm_out_za, arm_inout_za=arm_inout_za, arm_preserves_za=arm_preserves_za, section=section, unnamed_addr=unnamed_addr, alignment=alignment, vscale_range=vscale_range, frame_pointer=frame_pointer, target_cpu=target_cpu, target_features=target_features, unsafe_fp_math=unsafe_fp_math, no_infs_fp_math=no_infs_fp_math, no_nans_fp_math=no_nans_fp_math, approx_func_fp_math=approx_func_fp_math, no_signed_zeros_fp_math=no_signed_zeros_fp_math, no_inline=no_inline, always_inline=always_inline, optimize_none=optimize_none, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LShrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.lshr"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def lshr(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LShrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LandingpadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.landingpad"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_1, *, cleanup=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(cleanup): attributes["cleanup"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cleanup(self):
    return "cleanup" in self.operation.attributes

  @cleanup.setter
  def cleanup(self, value):
    if bool(value):
      self.operation.attributes["cleanup"] = _ods_ir.UnitAttr.get()
    elif "cleanup" in self.operation.attributes:
      del self.operation.attributes["cleanup"]

  @cleanup.deleter
  def cleanup(self):
    del self.operation.attributes["cleanup"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def landingpad(res, _gen_arg_1, *, cleanup=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LandingpadOp(res=res, _gen_arg_1=_gen_arg_1, cleanup=cleanup, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LifetimeEndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.lifetime.end"

  _ODS_REGIONS = (0, True)

  def __init__(self, size, ptr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["size"] = (size if (
    isinstance(size, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(size, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def size(self):
    return self.operation.attributes["size"]

  @size.setter
  def size(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["size"] = value

def intr_lifetime_end(size, ptr, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(LifetimeEndOp(size=size, ptr=ptr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LifetimeStartOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.lifetime.start"

  _ODS_REGIONS = (0, True)

  def __init__(self, size, ptr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["size"] = (size if (
    isinstance(size, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(size, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def size(self):
    return self.operation.attributes["size"]

  @size.setter
  def size(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["size"] = value

def intr_lifetime_start(size, ptr, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(LifetimeStartOp(size=size, ptr=ptr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LinkerOptionsOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.linker_options"

  _ODS_REGIONS = (0, True)

  def __init__(self, options, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["options"] = (options if (
    isinstance(options, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(options, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def options(self):
    return self.operation.attributes["options"]

  @options.setter
  def options(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["options"] = value

def linker_options(options, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(LinkerOptionsOp(options=options, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LlrintOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.llrint"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_llrint(res, val, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LlrintOp(res=res, val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LlroundOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.llround"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_llround(res, val, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LlroundOp(res=res, val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, addr, *, alignment=None, volatile_=None, nontemporal=None, invariant=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(addr))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(nontemporal): attributes["nontemporal"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(invariant): attributes["invariant"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if ordering is not None: attributes["ordering"] = (ordering if (
        isinstance(ordering, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
          _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        isinstance(syncscope, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def addr(self):
    return self.operation.operands[0]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def nontemporal(self):
    return "nontemporal" in self.operation.attributes

  @nontemporal.setter
  def nontemporal(self, value):
    if bool(value):
      self.operation.attributes["nontemporal"] = _ods_ir.UnitAttr.get()
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

  @builtins.property
  def invariant(self):
    return "invariant" in self.operation.attributes

  @invariant.setter
  def invariant(self, value):
    if bool(value):
      self.operation.attributes["invariant"] = _ods_ir.UnitAttr.get()
    elif "invariant" in self.operation.attributes:
      del self.operation.attributes["invariant"]

  @invariant.deleter
  def invariant(self):
    del self.operation.attributes["invariant"]

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def load(res, addr, *, alignment=None, volatile_=None, nontemporal=None, invariant=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LoadOp(res=res, addr=addr, alignment=alignment, volatile_=volatile_, nontemporal=nontemporal, invariant=invariant, ordering=ordering, syncscope=syncscope, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Log2Op(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.log2"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_log2(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(Log2Op(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Log10Op(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.log10"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_log10(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(Log10Op(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LogOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.log"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_log(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LogOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LrintOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.lrint"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_lrint(res, val, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LrintOp(res=res, val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LroundOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.lround"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_lround(res, val, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LroundOp(res=res, val=val, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MaskedLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.masked.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, data, mask, pass_thru, alignment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(data))
    operands.append(_get_op_result_or_value(mask))
    operands.extend(_get_op_results_or_values(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["alignment"] = (alignment if (
    isinstance(alignment, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(alignment, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def data(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def alignment(self):
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["alignment"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_masked_load(res, data, mask, pass_thru, alignment, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MaskedLoadOp(res=res, data=data, mask=mask, pass_thru=pass_thru, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MaskedStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.masked.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, data, mask, alignment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(data))
    operands.append(_get_op_result_or_value(mask))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["alignment"] = (alignment if (
    isinstance(alignment, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(alignment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def data(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def alignment(self):
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["alignment"] = value

def intr_masked_store(value, data, mask, alignment, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MaskedStoreOp(value=value, data=data, mask=mask, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatrixColumnMajorLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.matrix.column.major.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, data, stride, isVolatile, rows, columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(data))
    operands.append(_get_op_result_or_value(stride))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["isVolatile"] = (isVolatile if (
    isinstance(isVolatile, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(isVolatile, context=_ods_context))
    attributes["rows"] = (rows if (
    isinstance(rows, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rows, context=_ods_context))
    attributes["columns"] = (columns if (
    isinstance(columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def data(self):
    return self.operation.operands[0]

  @builtins.property
  def stride(self):
    return self.operation.operands[1]

  @builtins.property
  def isVolatile(self):
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def rows(self):
    return self.operation.attributes["rows"]

  @rows.setter
  def rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rows"] = value

  @builtins.property
  def columns(self):
    return self.operation.attributes["columns"]

  @columns.setter
  def columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_matrix_column_major_load(res, data, stride, is_volatile, rows, columns, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MatrixColumnMajorLoadOp(res=res, data=data, stride=stride, isVolatile=is_volatile, rows=rows, columns=columns, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatrixColumnMajorStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.matrix.column.major.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, matrix, data, stride, isVolatile, rows, columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(matrix))
    operands.append(_get_op_result_or_value(data))
    operands.append(_get_op_result_or_value(stride))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["isVolatile"] = (isVolatile if (
    isinstance(isVolatile, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(isVolatile, context=_ods_context))
    attributes["rows"] = (rows if (
    isinstance(rows, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rows, context=_ods_context))
    attributes["columns"] = (columns if (
    isinstance(columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(columns, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def matrix(self):
    return self.operation.operands[0]

  @builtins.property
  def data(self):
    return self.operation.operands[1]

  @builtins.property
  def stride(self):
    return self.operation.operands[2]

  @builtins.property
  def isVolatile(self):
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def rows(self):
    return self.operation.attributes["rows"]

  @rows.setter
  def rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rows"] = value

  @builtins.property
  def columns(self):
    return self.operation.attributes["columns"]

  @columns.setter
  def columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["columns"] = value

def intr_matrix_column_major_store(matrix, data, stride, is_volatile, rows, columns, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MatrixColumnMajorStoreOp(matrix=matrix, data=data, stride=stride, isVolatile=is_volatile, rows=rows, columns=columns, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatrixMultiplyOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.matrix.multiply"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, lhs_rows, lhs_columns, rhs_columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["lhs_rows"] = (lhs_rows if (
    isinstance(lhs_rows, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lhs_rows, context=_ods_context))
    attributes["lhs_columns"] = (lhs_columns if (
    isinstance(lhs_columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lhs_columns, context=_ods_context))
    attributes["rhs_columns"] = (rhs_columns if (
    isinstance(rhs_columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rhs_columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def lhs_rows(self):
    return self.operation.attributes["lhs_rows"]

  @lhs_rows.setter
  def lhs_rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_rows"] = value

  @builtins.property
  def lhs_columns(self):
    return self.operation.attributes["lhs_columns"]

  @lhs_columns.setter
  def lhs_columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_columns"] = value

  @builtins.property
  def rhs_columns(self):
    return self.operation.attributes["rhs_columns"]

  @rhs_columns.setter
  def rhs_columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rhs_columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_matrix_multiply(res, lhs, rhs, lhs_rows, lhs_columns, rhs_columns, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MatrixMultiplyOp(res=res, lhs=lhs, rhs=rhs, lhs_rows=lhs_rows, lhs_columns=lhs_columns, rhs_columns=rhs_columns, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MatrixTransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.matrix.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, matrix, rows, columns, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(matrix))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rows"] = (rows if (
    isinstance(rows, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rows, context=_ods_context))
    attributes["columns"] = (columns if (
    isinstance(columns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(columns, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def matrix(self):
    return self.operation.operands[0]

  @builtins.property
  def rows(self):
    return self.operation.attributes["rows"]

  @rows.setter
  def rows(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rows"] = value

  @builtins.property
  def columns(self):
    return self.operation.attributes["columns"]

  @columns.setter
  def columns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["columns"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_matrix_transpose(res, matrix, rows, columns, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MatrixTransposeOp(res=res, matrix=matrix, rows=rows, columns=columns, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MaxNumOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.maxnum"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_maxnum(a, b, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MaxNumOp(a=a, b=b, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MaximumOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.maximum"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_maximum(a, b, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MaximumOp(a=a, b=b, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemcpyInlineOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.memcpy.inline"

  _ODS_REGIONS = (0, True)

  def __init__(self, dst, src, len, isVolatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dst))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["len"] = (len if (
    isinstance(len, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('APIntAttr')) else
      _ods_ir.AttrBuilder.get('APIntAttr')(len, context=_ods_context))
    attributes["isVolatile"] = (isVolatile if (
    isinstance(isVolatile, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(isVolatile, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dst(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

  @builtins.property
  def len(self):
    return self.operation.attributes["len"]

  @len.setter
  def len(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["len"] = value

  @builtins.property
  def isVolatile(self):
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

def intr_memcpy_inline(dst, src, len, is_volatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MemcpyInlineOp(dst=dst, src=src, len=len, isVolatile=is_volatile, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemcpyOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.memcpy"

  _ODS_REGIONS = (0, True)

  def __init__(self, dst, src, len, isVolatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dst))
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(len))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["isVolatile"] = (isVolatile if (
    isinstance(isVolatile, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(isVolatile, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dst(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

  @builtins.property
  def len(self):
    return self.operation.operands[2]

  @builtins.property
  def isVolatile(self):
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

def intr_memcpy(dst, src, len, is_volatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MemcpyOp(dst=dst, src=src, len=len, isVolatile=is_volatile, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemmoveOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.memmove"

  _ODS_REGIONS = (0, True)

  def __init__(self, dst, src, len, isVolatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dst))
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(len))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["isVolatile"] = (isVolatile if (
    isinstance(isVolatile, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(isVolatile, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dst(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

  @builtins.property
  def len(self):
    return self.operation.operands[2]

  @builtins.property
  def isVolatile(self):
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

def intr_memmove(dst, src, len, is_volatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MemmoveOp(dst=dst, src=src, len=len, isVolatile=is_volatile, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MemsetOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.memset"

  _ODS_REGIONS = (0, True)

  def __init__(self, dst, val, len, isVolatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dst))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(len))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["isVolatile"] = (isVolatile if (
    isinstance(isVolatile, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I1Attr')) else
      _ods_ir.AttrBuilder.get('I1Attr')(isVolatile, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dst(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def len(self):
    return self.operation.operands[2]

  @builtins.property
  def isVolatile(self):
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

def intr_memset(dst, val, len, is_volatile, *, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MemsetOp(dst=dst, val=val, len=len, isVolatile=is_volatile, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MinNumOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.minnum"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_minnum(a, b, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MinNumOp(a=a, b=b, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MinimumOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.minimum"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_minimum(a, b, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MinimumOp(a=a, b=b, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, overflowFlags, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mul(lhs, rhs, overflow_flags, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MulOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NearbyintOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.nearbyint"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_nearbyint(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(NearbyintOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NoAliasScopeDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.experimental.noalias.scope.decl"

  _ODS_REGIONS = (0, True)

  def __init__(self, scope, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["scope"] = (scope if (
    isinstance(scope, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeAttr')) else
      _ods_ir.AttrBuilder.get('LLVM_AliasScopeAttr')(scope, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def scope(self):
    return self.operation.attributes["scope"]

  @scope.setter
  def scope(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["scope"] = value

def intr_experimental_noalias_scope_decl(scope, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(NoAliasScopeDeclOp(scope=scope, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class NoneTokenOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.none"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_none(*, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(NoneTokenOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.or"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def or_(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(OrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PoisonOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.poison"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_poison(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(PoisonOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PowIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.powi"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, val, power, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(power))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def power(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_powi(res, val, power, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(PowIOp(res=res, val=val, power=power, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.pow"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_pow(a, b, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(PowOp(a=a, b=b, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Prefetch(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.prefetch"

  _ODS_REGIONS = (0, True)

  def __init__(self, addr, rw, hint, cache, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(addr))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rw"] = (rw if (
    isinstance(rw, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(rw, context=_ods_context))
    attributes["hint"] = (hint if (
    isinstance(hint, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(hint, context=_ods_context))
    attributes["cache"] = (cache if (
    isinstance(cache, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(cache, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def addr(self):
    return self.operation.operands[0]

  @builtins.property
  def rw(self):
    return self.operation.attributes["rw"]

  @rw.setter
  def rw(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rw"] = value

  @builtins.property
  def hint(self):
    return self.operation.attributes["hint"]

  @hint.setter
  def hint(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["hint"] = value

  @builtins.property
  def cache(self):
    return self.operation.attributes["cache"]

  @cache.setter
  def cache(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cache"] = value

def intr_prefetch(addr, rw, hint, cache, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(Prefetch(addr=addr, rw=rw, hint=hint, cache=cache, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PtrAnnotation(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ptr.annotation"

  _ODS_REGIONS = (0, True)

  def __init__(self, ptr, annotation, fileName, line, attr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(annotation))
    operands.append(_get_op_result_or_value(fileName))
    operands.append(_get_op_result_or_value(line))
    operands.append(_get_op_result_or_value(attr))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def annotation(self):
    return self.operation.operands[1]

  @builtins.property
  def fileName(self):
    return self.operation.operands[2]

  @builtins.property
  def line(self):
    return self.operation.operands[3]

  @builtins.property
  def attr(self):
    return self.operation.operands[4]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ptr_annotation(ptr, annotation, file_name, line, attr, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(PtrAnnotation(ptr=ptr, annotation=annotation, fileName=file_name, line=line, attr=attr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PtrToIntOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.ptrtoint"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def ptrtoint(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(PtrToIntOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ResumeOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.resume"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

def resume(value, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ResumeOp(value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, arg=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if arg is not None: operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

def return_(*, arg=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReturnOp(arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RintOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.rint"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_rint(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(RintOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RoundEvenOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.roundeven"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_roundeven(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(RoundEvenOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RoundOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.round"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_round(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(RoundOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SAddSat(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.sadd.sat"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_sadd_sat(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SAddSat(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SAddWithOverflowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.sadd.with.overflow"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_sadd_with_overflow(res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SAddWithOverflowOp(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sdiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sdiv(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SDivOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sext(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SExtOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sitofp(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SIToFPOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.smax"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_smax(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SMaxOp(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.smin"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_smin(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SMinOp(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SMulWithOverflowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.smul.with.overflow"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_smul_with_overflow(res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SMulWithOverflowOp(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SRemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.srem"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def srem(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SRemOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SSACopyOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ssa.copy"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ssa_copy(operand, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SSACopyOp(operand=operand, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SSHLSat(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.sshl.sat"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_sshl_sat(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SSHLSat(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SSubSat(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ssub.sat"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ssub_sat(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SSubSat(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SSubWithOverflowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ssub.with.overflow"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ssub_with_overflow(res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SSubWithOverflowOp(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SelectOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.select"

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, trueValue, falseValue, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(condition))
    operands.append(_get_op_result_or_value(trueValue))
    operands.append(_get_op_result_or_value(falseValue))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def condition(self):
    return self.operation.operands[0]

  @builtins.property
  def trueValue(self):
    return self.operation.operands[1]

  @builtins.property
  def falseValue(self):
    return self.operation.operands[2]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def select(condition, true_value, false_value, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SelectOp(condition=condition, trueValue=true_value, falseValue=false_value, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ShlOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.shl"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, overflowFlags, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def shl(lhs, rhs, overflow_flags, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ShlOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ShuffleVectorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.shufflevector"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, v1, v2, mask, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(v1))
    operands.append(_get_op_result_or_value(v2))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["mask"] = (mask if (
    isinstance(mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(mask, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def v1(self):
    return self.operation.operands[0]

  @builtins.property
  def v2(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.attributes["mask"]

  @mask.setter
  def mask(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mask"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def shufflevector(res, v1, v2, mask, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ShuffleVectorOp(res=res, v1=v1, v2=v2, mask=mask, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.sin"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_sin(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SinOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SqrtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.sqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_sqrt(in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SqrtOp(in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StackRestoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.stackrestore"

  _ODS_REGIONS = (0, True)

  def __init__(self, ptr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

def intr_stackrestore(ptr, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(StackRestoreOp(ptr=ptr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StackSaveOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.stacksave"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_stacksave(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StackSaveOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StepVectorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.experimental.stepvector"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_experimental_stepvector(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StepVectorOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, addr, *, alignment=None, volatile_=None, nontemporal=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(addr))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        isinstance(alignment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    if bool(volatile_): attributes["volatile_"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(nontemporal): attributes["nontemporal"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if ordering is not None: attributes["ordering"] = (ordering if (
        isinstance(ordering, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AtomicOrdering')) else
          _ods_ir.AttrBuilder.get('AtomicOrdering')(ordering, context=_ods_context))
    if syncscope is not None: attributes["syncscope"] = (syncscope if (
        isinstance(syncscope, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(syncscope, context=_ods_context))
    if access_groups is not None: attributes["access_groups"] = (access_groups if (
        isinstance(access_groups, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AccessGroupArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AccessGroupArrayAttr')(access_groups, context=_ods_context))
    if alias_scopes is not None: attributes["alias_scopes"] = (alias_scopes if (
        isinstance(alias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(alias_scopes, context=_ods_context))
    if noalias_scopes is not None: attributes["noalias_scopes"] = (noalias_scopes if (
        isinstance(noalias_scopes, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_AliasScopeArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_AliasScopeArrayAttr')(noalias_scopes, context=_ods_context))
    if tbaa is not None: attributes["tbaa"] = (tbaa if (
        isinstance(tbaa, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_TBAATagArrayAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_TBAATagArrayAttr')(tbaa, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def addr(self):
    return self.operation.operands[1]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def volatile_(self):
    return "volatile_" in self.operation.attributes

  @volatile_.setter
  def volatile_(self, value):
    if bool(value):
      self.operation.attributes["volatile_"] = _ods_ir.UnitAttr.get()
    elif "volatile_" in self.operation.attributes:
      del self.operation.attributes["volatile_"]

  @volatile_.deleter
  def volatile_(self):
    del self.operation.attributes["volatile_"]

  @builtins.property
  def nontemporal(self):
    return "nontemporal" in self.operation.attributes

  @nontemporal.setter
  def nontemporal(self, value):
    if bool(value):
      self.operation.attributes["nontemporal"] = _ods_ir.UnitAttr.get()
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

  @builtins.property
  def ordering(self):
    return self.operation.attributes["ordering"]

  @ordering.setter
  def ordering(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ordering"] = value

  @builtins.property
  def syncscope(self):
    if "syncscope" not in self.operation.attributes:
      return None
    return self.operation.attributes["syncscope"]

  @syncscope.setter
  def syncscope(self, value):
    if value is not None:
      self.operation.attributes["syncscope"] = value
    elif "syncscope" in self.operation.attributes:
      del self.operation.attributes["syncscope"]

  @syncscope.deleter
  def syncscope(self):
    del self.operation.attributes["syncscope"]

  @builtins.property
  def access_groups(self):
    if "access_groups" not in self.operation.attributes:
      return None
    return self.operation.attributes["access_groups"]

  @access_groups.setter
  def access_groups(self, value):
    if value is not None:
      self.operation.attributes["access_groups"] = value
    elif "access_groups" in self.operation.attributes:
      del self.operation.attributes["access_groups"]

  @access_groups.deleter
  def access_groups(self):
    del self.operation.attributes["access_groups"]

  @builtins.property
  def alias_scopes(self):
    if "alias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["alias_scopes"]

  @alias_scopes.setter
  def alias_scopes(self, value):
    if value is not None:
      self.operation.attributes["alias_scopes"] = value
    elif "alias_scopes" in self.operation.attributes:
      del self.operation.attributes["alias_scopes"]

  @alias_scopes.deleter
  def alias_scopes(self):
    del self.operation.attributes["alias_scopes"]

  @builtins.property
  def noalias_scopes(self):
    if "noalias_scopes" not in self.operation.attributes:
      return None
    return self.operation.attributes["noalias_scopes"]

  @noalias_scopes.setter
  def noalias_scopes(self, value):
    if value is not None:
      self.operation.attributes["noalias_scopes"] = value
    elif "noalias_scopes" in self.operation.attributes:
      del self.operation.attributes["noalias_scopes"]

  @noalias_scopes.deleter
  def noalias_scopes(self):
    del self.operation.attributes["noalias_scopes"]

  @builtins.property
  def tbaa(self):
    if "tbaa" not in self.operation.attributes:
      return None
    return self.operation.attributes["tbaa"]

  @tbaa.setter
  def tbaa(self, value):
    if value is not None:
      self.operation.attributes["tbaa"] = value
    elif "tbaa" in self.operation.attributes:
      del self.operation.attributes["tbaa"]

  @tbaa.deleter
  def tbaa(self):
    del self.operation.attributes["tbaa"]

def store(value, addr, *, alignment=None, volatile_=None, nontemporal=None, ordering=None, syncscope=None, access_groups=None, alias_scopes=None, noalias_scopes=None, tbaa=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(StoreOp(value=value, addr=addr, alignment=alignment, volatile_=volatile_, nontemporal=nontemporal, ordering=ordering, syncscope=syncscope, access_groups=access_groups, alias_scopes=alias_scopes, noalias_scopes=noalias_scopes, tbaa=tbaa, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SubOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.sub"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, overflowFlags, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def sub(lhs, rhs, overflow_flags, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SubOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SwitchOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.switch"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, value, defaultOperands, caseOperands, case_operand_segments, defaultDestination, caseDestinations, *, case_values=None, branch_weights=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_results_or_values(defaultOperands))
    operands.append(_get_op_results_or_values(caseOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if case_values is not None: attributes["case_values"] = (case_values if (
        isinstance(case_values, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyIntElementsAttr')) else
          _ods_ir.AttrBuilder.get('AnyIntElementsAttr')(case_values, context=_ods_context))
    attributes["case_operand_segments"] = (case_operand_segments if (
    isinstance(case_operand_segments, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(case_operand_segments, context=_ods_context))
    if branch_weights is not None: attributes["branch_weights"] = (branch_weights if (
        isinstance(branch_weights, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(branch_weights, context=_ods_context))
    _ods_successors = []
    _ods_successors.append(defaultDestination)
    _ods_successors.extend(caseDestinations)
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def defaultOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def caseOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def case_values(self):
    if "case_values" not in self.operation.attributes:
      return None
    return self.operation.attributes["case_values"]

  @case_values.setter
  def case_values(self, value):
    if value is not None:
      self.operation.attributes["case_values"] = value
    elif "case_values" in self.operation.attributes:
      del self.operation.attributes["case_values"]

  @case_values.deleter
  def case_values(self):
    del self.operation.attributes["case_values"]

  @builtins.property
  def case_operand_segments(self):
    return self.operation.attributes["case_operand_segments"]

  @case_operand_segments.setter
  def case_operand_segments(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["case_operand_segments"] = value

  @builtins.property
  def branch_weights(self):
    if "branch_weights" not in self.operation.attributes:
      return None
    return self.operation.attributes["branch_weights"]

  @branch_weights.setter
  def branch_weights(self, value):
    if value is not None:
      self.operation.attributes["branch_weights"] = value
    elif "branch_weights" in self.operation.attributes:
      del self.operation.attributes["branch_weights"]

  @branch_weights.deleter
  def branch_weights(self):
    del self.operation.attributes["branch_weights"]

def switch(value, default_operands, case_operands, case_operand_segments, default_destination, case_destinations, *, case_values=None, branch_weights=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(SwitchOp(value=value, defaultOperands=default_operands, caseOperands=case_operands, case_operand_segments=case_operand_segments, defaultDestination=default_destination, caseDestinations=case_destinations, case_values=case_values, branch_weights=branch_weights, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ThreadlocalAddressOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.threadlocal.address"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, global_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(global_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def global_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_threadlocal_address(res, global_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ThreadlocalAddressOp(res=res, global_=global_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class Trap(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.trap"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def intr_trap(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(Trap(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.trunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def trunc(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(TruncOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UAddSat(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.uadd.sat"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_uadd_sat(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UAddSat(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UAddWithOverflowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.uadd.with.overflow"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_uadd_with_overflow(res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UAddWithOverflowOp(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UBSanTrap(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ubsantrap"

  _ODS_REGIONS = (0, True)

  def __init__(self, failureKind, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["failureKind"] = (failureKind if (
    isinstance(failureKind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I8Attr')) else
      _ods_ir.AttrBuilder.get('I8Attr')(failureKind, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def failureKind(self):
    return self.operation.attributes["failureKind"]

  @failureKind.setter
  def failureKind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["failureKind"] = value

def intr_ubsantrap(failure_kind, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(UBSanTrap(failureKind=failure_kind, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.udiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def udiv(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UDivOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.uitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def uitofp(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UIToFPOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.umax"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_umax(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UMaxOp(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.umin"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_umin(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UMinOp(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UMulWithOverflowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.umul.with.overflow"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_umul_with_overflow(res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UMulWithOverflowOp(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class URemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.urem"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def urem(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(URemOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class USHLSat(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.ushl.sat"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_ushl_sat(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(USHLSat(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class USubSat(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.usub.sat"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_usub_sat(a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(USubSat(a=a, b=b, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class USubWithOverflowOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.usub.with.overflow"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_usub_with_overflow(res, _gen_arg_0, _gen_arg_1, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(USubWithOverflowOp(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UndefOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.undef"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_undef(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UndefOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnreachableOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.unreachable"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def unreachable(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(UnreachableOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPAShrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.ashr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_ashr(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPAShrOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_add(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPAddOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPAndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.and"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_and(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPAndOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fadd"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fadd(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFAddOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fdiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fdiv(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFDivOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFMulAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fmuladd"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, op1, op2, op3, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(op1))
    operands.append(_get_op_result_or_value(op2))
    operands.append(_get_op_result_or_value(op3))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def op1(self):
    return self.operation.operands[0]

  @builtins.property
  def op2(self):
    return self.operation.operands[1]

  @builtins.property
  def op3(self):
    return self.operation.operands[2]

  @builtins.property
  def mask(self):
    return self.operation.operands[3]

  @builtins.property
  def evl(self):
    return self.operation.operands[4]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fmuladd(res, op1, op2, op3, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFMulAddOp(res=res, op1=op1, op2=op2, op3=op3, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFMulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fmul(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFMulOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFNegOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fneg"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, op, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(op))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def op(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fneg(res, op, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFNegOp(res=res, op=op, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFPExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fpext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fpext(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFPExtOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFPToSIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fptosi"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fptosi(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFPToSIOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFPToUIOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fptoui"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fptoui(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFPToUIOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFPTruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fptrunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fptrunc(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFPTruncOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFRemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.frem"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_frem(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFRemOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFSubOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fsub"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fsub(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFSubOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPFmaOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.fma"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, op1, op2, op3, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(op1))
    operands.append(_get_op_result_or_value(op2))
    operands.append(_get_op_result_or_value(op3))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def op1(self):
    return self.operation.operands[0]

  @builtins.property
  def op2(self):
    return self.operation.operands[1]

  @builtins.property
  def op3(self):
    return self.operation.operands[2]

  @builtins.property
  def mask(self):
    return self.operation.operands[3]

  @builtins.property
  def evl(self):
    return self.operation.operands[4]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_fma(res, op1, op2, op3, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPFmaOp(res=res, op1=op1, op2=op2, op3=op3, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPIntToPtrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.inttoptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_inttoptr(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPIntToPtrOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPLShrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.lshr"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_lshr(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPLShrOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, ptr, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_load(res, ptr, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPLoadOp(res=res, ptr=ptr, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPMergeMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.merge"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, cond, true_val, false_val, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(cond))
    operands.append(_get_op_result_or_value(true_val))
    operands.append(_get_op_result_or_value(false_val))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.operands[0]

  @builtins.property
  def true_val(self):
    return self.operation.operands[1]

  @builtins.property
  def false_val(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_merge(res, cond, true_val, false_val, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPMergeMinOp(res=res, cond=cond, true_val=true_val, false_val=false_val, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPMulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_mul(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPMulOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPOrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.or"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_or(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPOrOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPPtrToIntOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.ptrtoint"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_ptrtoint(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPPtrToIntOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_add(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceAddOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceAndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.and"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_and(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceAndOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceFAddOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.fadd"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_fadd(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceFAddOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceFMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.fmax"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_fmax(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceFMaxOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceFMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.fmin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_fmin(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceFMinOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceFMulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.fmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_fmul(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceFMulOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceMulOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_mul(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceMulOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceOrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.or"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_or(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceOrOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceSMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.smax"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_smax(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceSMaxOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceSMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.smin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_smin(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceSMinOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceUMaxOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.umax"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_umax(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceUMaxOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceUMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.umin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_umin(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceUMinOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPReduceXorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.reduce.xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, satrt_value, val, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(satrt_value))
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def satrt_value(self):
    return self.operation.operands[0]

  @builtins.property
  def val(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_reduce_xor(res, satrt_value, val, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPReduceXorOp(res=res, satrt_value=satrt_value, val=val, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPSDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.sdiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_sdiv(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPSDivOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPSExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.sext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_sext(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPSExtOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPSIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.sitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_sitofp(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPSIToFPOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPSRemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.srem"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_srem(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPSRemOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPSelectMinOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.select"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, cond, true_val, false_val, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(cond))
    operands.append(_get_op_result_or_value(true_val))
    operands.append(_get_op_result_or_value(false_val))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.operands[0]

  @builtins.property
  def true_val(self):
    return self.operation.operands[1]

  @builtins.property
  def false_val(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_select(res, cond, true_val, false_val, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPSelectMinOp(res=res, cond=cond, true_val=true_val, false_val=false_val, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPShlOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.shl"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_shl(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPShlOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, ptr, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def ptr(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

def intr_vp_store(val, ptr, mask, evl, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VPStoreOp(val=val, ptr=ptr, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPStridedLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.experimental.vp.strided.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, ptr, stride, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(stride))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def stride(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_experimental_vp_strided_load(res, ptr, stride, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPStridedLoadOp(res=res, ptr=ptr, stride=stride, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPStridedStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.experimental.vp.strided.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, ptr, stride, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(ptr))
    operands.append(_get_op_result_or_value(stride))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def ptr(self):
    return self.operation.operands[1]

  @builtins.property
  def stride(self):
    return self.operation.operands[2]

  @builtins.property
  def mask(self):
    return self.operation.operands[3]

  @builtins.property
  def evl(self):
    return self.operation.operands[4]

def intr_experimental_vp_strided_store(val, ptr, stride, mask, evl, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VPStridedStoreOp(val=val, ptr=ptr, stride=stride, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPSubOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.sub"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_sub(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPSubOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPTruncOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.trunc"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_trunc(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPTruncOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPUDivOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.udiv"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_udiv(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPUDivOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPUIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.uitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_uitofp(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPUIToFPOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPURemOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.urem"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_urem(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPURemOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPXorOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, lhs, rhs, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def evl(self):
    return self.operation.operands[3]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_xor(res, lhs, rhs, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPXorOp(res=res, lhs=lhs, rhs=rhs, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VPZExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vp.zext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, src, mask, evl, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    operands.append(_get_op_result_or_value(mask))
    operands.append(_get_op_result_or_value(evl))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def evl(self):
    return self.operation.operands[2]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vp_zext(res, src, mask, evl, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VPZExtOp(res=res, src=src, mask=mask, evl=evl, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VaCopyOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vacopy"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest_list, src_list, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest_list))
    operands.append(_get_op_result_or_value(src_list))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest_list(self):
    return self.operation.operands[0]

  @builtins.property
  def src_list(self):
    return self.operation.operands[1]

def intr_vacopy(dest_list, src_list, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VaCopyOp(dest_list=dest_list, src_list=src_list, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VaEndOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vaend"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg_list, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg_list))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg_list(self):
    return self.operation.operands[0]

def intr_vaend(arg_list, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VaEndOp(arg_list=arg_list, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VaStartOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vastart"

  _ODS_REGIONS = (0, True)

  def __init__(self, arg_list, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg_list))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg_list(self):
    return self.operation.operands[0]

def intr_vastart(arg_list, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VaStartOp(arg_list=arg_list, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VarAnnotation(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.var.annotation"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, annotation, fileName, line, attr, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(val))
    operands.append(_get_op_result_or_value(annotation))
    operands.append(_get_op_result_or_value(fileName))
    operands.append(_get_op_result_or_value(line))
    operands.append(_get_op_result_or_value(attr))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    return self.operation.operands[0]

  @builtins.property
  def annotation(self):
    return self.operation.operands[1]

  @builtins.property
  def fileName(self):
    return self.operation.operands[2]

  @builtins.property
  def line(self):
    return self.operation.operands[3]

  @builtins.property
  def attr(self):
    return self.operation.operands[4]

def intr_var_annotation(val, annotation, file_name, line, attr, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VarAnnotation(val=val, annotation=annotation, fileName=file_name, line=line, attr=attr, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class XOrOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def xor(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(XOrOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ZExtOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.zext"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, arg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(arg))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def arg(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def zext(res, arg, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ZExtOp(res=res, arg=arg, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ZeroOp(_ods_ir.OpView):
  OPERATION_NAME = "llvm.mlir.zero"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def mlir_zero(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ZeroOp(res=res, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class masked_compressstore(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.masked.compressstore"

  _ODS_REGIONS = (0, True)

  def __init__(self, _gen_arg_0, _gen_arg_1, _gen_arg_2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    operands.append(_get_op_result_or_value(_gen_arg_2))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def intr_masked_compressstore(_gen_arg_0, _gen_arg_1, _gen_arg_2, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(masked_compressstore(_gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, _gen_arg_2=_gen_arg_2, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class masked_expandload(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.masked.expandload"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, _gen_arg_0, _gen_arg_1, _gen_arg_2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(_gen_arg_0))
    operands.append(_get_op_result_or_value(_gen_arg_1))
    operands.append(_get_op_result_or_value(_gen_arg_2))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_masked_expandload(res, _gen_arg_0, _gen_arg_1, _gen_arg_2, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(masked_expandload(res=res, _gen_arg_0=_gen_arg_0, _gen_arg_1=_gen_arg_1, _gen_arg_2=_gen_arg_2, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class masked_gather(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.masked.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, ptrs, mask, pass_thru, alignment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(ptrs))
    operands.append(_get_op_result_or_value(mask))
    operands.extend(_get_op_results_or_values(pass_thru))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["alignment"] = (alignment if (
    isinstance(alignment, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(alignment, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ptrs(self):
    return self.operation.operands[0]

  @builtins.property
  def mask(self):
    return self.operation.operands[1]

  @builtins.property
  def pass_thru(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def alignment(self):
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["alignment"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_masked_gather(res, ptrs, mask, pass_thru, alignment, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(masked_gather(res=res, ptrs=ptrs, mask=mask, pass_thru=pass_thru, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class masked_scatter(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.masked.scatter"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, ptrs, mask, alignment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(ptrs))
    operands.append(_get_op_result_or_value(mask))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["alignment"] = (alignment if (
    isinstance(alignment, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(alignment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def ptrs(self):
    return self.operation.operands[1]

  @builtins.property
  def mask(self):
    return self.operation.operands[2]

  @builtins.property
  def alignment(self):
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["alignment"] = value

def intr_masked_scatter(value, ptrs, mask, alignment, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(masked_scatter(value=value, ptrs=ptrs, mask=mask, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_deinterleave2(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.deinterleave2"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, vec, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vec))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vec(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_deinterleave2(res, vec, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_deinterleave2(res=res, vec=vec, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_extract(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, srcvec, pos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(srcvec))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pos"] = (pos if (
    isinstance(pos, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(pos, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def srcvec(self):
    return self.operation.operands[0]

  @builtins.property
  def pos(self):
    return self.operation.attributes["pos"]

  @pos.setter
  def pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pos"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_extract(res, srcvec, pos, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_extract(res=res, srcvec=srcvec, pos=pos, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_insert(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.insert"

  _ODS_REGIONS = (0, True)

  def __init__(self, dstvec, srcvec, pos, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dstvec))
    operands.append(_get_op_result_or_value(srcvec))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pos"] = (pos if (
    isinstance(pos, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(pos, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dstvec(self):
    return self.operation.operands[0]

  @builtins.property
  def srcvec(self):
    return self.operation.operands[1]

  @builtins.property
  def pos(self):
    return self.operation.attributes["pos"]

  @pos.setter
  def pos(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pos"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_insert(dstvec, srcvec, pos, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_insert(dstvec=dstvec, srcvec=srcvec, pos=pos, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_interleave2(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.interleave2"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, vec1, vec2, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(vec1))
    operands.append(_get_op_result_or_value(vec2))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def vec1(self):
    return self.operation.operands[0]

  @builtins.property
  def vec2(self):
    return self.operation.operands[1]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_interleave2(res, vec1, vec2, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_interleave2(res=res, vec1=vec1, vec2=vec2, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_add(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_add(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_add(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_and(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.and"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_and(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_and(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_fadd(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.fadd"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, start_value, input, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(start_value))
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def start_value(self):
    return self.operation.operands[0]

  @builtins.property
  def input(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_fadd(res, start_value, input, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_fadd(res=res, start_value=start_value, input=input, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_fmax(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.fmax"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_fmax(res, in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_fmax(res=res, in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_fmaximum(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.fmaximum"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_fmaximum(res, in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_fmaximum(res=res, in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_fmin(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.fmin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_fmin(res, in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_fmin(res=res, in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_fminimum(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.fminimum"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_fminimum(res, in_, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_fminimum(res=res, in_=in_, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_fmul(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.fmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, start_value, input, *, fastmathFlags=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(start_value))
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmathFlags is not None: attributes["fastmathFlags"] = (fastmathFlags if (
        isinstance(fastmathFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LLVM_FastmathFlagsAttr')) else
          _ods_ir.AttrBuilder.get('LLVM_FastmathFlagsAttr')(fastmathFlags, context=_ods_context))
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def start_value(self):
    return self.operation.operands[0]

  @builtins.property
  def input(self):
    return self.operation.operands[1]

  @builtins.property
  def fastmathFlags(self):
    return self.operation.attributes["fastmathFlags"]

  @fastmathFlags.setter
  def fastmathFlags(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmathFlags"] = value

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_fmul(res, start_value, input, *, fastmath_flags=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_fmul(res=res, start_value=start_value, input=input, fastmathFlags=fastmath_flags, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_mul(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.mul"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_mul(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_mul(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_or(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.or"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_or(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_or(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_smax(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.smax"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_smax(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_smax(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_smin(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.smin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_smin(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_smin(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_umax(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.umax"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_umax(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_umax(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_umin(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.umin"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_umin(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_umin(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vector_reduce_xor(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vector.reduce.xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, in_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vector_reduce_xor(res, in_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vector_reduce_xor(res=res, in_=in_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class vscale(_ods_ir.OpView):
  OPERATION_NAME = "llvm.intr.vscale"

  _ODS_REGIONS = (0, True)

  def __init__(self, res, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(res)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def res(self):
    return self.operation.results[0]

def intr_vscale(res, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(vscale(res=res, loc=loc, ip=ip))
