
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class TensorMapInterleaveKind(IntEnum):
    """Tensor map interleave layout type"""

    INTERLEAVE_NONE = 0
    INTERLEAVE_16B = 1
    INTERLEAVE_32B = 2

    def __str__(self):
        if self is TensorMapInterleaveKind.INTERLEAVE_NONE:
            return "none"
        if self is TensorMapInterleaveKind.INTERLEAVE_16B:
            return "interleave_16b"
        if self is TensorMapInterleaveKind.INTERLEAVE_32B:
            return "interleave_32b"
        raise ValueError("Unknown TensorMapInterleaveKind enum entry.")



@register_attribute_builder("TensorMapInterleaveKind")
def _tensormapinterleavekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TensorMapL2PromoKind(IntEnum):
    """Tensor map L2 promotion type"""

    L2PROMO_NONE = 0
    L2PROMO_64B = 1
    L2PROMO_128B = 2
    L2PROMO_256B = 3

    def __str__(self):
        if self is TensorMapL2PromoKind.L2PROMO_NONE:
            return "none"
        if self is TensorMapL2PromoKind.L2PROMO_64B:
            return "l2promo_64b"
        if self is TensorMapL2PromoKind.L2PROMO_128B:
            return "l2promo_128b"
        if self is TensorMapL2PromoKind.L2PROMO_256B:
            return "l2promo_256b"
        raise ValueError("Unknown TensorMapL2PromoKind enum entry.")



@register_attribute_builder("TensorMapL2PromoKind")
def _tensormapl2promokind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TensorMapOOBKind(IntEnum):
    """Tensor map out-of-bounds fill type"""

    OOB_ZERO = 0
    OOB_NAN = 1

    def __str__(self):
        if self is TensorMapOOBKind.OOB_ZERO:
            return "zero"
        if self is TensorMapOOBKind.OOB_NAN:
            return "nan"
        raise ValueError("Unknown TensorMapOOBKind enum entry.")



@register_attribute_builder("TensorMapOOBKind")
def _tensormapoobkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class TensorMapSwizzleKind(IntEnum):
    """Tensor map swizzling mode of shared memory banks"""

    SWIZZLE_NONE = 0
    SWIZZLE_32B = 1
    SWIZZLE_64B = 2
    SWIZZLE_128B = 3

    def __str__(self):
        if self is TensorMapSwizzleKind.SWIZZLE_NONE:
            return "none"
        if self is TensorMapSwizzleKind.SWIZZLE_32B:
            return "swizzle_32b"
        if self is TensorMapSwizzleKind.SWIZZLE_64B:
            return "swizzle_64b"
        if self is TensorMapSwizzleKind.SWIZZLE_128B:
            return "swizzle_128b"
        raise ValueError("Unknown TensorMapSwizzleKind enum entry.")



@register_attribute_builder("TensorMapSwizzleKind")
def _tensormapswizzlekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

@register_attribute_builder("TensorMapInterleaveAttr")
def _tensormapinterleaveattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvgpu<interleave {str(x)}>', context=context)

@register_attribute_builder("TensorMapL2PromoAttr")
def _tensormapl2promoattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvgpu<l2promo {str(x)}>', context=context)

@register_attribute_builder("TensorMapOOBAttr")
def _tensormapoobattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvgpu<oob {str(x)}>', context=context)

@register_attribute_builder("TensorMapSwizzleAttr")
def _tensormapswizzleattr(x, context):
    return _ods_ir.Attribute.parse(f'#nvgpu<swizzle {str(x)}>', context=context)

