#!/usr/bin/env python 
# -*- coding: utf-8 -*-

# Copyright (C) 2011 Modelon AB
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

__all__ = ["euler","radau5","sundials","runge_kutta","rosenbrock",
           "glimda","odepack"]

#Import all the solvers from the different modules
from euler import ExplicitEuler
from radau5 import Radau5ODE, Radau5DAE, _Radau5ODE, _Radau5DAE 
from sundials import IDA, CVode
from runge_kutta import RungeKutta34, RungeKutta4, Dopri5
from rosenbrock import RodasODE
from odassl import ODASSLODE
from odepack import LSODAR

try:
    from glimda import GLIMDA
except ImportError:
    print "Could not find GLIMDA"
