"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlFederatedPrincipal = exports.SamlIdentityProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * Create a SAML identity provider
 *
 * @deprecated use `SamlProvider` from `aws-cdk-lib/aws-iam`
 */
class SamlIdentityProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const name = props.name ?? `${aws_cdk_lib_1.Names.uniqueId(this)}IdentityProvider`;
        const arn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'iam',
            region: '',
            resource: 'saml-provider',
            resourceName: name,
        });
        const idp = new cr.AwsCustomResource(this, 'Resource', {
            resourceType: 'Custom::SamlIdentityProvider',
            onCreate: {
                service: 'IAM',
                action: 'createSAMLProvider',
                parameters: {
                    Name: name,
                    SAMLMetadataDocument: props.metadataDocument,
                },
                physicalResourceId: cr.PhysicalResourceId.fromResponse('SAMLProviderArn'),
            },
            onUpdate: {
                service: 'IAM',
                action: 'updateSAMLProvider',
                parameters: {
                    SAMLProviderArn: new cr.PhysicalResourceIdReference().toJSON(),
                    SAMLMetadataDocument: props.metadataDocument,
                },
                physicalResourceId: cr.PhysicalResourceId.fromResponse('SAMLProviderArn'),
            },
            onDelete: {
                service: 'IAM',
                action: 'deleteSAMLProvider',
                parameters: {
                    SAMLProviderArn: new cr.PhysicalResourceIdReference().toJSON(),
                },
            },
            policy: cr.AwsCustomResourcePolicy.fromStatements([
                new iam.PolicyStatement({
                    actions: [
                        'iam:createSAMLProvider',
                        'iam:updateSAMLProvider',
                        'iam:deleteSAMLProvider',
                    ],
                    resources: [arn],
                }),
            ]),
        });
        this.samlIdentityProviderArn = idp.getResponseField('SAMLProviderArn');
    }
}
exports.SamlIdentityProvider = SamlIdentityProvider;
_a = JSII_RTTI_SYMBOL_1;
SamlIdentityProvider[_a] = { fqn: "cloudstructs.SamlIdentityProvider", version: "0.5.8" };
/**
 * Principal entity that represents a SAML federated identity provider.
 *
 * @deprecated use `SamlPrincipal` from `aws-cdk-lib/aws-iam`
 */
class SamlFederatedPrincipal extends iam.FederatedPrincipal {
    constructor(identityProvider) {
        super(identityProvider.samlIdentityProviderArn, {
            StringEquals: {
                'SAML:aud': 'https://signin.aws.amazon.com/saml',
            },
        }, 'sts:AssumeRoleWithSAML');
    }
}
exports.SamlFederatedPrincipal = SamlFederatedPrincipal;
_b = JSII_RTTI_SYMBOL_1;
SamlFederatedPrincipal[_b] = { fqn: "cloudstructs.SamlFederatedPrincipal", version: "0.5.8" };
//# sourceMappingURL=data:application/json;base64,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