export declare const CREATE_FAILED_PHYSICAL_ID_MARKER = "AWSCDK::StateMachineProvider::CREATE_FAILED";
interface Output {
    PhysicalResourceId?: string;
    Data?: {
        [Key: string]: any;
    };
    NoEcho?: boolean;
}
interface ExecutionResult {
    ExecutionArn: string;
    Input: AWSLambda.CloudFormationCustomResourceEvent & {
        PhysicalResourceId?: string;
    };
    Name: string;
    Output?: Output;
    StartDate: number;
    StateMachineArn: string;
    Status: 'RUNNING' | 'SUCCEEDED' | 'FAILED' | 'TIMED_OUT' | 'ABORTED';
    StopDate: number;
}
interface FailedExecutionEvent {
    Error: string;
    Cause: string;
}
export declare function cfnResponseSuccess(event: ExecutionResult): Promise<void>;
export declare function cfnResponseFailed(event: FailedExecutionEvent): Promise<void>;
export declare function startExecution(event: AWSLambda.CloudFormationCustomResourceEvent): Promise<void>;
export {};
