"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CleanImagesFunction = void 0;
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
/**
 * An AWS Lambda function which executes src/toolkit-cleaner/clean-images.
 */
class CleanImagesFunction extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            description: 'src/toolkit-cleaner/clean-images.lambda.ts',
            ...props,
            runtime: new lambda.Runtime('nodejs16.x', lambda.RuntimeFamily.NODEJS),
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '../../assets/toolkit-cleaner/clean-images.lambda')),
        });
        this.addEnvironment('AWS_NODEJS_CONNECTION_REUSE_ENABLED', '1', { removeInEdge: true });
    }
}
exports.CleanImagesFunction = CleanImagesFunction;
//# sourceMappingURL=data:application/json;base64,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