"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const ecr = new aws_sdk_1.ECR();
async function handler(assetHashes) {
    if (!process.env.REPOSITORY_NAME) {
        throw new Error('Missing REPOSITORY_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await ecr.describeImages({
            repositoryName: process.env.REPOSITORY_NAME,
            nextToken,
        }).promise();
        const toDelete = response.imageDetails?.filter(x => {
            if (!x.imageTags) {
                return false;
            }
            let pred = !assetHashes.includes(x.imageTags[0]);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!x.imagePushedAt) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.imagePushedAt && x.imagePushedAt < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await ecr.batchDeleteImage({
                    repositoryName: process.env.REPOSITORY_NAME,
                    imageIds: toDelete.map(x => ({ imageTag: x.imageTags[0] })),
                }).promise();
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.imageSizeInBytes ?? 0), 0);
        }
        nextToken = response.nextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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