"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Analysis import Beam, IMessage, IMessages, SampleSizes, ShowAs

from . import (
    RMS,
    Aberrations,
    Coatings,
    DiffractionEfficiency,
    EncircledEnergy,
    ExtendedScene,
    Fans,
    Materials,
    Mtf,
    NSCSurface,
    Psf,
    RayTracing,
    Spot,
    Surface,
    Wavefront,
)

__all__ = (
    "Aberrations",
    "Coatings",
    "DiffractionEfficiency",
    "EncircledEnergy",
    "ExtendedScene",
    "Fans",
    "Materials",
    "Mtf",
    "NSCSurface",
    "Psf",
    "RayTracing",
    "RMS",
    "Spot",
    "Surface",
    "Wavefront",
    "AxisType",
    "DetectorViewerScaleTypes",
    "DisplayOption",
    "HuygensPsfTypes",
    "IAS_",
    "IAS_CriticalRayTracer",
    "IAS_Detector",
    "IAS_Field",
    "IAS_FileComparator",
    "IAS_Interferogram",
    "IAS_Surface",
    "IAS_WavefrontMap",
    "IAS_Wavelength",
    "IAS_XXXTemplateXXX",
    "Parity",
    "Polarizations",
    "PsfSpread",
    "PsfTypes",
    "ReferenceGia",
    "Rotations",
    "ScanTypes",
    "SourceGia",
    "STAREffectsOptions",
)

class AxisType:
    X = 0
    Y = 1
    Z = 2

class DetectorViewerScaleTypes:
    Linear = 0
    Log_Minus_5 = 1
    Normalized = 1
    Log_Minus_10 = 2
    Log_Minus_15 = 3

class DisplayOption:
    AllRays = 0
    FailedRays = 1
    PassedRays = 2

class HuygensPsfTypes:
    Linear = 0
    Log_Minus_1 = 1
    Log_Minus_2 = 2
    Log_Minus_3 = 3
    Log_Minus_4 = 4
    Log_Minus_5 = 5
    Real = 6
    Imaginary = 7
    Phase = 8

class IAS_:
    def Load(self) -> None: ...
    def LoadFrom(self, settingsFile: str) -> bool: ...
    def ModifySettings(self, settingsFile: str, typeCode: str, newValue: str) -> bool: ...
    def Reset(self) -> None: ...
    def Save(self) -> None: ...
    def SaveTo(self, settingsFile: str) -> bool: ...
    def Verify(self) -> IMessages: ...

class IAS_CriticalRayTracer(IAS_):
    @property
    def PositionTolerance(self) -> float: ...
    @PositionTolerance.setter
    def PositionTolerance(self, value: float) -> None: ...
    @property
    def AngleTolerance(self) -> float: ...
    @AngleTolerance.setter
    def AngleTolerance(self, value: float) -> None: ...
    @property
    def Filename(self) -> str: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...
    @property
    def RaysToDisplay(self) -> DisplayOption: ...
    @RaysToDisplay.setter
    def RaysToDisplay(self, value: DisplayOption) -> None: ...
    @property
    def DisplayXYZ(self) -> bool: ...
    @DisplayXYZ.setter
    def DisplayXYZ(self, value: bool) -> None: ...
    @property
    def DisplayLMN(self) -> bool: ...
    @DisplayLMN.setter
    def DisplayLMN(self, value: bool) -> None: ...
    @property
    def DisplayActualEndData(self) -> bool: ...
    @DisplayActualEndData.setter
    def DisplayActualEndData(self, value: bool) -> None: ...
    @property
    def DisplayTargetEndData(self) -> bool: ...
    @DisplayTargetEndData.setter
    def DisplayTargetEndData(self, value: bool) -> None: ...
    @property
    def DisplayStartData(self) -> bool: ...
    @DisplayStartData.setter
    def DisplayStartData(self, value: bool) -> None: ...

class IAS_Detector:
    def GetDetectorNumber(self) -> int: ...
    def SetDetectorNumber(self, N: int) -> IMessage: ...
    def SummarizeAll(self) -> IMessage: ...

class IAS_Field:
    def GetFieldNumber(self) -> int: ...
    def SetFieldNumber(self, N: int) -> IMessage: ...
    def UseAllFields(self) -> IMessage: ...

class IAS_FileComparator(IAS_):
    @property
    def File1Name(self) -> str: ...
    @File1Name.setter
    def File1Name(self, value: str) -> None: ...
    @property
    def File1SpecifyConfig(self) -> bool: ...
    @File1SpecifyConfig.setter
    def File1SpecifyConfig(self, value: bool) -> None: ...
    @property
    def File1Config(self) -> int: ...
    @File1Config.setter
    def File1Config(self, value: int) -> None: ...
    @property
    def File2Name(self) -> str: ...
    @File2Name.setter
    def File2Name(self, value: str) -> None: ...
    @property
    def File2SpecifyConfig(self) -> bool: ...
    @File2SpecifyConfig.setter
    def File2SpecifyConfig(self, value: bool) -> None: ...
    @property
    def File2Config(self) -> int: ...
    @File2Config.setter
    def File2Config(self, value: int) -> None: ...
    @property
    def IncludeGeneralData(self) -> bool: ...
    @IncludeGeneralData.setter
    def IncludeGeneralData(self, value: bool) -> None: ...
    @property
    def IncludeSurfaceData(self) -> bool: ...
    @IncludeSurfaceData.setter
    def IncludeSurfaceData(self, value: bool) -> None: ...
    @property
    def IncludeSurfaceDetail(self) -> bool: ...
    @IncludeSurfaceDetail.setter
    def IncludeSurfaceDetail(self, value: bool) -> None: ...
    @property
    def IncludeEdgeThickness(self) -> bool: ...
    @IncludeEdgeThickness.setter
    def IncludeEdgeThickness(self, value: bool) -> None: ...
    @property
    def IncludeMultiConfigData(self) -> bool: ...
    @IncludeMultiConfigData.setter
    def IncludeMultiConfigData(self, value: bool) -> None: ...
    @property
    def IncludeSolvesVariables(self) -> bool: ...
    @IncludeSolvesVariables.setter
    def IncludeSolvesVariables(self, value: bool) -> None: ...
    @property
    def IncludeIndexTCEData(self) -> bool: ...
    @IncludeIndexTCEData.setter
    def IncludeIndexTCEData(self, value: bool) -> None: ...
    @property
    def IncludeGlobalVertex(self) -> bool: ...
    @IncludeGlobalVertex.setter
    def IncludeGlobalVertex(self, value: bool) -> None: ...
    @property
    def IncludeCOCPoint(self) -> bool: ...
    @IncludeCOCPoint.setter
    def IncludeCOCPoint(self, value: bool) -> None: ...
    @property
    def IncludeElementVolume(self) -> bool: ...
    @IncludeElementVolume.setter
    def IncludeElementVolume(self, value: bool) -> None: ...
    @property
    def IncludeFNumbers(self) -> bool: ...
    @IncludeFNumbers.setter
    def IncludeFNumbers(self, value: bool) -> None: ...
    @property
    def IncludeCardinalPoints(self) -> bool: ...
    @IncludeCardinalPoints.setter
    def IncludeCardinalPoints(self, value: bool) -> None: ...
    @property
    def IncludePOPSettings(self) -> bool: ...
    @IncludePOPSettings.setter
    def IncludePOPSettings(self, value: bool) -> None: ...
    @property
    def IncludeFilesUsed(self) -> bool: ...
    @IncludeFilesUsed.setter
    def IncludeFilesUsed(self, value: bool) -> None: ...
    @property
    def IncludeMeritFunction(self) -> bool: ...
    @IncludeMeritFunction.setter
    def IncludeMeritFunction(self, value: bool) -> None: ...
    @property
    def ShowDifferencesOnly(self) -> bool: ...
    @ShowDifferencesOnly.setter
    def ShowDifferencesOnly(self, value: bool) -> None: ...
    def ClearAllIncludes(self) -> None: ...
    def SetAllIncludes(self) -> None: ...

class IAS_Interferogram(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def Sampling(self) -> SampleSizes: ...
    @Sampling.setter
    def Sampling(self, value: SampleSizes) -> None: ...
    @property
    def ShowAs(self) -> ShowAs: ...
    @ShowAs.setter
    def ShowAs(self, value: ShowAs) -> None: ...
    @property
    def Beam_1(self) -> Beam: ...
    @Beam_1.setter
    def Beam_1(self, value: Beam) -> None: ...
    @property
    def Beam_2(self) -> Beam: ...
    @Beam_2.setter
    def Beam_2(self, value: Beam) -> None: ...
    @property
    def Ref_Beam_1_To_Vertex(self) -> bool: ...
    @Ref_Beam_1_To_Vertex.setter
    def Ref_Beam_1_To_Vertex(self, value: bool) -> None: ...
    @property
    def Ref_Beam_2_To_Vertex(self) -> bool: ...
    @Ref_Beam_2_To_Vertex.setter
    def Ref_Beam_2_To_Vertex(self, value: bool) -> None: ...
    @property
    def UseExitPupil(self) -> bool: ...
    @UseExitPupil.setter
    def UseExitPupil(self, value: bool) -> None: ...
    @property
    def ConsiderOPL(self) -> bool: ...
    @ConsiderOPL.setter
    def ConsiderOPL(self, value: bool) -> None: ...
    @property
    def ScaleFactor(self) -> float: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @property
    def X_Tilt(self) -> float: ...
    @X_Tilt.setter
    def X_Tilt(self, value: float) -> None: ...
    @property
    def Y_Tilt(self) -> float: ...
    @Y_Tilt.setter
    def Y_Tilt(self, value: float) -> None: ...
    @property
    def Subaperture_X(self) -> float: ...
    @Subaperture_X.setter
    def Subaperture_X(self, value: float) -> None: ...
    @property
    def Subaperture_Y(self) -> float: ...
    @Subaperture_Y.setter
    def Subaperture_Y(self, value: float) -> None: ...
    @property
    def Subaperture_R(self) -> float: ...
    @Subaperture_R.setter
    def Subaperture_R(self, value: float) -> None: ...
    @property
    def ContourFormat(self) -> str: ...
    @ContourFormat.setter
    def ContourFormat(self, value: str) -> None: ...

class IAS_Surface:
    def GetSurfaceNumber(self) -> int: ...
    def SetSurfaceNumber(self, N: int) -> IMessage: ...
    def UseImageSurface(self) -> IMessage: ...
    def UseObjectiveSurface(self) -> IMessage: ...

class IAS_WavefrontMap(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def ShowAs(self) -> ShowAs: ...
    @ShowAs.setter
    def ShowAs(self, value: ShowAs) -> None: ...
    @property
    def Rotation(self) -> Rotations: ...
    @Rotation.setter
    def Rotation(self, value: Rotations) -> None: ...
    @property
    def Sampling(self) -> SampleSizes: ...
    @Sampling.setter
    def Sampling(self, value: SampleSizes) -> None: ...
    @property
    def Polarization(self) -> Polarizations: ...
    @Polarization.setter
    def Polarization(self, value: Polarizations) -> None: ...
    @property
    def ReferenceToPrimary(self) -> bool: ...
    @ReferenceToPrimary.setter
    def ReferenceToPrimary(self, value: bool) -> None: ...
    @property
    def UseExitPupil(self) -> bool: ...
    @UseExitPupil.setter
    def UseExitPupil(self, value: bool) -> None: ...
    @property
    def RemoveTilt(self) -> bool: ...
    @RemoveTilt.setter
    def RemoveTilt(self, value: bool) -> None: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def Subaperture_X(self) -> float: ...
    @Subaperture_X.setter
    def Subaperture_X(self, value: float) -> None: ...
    @property
    def Subaperture_Y(self) -> float: ...
    @Subaperture_Y.setter
    def Subaperture_Y(self, value: float) -> None: ...
    @property
    def Subaperture_R(self) -> float: ...
    @Subaperture_R.setter
    def Subaperture_R(self, value: float) -> None: ...
    @property
    def ContourFormat(self) -> str: ...
    @ContourFormat.setter
    def ContourFormat(self, value: str) -> None: ...
    @property
    def STAREffects(self) -> STAREffectsOptions: ...
    @STAREffects.setter
    def STAREffects(self, value: STAREffectsOptions) -> None: ...

class IAS_Wavelength:
    def GetWavelengthNumber(self) -> int: ...
    def SetWavelengthNumber(self, N: int) -> IMessage: ...
    def UseAllWavelengths(self) -> IMessage: ...

class IAS_XXXTemplateXXX(IAS_):
    pass

class Parity:
    Even = 0
    Odd = 1

class Polarizations:
    # None = 0
    Ex = 1
    Ey = 2
    Ez = 3

class PsfSpread:
    Line = 0
    Edge = 1

class PsfTypes:
    X_Linear = 0
    Y_Linear = 1
    X_Logarithmic = 2
    Y_Logarithmic = 3
    X_Phase = 4
    Y_Phase = 5
    X_RealPart = 6
    Y_RealPart = 7
    X_ImaginaryPart = 8
    Y_ImaginaryPart = 9

class ReferenceGia:
    ChiefRay = 0
    Vertex = 1
    PrimaryChief = 2
    Centroid = 3

class Rotations:
    Rotate_0 = 0
    Rotate_90 = 1
    Rotate_180 = 2
    Rotate_270 = 3

class ScanTypes:
    Plus_Y = 0
    Plus_X = 1
    Minus_Y = 2
    Minus_X = 3

class SourceGia:
    Uniform = 0
    Lambertian = 1

class STAREffectsOptions:
    On = 0
    Difference = 1
