"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Analysis import IMessage
from zospy.api._ZOSAPI.Common import (
    ICoordinateTransform,
    IMetadata,
    ZemaxColor,
    ZemaxOpacity,
)
from zospy.api._ZOSAPI.Editors import (
    DirectionOfRayTravel,
    IEditor,
    IEditorCell,
    IEditorRow,
    ReflectTransmitCode,
    SampleSides,
    Samplings,
)
from zospy.api._ZOSAPI.SystemData import ZemaxApertureType

__all__ = (
    "CoatingStatusType",
    "ConversionOrder",
    "CoordinateConversionResult",
    "CoordinateReturnType",
    "ICoatingPerformanceData",
    "ILDEApertureData",
    "ILDECoatingData",
    "ILDECoatingSettings",
    "ILDECompositeData",
    "ILDEDrawData",
    "ILDEImportData",
    "ILDEPhysicalOpticsData",
    "ILDERow",
    "ILDEScatteringData",
    "ILDETiltDecenterData",
    "ILDETool_AddCoatingsToAllSurfaces",
    "ILDETool_TiltDecenterElements",
    "ILDETypeData",
    "ILensDataEditor",
    "IndexDataType",
    "InterpolationMethod",
    "ISTAR_ComponentRBMs",
    "ISTAR_CoordinateTransform",
    "ISTAR_Data",
    "ISTAR_Decenters",
    "ISTAR_Deformation",
    "ISTAR_DeformationFits",
    "ISTAR_Deformations",
    "ISTAR_DeformationsFEAData",
    "ISTAR_DirectIndex",
    "ISTAR_DirectIndexFEAData",
    "ISTAR_DirectIndexFits",
    "ISTAR_FEAFitResults",
    "ISTAR_FEAFitSettings",
    "ISTAR_PointWithDeformation",
    "ISTAR_PointWithDeformationAndWeight",
    "ISTAR_PointWithIndex",
    "ISTAR_PointWithTemperatureAndIndex",
    "ISTAR_RBM_Centroid",
    "ISTAR_RBM_ReferencePoint",
    "ISTAR_RBMs",
    "ISTAR_RotationAngles",
    "ISTAR_Rotations",
    "ISTAR_RotationValues",
    "ISTAR_Temperatures",
    "ISTAR_TemperaturesFEAData",
    "ISTAR_TemperaturesFits",
    "ISurface",
    "ISurfaceABCD",
    "ISurfaceAlternateEven",
    "ISurfaceAlternateOdd",
    "ISurfaceAnnularZernikeSag",
    "ISurfaceAPBC",
    "ISurfaceApertureCircular",
    "ISurfaceApertureElliptical",
    "ISurfaceApertureFloating",
    "ISurfaceApertureNone",
    "ISurfaceApertureRectangular",
    "ISurfaceApertureSpider",
    "ISurfaceApertureType",
    "ISurfaceApertureUser",
    "ISurfaceAtmospheric",
    "ISurfaceBiconic",
    "ISurfaceBiconicZernike",
    "ISurfaceBinary1",
    "ISurfaceBinary2",
    "ISurfaceBinary3",
    "ISurfaceBinary4",
    "ISurfaceBirefringentIn",
    "ISurfaceBirefringentOut",
    "ISurfaceBlackBoxLens",
    "ISurfaceChebyShv",
    "ISurfaceCoeff_P_NthEvenPower",
    "ISurfaceCoeff_P_NthPower",
    "ISurfaceCoeff_R_NthEvenPower",
    "ISurfaceCoeff_R_NthPower",
    "ISurfaceCoeff_X_NthEvenPower",
    "ISurfaceCoeff_X_NthEvenPower_8",
    "ISurfaceCoeff_X1P1X2P2_NthEvenPower",
    "ISurfaceCoeff_Y_NthEvenPower",
    "ISurfaceCoeff_Y_NthEvenPower_8",
    "ISurfaceConjugate",
    "ISurfaceCoordinateBreak",
    "ISurfaceCubicSpline",
    "ISurfaceCylinderFrensel",
    "ISurfaceCylinderFresnel",
    "ISurfaceData",
    "ISurfaceDiffractionGrating",
    "ISurfaceEllipticalGrating1",
    "ISurfaceEllipticalGrating2",
    "ISurfaceEvenAspheric",
    "ISurfaceExtendedAsphere",
    "ISurfaceExtendedCubicSpline",
    "ISurfaceExtendedFresnel",
    "ISurfaceExtendedOddAsphere",
    "ISurfaceExtendedPolynomial",
    "ISurfaceExtendedToroidalGrating",
    "ISurfaceFreeformNthZernike",
    "ISurfaceFreeformXYPolynomial",
    "ISurfaceFresnel",
    "ISurfaceGeneralizedFresnel",
    "ISurfaceGradient1",
    "ISurfaceGradient10",
    "ISurfaceGradient12",
    "ISurfaceGradient2",
    "ISurfaceGradient3",
    "ISurfaceGradient4",
    "ISurfaceGradient5",
    "ISurfaceGradient6",
    "ISurfaceGradient7",
    "ISurfaceGradient9",
    "ISurfaceGradium",
    "ISurfaceGridGradient",
    "ISurfaceGridPhase",
    "ISurfaceGridSag",
    "ISurfaceHologram1",
    "ISurfaceHologram2",
    "ISurfaceIrregular",
    "ISurfaceJonesMatrix",
    "ISurfaceNonSequential",
    "ISurfaceNthEvenOrderTerms",
    "ISurfaceNthOrderTerms",
    "ISurfaceNthThickness",
    "ISurfaceNthZernike",
    "ISurfaceOddAsphere",
    "ISurfaceOddCosine",
    "ISurfaceOffAxisConicFreeform",
    "ISurfaceOpticallyFabricatedHologram",
    "ISurfaceParaxial",
    "ISurfaceParaxialXY",
    "ISurfacePeriodic",
    "ISurfacePolynomial",
    "ISurfaceQTypeAsphere",
    "ISurfaceQTypeFreeform",
    "ISurfaceRadialGrating",
    "ISurfaceRadialNurbs",
    "ISurfaceRetroReflect",
    "ISurfaceScatteringABg",
    "ISurfaceScatteringABgFile",
    "ISurfaceScatteringBSDF",
    "ISurfaceScatteringCatalog",
    "ISurfaceScatteringGaussian",
    "ISurfaceScatteringLambertian",
    "ISurfaceScatteringNone",
    "ISurfaceScatteringType",
    "ISurfaceScatteringUser",
    "ISurfaceSlide",
    "ISurfaceStandard",
    "ISurfaceSuperconic",
    "ISurfaceTilted",
    "ISurfaceToroidal",
    "ISurfaceToroidalGrat",
    "ISurfaceToroidalHologram",
    "ISurfaceToroidalNurbs",
    "ISurfaceTrueFreeform",
    "ISurfaceTypeSettings",
    "ISurfaceVariableLineSpaceGrating",
    "ISurfaceXYPolynomial",
    "ISurfaceZernikeAnnularPhase",
    "ISurfaceZernikeFringePhase",
    "ISurfaceZernikeFringeSag",
    "ISurfaceZernikeStandardPhase",
    "ISurfaceZernikeStandardSag",
    "ISurfaceZonePlate",
    "NodesDataType",
    "PilotRadiusMode",
    "PointCloudFileFormat",
    "PupilApodizationType",
    "QTypes",
    "STARDeformationOption",
    "SubstrateType",
    "SurfaceApertureTypes",
    "SurfaceColumn",
    "SurfaceEdgeDraw",
    "SurfaceScatteringTypes",
    "SurfaceType",
    "TiltDecenterOrderType",
    "TiltDecenterPickupType",
    "TiltType",
    "XYSampling",
)

class CoatingStatusType:
    Fixed = 0
    Variable = 1
    Pickup = 2

class ConversionOrder:
    Forward = 0
    Reverse = 1

class CoordinateConversionResult:
    Success = 0
    Error_MultiConfig = -5
    Error_TiltDecenter = -4
    Error_IgnoredSurface = -3
    Error_CoordianteBreak = -2
    Error_InvalidRange = -1

class CoordinateReturnType:
    # None = 0
    OrientationOnly = 1
    OrientationXY = 2
    OrientationXYZ = 3

class ICoatingPerformanceData:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Reflection(self) -> ICoatingParameter: ...
    @property
    def Transmission(self) -> ICoatingParameter: ...
    @property
    def Absorption(self) -> ICoatingParameter: ...
    @property
    def Diattenuation(self) -> ICoatingParameter: ...
    @property
    def Phase(self) -> ICoatingParameter: ...
    @property
    def Retardation(self) -> ICoatingParameter: ...
    def GetCoatingPerformance(self, AOI: float, wavelen: float, direction: DirectionOfRayTravel) -> None: ...

class ILDEApertureData:
    @property
    def PickupFrom(self) -> int: ...
    @PickupFrom.setter
    def PickupFrom(self, value: int) -> None: ...
    @property
    def IsPickedUp(self) -> bool: ...
    @property
    def CurrentType(self) -> SurfaceApertureTypes: ...
    @property
    def CurrentTypeSettings(self) -> ISurfaceApertureType: ...
    @property
    def DisableClearSemiDiameterMarginsForThisSurface(self) -> bool: ...
    @DisableClearSemiDiameterMarginsForThisSurface.setter
    def DisableClearSemiDiameterMarginsForThisSurface(self, value: bool) -> None: ...
    def ChangeApertureTypeSettings(self, settings: ISurfaceApertureType) -> bool: ...
    def CreateApertureTypeSettings(self, type: SurfaceApertureTypes) -> ISurfaceApertureType: ...
    def SetPickupNone(self) -> None: ...

class ILDECoatingData:
    @property
    def Coating(self) -> str: ...
    @Coating.setter
    def Coating(self, value: str) -> None: ...
    @property
    def UseLayerMultiplierAndOffsets(self) -> bool: ...
    @UseLayerMultiplierAndOffsets.setter
    def UseLayerMultiplierAndOffsets(self, value: bool) -> None: ...
    @property
    def NumberOfLayers(self) -> int: ...
    def GetAvailableCoatings(self) -> list[str]: ...
    def GetLayerSettings(self, Layer: int) -> ILDECoatingSettings: ...
    def SetAllExtinctionFixed(self) -> None: ...
    def SetAllExtinctionVariable(self) -> None: ...
    def SetAllExtinctionZero(self) -> None: ...
    def SetAllIndexFixed(self) -> None: ...
    def SetAllIndexVariable(self) -> None: ...
    def SetAllIndexZero(self) -> None: ...
    def SetAllThicknessFixed(self) -> None: ...
    def SetAllThicknessOne(self) -> None: ...
    def SetAllThicknessVariable(self) -> None: ...
    def SetLayerSettings(self, Layer: int, settings: ILDECoatingSettings) -> bool: ...

class ILDECoatingSettings:
    @property
    def Layer(self) -> int: ...
    @property
    def ThicknessMultiplier(self) -> float: ...
    @ThicknessMultiplier.setter
    def ThicknessMultiplier(self, value: float) -> None: ...
    @property
    def ThicknessStatus(self) -> CoatingStatusType: ...
    @property
    def ThicknessPickupFrom(self) -> int: ...
    @property
    def IndexOffset(self) -> float: ...
    @IndexOffset.setter
    def IndexOffset(self, value: float) -> None: ...
    @property
    def IndexStatus(self) -> CoatingStatusType: ...
    @property
    def IndexPickupFrom(self) -> int: ...
    @property
    def ExtinctionOffset(self) -> float: ...
    @ExtinctionOffset.setter
    def ExtinctionOffset(self, value: float) -> None: ...
    @property
    def ExtinctionStatus(self) -> CoatingStatusType: ...
    @property
    def ExtinctionPickupFrom(self) -> int: ...
    def SetExtinctionStatusFixed(self) -> None: ...
    def SetExtinctionStatusPickup(self, fromLayer: int) -> bool: ...
    def SetExtinctionStatusVariable(self) -> None: ...
    def SetIndexStatusFixed(self) -> None: ...
    def SetIndexStatusPickup(self, fromLayer: int) -> bool: ...
    def SetIndexStatusVariable(self) -> None: ...
    def SetThicknessStatusFixed(self) -> None: ...
    def SetThicknessStatusPickup(self, fromLayer: int) -> bool: ...
    def SetThicknessStatusVariable(self) -> None: ...

class ILDECompositeData:
    @property
    def IsCompositeSurface(self) -> bool: ...
    @IsCompositeSurface.setter
    def IsCompositeSurface(self, value: bool) -> None: ...
    def SetOffAxisTiltAndDecenter(self) -> None: ...

class ILDEDrawData:
    @property
    def HideRaysToThisSurface(self) -> bool: ...
    @HideRaysToThisSurface.setter
    def HideRaysToThisSurface(self, value: bool) -> None: ...
    @property
    def SkipRaysToThisSurface(self) -> bool: ...
    @SkipRaysToThisSurface.setter
    def SkipRaysToThisSurface(self, value: bool) -> None: ...
    @property
    def DoNotDrawThisSurface(self) -> bool: ...
    @DoNotDrawThisSurface.setter
    def DoNotDrawThisSurface(self, value: bool) -> None: ...
    @property
    def DoNotDrawEdgesFromThisSurface(self) -> bool: ...
    @DoNotDrawEdgesFromThisSurface.setter
    def DoNotDrawEdgesFromThisSurface(self, value: bool) -> None: ...
    @property
    def DrawLocalAxis(self) -> bool: ...
    @DrawLocalAxis.setter
    def DrawLocalAxis(self, value: bool) -> None: ...
    @property
    def DrawEdgesAs(self) -> SurfaceEdgeDraw: ...
    @DrawEdgesAs.setter
    def DrawEdgesAs(self, value: SurfaceEdgeDraw) -> None: ...
    @property
    def HasMirrorSettings(self) -> bool: ...
    @property
    def MirrorSubstrate(self) -> SubstrateType: ...
    @MirrorSubstrate.setter
    def MirrorSubstrate(self, value: SubstrateType) -> None: ...
    @property
    def MirrorThickness(self) -> float: ...
    @MirrorThickness.setter
    def MirrorThickness(self, value: float) -> None: ...

class ILDEImportData:
    @property
    def DefaultImportDirectory(self) -> str: ...
    def CopyImportDataFrom(self, source: ILDEImportData) -> bool: ...
    def GetImportFiles(self, directory: str) -> list[str]: ...
    def ImportDataFile(self, dataFile: str) -> bool: ...

class ILDEPhysicalOpticsData:
    @property
    def UseRaysToPropagateToNextSurface(self) -> bool: ...
    @UseRaysToPropagateToNextSurface.setter
    def UseRaysToPropagateToNextSurface(self, value: bool) -> None: ...
    @property
    def DoNotRescaleBeamSizeUsingRayData(self) -> bool: ...
    @DoNotRescaleBeamSizeUsingRayData.setter
    def DoNotRescaleBeamSizeUsingRayData(self, value: bool) -> None: ...
    @property
    def UseAngularSpectrumPropagator(self) -> bool: ...
    @UseAngularSpectrumPropagator.setter
    def UseAngularSpectrumPropagator(self, value: bool) -> None: ...
    @property
    def DrawThisLensOnShadedModel(self) -> bool: ...
    @DrawThisLensOnShadedModel.setter
    def DrawThisLensOnShadedModel(self, value: bool) -> None: ...
    @property
    def ReComputePilotBeamParameters(self) -> bool: ...
    @ReComputePilotBeamParameters.setter
    def ReComputePilotBeamParameters(self, value: bool) -> None: ...
    @property
    def UseXaxisReference(self) -> bool: ...
    @UseXaxisReference.setter
    def UseXaxisReference(self, value: bool) -> None: ...
    @property
    def ResampleAfterRefraction(self) -> bool: ...
    @ResampleAfterRefraction.setter
    def ResampleAfterRefraction(self, value: bool) -> None: ...
    @property
    def AutoResample(self) -> bool: ...
    @AutoResample.setter
    def AutoResample(self, value: bool) -> None: ...
    @property
    def XSampling(self) -> XYSampling: ...
    @XSampling.setter
    def XSampling(self, value: XYSampling) -> None: ...
    @property
    def YSampling(self) -> XYSampling: ...
    @YSampling.setter
    def YSampling(self, value: XYSampling) -> None: ...
    @property
    def XWidth(self) -> float: ...
    @XWidth.setter
    def XWidth(self, value: float) -> None: ...
    @property
    def YWidth(self) -> float: ...
    @YWidth.setter
    def YWidth(self, value: float) -> None: ...
    @property
    def OutputPilotRadius(self) -> PilotRadiusMode: ...
    @OutputPilotRadius.setter
    def OutputPilotRadius(self, value: PilotRadiusMode) -> None: ...
    @property
    def XRadius(self) -> float: ...
    @XRadius.setter
    def XRadius(self, value: float) -> None: ...
    @property
    def YRadius(self) -> float: ...
    @YRadius.setter
    def YRadius(self, value: float) -> None: ...

class ILDERow(IEditorRow):
    @property
    def IsActive(self) -> bool: ...
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def TypeName(self) -> str: ...
    @property
    def Type(self) -> SurfaceType: ...
    @property
    def CurrentTypeSettings(self) -> ISurfaceTypeSettings: ...
    @property
    def IsObject(self) -> bool: ...
    @property
    def IsImage(self) -> bool: ...
    @property
    def IsStop(self) -> bool: ...
    @IsStop.setter
    def IsStop(self, value: bool) -> None: ...
    @property
    def SurfaceData(self) -> ISurface: ...
    @property
    def TypeData(self) -> ILDETypeData: ...
    @property
    def DrawData(self) -> ILDEDrawData: ...
    @property
    def ApertureData(self) -> ILDEApertureData: ...
    @property
    def ScatteringData(self) -> ILDEScatteringData: ...
    @property
    def TiltDecenterData(self) -> ILDETiltDecenterData: ...
    @property
    def PhysicalOpticsData(self) -> ILDEPhysicalOpticsData: ...
    @property
    def CoatingData(self) -> ILDECoatingData: ...
    @property
    def ImportData(self) -> ILDEImportData: ...
    @property
    def CompositeData(self) -> ILDECompositeData: ...
    @property
    def Comment(self) -> str: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @property
    def CommentCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Material(self) -> str: ...
    @Material.setter
    def Material(self, value: str) -> None: ...
    @property
    def MaterialCell(self) -> IEditorCell: ...
    @property
    def Coating(self) -> str: ...
    @Coating.setter
    def Coating(self, value: str) -> None: ...
    @property
    def CoatingCell(self) -> IEditorCell: ...
    @property
    def SemiDiameter(self) -> float: ...
    @SemiDiameter.setter
    def SemiDiameter(self, value: float) -> None: ...
    @property
    def SemiDiameterCell(self) -> IEditorCell: ...
    @property
    def ChipZone(self) -> float: ...
    @ChipZone.setter
    def ChipZone(self, value: float) -> None: ...
    @property
    def ChipZoneCell(self) -> IEditorCell: ...
    @property
    def MechanicalSemiDiameter(self) -> float: ...
    @MechanicalSemiDiameter.setter
    def MechanicalSemiDiameter(self, value: float) -> None: ...
    @property
    def MechanicalSemiDiameterCell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def TCE(self) -> float: ...
    @TCE.setter
    def TCE(self, value: float) -> None: ...
    @property
    def TCECell(self) -> IEditorCell: ...
    @property
    def SurfaceId(self) -> int: ...
    @property
    def STARData(self) -> ISTAR_Data: ...
    @property
    def MaterialCatalog(self) -> str: ...
    def AvailableSurfaceTypes(self) -> list[SurfaceType]: ...
    def ChangeType(self, settings: ISurfaceTypeSettings) -> bool: ...
    def GetCoatingPerformanceData(self) -> ICoatingPerformanceData: ...
    def GetMetadata(self) -> IMetadata: ...
    def GetSurfaceCell(self, Col: SurfaceColumn) -> IEditorCell: ...
    def GetSurfaceTypeSettings(self, type: SurfaceType) -> ISurfaceTypeSettings: ...

class ILDEScatteringData:
    @property
    def CurrentType(self) -> SurfaceScatteringTypes: ...
    @property
    def CurrentTypeSettings(self) -> ISurfaceScatteringType: ...
    def ChangeScatteringTypeSettings(self, settings: ISurfaceScatteringType) -> bool: ...
    def CreateScatteringTypeSettings(self, type: SurfaceScatteringTypes) -> ISurfaceScatteringType: ...

class ILDETiltDecenterData:
    @property
    def BeforeSurfaceOrder(self) -> TiltDecenterOrderType: ...
    @BeforeSurfaceOrder.setter
    def BeforeSurfaceOrder(self, value: TiltDecenterOrderType) -> None: ...
    @property
    def BeforeSurfaceDecenterX(self) -> float: ...
    @BeforeSurfaceDecenterX.setter
    def BeforeSurfaceDecenterX(self, value: float) -> None: ...
    @property
    def BeforeSurfaceDecenterY(self) -> float: ...
    @BeforeSurfaceDecenterY.setter
    def BeforeSurfaceDecenterY(self, value: float) -> None: ...
    @property
    def BeforeSurfaceTiltX(self) -> float: ...
    @BeforeSurfaceTiltX.setter
    def BeforeSurfaceTiltX(self, value: float) -> None: ...
    @property
    def BeforeSurfaceTiltY(self) -> float: ...
    @BeforeSurfaceTiltY.setter
    def BeforeSurfaceTiltY(self, value: float) -> None: ...
    @property
    def BeforeSurfaceTiltZ(self) -> float: ...
    @BeforeSurfaceTiltZ.setter
    def BeforeSurfaceTiltZ(self, value: float) -> None: ...
    @property
    def AfterSurfaceMode(self) -> TiltDecenterPickupType: ...
    @property
    def AfterSurfaceModeSurface(self) -> int: ...
    @property
    def AfterSurfaceModeSurfaceIsThis(self) -> bool: ...
    @property
    def AfterSurfaceOrder(self) -> TiltDecenterOrderType: ...
    @AfterSurfaceOrder.setter
    def AfterSurfaceOrder(self, value: TiltDecenterOrderType) -> None: ...
    @property
    def AfterSurfaceDecenterX(self) -> float: ...
    @AfterSurfaceDecenterX.setter
    def AfterSurfaceDecenterX(self, value: float) -> None: ...
    @property
    def AfterSurfaceDecenterY(self) -> float: ...
    @AfterSurfaceDecenterY.setter
    def AfterSurfaceDecenterY(self, value: float) -> None: ...
    @property
    def AfterSurfaceTiltX(self) -> float: ...
    @AfterSurfaceTiltX.setter
    def AfterSurfaceTiltX(self, value: float) -> None: ...
    @property
    def AfterSurfaceTiltY(self) -> float: ...
    @AfterSurfaceTiltY.setter
    def AfterSurfaceTiltY(self, value: float) -> None: ...
    @property
    def AfterSurfaceTiltZ(self) -> float: ...
    @AfterSurfaceTiltZ.setter
    def AfterSurfaceTiltZ(self, value: float) -> None: ...
    @property
    def BeforeAfterSurfaceEnabled(self) -> bool: ...
    @property
    def CoordinateReturnEnabled(self) -> bool: ...
    @property
    def CoordinateReturn(self) -> CoordinateReturnType: ...
    @CoordinateReturn.setter
    def CoordinateReturn(self, value: CoordinateReturnType) -> None: ...
    @property
    def CoordinateReturnToSurface(self) -> int: ...
    @CoordinateReturnToSurface.setter
    def CoordinateReturnToSurface(self, value: int) -> None: ...
    def SetAfterSurfaceModeExplicit(self) -> None: ...
    def SetAfterSurfaceModePickup(self, fromSurface: int) -> bool: ...
    def SetAfterSurfaceModePickupThis(self) -> bool: ...
    def SetAfterSurfaceModeReverse(self, fromSurface: int) -> bool: ...
    def SetAfterSurfaceModeReverseThis(self) -> bool: ...

class ILDETool_AddCoatingsToAllSurfaces:
    @property
    def AvailableCoatings(self) -> list[str]: ...
    @property
    def CoatingToAdd(self) -> str: ...
    @CoatingToAdd.setter
    def CoatingToAdd(self, value: str) -> None: ...

class ILDETool_TiltDecenterElements:
    @property
    def FirstSurface(self) -> int: ...
    @FirstSurface.setter
    def FirstSurface(self, value: int) -> None: ...
    @property
    def LastSurface(self) -> int: ...
    @LastSurface.setter
    def LastSurface(self, value: int) -> None: ...
    @property
    def DecenterX(self) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @property
    def DecenterY(self) -> float: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @property
    def Order(self) -> TiltDecenterOrderType: ...
    @Order.setter
    def Order(self, value: TiltDecenterOrderType) -> None: ...
    @property
    def TiltX(self) -> float: ...
    @TiltX.setter
    def TiltX(self, value: float) -> None: ...
    @property
    def TiltY(self) -> float: ...
    @TiltY.setter
    def TiltY(self, value: float) -> None: ...
    @property
    def TiltZ(self) -> float: ...
    @TiltZ.setter
    def TiltZ(self, value: float) -> None: ...
    @property
    def PivotX(self) -> float: ...
    @PivotX.setter
    def PivotX(self, value: float) -> None: ...
    @property
    def PivotY(self) -> float: ...
    @PivotY.setter
    def PivotY(self, value: float) -> None: ...
    @property
    def PivotZ(self) -> float: ...
    @PivotZ.setter
    def PivotZ(self, value: float) -> None: ...
    @property
    def GlobalCoordinates(self) -> bool: ...
    @GlobalCoordinates.setter
    def GlobalCoordinates(self, value: bool) -> None: ...
    @property
    def PivotColor(self) -> ZemaxColor: ...
    @PivotColor.setter
    def PivotColor(self, value: ZemaxColor) -> None: ...
    @property
    def PivotComment(self) -> str: ...
    @PivotComment.setter
    def PivotComment(self, value: str) -> None: ...
    @property
    def CoordinateBreakColor(self) -> ZemaxColor: ...
    @CoordinateBreakColor.setter
    def CoordinateBreakColor(self, value: ZemaxColor) -> None: ...
    @property
    def CoordinateBreakComment(self) -> str: ...
    @CoordinateBreakComment.setter
    def CoordinateBreakComment(self, value: str) -> None: ...
    @property
    def HideTrailingDummySurface(self) -> bool: ...
    @HideTrailingDummySurface.setter
    def HideTrailingDummySurface(self, value: bool) -> None: ...

class ILDETypeData:
    @property
    def SurfaceColor(self) -> ZemaxColor: ...
    @SurfaceColor.setter
    def SurfaceColor(self, value: ZemaxColor) -> None: ...
    @property
    def SurfaceOpacity(self) -> ZemaxOpacity: ...
    @SurfaceOpacity.setter
    def SurfaceOpacity(self, value: ZemaxOpacity) -> None: ...
    @property
    def RowColor(self) -> ZemaxColor: ...
    @RowColor.setter
    def RowColor(self, value: ZemaxColor) -> None: ...
    @property
    def IsStop(self) -> bool: ...
    @IsStop.setter
    def IsStop(self, value: bool) -> None: ...
    @property
    def CanBeStop(self) -> bool: ...
    @property
    def IsGlobalCoordinateReference(self) -> bool: ...
    @IsGlobalCoordinateReference.setter
    def IsGlobalCoordinateReference(self, value: bool) -> None: ...
    @property
    def CanBeGCR(self) -> bool: ...
    @property
    def IgnoreSurface(self) -> bool: ...
    @IgnoreSurface.setter
    def IgnoreSurface(self, value: bool) -> None: ...
    @property
    def SurfaceCannotBeHyperhemispheric(self) -> bool: ...
    @SurfaceCannotBeHyperhemispheric.setter
    def SurfaceCannotBeHyperhemispheric(self, value: bool) -> None: ...

class ILensDataEditor(IEditor):
    @property
    def RowToSurfaceOffset(self) -> int: ...
    @property
    def NumberOfSurfaces(self) -> int: ...
    @property
    def NumberOfNonSequentialSurfaces(self) -> int: ...
    @property
    def FirstColumn(self) -> SurfaceColumn: ...
    @property
    def LastColumn(self) -> SurfaceColumn: ...
    @property
    def StopSurface(self) -> int: ...
    def AddSurface(self) -> ILDERow: ...
    def CanConvertSurfaceToFreeform(self, fromSurface: int) -> bool: ...
    def CanExportPointCloud(self, Surface: int) -> bool: ...
    def CopySurfaces(self, fromSurfaceNumber: int, NumberOfSurfaces: int, toSurfaceNumber: int) -> int: ...
    def CopySurfacesFrom(
        self, fromEditor: ILensDataEditor, fromSurfaceNumber: int, NumberOfSurfaces: int, toSurfaceNumber: int
    ) -> int: ...
    def FindLabel(self, label: int) -> tuple[bool, int]: ...
    def GetApodization(self, px: float, py: float) -> float: ...
    def GetClosestGlass(self, Surface: int) -> str: ...
    def GetFirstOrderData(self) -> tuple[float, float, float, float, float]: ...
    def GetGlass(self, Surface: int) -> tuple[bool, str, float, float, float]: ...
    def GetGlobalMatrix(
        self, Surface: int
    ) -> tuple[bool, float, float, float, float, float, float, float, float, float, float, float, float]: ...
    def GetId(self, surface: int) -> int: ...
    def GetIndex(self, Surface: int, NumberOfWavelengths: int) -> tuple[int, list[float]]: ...
    def GetLabel(self, Surface: int) -> tuple[bool, int]: ...
    def GetPupil(self) -> tuple[ZemaxApertureType, float, float, float, float, float, PupilApodizationType, float]: ...
    def GetSag(self, Surface: int, X: float, Y: float) -> tuple[bool, float, float]: ...
    def GetSurfaceAt(self, SurfaceNumber: int) -> ILDERow: ...
    def GetTool_AddCoatingsToAllSurfaces(self) -> ILDETool_AddCoatingsToAllSurfaces: ...
    def GetTool_TiltDecenterElements(self) -> ILDETool_TiltDecenterElements: ...
    def HideLDE(self) -> None: ...
    def InsertNewSurfaceAt(self, SurfaceNumber: int) -> ILDERow: ...
    def RemoveSurfaceAt(self, SurfaceNumber: int) -> bool: ...
    def RemoveSurfacesAt(self, SurfaceNumber: int, numSurfaces: int) -> int: ...
    def RunTool_AddCoatingsToAllSurfaces(self, settings: ILDETool_AddCoatingsToAllSurfaces) -> None: ...
    def RunTool_AddFoldMirror(self, Surface: int, tilt: TiltType, reflectAngle: float) -> IMessage: ...
    def RunTool_ConvertGlobalToLocalCoordinates(
        self, FirstSurface: int, LastSurface: int, order: ConversionOrder
    ) -> CoordinateConversionResult: ...
    def RunTool_ConvertLocalToGlobalCoordinates(
        self, FirstSurface: int, LastSurface: int, referenceSurface: int
    ) -> CoordinateConversionResult: ...
    def RunTool_ConvertSemiDiametersToCircularApertures(self) -> None: ...
    def RunTool_ConvertSemiDiametersToFloatingApertures(self) -> None: ...
    def RunTool_ConvertSemiDiametersToMaximumApertures(self) -> None: ...
    def RunTool_ConvertSurfaceInPlaceToFreeform(
        self, fromSurface: int, gridNx: int, gridNy: int, limitToClearAperture: bool
    ) -> IMessage: ...
    def RunTool_ConvertSurfaceToFreeform(
        self, fromSurface: int, freeformSurface: int, gridNx: int, gridNy: int, limitToClearAperture: bool
    ) -> IMessage: ...
    def RunTool_DeleteFoldMirror(self, foldSurface: int) -> IMessage: ...
    def RunTool_ExportPointCloudFile(
        self,
        Surface: int,
        filename: str,
        gridNx: int,
        gridNy: int,
        includeSurfaceNormals: bool,
        format: PointCloudFileFormat,
    ) -> IMessage: ...
    def RunTool_MakeDoublePass(self, reflectAtSurface: int) -> IMessage: ...
    def RunTool_MakeFocal(self, focalLength: float) -> IMessage: ...
    def RunTool_RemoveAllApertures(self) -> None: ...
    def RunTool_ReplaceVignettingWithApertures(self) -> None: ...
    def RunTool_ReverseElements(self, firstSurface: int, lastSurface: int) -> IMessage: ...
    def RunTool_TiltDecenterElements(self, settings: ILDETool_TiltDecenterElements) -> IMessage: ...
    def SetLabel(self, Surface: int, label: int) -> bool: ...
    def ShowLDE(self) -> bool: ...

class IndexDataType:
    # None = 0
    PhysicsBasedIndex = 1
    DirectRefractiveIndex = 2
    Unknown = -1

class InterpolationMethod:
    BicubicSpline = 0
    Linear = 1

class ISTAR_ComponentRBMs:
    @property
    def ListOfSurfacesInComponent(self) -> list[int]: ...
    @property
    def FirstSurfaceInComponent(self) -> int: ...
    @property
    def LastSurfaceInComponent(self) -> int: ...
    @property
    def NumberOfSurfacesInComponent(self) -> int: ...
    @property
    def Transform(self) -> ICoordinateTransform: ...
    @property
    def AdjustIndexDataWithComponentRBM(self) -> bool: ...
    @AdjustIndexDataWithComponentRBM.setter
    def AdjustIndexDataWithComponentRBM(self, value: bool) -> None: ...
    @property
    def ComponentRBMsAreRemoved(self) -> bool: ...
    @property
    def CRBMsAreInCoordinateBreaks(self) -> bool: ...
    def AddComponentRBMsAsCoordinateBreaks(self) -> None: ...
    def IsPartOfAComponent(self) -> bool: ...
    def RemoveComponent(self, firstSurface: int) -> None: ...
    def RemoveComponentRBMsFromFEADataSets(self) -> None: ...
    def SetSurfacesInComponent(self, firstSurface: int, lastSurface: int) -> None: ...

class ISTAR_CoordinateTransform:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def IsEnabled(self) -> bool: ...
    @property
    def Transform(self) -> ICoordinateTransform: ...
    @property
    def Decenters(self) -> ISTAR_Decenters: ...
    @property
    def Rotations(self) -> ISTAR_Rotations: ...
    def ConvertAnglesToRotationMatrix(self, thetaX: float, thetaY: float, thetaZ: float) -> list[list[float]]: ...
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def IsInDefaultFrameOfReference(self) -> bool: ...
    def ResetToDefaultFrameOfReference(self) -> None: ...
    def SetDecenter(self, DX: float, DY: float, DZ: float) -> None: ...
    def SetRotationMatrix(
        self, R11: float, R12: float, R13: float, R21: float, R22: float, R23: float, R31: float, R32: float, R33: float
    ) -> None: ...
    def SetTransformValues(
        self,
        R11: float,
        R12: float,
        R13: float,
        R21: float,
        R22: float,
        R23: float,
        R31: float,
        R32: float,
        R33: float,
        DX: float,
        DY: float,
        DZ: float,
    ) -> None: ...
    def SetTransformValuesWithAngles(
        self, ThetaX: float, ThetaY: float, ThetaZ: float, DX: float, DY: float, DZ: float
    ) -> None: ...

class ISTAR_Data:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Deformations(self) -> ISTAR_Deformations: ...
    @property
    def Temperatures(self) -> ISTAR_Temperatures: ...
    @property
    def DirectIndex(self) -> ISTAR_DirectIndex: ...
    @property
    def IndexDataType(self) -> IndexDataType: ...
    @property
    def ComponentRBMs(self) -> ISTAR_ComponentRBMs: ...

class ISTAR_Decenters:
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    def GetVector(self) -> list[float]: ...

class ISTAR_Deformation:
    @property
    def DX(self) -> float: ...
    @DX.setter
    def DX(self, value: float) -> None: ...
    @property
    def DY(self) -> float: ...
    @DY.setter
    def DY(self, value: float) -> None: ...
    @property
    def DZ(self) -> float: ...
    @DZ.setter
    def DZ(self, value: float) -> None: ...

class ISTAR_DeformationFits:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def IsSurfaceDeformationEnabled(self) -> bool: ...
    @property
    def Settings(self) -> ISTAR_FEAFitSettings: ...
    @property
    def FitResultsDX(self) -> ISTAR_FEAFitResults: ...
    @property
    def FitResultsDY(self) -> ISTAR_FEAFitResults: ...
    @property
    def FitResultsDZ(self) -> ISTAR_FEAFitResults: ...
    @property
    def FitResultsAverage(self) -> ISTAR_FEAFitResults: ...
    @property
    def Options(self) -> STARDeformationOption: ...
    @Options.setter
    def Options(self, value: STARDeformationOption) -> None: ...
    def GetFittedDeformation_1(
        self, X: float, Y: float, option: STARDeformationOption
    ) -> ISTAR_PointWithDeformation: ...
    def ListFittedDeformationSafe_1(
        self, xCoor: list[float], yCoor: list[float], option: STARDeformationOption
    ) -> list[ISTAR_PointWithDeformation]: ...
    def MeshFittedDeformationSafe_1(
        self,
        num_X_pts: int,
        num_Y_pts: int,
        X1_edge: float,
        Y1_edge: float,
        X2_edge: float,
        Y2_edge: float,
        option: STARDeformationOption,
    ) -> list[ISTAR_PointWithDeformation]: ...
    def Refit(self) -> None: ...

class ISTAR_Deformations:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def FEAData(self) -> ISTAR_DeformationsFEAData: ...
    @property
    def RBMs(self) -> ISTAR_RBMs: ...
    @property
    def CoordinateTransform(self) -> ISTAR_CoordinateTransform: ...
    @property
    def Fits(self) -> ISTAR_DeformationFits: ...
    def IsDataLocalCS(self) -> bool: ...
    def SetDataIsGlobal(self) -> None: ...
    def SetDataIsLocal(self) -> None: ...

class ISTAR_DeformationsFEAData:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def AreDeformationsImported(self) -> bool: ...
    @property
    def NumberOfDataPoints(self) -> int: ...
    @property
    def Filename(self) -> str: ...
    def GetFEAPointsSafe(self) -> list[ISTAR_PointWithDeformation]: ...
    def GetFEAPointsSafeOld(self) -> list[ISTAR_PointWithDeformation]: ...
    def GetFEAPointsWithAutoWeightsSafe(self, weightVariation: int) -> list[ISTAR_PointWithDeformationAndWeight]: ...
    def GetTransformedFEAPointsNoImportRequired(
        self, filename: str, adaptCase: int, adapterR: list[list[float]], adapterO: list[float], coordinateOption: int
    ) -> list[ISTAR_PointWithDeformation]: ...
    def GetTransformedFEAPointsSafe(self, coordinateOption: int) -> list[ISTAR_PointWithDeformation]: ...
    def GetTransformValues(self, transformType: int) -> ICoordinateTransform: ...
    def ImportDeformations(self, filename: str) -> None: ...
    def UnloadData(self) -> None: ...

class ISTAR_DirectIndex:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def FEAData(self) -> ISTAR_DirectIndexFEAData: ...
    @property
    def CoordinateTransform(self) -> ISTAR_CoordinateTransform: ...
    @property
    def Fits(self) -> ISTAR_DirectIndexFits: ...
    @property
    def GRINStep(self) -> float: ...
    @GRINStep.setter
    def GRINStep(self, value: float) -> None: ...
    def IsDataLocalCS(self) -> bool: ...
    def SetDataIsGlobal(self) -> None: ...
    def SetDataIsLocal(self) -> None: ...

class ISTAR_DirectIndexFEAData:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def IsDirectIndexImported(self) -> bool: ...
    @property
    def NumberOfDataPoints(self) -> int: ...
    @property
    def Filename(self) -> str: ...
    def GetFEAPointsSafe(self) -> list[ISTAR_PointWithIndex]: ...
    def GetTransformedFEAPointsNoImportRequired(
        self, filename: str, adaptCase: int, adapterR: list[list[float]], adapterO: list[float], coordinateOption: int
    ) -> list[ISTAR_PointWithIndex]: ...
    def GetTransformedFEAPointsSafe(self, coordinateOption: int) -> list[ISTAR_PointWithIndex]: ...
    def GetTransformValues(self, transformType: int) -> ICoordinateTransform: ...
    def ImportDirectIndex(self, filename: str) -> None: ...
    def IsDirectIndexApplied(self) -> bool: ...
    def UnloadData(self) -> None: ...

class ISTAR_DirectIndexFits:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Settings(self) -> ISTAR_FEAFitSettings: ...
    @property
    def FitResultsIndex(self) -> ISTAR_FEAFitResults: ...
    @property
    def GRINStep(self) -> float: ...
    @GRINStep.setter
    def GRINStep(self, value: float) -> None: ...
    def ApplyIndex(self) -> None: ...
    def GetFittedIndex(self, X: float, Y: float, Z: float) -> float: ...
    def ListFittedIndexSafe(
        self, xCoor: list[float], yCoor: list[float], zCoor: list[float]
    ) -> list[ISTAR_PointWithIndex]: ...
    def MeshFittedIndexSafe(
        self,
        num_X_pts: int,
        num_Y_pts: int,
        num_Z_pts: int,
        X1_edge: float,
        Y1_edge: float,
        Z1_edge: float,
        X2_edge: float,
        Y2_edge: float,
        Z2_edge: float,
    ) -> list[ISTAR_PointWithIndex]: ...
    def Refit(self) -> None: ...
    def RemoveIndex(self) -> None: ...

class ISTAR_FEAFitResults:
    @property
    def Points(self) -> float: ...
    @property
    def FitLevels(self) -> float: ...
    @property
    def FitAccuracy(self) -> float: ...
    @property
    def FitFill(self) -> float: ...
    @property
    def FitNorm(self) -> float: ...
    @property
    def FitAverage(self) -> float: ...
    @property
    def FitRMS(self) -> float: ...
    @property
    def FitPV(self) -> float: ...

class ISTAR_FEAFitSettings:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Type(self) -> int: ...
    @property
    def Grid1(self) -> int: ...
    @Grid1.setter
    def Grid1(self, value: int) -> None: ...
    @property
    def Grid2(self) -> int: ...
    @Grid2.setter
    def Grid2(self, value: int) -> None: ...
    @property
    def Grid3(self) -> int: ...
    @Grid3.setter
    def Grid3(self, value: int) -> None: ...
    @property
    def MBAMaxLevel(self) -> int: ...
    @MBAMaxLevel.setter
    def MBAMaxLevel(self, value: int) -> None: ...
    @property
    def MBATol(self) -> float: ...
    @MBATol.setter
    def MBATol(self, value: float) -> None: ...
    @property
    def MBAMinFill(self) -> float: ...
    @MBAMinFill.setter
    def MBAMinFill(self, value: float) -> None: ...
    def SetAllValues(
        self, grid1: int, grid2: int, grid3: int, mbaMaxLevel: int, mbaTol: float, mbaMinFill: float
    ) -> None: ...

class ISTAR_PointWithDeformation:
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Z(self) -> float: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    @property
    def DX(self) -> float: ...
    @DX.setter
    def DX(self, value: float) -> None: ...
    @property
    def DY(self) -> float: ...
    @DY.setter
    def DY(self, value: float) -> None: ...
    @property
    def DZ(self) -> float: ...
    @DZ.setter
    def DZ(self, value: float) -> None: ...

class ISTAR_PointWithDeformationAndWeight:
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Z(self) -> float: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    @property
    def DX(self) -> float: ...
    @DX.setter
    def DX(self, value: float) -> None: ...
    @property
    def DY(self) -> float: ...
    @DY.setter
    def DY(self, value: float) -> None: ...
    @property
    def DZ(self) -> float: ...
    @DZ.setter
    def DZ(self, value: float) -> None: ...
    @property
    def Weight(self) -> float: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...

class ISTAR_PointWithIndex:
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Z(self) -> float: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    @property
    def Index(self) -> float: ...
    @Index.setter
    def Index(self, value: float) -> None: ...

class ISTAR_PointWithTemperatureAndIndex:
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Z(self) -> float: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    @property
    def T(self) -> float: ...
    @T.setter
    def T(self, value: float) -> None: ...
    @property
    def Index(self) -> float: ...
    @Index.setter
    def Index(self, value: float) -> None: ...

class ISTAR_RBM_Centroid:
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class ISTAR_RBM_ReferencePoint:
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class ISTAR_RBMs:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def IsEnabled(self) -> bool: ...
    @property
    def Transform(self) -> ICoordinateTransform: ...
    @property
    def Decenters(self) -> ISTAR_Decenters: ...
    @property
    def Rotations(self) -> ISTAR_Rotations: ...
    @property
    def Centroid(self) -> ISTAR_RBM_Centroid: ...
    @property
    def UsedWeights(self) -> bool: ...
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def GetReferencePoint(self) -> ISTAR_RBM_ReferencePoint: ...
    def GetTransformValues(self) -> None: ...
    def SetReferencePoint(self, refX: float, refY: float, refZ: float) -> None: ...

class ISTAR_RotationAngles:
    @property
    def Alpha(self) -> float: ...
    @property
    def Beta(self) -> float: ...
    @property
    def Gamma(self) -> float: ...
    @property
    def ThetaX(self) -> float: ...
    @property
    def ThetaY(self) -> float: ...
    @property
    def ThetaZ(self) -> float: ...

class ISTAR_Rotations:
    @property
    def Values(self) -> ISTAR_RotationValues: ...
    @property
    def Angles(self) -> ISTAR_RotationAngles: ...

class ISTAR_RotationValues:
    @property
    def R11(self) -> float: ...
    @property
    def R12(self) -> float: ...
    @property
    def R13(self) -> float: ...
    @property
    def R21(self) -> float: ...
    @property
    def R22(self) -> float: ...
    @property
    def R23(self) -> float: ...
    @property
    def R31(self) -> float: ...
    @property
    def R32(self) -> float: ...
    @property
    def R33(self) -> float: ...

class ISTAR_Temperatures:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def PrimaryWavelengthValue(self) -> float: ...
    @property
    def FEAData(self) -> ISTAR_TemperaturesFEAData: ...
    @property
    def CoordinateTransform(self) -> ISTAR_CoordinateTransform: ...
    @property
    def Fits(self) -> ISTAR_TemperaturesFits: ...
    @property
    def GRINStep(self) -> float: ...
    @GRINStep.setter
    def GRINStep(self, value: float) -> None: ...
    def GetThermalFEAFitType(self) -> int: ...
    def GetWorkingWavelength(self) -> int: ...
    def IsDataLocalCS(self) -> bool: ...
    def SetDataIsGlobal(self) -> None: ...
    def SetDataIsLocal(self) -> None: ...
    def SetThermalFEAFitType(self, FitType: int) -> None: ...
    def SetWorkingWavelength(self, wavelength_number: int) -> None: ...

class ISTAR_TemperaturesFEAData:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def AreTemperaturesImported(self) -> bool: ...
    @property
    def NumberOfDataPoints(self) -> int: ...
    @property
    def Filename(self) -> str: ...
    def AreTemperaturesApplied(self) -> bool: ...
    def GetFEAPointsSafe(self) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetFEAPointsSafeOld(self) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetTransformedFEAPointsNoImportRequired(
        self, filename: str, adaptCase: int, adapterR: list[list[float]], adapterO: list[float], coordinateOption: int
    ) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetTransformedFEAPointsSafe(self, coordinateOption: int) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetTransformValues(self, transformType: int) -> ICoordinateTransform: ...
    def ImportTemperatures(self, filename: str) -> None: ...
    def UnloadData(self) -> None: ...

class ISTAR_TemperaturesFits:
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def IsTemperatureProfileEnabled(self) -> bool: ...
    @property
    def Settings(self) -> ISTAR_FEAFitSettings: ...
    @property
    def FitResultsIndex(self) -> ISTAR_FEAFitResults: ...
    @property
    def GRINStep(self) -> float: ...
    @GRINStep.setter
    def GRINStep(self, value: float) -> None: ...
    def ApplyTemperatures(self) -> None: ...
    def GetFittedIndex(self, X: float, Y: float, Z: float) -> float: ...
    def GetFittedTemperature(self, X: float, Y: float, Z: float) -> float: ...
    def ListFittedIndexSafe(
        self, xCoor: list[float], yCoor: list[float], zCoor: list[float]
    ) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def MeshFittedIndexSafe(
        self,
        num_X_pts: int,
        num_Y_pts: int,
        num_Z_pts: int,
        X1_edge: float,
        Y1_edge: float,
        Z1_edge: float,
        X2_edge: float,
        Y2_edge: float,
        Z2_edge: float,
    ) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def Refit(self) -> None: ...
    def RemoveTemperatures(self) -> None: ...

class ISurface:
    @property
    def Type(self) -> SurfaceType: ...
    @property
    def Row(self) -> ILDERow: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Id(self) -> int: ...

class ISurfaceABCD(ISurface):
    @property
    def AxCell(self) -> IEditorCell: ...
    @property
    def BxCell(self) -> IEditorCell: ...
    @property
    def CxCell(self) -> IEditorCell: ...
    @property
    def DxCell(self) -> IEditorCell: ...
    @property
    def AyCell(self) -> IEditorCell: ...
    @property
    def ByCell(self) -> IEditorCell: ...
    @property
    def CyCell(self) -> IEditorCell: ...
    @property
    def DyCell(self) -> IEditorCell: ...
    @property
    def Ax(self) -> float: ...
    @Ax.setter
    def Ax(self, value: float) -> None: ...
    @property
    def Bx(self) -> float: ...
    @Bx.setter
    def Bx(self, value: float) -> None: ...
    @property
    def Cx(self) -> float: ...
    @Cx.setter
    def Cx(self, value: float) -> None: ...
    @property
    def Dx(self) -> float: ...
    @Dx.setter
    def Dx(self, value: float) -> None: ...
    @property
    def Ay(self) -> float: ...
    @Ay.setter
    def Ay(self, value: float) -> None: ...
    @property
    def By(self) -> float: ...
    @By.setter
    def By(self, value: float) -> None: ...
    @property
    def Cy(self) -> float: ...
    @Cy.setter
    def Cy(self, value: float) -> None: ...
    @property
    def Dy(self) -> float: ...
    @Dy.setter
    def Dy(self, value: float) -> None: ...

class ISurfaceAlternateEven(ISurfaceNthEvenOrderTerms, ISurface):
    pass

class ISurfaceAlternateOdd(ISurfaceNthOrderTerms, ISurface):
    pass

class ISurfaceAnnularZernikeSag(ISurfaceNthEvenOrderTerms, ISurface):
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def ObscurationCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @property
    def Obscuration(self) -> float: ...
    @Obscuration.setter
    def Obscuration(self, value: float) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetZernikeTerm(self, termN: int) -> float: ...
    def GetZernikeTermCell(self, termN: int) -> IEditorCell: ...
    def SetZernikeTerm(self, termN: int, Value: float) -> None: ...

class ISurfaceAPBC(ISurface):
    def AnCell(self, n: int) -> IEditorCell: ...
    def BnCell(self, n: int) -> IEditorCell: ...
    def CnCell(self, n: int) -> IEditorCell: ...
    def GetAn(self, n: int) -> float: ...
    def GetBn(self, n: int) -> float: ...
    def GetCn(self, n: int) -> float: ...
    def GetPn(self, n: int) -> float: ...
    def PnCell(self, n: int) -> IEditorCell: ...
    def SetAn(self, n: int, Value: float) -> None: ...
    def SetBn(self, n: int, Value: float) -> None: ...
    def SetCn(self, n: int, Value: float) -> None: ...
    def SetPn(self, n: int, Value: float) -> None: ...

class ISurfaceApertureCircular(ISurfaceApertureType):
    @property
    def MinimumRadius(self) -> float: ...
    @MinimumRadius.setter
    def MinimumRadius(self, value: float) -> None: ...
    @property
    def MaximumRadius(self) -> float: ...
    @MaximumRadius.setter
    def MaximumRadius(self, value: float) -> None: ...
    @property
    def ApertureXDecenter(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...

class ISurfaceApertureElliptical(ISurfaceApertureType):
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def ApertureXDecenter(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...

class ISurfaceApertureFloating(ISurfaceApertureType):
    pass

class ISurfaceApertureNone(ISurfaceApertureType):
    pass

class ISurfaceApertureRectangular(ISurfaceApertureType):
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def ApertureXDecenter(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...

class ISurfaceApertureSpider(ISurfaceApertureType):
    @property
    def WidthOfArms(self) -> float: ...
    @WidthOfArms.setter
    def WidthOfArms(self, value: float) -> None: ...
    @property
    def NumberOfArms(self) -> int: ...
    @NumberOfArms.setter
    def NumberOfArms(self, value: int) -> None: ...
    @property
    def ApertureXDecenter(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...

class ISurfaceApertureType:
    @property
    def Type(self) -> SurfaceApertureTypes: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def _S_None(self) -> ISurfaceApertureNone: ...
    @property
    def _S_CircularAperture(self) -> ISurfaceApertureCircular: ...
    @property
    def _S_CircularObscuration(self) -> ISurfaceApertureCircular: ...
    @property
    def _S_Spider(self) -> ISurfaceApertureSpider: ...
    @property
    def _S_RectangularAperture(self) -> ISurfaceApertureRectangular: ...
    @property
    def _S_RectangularObscuration(self) -> ISurfaceApertureRectangular: ...
    @property
    def _S_EllipticalAperture(self) -> ISurfaceApertureElliptical: ...
    @property
    def _S_EllipticalObscuration(self) -> ISurfaceApertureElliptical: ...
    @property
    def _S_UserAperture(self) -> ISurfaceApertureUser: ...
    @property
    def _S_UserObscuration(self) -> ISurfaceApertureUser: ...
    @property
    def _S_FloatingAperture(self) -> ISurfaceApertureFloating: ...

class ISurfaceApertureUser(ISurfaceApertureType):
    @property
    def UDASCale(self) -> float: ...
    @UDASCale.setter
    def UDASCale(self, value: float) -> None: ...
    @property
    def ApertureXDecenter(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...
    @property
    def ApertureFile(self) -> str: ...
    @ApertureFile.setter
    def ApertureFile(self, value: str) -> None: ...
    def GetAvailableFiles(self) -> list[str]: ...

class ISurfaceAtmospheric(ISurface):
    @property
    def ZenithCell(self) -> IEditorCell: ...
    @property
    def HeightCell(self) -> IEditorCell: ...
    @property
    def TemperatureCell(self) -> IEditorCell: ...
    @property
    def PressureCell(self) -> IEditorCell: ...
    @property
    def HumidityCell(self) -> IEditorCell: ...
    @property
    def LatitudeCell(self) -> IEditorCell: ...
    @property
    def IsAbsoluteCell(self) -> IEditorCell: ...
    @property
    def Zenith(self) -> float: ...
    @Zenith.setter
    def Zenith(self, value: float) -> None: ...
    @property
    def Height(self) -> float: ...
    @Height.setter
    def Height(self, value: float) -> None: ...
    @property
    def Temperature(self) -> float: ...
    @Temperature.setter
    def Temperature(self, value: float) -> None: ...
    @property
    def Pressure(self) -> float: ...
    @Pressure.setter
    def Pressure(self, value: float) -> None: ...
    @property
    def Humidity(self) -> float: ...
    @Humidity.setter
    def Humidity(self, value: float) -> None: ...
    @property
    def Latitude(self) -> float: ...
    @Latitude.setter
    def Latitude(self, value: float) -> None: ...
    @property
    def IsAbsolute(self) -> bool: ...
    @IsAbsolute.setter
    def IsAbsolute(self, value: bool) -> None: ...

class ISurfaceBiconic(ISurface):
    @property
    def XRadiusCell(self) -> IEditorCell: ...
    @property
    def XConicCell(self) -> IEditorCell: ...
    @property
    def XRadius(self) -> float: ...
    @XRadius.setter
    def XRadius(self, value: float) -> None: ...
    @property
    def XConic(self) -> float: ...
    @XConic.setter
    def XConic(self, value: float) -> None: ...

class ISurfaceBiconicZernike(ISurface):
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def XRadiusCell(self) -> IEditorCell: ...
    @property
    def XConicCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @property
    def XRadius(self) -> float: ...
    @XRadius.setter
    def XRadius(self, value: float) -> None: ...
    @property
    def XConic(self) -> float: ...
    @XConic.setter
    def XConic(self, value: float) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetCellXn(self, n: int) -> IEditorCell: ...
    def GetCellYn(self, n: int) -> IEditorCell: ...
    def GetCellZn(self, n: int) -> IEditorCell: ...
    def GetXn(self, n: int) -> float: ...
    def GetYn(self, n: int) -> float: ...
    def GetZn(self, n: int) -> float: ...
    def SetXn(self, n: int, v: float) -> None: ...
    def SetYn(self, n: int, v: float) -> None: ...
    def SetZn(self, n: int, v: float) -> None: ...

class ISurfaceBinary1(ISurfaceXYPolynomial, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def IsAbsoluteCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def IsAbsolute(self) -> bool: ...
    @IsAbsolute.setter
    def IsAbsolute(self, value: bool) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceBinary2(ISurfaceCoeff_P_NthEvenPower, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceBinary3(ISurface):
    @property
    def R2Cell(self) -> IEditorCell: ...
    @property
    def K2Cell(self) -> IEditorCell: ...
    @property
    def A1Cell(self) -> IEditorCell: ...
    @property
    def A2Cell(self) -> IEditorCell: ...
    @property
    def M1Cell(self) -> IEditorCell: ...
    @property
    def M2Cell(self) -> IEditorCell: ...
    @property
    def SinDeltaZeroCell(self) -> IEditorCell: ...
    @property
    def BreakCell(self) -> IEditorCell: ...
    @property
    def R2(self) -> float: ...
    @R2.setter
    def R2(self, value: float) -> None: ...
    @property
    def K2(self) -> float: ...
    @K2.setter
    def K2(self, value: float) -> None: ...
    @property
    def A1(self) -> float: ...
    @A1.setter
    def A1(self, value: float) -> None: ...
    @property
    def A2(self) -> float: ...
    @A2.setter
    def A2(self, value: float) -> None: ...
    @property
    def M1(self) -> float: ...
    @M1.setter
    def M1(self, value: float) -> None: ...
    @property
    def M2(self) -> float: ...
    @M2.setter
    def M2(self, value: float) -> None: ...
    @property
    def SinDeltaZero(self) -> float: ...
    @SinDeltaZero.setter
    def SinDeltaZero(self, value: float) -> None: ...
    @property
    def Break(self) -> bool: ...
    @Break.setter
    def Break(self, value: bool) -> None: ...

class ISurfaceBinary4(ISurface):
    @property
    def NumberOfRadialZonesCell(self) -> IEditorCell: ...
    @property
    def NumberOfAsphericTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPhaseTermsCell(self) -> IEditorCell: ...
    @property
    def SineDeltaZeroCell(self) -> IEditorCell: ...
    @property
    def NumberOfRadialZones(self) -> int: ...
    @NumberOfRadialZones.setter
    def NumberOfRadialZones(self, value: int) -> None: ...
    @property
    def NumberOfAsphericTerms(self) -> int: ...
    @NumberOfAsphericTerms.setter
    def NumberOfAsphericTerms(self, value: int) -> None: ...
    @property
    def NumberOfPhaseTerms(self) -> int: ...
    @NumberOfPhaseTerms.setter
    def NumberOfPhaseTerms(self, value: int) -> None: ...
    @property
    def SineDeltaZero(self) -> float: ...
    @SineDeltaZero.setter
    def SineDeltaZero(self, value: float) -> None: ...
    def AsphereInZone_P_NthEvenPowerCell(self, zoneN: int, n: int) -> IEditorCell: ...
    def ConicInZoneCell(self, zoneN: int) -> IEditorCell: ...
    def GetAsphereInZone_P_NthEvenPower(self, zoneN: int, n: int) -> float: ...
    def GetConicInZone(self, zoneN: int) -> float: ...
    def GetOrderInZone(self, zoneN: int) -> float: ...
    def GetPhaseInZone_P_NthEvenPower(self, zoneN: int, n: int) -> float: ...
    def GetRadialApertureInZone(self, zoneN: int) -> float: ...
    def GetRadiusInZone(self, zoneN: int) -> float: ...
    def OrderInZoneCell(self, zoneN: int) -> IEditorCell: ...
    def PhaseInZone_P_NthEvenPowerCell(self, zoneN: int, n: int) -> IEditorCell: ...
    def RadialApertureInZoneCell(self, zoneN: int) -> IEditorCell: ...
    def RadiusInZoneCell(self, zoneN: int) -> IEditorCell: ...
    def SetAsphereInZone_P_NthEvenPower(self, zoneN: int, n: int, Value: float) -> None: ...
    def SetConicInZone(self, zoneN: int, Value: float) -> None: ...
    def SetOrderInZone(self, zoneN: int, Value: float) -> None: ...
    def SetPhaseInZone_P_NthEvenPower(self, zoneN: int, n: int, Value: float) -> None: ...
    def SetRadialApertureInZone(self, zoneN: int, Value: float) -> None: ...
    def SetRadiusInZone(self, zoneN: int, Value: float) -> None: ...

class ISurfaceBirefringentIn(ISurface):
    @property
    def DrawAxisCell(self) -> IEditorCell: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def X_CosineCell(self) -> IEditorCell: ...
    @property
    def Y_CosineCell(self) -> IEditorCell: ...
    @property
    def Z_CosineCell(self) -> IEditorCell: ...
    @property
    def IgnoreParaxialRaysCell(self) -> IEditorCell: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def GradientModeCell(self) -> IEditorCell: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def OCell(self) -> IEditorCell: ...
    @property
    def ECell(self) -> IEditorCell: ...
    @property
    def ACell(self) -> IEditorCell: ...
    @property
    def BCell(self) -> IEditorCell: ...
    @property
    def azCell(self) -> IEditorCell: ...
    @property
    def Z0Cell(self) -> IEditorCell: ...
    @property
    def ZnCell(self) -> IEditorCell: ...
    @property
    def DrawAxis(self) -> float: ...
    @DrawAxis.setter
    def DrawAxis(self, value: float) -> None: ...
    @property
    def Mode(self) -> int: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @property
    def X_Cosine(self) -> float: ...
    @X_Cosine.setter
    def X_Cosine(self, value: float) -> None: ...
    @property
    def Y_Cosine(self) -> float: ...
    @Y_Cosine.setter
    def Y_Cosine(self, value: float) -> None: ...
    @property
    def Z_Cosine(self) -> float: ...
    @Z_Cosine.setter
    def Z_Cosine(self, value: float) -> None: ...
    @property
    def IgnoreParaxialRays(self) -> bool: ...
    @IgnoreParaxialRays.setter
    def IgnoreParaxialRays(self, value: bool) -> None: ...
    @property
    def Shape(self) -> int: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @property
    def GradientMode(self) -> int: ...
    @GradientMode.setter
    def GradientMode(self, value: int) -> None: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def O(self) -> float: ...
    @O.setter
    def O(self, value: float) -> None: ...
    @property
    def E(self) -> float: ...
    @E.setter
    def E(self, value: float) -> None: ...
    @property
    def A(self) -> float: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @property
    def B(self) -> float: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @property
    def az(self) -> float: ...
    @az.setter
    def az(self, value: float) -> None: ...
    @property
    def Z0(self) -> float: ...
    @Z0.setter
    def Z0(self, value: float) -> None: ...
    @property
    def Zn(self) -> float: ...
    @Zn.setter
    def Zn(self, value: float) -> None: ...
    def aCell(self, n: int) -> IEditorCell: ...
    def CmnCell(self, m: int, n: int) -> IEditorCell: ...
    def CxCell(self, n: int) -> IEditorCell: ...
    def CyCell(self, n: int) -> IEditorCell: ...
    def CzCell(self, n: int) -> IEditorCell: ...
    def Get_a(self, n: int) -> float: ...
    def GetCmn(self, m: int, n: int) -> float: ...
    def GetCx(self, n: int) -> float: ...
    def GetCy(self, n: int) -> float: ...
    def GetCz(self, n: int) -> float: ...
    def GetMode7Cx(self, n: int) -> float: ...
    def GetNthEvenOrderTerm(self, n: int) -> float: ...
    def GetPhi(self, n: int) -> float: ...
    def Mode7CxCell(self, n: int) -> IEditorCell: ...
    def NthEvenOrderTermCell(self, n: int) -> IEditorCell: ...
    def PhiCell(self, n: int) -> IEditorCell: ...
    def Set_a(self, n: int, Value: float) -> None: ...
    def SetCmn(self, m: int, n: int, Value: float) -> None: ...
    def SetCx(self, n: int, Value: float) -> None: ...
    def SetCy(self, n: int, Value: float) -> None: ...
    def SetCz(self, n: int, Value: float) -> None: ...
    def SetMode7Cx(self, n: int, Value: float) -> None: ...
    def SetNthEvenOrderTerm(self, n: int, Value: float) -> None: ...
    def SetPhi(self, n: int, Value: float) -> None: ...

class ISurfaceBirefringentOut(ISurfaceNthEvenOrderTerms, ISurface):
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> int: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...

class ISurfaceBlackBoxLens(ISurface):
    @property
    def NumberOfAvailableBlackBoxLensFilenames(self) -> int: ...
    @property
    def BlackBoxLensFilename(self) -> str: ...
    @BlackBoxLensFilename.setter
    def BlackBoxLensFilename(self, value: str) -> None: ...
    def GetBlackBoxLensFilenameAt(self, idx: int) -> str: ...

class ISurfaceChebyShv(ISurface):
    @property
    def NumberOf_X_OrdersCell(self) -> IEditorCell: ...
    @property
    def NumberOf_Y_OrdersCell(self) -> IEditorCell: ...
    @property
    def Norm_X_LengthCell(self) -> IEditorCell: ...
    @property
    def Norm_Y_LengthCell(self) -> IEditorCell: ...
    @property
    def NumberOf_X_Orders(self) -> int: ...
    @NumberOf_X_Orders.setter
    def NumberOf_X_Orders(self, value: int) -> None: ...
    @property
    def NumberOf_Y_Orders(self) -> int: ...
    @NumberOf_Y_Orders.setter
    def NumberOf_Y_Orders(self, value: int) -> None: ...
    @property
    def Norm_X_Length(self) -> float: ...
    @Norm_X_Length.setter
    def Norm_X_Length(self, value: float) -> None: ...
    @property
    def Norm_Y_Length(self) -> float: ...
    @Norm_Y_Length.setter
    def Norm_Y_Length(self, value: float) -> None: ...
    def CxyCell(self, orderX: int, orderY: int) -> IEditorCell: ...
    def GetCxy(self, orderX: int, orderY: int) -> float: ...
    def SetCxy(self, orderX: int, orderY: int, Value: float) -> None: ...

class ISurfaceCoeff_P_NthEvenPower(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def Coeff_P_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_P_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_P_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_P_NthPower(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def Coeff_P_NthPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_P_NthPower(self, n: int) -> float: ...
    def SetCoeff_P_NthPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_R_NthEvenPower(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def Coeff_R_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_R_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_R_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_R_NthPower(ISurface):
    def Coeff_R_NthPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_R_NthPower(self, n: int) -> float: ...
    def SetCoeff_R_NthPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_X_NthEvenPower(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def Coeff_X_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_X_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_X_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_X_NthEvenPower_8(ISurface):
    def Coeff_X_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_X_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_X_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_X1P1X2P2_NthEvenPower(ISurface):
    def Coeff_P1_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def Coeff_P2_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def Coeff_X1_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def Coeff_X2_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_P1_NthEvenPower(self, n: int) -> float: ...
    def GetCoeff_P2_NthEvenPower(self, n: int) -> float: ...
    def GetCoeff_X1_NthEvenPower(self, n: int) -> float: ...
    def GetCoeff_X2_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_P1_NthEvenPower(self, n: int, Value: float) -> None: ...
    def SetCoeff_P2_NthEvenPower(self, n: int, Value: float) -> None: ...
    def SetCoeff_X1_NthEvenPower(self, n: int, Value: float) -> None: ...
    def SetCoeff_X2_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_Y_NthEvenPower(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def Coeff_Y_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_Y_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_Y_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_Y_NthEvenPower_8(ISurface):
    def Coeff_Y_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_Y_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_Y_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceConjugate(ISurface):
    @property
    def X1_Cell(self) -> IEditorCell: ...
    @property
    def Y1_Cell(self) -> IEditorCell: ...
    @property
    def Z1_Cell(self) -> IEditorCell: ...
    @property
    def X2_Cell(self) -> IEditorCell: ...
    @property
    def Y2_Cell(self) -> IEditorCell: ...
    @property
    def Z2_Cell(self) -> IEditorCell: ...
    @property
    def X1(self) -> float: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @property
    def Y1(self) -> float: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @property
    def Z1(self) -> float: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @property
    def X2(self) -> float: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @property
    def Y2(self) -> float: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @property
    def Z2(self) -> float: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...

class ISurfaceCoordinateBreak(ISurface):
    @property
    def Decenter_X_Cell(self) -> IEditorCell: ...
    @property
    def Decenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_X_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_Y_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_Z_Cell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def Decenter_X(self) -> float: ...
    @Decenter_X.setter
    def Decenter_X(self, value: float) -> None: ...
    @property
    def Decenter_Y(self) -> float: ...
    @Decenter_Y.setter
    def Decenter_Y(self, value: float) -> None: ...
    @property
    def TiltAbout_X(self) -> float: ...
    @TiltAbout_X.setter
    def TiltAbout_X(self, value: float) -> None: ...
    @property
    def TiltAbout_Y(self) -> float: ...
    @TiltAbout_Y.setter
    def TiltAbout_Y(self, value: float) -> None: ...
    @property
    def TiltAbout_Z(self) -> float: ...
    @TiltAbout_Z.setter
    def TiltAbout_Z(self, value: float) -> None: ...
    @property
    def Order(self) -> int: ...
    @Order.setter
    def Order(self, value: int) -> None: ...

class ISurfaceCubicSpline(ISurface):
    def Get_Z_nEighths(self, n: int) -> float: ...
    def Set_Z_nEighths(self, n: int, Value: float) -> None: ...
    def Z_nEigthsCell(self, n: int) -> IEditorCell: ...

class ISurfaceCylinderFrensel(ISurface, ISurfaceNthEvenOrderTerms, ISurfaceCoeff_Y_NthEvenPower):
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...

class ISurfaceCylinderFresnel(ISurface, ISurfaceNthEvenOrderTerms, ISurfaceCoeff_Y_NthEvenPower):
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...

class ISurfaceData(ISurface):
    def GetNthExtraData(self, n: int) -> float: ...
    def NthExtraDataCell(self, n: int) -> IEditorCell: ...
    def SetNthExtraData(self, n: int, Value: float) -> None: ...

class ISurfaceDiffractionGrating(ISurface):
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...

class ISurfaceEllipticalGrating1(ISurfaceXYPolynomial, ISurface):
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def aCell(self) -> IEditorCell: ...
    @property
    def bCell(self) -> IEditorCell: ...
    @property
    def cCell(self) -> IEditorCell: ...
    @property
    def AlphaCell(self) -> IEditorCell: ...
    @property
    def BetaCell(self) -> IEditorCell: ...
    @property
    def GammaCell(self) -> IEditorCell: ...
    @property
    def DeltaCell(self) -> IEditorCell: ...
    @property
    def EpsilonCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @property
    def a(self) -> float: ...
    @a.setter
    def a(self, value: float) -> None: ...
    @property
    def b(self) -> float: ...
    @b.setter
    def b(self, value: float) -> None: ...
    @property
    def c(self) -> float: ...
    @c.setter
    def c(self, value: float) -> None: ...
    @property
    def Alpha(self) -> float: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @property
    def Beta(self) -> float: ...
    @Beta.setter
    def Beta(self, value: float) -> None: ...
    @property
    def Gamma(self) -> float: ...
    @Gamma.setter
    def Gamma(self, value: float) -> None: ...
    @property
    def Delta(self) -> float: ...
    @Delta.setter
    def Delta(self, value: float) -> None: ...
    @property
    def Epsilon(self) -> float: ...
    @Epsilon.setter
    def Epsilon(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceEllipticalGrating2(ISurfaceXYPolynomial, ISurface):
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def aCell(self) -> IEditorCell: ...
    @property
    def bCell(self) -> IEditorCell: ...
    @property
    def cCell(self) -> IEditorCell: ...
    @property
    def ThetaCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @property
    def a(self) -> float: ...
    @a.setter
    def a(self, value: float) -> None: ...
    @property
    def b(self) -> float: ...
    @b.setter
    def b(self, value: float) -> None: ...
    @property
    def c(self) -> float: ...
    @c.setter
    def c(self, value: float) -> None: ...
    @property
    def Theta(self) -> float: ...
    @Theta.setter
    def Theta(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceEvenAspheric(ISurface, ISurfaceNthEvenOrderTerms):
    pass

class ISurfaceExtendedAsphere(ISurfaceCoeff_P_NthEvenPower, ISurface):
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceExtendedCubicSpline(ISurface):
    @property
    def NumberOfStepsCell(self) -> IEditorCell: ...
    @property
    def StepSizeCell(self) -> IEditorCell: ...
    @property
    def NumberOfSteps(self) -> int: ...
    @NumberOfSteps.setter
    def NumberOfSteps(self, value: int) -> None: ...
    @property
    def StepSize(self) -> float: ...
    @StepSize.setter
    def StepSize(self, value: float) -> None: ...
    def GetSagAtNthStep(self, n: int) -> float: ...
    def SagAtNthStepCell(self, n: int) -> IEditorCell: ...
    def SetSagAtNthStep(self, n: int, Value: float) -> None: ...

class ISurfaceExtendedFresnel(ISurface, ISurfaceNthEvenOrderTerms, ISurfaceCoeff_R_NthEvenPower):
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...

class ISurfaceExtendedOddAsphere(ISurface, ISurfaceCoeff_P_NthPower):
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceExtendedPolynomial(ISurfaceXYPolynomial, ISurface):
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceExtendedToroidalGrating(ISurfaceXYPolynomial, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceFreeformNthZernike(ISurface):
    @property
    def NumberOfZernikeTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfZernikeTerms(self) -> int: ...
    @NumberOfZernikeTerms.setter
    def NumberOfZernikeTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetNthZernikeCoefficient(self, n: int) -> float: ...
    def NthZernikeCoefficientCell(self, n: int) -> IEditorCell: ...
    def SetNthZernikeCoefficient(self, n: int, Value: float) -> None: ...

class ISurfaceFreeformXYPolynomial(ISurface):
    @property
    def NumberOfPolynomialTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPolynomialTerms(self) -> int: ...
    @NumberOfPolynomialTerms.setter
    def NumberOfPolynomialTerms(self, value: int) -> None: ...
    @property
    def X1Y0Cell(self) -> IEditorCell: ...
    @property
    def X0Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y0Cell(self) -> IEditorCell: ...
    @property
    def X1Y1Cell(self) -> IEditorCell: ...
    @property
    def X0Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y1Cell(self) -> IEditorCell: ...
    @property
    def X1Y2Cell(self) -> IEditorCell: ...
    @property
    def X0Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y0Cell(self) -> IEditorCell: ...
    @property
    def X3Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y3Cell(self) -> IEditorCell: ...
    @property
    def X0Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y0Cell(self) -> IEditorCell: ...
    @property
    def X4Y1Cell(self) -> IEditorCell: ...
    @property
    def X3Y2Cell(self) -> IEditorCell: ...
    @property
    def X2Y3Cell(self) -> IEditorCell: ...
    @property
    def X1Y4Cell(self) -> IEditorCell: ...
    @property
    def X0Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y0Cell(self) -> IEditorCell: ...
    @property
    def X5Y1Cell(self) -> IEditorCell: ...
    @property
    def X4Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y3Cell(self) -> IEditorCell: ...
    @property
    def X2Y4Cell(self) -> IEditorCell: ...
    @property
    def X1Y5Cell(self) -> IEditorCell: ...
    @property
    def X0Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y0Cell(self) -> IEditorCell: ...
    @property
    def X6Y1Cell(self) -> IEditorCell: ...
    @property
    def X5Y2Cell(self) -> IEditorCell: ...
    @property
    def X4Y3Cell(self) -> IEditorCell: ...
    @property
    def X3Y4Cell(self) -> IEditorCell: ...
    @property
    def X2Y5Cell(self) -> IEditorCell: ...
    @property
    def X1Y6Cell(self) -> IEditorCell: ...
    @property
    def X0Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y0Cell(self) -> IEditorCell: ...
    @property
    def X7Y1Cell(self) -> IEditorCell: ...
    @property
    def X6Y2Cell(self) -> IEditorCell: ...
    @property
    def X5Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y4Cell(self) -> IEditorCell: ...
    @property
    def X3Y5Cell(self) -> IEditorCell: ...
    @property
    def X2Y6Cell(self) -> IEditorCell: ...
    @property
    def X1Y7Cell(self) -> IEditorCell: ...
    @property
    def X0Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y0Cell(self) -> IEditorCell: ...
    @property
    def X8Y1Cell(self) -> IEditorCell: ...
    @property
    def X7Y2Cell(self) -> IEditorCell: ...
    @property
    def X6Y3Cell(self) -> IEditorCell: ...
    @property
    def X5Y4Cell(self) -> IEditorCell: ...
    @property
    def X4Y5Cell(self) -> IEditorCell: ...
    @property
    def X3Y6Cell(self) -> IEditorCell: ...
    @property
    def X2Y7Cell(self) -> IEditorCell: ...
    @property
    def X1Y8Cell(self) -> IEditorCell: ...
    @property
    def X0Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y0Cell(self) -> IEditorCell: ...
    @property
    def X9Y1Cell(self) -> IEditorCell: ...
    @property
    def X8Y2Cell(self) -> IEditorCell: ...
    @property
    def X7Y3Cell(self) -> IEditorCell: ...
    @property
    def X6Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y5Cell(self) -> IEditorCell: ...
    @property
    def X4Y6Cell(self) -> IEditorCell: ...
    @property
    def X3Y7Cell(self) -> IEditorCell: ...
    @property
    def X2Y8Cell(self) -> IEditorCell: ...
    @property
    def X1Y9Cell(self) -> IEditorCell: ...
    @property
    def X0Y10Cell(self) -> IEditorCell: ...
    @property
    def X11Y0Cell(self) -> IEditorCell: ...
    @property
    def X10Y1Cell(self) -> IEditorCell: ...
    @property
    def X9Y2Cell(self) -> IEditorCell: ...
    @property
    def X8Y3Cell(self) -> IEditorCell: ...
    @property
    def X7Y4Cell(self) -> IEditorCell: ...
    @property
    def X6Y5Cell(self) -> IEditorCell: ...
    @property
    def X5Y6Cell(self) -> IEditorCell: ...
    @property
    def X4Y7Cell(self) -> IEditorCell: ...
    @property
    def X3Y8Cell(self) -> IEditorCell: ...
    @property
    def X2Y9Cell(self) -> IEditorCell: ...
    @property
    def X1Y10Cell(self) -> IEditorCell: ...
    @property
    def X0Y11Cell(self) -> IEditorCell: ...
    @property
    def X12Y0Cell(self) -> IEditorCell: ...
    @property
    def X11Y1Cell(self) -> IEditorCell: ...
    @property
    def X10Y2Cell(self) -> IEditorCell: ...
    @property
    def X9Y3Cell(self) -> IEditorCell: ...
    @property
    def X8Y4Cell(self) -> IEditorCell: ...
    @property
    def X7Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y6Cell(self) -> IEditorCell: ...
    @property
    def X5Y7Cell(self) -> IEditorCell: ...
    @property
    def X4Y8Cell(self) -> IEditorCell: ...
    @property
    def X3Y9Cell(self) -> IEditorCell: ...
    @property
    def X2Y10Cell(self) -> IEditorCell: ...
    @property
    def X1Y11Cell(self) -> IEditorCell: ...
    @property
    def X0Y12Cell(self) -> IEditorCell: ...
    @property
    def X13Y0Cell(self) -> IEditorCell: ...
    @property
    def X12Y1Cell(self) -> IEditorCell: ...
    @property
    def X11Y2Cell(self) -> IEditorCell: ...
    @property
    def X10Y3Cell(self) -> IEditorCell: ...
    @property
    def X9Y4Cell(self) -> IEditorCell: ...
    @property
    def X8Y5Cell(self) -> IEditorCell: ...
    @property
    def X7Y6Cell(self) -> IEditorCell: ...
    @property
    def X6Y7Cell(self) -> IEditorCell: ...
    @property
    def X5Y8Cell(self) -> IEditorCell: ...
    @property
    def X4Y9Cell(self) -> IEditorCell: ...
    @property
    def X3Y10Cell(self) -> IEditorCell: ...
    @property
    def X2Y11Cell(self) -> IEditorCell: ...
    @property
    def X1Y12Cell(self) -> IEditorCell: ...
    @property
    def X0Y13Cell(self) -> IEditorCell: ...
    @property
    def X14Y0Cell(self) -> IEditorCell: ...
    @property
    def X13Y1Cell(self) -> IEditorCell: ...
    @property
    def X12Y2Cell(self) -> IEditorCell: ...
    @property
    def X11Y3Cell(self) -> IEditorCell: ...
    @property
    def X10Y4Cell(self) -> IEditorCell: ...
    @property
    def X9Y5Cell(self) -> IEditorCell: ...
    @property
    def X8Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y7Cell(self) -> IEditorCell: ...
    @property
    def X6Y8Cell(self) -> IEditorCell: ...
    @property
    def X5Y9Cell(self) -> IEditorCell: ...
    @property
    def X4Y10Cell(self) -> IEditorCell: ...
    @property
    def X3Y11Cell(self) -> IEditorCell: ...
    @property
    def X2Y12Cell(self) -> IEditorCell: ...
    @property
    def X1Y13Cell(self) -> IEditorCell: ...
    @property
    def X0Y14Cell(self) -> IEditorCell: ...
    @property
    def X15Y0Cell(self) -> IEditorCell: ...
    @property
    def X14Y1Cell(self) -> IEditorCell: ...
    @property
    def X13Y2Cell(self) -> IEditorCell: ...
    @property
    def X12Y3Cell(self) -> IEditorCell: ...
    @property
    def X11Y4Cell(self) -> IEditorCell: ...
    @property
    def X10Y5Cell(self) -> IEditorCell: ...
    @property
    def X9Y6Cell(self) -> IEditorCell: ...
    @property
    def X8Y7Cell(self) -> IEditorCell: ...
    @property
    def X7Y8Cell(self) -> IEditorCell: ...
    @property
    def X6Y9Cell(self) -> IEditorCell: ...
    @property
    def X5Y10Cell(self) -> IEditorCell: ...
    @property
    def X4Y11Cell(self) -> IEditorCell: ...
    @property
    def X3Y12Cell(self) -> IEditorCell: ...
    @property
    def X2Y13Cell(self) -> IEditorCell: ...
    @property
    def X1Y14Cell(self) -> IEditorCell: ...
    @property
    def X0Y15Cell(self) -> IEditorCell: ...
    @property
    def X16Y0Cell(self) -> IEditorCell: ...
    @property
    def X15Y1Cell(self) -> IEditorCell: ...
    @property
    def X14Y2Cell(self) -> IEditorCell: ...
    @property
    def X13Y3Cell(self) -> IEditorCell: ...
    @property
    def X12Y4Cell(self) -> IEditorCell: ...
    @property
    def X11Y5Cell(self) -> IEditorCell: ...
    @property
    def X10Y6Cell(self) -> IEditorCell: ...
    @property
    def X9Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y8Cell(self) -> IEditorCell: ...
    @property
    def X7Y9Cell(self) -> IEditorCell: ...
    @property
    def X6Y10Cell(self) -> IEditorCell: ...
    @property
    def X5Y11Cell(self) -> IEditorCell: ...
    @property
    def X4Y12Cell(self) -> IEditorCell: ...
    @property
    def X3Y13Cell(self) -> IEditorCell: ...
    @property
    def X2Y14Cell(self) -> IEditorCell: ...
    @property
    def X1Y15Cell(self) -> IEditorCell: ...
    @property
    def X0Y16Cell(self) -> IEditorCell: ...
    @property
    def X17Y0Cell(self) -> IEditorCell: ...
    @property
    def X16Y1Cell(self) -> IEditorCell: ...
    @property
    def X15Y2Cell(self) -> IEditorCell: ...
    @property
    def X14Y3Cell(self) -> IEditorCell: ...
    @property
    def X13Y4Cell(self) -> IEditorCell: ...
    @property
    def X12Y5Cell(self) -> IEditorCell: ...
    @property
    def X11Y6Cell(self) -> IEditorCell: ...
    @property
    def X10Y7Cell(self) -> IEditorCell: ...
    @property
    def X9Y8Cell(self) -> IEditorCell: ...
    @property
    def X8Y9Cell(self) -> IEditorCell: ...
    @property
    def X7Y10Cell(self) -> IEditorCell: ...
    @property
    def X6Y11Cell(self) -> IEditorCell: ...
    @property
    def X5Y12Cell(self) -> IEditorCell: ...
    @property
    def X4Y13Cell(self) -> IEditorCell: ...
    @property
    def X3Y14Cell(self) -> IEditorCell: ...
    @property
    def X2Y15Cell(self) -> IEditorCell: ...
    @property
    def X1Y16Cell(self) -> IEditorCell: ...
    @property
    def X0Y17Cell(self) -> IEditorCell: ...
    @property
    def X18Y0Cell(self) -> IEditorCell: ...
    @property
    def X17Y1Cell(self) -> IEditorCell: ...
    @property
    def X16Y2Cell(self) -> IEditorCell: ...
    @property
    def X15Y3Cell(self) -> IEditorCell: ...
    @property
    def X14Y4Cell(self) -> IEditorCell: ...
    @property
    def X13Y5Cell(self) -> IEditorCell: ...
    @property
    def X12Y6Cell(self) -> IEditorCell: ...
    @property
    def X11Y7Cell(self) -> IEditorCell: ...
    @property
    def X10Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y9Cell(self) -> IEditorCell: ...
    @property
    def X8Y10Cell(self) -> IEditorCell: ...
    @property
    def X7Y11Cell(self) -> IEditorCell: ...
    @property
    def X6Y12Cell(self) -> IEditorCell: ...
    @property
    def X5Y13Cell(self) -> IEditorCell: ...
    @property
    def X4Y14Cell(self) -> IEditorCell: ...
    @property
    def X3Y15Cell(self) -> IEditorCell: ...
    @property
    def X2Y16Cell(self) -> IEditorCell: ...
    @property
    def X1Y17Cell(self) -> IEditorCell: ...
    @property
    def X0Y18Cell(self) -> IEditorCell: ...
    @property
    def X19Y0Cell(self) -> IEditorCell: ...
    @property
    def X18Y1Cell(self) -> IEditorCell: ...
    @property
    def X17Y2Cell(self) -> IEditorCell: ...
    @property
    def X16Y3Cell(self) -> IEditorCell: ...
    @property
    def X15Y4Cell(self) -> IEditorCell: ...
    @property
    def X14Y5Cell(self) -> IEditorCell: ...
    @property
    def X13Y6Cell(self) -> IEditorCell: ...
    @property
    def X12Y7Cell(self) -> IEditorCell: ...
    @property
    def X11Y8Cell(self) -> IEditorCell: ...
    @property
    def X10Y9Cell(self) -> IEditorCell: ...
    @property
    def X9Y10Cell(self) -> IEditorCell: ...
    @property
    def X8Y11Cell(self) -> IEditorCell: ...
    @property
    def X7Y12Cell(self) -> IEditorCell: ...
    @property
    def X6Y13Cell(self) -> IEditorCell: ...
    @property
    def X5Y14Cell(self) -> IEditorCell: ...
    @property
    def X4Y15Cell(self) -> IEditorCell: ...
    @property
    def X3Y16Cell(self) -> IEditorCell: ...
    @property
    def X2Y17Cell(self) -> IEditorCell: ...
    @property
    def X1Y18Cell(self) -> IEditorCell: ...
    @property
    def X0Y19Cell(self) -> IEditorCell: ...
    @property
    def X20Y0Cell(self) -> IEditorCell: ...
    @property
    def X19Y1Cell(self) -> IEditorCell: ...
    @property
    def X18Y2Cell(self) -> IEditorCell: ...
    @property
    def X17Y3Cell(self) -> IEditorCell: ...
    @property
    def X16Y4Cell(self) -> IEditorCell: ...
    @property
    def X15Y5Cell(self) -> IEditorCell: ...
    @property
    def X14Y6Cell(self) -> IEditorCell: ...
    @property
    def X13Y7Cell(self) -> IEditorCell: ...
    @property
    def X12Y8Cell(self) -> IEditorCell: ...
    @property
    def X11Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y10Cell(self) -> IEditorCell: ...
    @property
    def X9Y11Cell(self) -> IEditorCell: ...
    @property
    def X8Y12Cell(self) -> IEditorCell: ...
    @property
    def X7Y13Cell(self) -> IEditorCell: ...
    @property
    def X6Y14Cell(self) -> IEditorCell: ...
    @property
    def X5Y15Cell(self) -> IEditorCell: ...
    @property
    def X4Y16Cell(self) -> IEditorCell: ...
    @property
    def X3Y17Cell(self) -> IEditorCell: ...
    @property
    def X2Y18Cell(self) -> IEditorCell: ...
    @property
    def X1Y19Cell(self) -> IEditorCell: ...
    @property
    def X0Y20Cell(self) -> IEditorCell: ...
    @property
    def X21Y0Cell(self) -> IEditorCell: ...
    @property
    def X20Y1Cell(self) -> IEditorCell: ...
    @property
    def X19Y2Cell(self) -> IEditorCell: ...
    @property
    def X18Y3Cell(self) -> IEditorCell: ...
    @property
    def X17Y4Cell(self) -> IEditorCell: ...
    @property
    def X16Y5Cell(self) -> IEditorCell: ...
    @property
    def X15Y6Cell(self) -> IEditorCell: ...
    @property
    def X14Y7Cell(self) -> IEditorCell: ...
    @property
    def X13Y8Cell(self) -> IEditorCell: ...
    @property
    def X12Y9Cell(self) -> IEditorCell: ...
    @property
    def X11Y10Cell(self) -> IEditorCell: ...
    @property
    def X10Y11Cell(self) -> IEditorCell: ...
    @property
    def X9Y12Cell(self) -> IEditorCell: ...
    @property
    def X8Y13Cell(self) -> IEditorCell: ...
    @property
    def X7Y14Cell(self) -> IEditorCell: ...
    @property
    def X6Y15Cell(self) -> IEditorCell: ...
    @property
    def X5Y16Cell(self) -> IEditorCell: ...
    @property
    def X4Y17Cell(self) -> IEditorCell: ...
    @property
    def X3Y18Cell(self) -> IEditorCell: ...
    @property
    def X2Y19Cell(self) -> IEditorCell: ...
    @property
    def X1Y0(self) -> float: ...
    @X1Y0.setter
    def X1Y0(self, value: float) -> None: ...
    @property
    def X0Y1(self) -> float: ...
    @X0Y1.setter
    def X0Y1(self, value: float) -> None: ...
    @property
    def X2Y0(self) -> float: ...
    @X2Y0.setter
    def X2Y0(self, value: float) -> None: ...
    @property
    def X1Y1(self) -> float: ...
    @X1Y1.setter
    def X1Y1(self, value: float) -> None: ...
    @property
    def X0Y2(self) -> float: ...
    @X0Y2.setter
    def X0Y2(self, value: float) -> None: ...
    @property
    def X3Y0(self) -> float: ...
    @X3Y0.setter
    def X3Y0(self, value: float) -> None: ...
    @property
    def X2Y1(self) -> float: ...
    @X2Y1.setter
    def X2Y1(self, value: float) -> None: ...
    @property
    def X1Y2(self) -> float: ...
    @X1Y2.setter
    def X1Y2(self, value: float) -> None: ...
    @property
    def X0Y3(self) -> float: ...
    @X0Y3.setter
    def X0Y3(self, value: float) -> None: ...
    @property
    def X4Y0(self) -> float: ...
    @X4Y0.setter
    def X4Y0(self, value: float) -> None: ...
    @property
    def X3Y1(self) -> float: ...
    @X3Y1.setter
    def X3Y1(self, value: float) -> None: ...
    @property
    def X2Y2(self) -> float: ...
    @X2Y2.setter
    def X2Y2(self, value: float) -> None: ...
    @property
    def X1Y3(self) -> float: ...
    @X1Y3.setter
    def X1Y3(self, value: float) -> None: ...
    @property
    def X0Y4(self) -> float: ...
    @X0Y4.setter
    def X0Y4(self, value: float) -> None: ...
    @property
    def X5Y0(self) -> float: ...
    @X5Y0.setter
    def X5Y0(self, value: float) -> None: ...
    @property
    def X4Y1(self) -> float: ...
    @X4Y1.setter
    def X4Y1(self, value: float) -> None: ...
    @property
    def X3Y2(self) -> float: ...
    @X3Y2.setter
    def X3Y2(self, value: float) -> None: ...
    @property
    def X2Y3(self) -> float: ...
    @X2Y3.setter
    def X2Y3(self, value: float) -> None: ...
    @property
    def X1Y4(self) -> float: ...
    @X1Y4.setter
    def X1Y4(self, value: float) -> None: ...
    @property
    def X0Y5(self) -> float: ...
    @X0Y5.setter
    def X0Y5(self, value: float) -> None: ...
    @property
    def X6Y0(self) -> float: ...
    @X6Y0.setter
    def X6Y0(self, value: float) -> None: ...
    @property
    def X5Y1(self) -> float: ...
    @X5Y1.setter
    def X5Y1(self, value: float) -> None: ...
    @property
    def X4Y2(self) -> float: ...
    @X4Y2.setter
    def X4Y2(self, value: float) -> None: ...
    @property
    def X3Y3(self) -> float: ...
    @X3Y3.setter
    def X3Y3(self, value: float) -> None: ...
    @property
    def X2Y4(self) -> float: ...
    @X2Y4.setter
    def X2Y4(self, value: float) -> None: ...
    @property
    def X1Y5(self) -> float: ...
    @X1Y5.setter
    def X1Y5(self, value: float) -> None: ...
    @property
    def X0Y6(self) -> float: ...
    @X0Y6.setter
    def X0Y6(self, value: float) -> None: ...
    @property
    def X7Y0(self) -> float: ...
    @X7Y0.setter
    def X7Y0(self, value: float) -> None: ...
    @property
    def X6Y1(self) -> float: ...
    @X6Y1.setter
    def X6Y1(self, value: float) -> None: ...
    @property
    def X5Y2(self) -> float: ...
    @X5Y2.setter
    def X5Y2(self, value: float) -> None: ...
    @property
    def X4Y3(self) -> float: ...
    @X4Y3.setter
    def X4Y3(self, value: float) -> None: ...
    @property
    def X3Y4(self) -> float: ...
    @X3Y4.setter
    def X3Y4(self, value: float) -> None: ...
    @property
    def X2Y5(self) -> float: ...
    @X2Y5.setter
    def X2Y5(self, value: float) -> None: ...
    @property
    def X1Y6(self) -> float: ...
    @X1Y6.setter
    def X1Y6(self, value: float) -> None: ...
    @property
    def X0Y7(self) -> float: ...
    @X0Y7.setter
    def X0Y7(self, value: float) -> None: ...
    @property
    def X8Y0(self) -> float: ...
    @X8Y0.setter
    def X8Y0(self, value: float) -> None: ...
    @property
    def X7Y1(self) -> float: ...
    @X7Y1.setter
    def X7Y1(self, value: float) -> None: ...
    @property
    def X6Y2(self) -> float: ...
    @X6Y2.setter
    def X6Y2(self, value: float) -> None: ...
    @property
    def X5Y3(self) -> float: ...
    @X5Y3.setter
    def X5Y3(self, value: float) -> None: ...
    @property
    def X4Y4(self) -> float: ...
    @X4Y4.setter
    def X4Y4(self, value: float) -> None: ...
    @property
    def X3Y5(self) -> float: ...
    @X3Y5.setter
    def X3Y5(self, value: float) -> None: ...
    @property
    def X2Y6(self) -> float: ...
    @X2Y6.setter
    def X2Y6(self, value: float) -> None: ...
    @property
    def X1Y7(self) -> float: ...
    @X1Y7.setter
    def X1Y7(self, value: float) -> None: ...
    @property
    def X0Y8(self) -> float: ...
    @X0Y8.setter
    def X0Y8(self, value: float) -> None: ...
    @property
    def X9Y0(self) -> float: ...
    @X9Y0.setter
    def X9Y0(self, value: float) -> None: ...
    @property
    def X8Y1(self) -> float: ...
    @X8Y1.setter
    def X8Y1(self, value: float) -> None: ...
    @property
    def X7Y2(self) -> float: ...
    @X7Y2.setter
    def X7Y2(self, value: float) -> None: ...
    @property
    def X6Y3(self) -> float: ...
    @X6Y3.setter
    def X6Y3(self, value: float) -> None: ...
    @property
    def X5Y4(self) -> float: ...
    @X5Y4.setter
    def X5Y4(self, value: float) -> None: ...
    @property
    def X4Y5(self) -> float: ...
    @X4Y5.setter
    def X4Y5(self, value: float) -> None: ...
    @property
    def X3Y6(self) -> float: ...
    @X3Y6.setter
    def X3Y6(self, value: float) -> None: ...
    @property
    def X2Y7(self) -> float: ...
    @X2Y7.setter
    def X2Y7(self, value: float) -> None: ...
    @property
    def X1Y8(self) -> float: ...
    @X1Y8.setter
    def X1Y8(self, value: float) -> None: ...
    @property
    def X0Y9(self) -> float: ...
    @X0Y9.setter
    def X0Y9(self, value: float) -> None: ...
    @property
    def X10Y0(self) -> float: ...
    @X10Y0.setter
    def X10Y0(self, value: float) -> None: ...
    @property
    def X9Y1(self) -> float: ...
    @X9Y1.setter
    def X9Y1(self, value: float) -> None: ...
    @property
    def X8Y2(self) -> float: ...
    @X8Y2.setter
    def X8Y2(self, value: float) -> None: ...
    @property
    def X7Y3(self) -> float: ...
    @X7Y3.setter
    def X7Y3(self, value: float) -> None: ...
    @property
    def X6Y4(self) -> float: ...
    @X6Y4.setter
    def X6Y4(self, value: float) -> None: ...
    @property
    def X5Y5(self) -> float: ...
    @X5Y5.setter
    def X5Y5(self, value: float) -> None: ...
    @property
    def X4Y6(self) -> float: ...
    @X4Y6.setter
    def X4Y6(self, value: float) -> None: ...
    @property
    def X3Y7(self) -> float: ...
    @X3Y7.setter
    def X3Y7(self, value: float) -> None: ...
    @property
    def X2Y8(self) -> float: ...
    @X2Y8.setter
    def X2Y8(self, value: float) -> None: ...
    @property
    def X1Y9(self) -> float: ...
    @X1Y9.setter
    def X1Y9(self, value: float) -> None: ...
    @property
    def X0Y10(self) -> float: ...
    @X0Y10.setter
    def X0Y10(self, value: float) -> None: ...
    @property
    def X11Y0(self) -> float: ...
    @X11Y0.setter
    def X11Y0(self, value: float) -> None: ...
    @property
    def X10Y1(self) -> float: ...
    @X10Y1.setter
    def X10Y1(self, value: float) -> None: ...
    @property
    def X9Y2(self) -> float: ...
    @X9Y2.setter
    def X9Y2(self, value: float) -> None: ...
    @property
    def X8Y3(self) -> float: ...
    @X8Y3.setter
    def X8Y3(self, value: float) -> None: ...
    @property
    def X7Y4(self) -> float: ...
    @X7Y4.setter
    def X7Y4(self, value: float) -> None: ...
    @property
    def X6Y5(self) -> float: ...
    @X6Y5.setter
    def X6Y5(self, value: float) -> None: ...
    @property
    def X5Y6(self) -> float: ...
    @X5Y6.setter
    def X5Y6(self, value: float) -> None: ...
    @property
    def X4Y7(self) -> float: ...
    @X4Y7.setter
    def X4Y7(self, value: float) -> None: ...
    @property
    def X3Y8(self) -> float: ...
    @X3Y8.setter
    def X3Y8(self, value: float) -> None: ...
    @property
    def X2Y9(self) -> float: ...
    @X2Y9.setter
    def X2Y9(self, value: float) -> None: ...
    @property
    def X1Y10(self) -> float: ...
    @X1Y10.setter
    def X1Y10(self, value: float) -> None: ...
    @property
    def X0Y11(self) -> float: ...
    @X0Y11.setter
    def X0Y11(self, value: float) -> None: ...
    @property
    def X12Y0(self) -> float: ...
    @X12Y0.setter
    def X12Y0(self, value: float) -> None: ...
    @property
    def X11Y1(self) -> float: ...
    @X11Y1.setter
    def X11Y1(self, value: float) -> None: ...
    @property
    def X10Y2(self) -> float: ...
    @X10Y2.setter
    def X10Y2(self, value: float) -> None: ...
    @property
    def X9Y3(self) -> float: ...
    @X9Y3.setter
    def X9Y3(self, value: float) -> None: ...
    @property
    def X8Y4(self) -> float: ...
    @X8Y4.setter
    def X8Y4(self, value: float) -> None: ...
    @property
    def X7Y5(self) -> float: ...
    @X7Y5.setter
    def X7Y5(self, value: float) -> None: ...
    @property
    def X6Y6(self) -> float: ...
    @X6Y6.setter
    def X6Y6(self, value: float) -> None: ...
    @property
    def X5Y7(self) -> float: ...
    @X5Y7.setter
    def X5Y7(self, value: float) -> None: ...
    @property
    def X4Y8(self) -> float: ...
    @X4Y8.setter
    def X4Y8(self, value: float) -> None: ...
    @property
    def X3Y9(self) -> float: ...
    @X3Y9.setter
    def X3Y9(self, value: float) -> None: ...
    @property
    def X2Y10(self) -> float: ...
    @X2Y10.setter
    def X2Y10(self, value: float) -> None: ...
    @property
    def X1Y11(self) -> float: ...
    @X1Y11.setter
    def X1Y11(self, value: float) -> None: ...
    @property
    def X0Y12(self) -> float: ...
    @X0Y12.setter
    def X0Y12(self, value: float) -> None: ...
    @property
    def X13Y0(self) -> float: ...
    @X13Y0.setter
    def X13Y0(self, value: float) -> None: ...
    @property
    def X12Y1(self) -> float: ...
    @X12Y1.setter
    def X12Y1(self, value: float) -> None: ...
    @property
    def X11Y2(self) -> float: ...
    @X11Y2.setter
    def X11Y2(self, value: float) -> None: ...
    @property
    def X10Y3(self) -> float: ...
    @X10Y3.setter
    def X10Y3(self, value: float) -> None: ...
    @property
    def X9Y4(self) -> float: ...
    @X9Y4.setter
    def X9Y4(self, value: float) -> None: ...
    @property
    def X8Y5(self) -> float: ...
    @X8Y5.setter
    def X8Y5(self, value: float) -> None: ...
    @property
    def X7Y6(self) -> float: ...
    @X7Y6.setter
    def X7Y6(self, value: float) -> None: ...
    @property
    def X6Y7(self) -> float: ...
    @X6Y7.setter
    def X6Y7(self, value: float) -> None: ...
    @property
    def X5Y8(self) -> float: ...
    @X5Y8.setter
    def X5Y8(self, value: float) -> None: ...
    @property
    def X4Y9(self) -> float: ...
    @X4Y9.setter
    def X4Y9(self, value: float) -> None: ...
    @property
    def X3Y10(self) -> float: ...
    @X3Y10.setter
    def X3Y10(self, value: float) -> None: ...
    @property
    def X2Y11(self) -> float: ...
    @X2Y11.setter
    def X2Y11(self, value: float) -> None: ...
    @property
    def X1Y12(self) -> float: ...
    @X1Y12.setter
    def X1Y12(self, value: float) -> None: ...
    @property
    def X0Y13(self) -> float: ...
    @X0Y13.setter
    def X0Y13(self, value: float) -> None: ...
    @property
    def X14Y0(self) -> float: ...
    @X14Y0.setter
    def X14Y0(self, value: float) -> None: ...
    @property
    def X13Y1(self) -> float: ...
    @X13Y1.setter
    def X13Y1(self, value: float) -> None: ...
    @property
    def X12Y2(self) -> float: ...
    @X12Y2.setter
    def X12Y2(self, value: float) -> None: ...
    @property
    def X11Y3(self) -> float: ...
    @X11Y3.setter
    def X11Y3(self, value: float) -> None: ...
    @property
    def X10Y4(self) -> float: ...
    @X10Y4.setter
    def X10Y4(self, value: float) -> None: ...
    @property
    def X9Y5(self) -> float: ...
    @X9Y5.setter
    def X9Y5(self, value: float) -> None: ...
    @property
    def X8Y6(self) -> float: ...
    @X8Y6.setter
    def X8Y6(self, value: float) -> None: ...
    @property
    def X7Y7(self) -> float: ...
    @X7Y7.setter
    def X7Y7(self, value: float) -> None: ...
    @property
    def X6Y8(self) -> float: ...
    @X6Y8.setter
    def X6Y8(self, value: float) -> None: ...
    @property
    def X5Y9(self) -> float: ...
    @X5Y9.setter
    def X5Y9(self, value: float) -> None: ...
    @property
    def X4Y10(self) -> float: ...
    @X4Y10.setter
    def X4Y10(self, value: float) -> None: ...
    @property
    def X3Y11(self) -> float: ...
    @X3Y11.setter
    def X3Y11(self, value: float) -> None: ...
    @property
    def X2Y12(self) -> float: ...
    @X2Y12.setter
    def X2Y12(self, value: float) -> None: ...
    @property
    def X1Y13(self) -> float: ...
    @X1Y13.setter
    def X1Y13(self, value: float) -> None: ...
    @property
    def X0Y14(self) -> float: ...
    @X0Y14.setter
    def X0Y14(self, value: float) -> None: ...
    @property
    def X15Y0(self) -> float: ...
    @X15Y0.setter
    def X15Y0(self, value: float) -> None: ...
    @property
    def X14Y1(self) -> float: ...
    @X14Y1.setter
    def X14Y1(self, value: float) -> None: ...
    @property
    def X13Y2(self) -> float: ...
    @X13Y2.setter
    def X13Y2(self, value: float) -> None: ...
    @property
    def X12Y3(self) -> float: ...
    @X12Y3.setter
    def X12Y3(self, value: float) -> None: ...
    @property
    def X11Y4(self) -> float: ...
    @X11Y4.setter
    def X11Y4(self, value: float) -> None: ...
    @property
    def X10Y5(self) -> float: ...
    @X10Y5.setter
    def X10Y5(self, value: float) -> None: ...
    @property
    def X9Y6(self) -> float: ...
    @X9Y6.setter
    def X9Y6(self, value: float) -> None: ...
    @property
    def X8Y7(self) -> float: ...
    @X8Y7.setter
    def X8Y7(self, value: float) -> None: ...
    @property
    def X7Y8(self) -> float: ...
    @X7Y8.setter
    def X7Y8(self, value: float) -> None: ...
    @property
    def X6Y9(self) -> float: ...
    @X6Y9.setter
    def X6Y9(self, value: float) -> None: ...
    @property
    def X5Y10(self) -> float: ...
    @X5Y10.setter
    def X5Y10(self, value: float) -> None: ...
    @property
    def X4Y11(self) -> float: ...
    @X4Y11.setter
    def X4Y11(self, value: float) -> None: ...
    @property
    def X3Y12(self) -> float: ...
    @X3Y12.setter
    def X3Y12(self, value: float) -> None: ...
    @property
    def X2Y13(self) -> float: ...
    @X2Y13.setter
    def X2Y13(self, value: float) -> None: ...
    @property
    def X1Y14(self) -> float: ...
    @X1Y14.setter
    def X1Y14(self, value: float) -> None: ...
    @property
    def X0Y15(self) -> float: ...
    @X0Y15.setter
    def X0Y15(self, value: float) -> None: ...
    @property
    def X16Y0(self) -> float: ...
    @X16Y0.setter
    def X16Y0(self, value: float) -> None: ...
    @property
    def X15Y1(self) -> float: ...
    @X15Y1.setter
    def X15Y1(self, value: float) -> None: ...
    @property
    def X14Y2(self) -> float: ...
    @X14Y2.setter
    def X14Y2(self, value: float) -> None: ...
    @property
    def X13Y3(self) -> float: ...
    @X13Y3.setter
    def X13Y3(self, value: float) -> None: ...
    @property
    def X12Y4(self) -> float: ...
    @X12Y4.setter
    def X12Y4(self, value: float) -> None: ...
    @property
    def X11Y5(self) -> float: ...
    @X11Y5.setter
    def X11Y5(self, value: float) -> None: ...
    @property
    def X10Y6(self) -> float: ...
    @X10Y6.setter
    def X10Y6(self, value: float) -> None: ...
    @property
    def X9Y7(self) -> float: ...
    @X9Y7.setter
    def X9Y7(self, value: float) -> None: ...
    @property
    def X8Y8(self) -> float: ...
    @X8Y8.setter
    def X8Y8(self, value: float) -> None: ...
    @property
    def X7Y9(self) -> float: ...
    @X7Y9.setter
    def X7Y9(self, value: float) -> None: ...
    @property
    def X6Y10(self) -> float: ...
    @X6Y10.setter
    def X6Y10(self, value: float) -> None: ...
    @property
    def X5Y11(self) -> float: ...
    @X5Y11.setter
    def X5Y11(self, value: float) -> None: ...
    @property
    def X4Y12(self) -> float: ...
    @X4Y12.setter
    def X4Y12(self, value: float) -> None: ...
    @property
    def X3Y13(self) -> float: ...
    @X3Y13.setter
    def X3Y13(self, value: float) -> None: ...
    @property
    def X2Y14(self) -> float: ...
    @X2Y14.setter
    def X2Y14(self, value: float) -> None: ...
    @property
    def X1Y15(self) -> float: ...
    @X1Y15.setter
    def X1Y15(self, value: float) -> None: ...
    @property
    def X0Y16(self) -> float: ...
    @X0Y16.setter
    def X0Y16(self, value: float) -> None: ...
    @property
    def X17Y0(self) -> float: ...
    @X17Y0.setter
    def X17Y0(self, value: float) -> None: ...
    @property
    def X16Y1(self) -> float: ...
    @X16Y1.setter
    def X16Y1(self, value: float) -> None: ...
    @property
    def X15Y2(self) -> float: ...
    @X15Y2.setter
    def X15Y2(self, value: float) -> None: ...
    @property
    def X14Y3(self) -> float: ...
    @X14Y3.setter
    def X14Y3(self, value: float) -> None: ...
    @property
    def X13Y4(self) -> float: ...
    @X13Y4.setter
    def X13Y4(self, value: float) -> None: ...
    @property
    def X12Y5(self) -> float: ...
    @X12Y5.setter
    def X12Y5(self, value: float) -> None: ...
    @property
    def X11Y6(self) -> float: ...
    @X11Y6.setter
    def X11Y6(self, value: float) -> None: ...
    @property
    def X10Y7(self) -> float: ...
    @X10Y7.setter
    def X10Y7(self, value: float) -> None: ...
    @property
    def X9Y8(self) -> float: ...
    @X9Y8.setter
    def X9Y8(self, value: float) -> None: ...
    @property
    def X8Y9(self) -> float: ...
    @X8Y9.setter
    def X8Y9(self, value: float) -> None: ...
    @property
    def X7Y10(self) -> float: ...
    @X7Y10.setter
    def X7Y10(self, value: float) -> None: ...
    @property
    def X6Y11(self) -> float: ...
    @X6Y11.setter
    def X6Y11(self, value: float) -> None: ...
    @property
    def X5Y12(self) -> float: ...
    @X5Y12.setter
    def X5Y12(self, value: float) -> None: ...
    @property
    def X4Y13(self) -> float: ...
    @X4Y13.setter
    def X4Y13(self, value: float) -> None: ...
    @property
    def X3Y14(self) -> float: ...
    @X3Y14.setter
    def X3Y14(self, value: float) -> None: ...
    @property
    def X2Y15(self) -> float: ...
    @X2Y15.setter
    def X2Y15(self, value: float) -> None: ...
    @property
    def X1Y16(self) -> float: ...
    @X1Y16.setter
    def X1Y16(self, value: float) -> None: ...
    @property
    def X0Y17(self) -> float: ...
    @X0Y17.setter
    def X0Y17(self, value: float) -> None: ...
    @property
    def X18Y0(self) -> float: ...
    @X18Y0.setter
    def X18Y0(self, value: float) -> None: ...
    @property
    def X17Y1(self) -> float: ...
    @X17Y1.setter
    def X17Y1(self, value: float) -> None: ...
    @property
    def X16Y2(self) -> float: ...
    @X16Y2.setter
    def X16Y2(self, value: float) -> None: ...
    @property
    def X15Y3(self) -> float: ...
    @X15Y3.setter
    def X15Y3(self, value: float) -> None: ...
    @property
    def X14Y4(self) -> float: ...
    @X14Y4.setter
    def X14Y4(self, value: float) -> None: ...
    @property
    def X13Y5(self) -> float: ...
    @X13Y5.setter
    def X13Y5(self, value: float) -> None: ...
    @property
    def X12Y6(self) -> float: ...
    @X12Y6.setter
    def X12Y6(self, value: float) -> None: ...
    @property
    def X11Y7(self) -> float: ...
    @X11Y7.setter
    def X11Y7(self, value: float) -> None: ...
    @property
    def X10Y8(self) -> float: ...
    @X10Y8.setter
    def X10Y8(self, value: float) -> None: ...
    @property
    def X9Y9(self) -> float: ...
    @X9Y9.setter
    def X9Y9(self, value: float) -> None: ...
    @property
    def X8Y10(self) -> float: ...
    @X8Y10.setter
    def X8Y10(self, value: float) -> None: ...
    @property
    def X7Y11(self) -> float: ...
    @X7Y11.setter
    def X7Y11(self, value: float) -> None: ...
    @property
    def X6Y12(self) -> float: ...
    @X6Y12.setter
    def X6Y12(self, value: float) -> None: ...
    @property
    def X5Y13(self) -> float: ...
    @X5Y13.setter
    def X5Y13(self, value: float) -> None: ...
    @property
    def X4Y14(self) -> float: ...
    @X4Y14.setter
    def X4Y14(self, value: float) -> None: ...
    @property
    def X3Y15(self) -> float: ...
    @X3Y15.setter
    def X3Y15(self, value: float) -> None: ...
    @property
    def X2Y16(self) -> float: ...
    @X2Y16.setter
    def X2Y16(self, value: float) -> None: ...
    @property
    def X1Y17(self) -> float: ...
    @X1Y17.setter
    def X1Y17(self, value: float) -> None: ...
    @property
    def X0Y18(self) -> float: ...
    @X0Y18.setter
    def X0Y18(self, value: float) -> None: ...
    @property
    def X19Y0(self) -> float: ...
    @X19Y0.setter
    def X19Y0(self, value: float) -> None: ...
    @property
    def X18Y1(self) -> float: ...
    @X18Y1.setter
    def X18Y1(self, value: float) -> None: ...
    @property
    def X17Y2(self) -> float: ...
    @X17Y2.setter
    def X17Y2(self, value: float) -> None: ...
    @property
    def X16Y3(self) -> float: ...
    @X16Y3.setter
    def X16Y3(self, value: float) -> None: ...
    @property
    def X15Y4(self) -> float: ...
    @X15Y4.setter
    def X15Y4(self, value: float) -> None: ...
    @property
    def X14Y5(self) -> float: ...
    @X14Y5.setter
    def X14Y5(self, value: float) -> None: ...
    @property
    def X13Y6(self) -> float: ...
    @X13Y6.setter
    def X13Y6(self, value: float) -> None: ...
    @property
    def X12Y7(self) -> float: ...
    @X12Y7.setter
    def X12Y7(self, value: float) -> None: ...
    @property
    def X11Y8(self) -> float: ...
    @X11Y8.setter
    def X11Y8(self, value: float) -> None: ...
    @property
    def X10Y9(self) -> float: ...
    @X10Y9.setter
    def X10Y9(self, value: float) -> None: ...
    @property
    def X9Y10(self) -> float: ...
    @X9Y10.setter
    def X9Y10(self, value: float) -> None: ...
    @property
    def X8Y11(self) -> float: ...
    @X8Y11.setter
    def X8Y11(self, value: float) -> None: ...
    @property
    def X7Y12(self) -> float: ...
    @X7Y12.setter
    def X7Y12(self, value: float) -> None: ...
    @property
    def X6Y13(self) -> float: ...
    @X6Y13.setter
    def X6Y13(self, value: float) -> None: ...
    @property
    def X5Y14(self) -> float: ...
    @X5Y14.setter
    def X5Y14(self, value: float) -> None: ...
    @property
    def X4Y15(self) -> float: ...
    @X4Y15.setter
    def X4Y15(self, value: float) -> None: ...
    @property
    def X3Y16(self) -> float: ...
    @X3Y16.setter
    def X3Y16(self, value: float) -> None: ...
    @property
    def X2Y17(self) -> float: ...
    @X2Y17.setter
    def X2Y17(self, value: float) -> None: ...
    @property
    def X1Y18(self) -> float: ...
    @X1Y18.setter
    def X1Y18(self, value: float) -> None: ...
    @property
    def X0Y19(self) -> float: ...
    @X0Y19.setter
    def X0Y19(self, value: float) -> None: ...
    @property
    def X20Y0(self) -> float: ...
    @X20Y0.setter
    def X20Y0(self, value: float) -> None: ...
    @property
    def X19Y1(self) -> float: ...
    @X19Y1.setter
    def X19Y1(self, value: float) -> None: ...
    @property
    def X18Y2(self) -> float: ...
    @X18Y2.setter
    def X18Y2(self, value: float) -> None: ...
    @property
    def X17Y3(self) -> float: ...
    @X17Y3.setter
    def X17Y3(self, value: float) -> None: ...
    @property
    def X16Y4(self) -> float: ...
    @X16Y4.setter
    def X16Y4(self, value: float) -> None: ...
    @property
    def X15Y5(self) -> float: ...
    @X15Y5.setter
    def X15Y5(self, value: float) -> None: ...
    @property
    def X14Y6(self) -> float: ...
    @X14Y6.setter
    def X14Y6(self, value: float) -> None: ...
    @property
    def X13Y7(self) -> float: ...
    @X13Y7.setter
    def X13Y7(self, value: float) -> None: ...
    @property
    def X12Y8(self) -> float: ...
    @X12Y8.setter
    def X12Y8(self, value: float) -> None: ...
    @property
    def X11Y9(self) -> float: ...
    @X11Y9.setter
    def X11Y9(self, value: float) -> None: ...
    @property
    def X10Y10(self) -> float: ...
    @X10Y10.setter
    def X10Y10(self, value: float) -> None: ...
    @property
    def X9Y11(self) -> float: ...
    @X9Y11.setter
    def X9Y11(self, value: float) -> None: ...
    @property
    def X8Y12(self) -> float: ...
    @X8Y12.setter
    def X8Y12(self, value: float) -> None: ...
    @property
    def X7Y13(self) -> float: ...
    @X7Y13.setter
    def X7Y13(self, value: float) -> None: ...
    @property
    def X6Y14(self) -> float: ...
    @X6Y14.setter
    def X6Y14(self, value: float) -> None: ...
    @property
    def X5Y15(self) -> float: ...
    @X5Y15.setter
    def X5Y15(self, value: float) -> None: ...
    @property
    def X4Y16(self) -> float: ...
    @X4Y16.setter
    def X4Y16(self, value: float) -> None: ...
    @property
    def X3Y17(self) -> float: ...
    @X3Y17.setter
    def X3Y17(self, value: float) -> None: ...
    @property
    def X2Y18(self) -> float: ...
    @X2Y18.setter
    def X2Y18(self, value: float) -> None: ...
    @property
    def X1Y19(self) -> float: ...
    @X1Y19.setter
    def X1Y19(self, value: float) -> None: ...
    @property
    def X0Y20(self) -> float: ...
    @X0Y20.setter
    def X0Y20(self, value: float) -> None: ...
    @property
    def X21Y0(self) -> float: ...
    @X21Y0.setter
    def X21Y0(self, value: float) -> None: ...
    @property
    def X20Y1(self) -> float: ...
    @X20Y1.setter
    def X20Y1(self, value: float) -> None: ...
    @property
    def X19Y2(self) -> float: ...
    @X19Y2.setter
    def X19Y2(self, value: float) -> None: ...
    @property
    def X18Y3(self) -> float: ...
    @X18Y3.setter
    def X18Y3(self, value: float) -> None: ...
    @property
    def X17Y4(self) -> float: ...
    @X17Y4.setter
    def X17Y4(self, value: float) -> None: ...
    @property
    def X16Y5(self) -> float: ...
    @X16Y5.setter
    def X16Y5(self, value: float) -> None: ...
    @property
    def X15Y6(self) -> float: ...
    @X15Y6.setter
    def X15Y6(self, value: float) -> None: ...
    @property
    def X14Y7(self) -> float: ...
    @X14Y7.setter
    def X14Y7(self, value: float) -> None: ...
    @property
    def X13Y8(self) -> float: ...
    @X13Y8.setter
    def X13Y8(self, value: float) -> None: ...
    @property
    def X12Y9(self) -> float: ...
    @X12Y9.setter
    def X12Y9(self, value: float) -> None: ...
    @property
    def X11Y10(self) -> float: ...
    @X11Y10.setter
    def X11Y10(self, value: float) -> None: ...
    @property
    def X10Y11(self) -> float: ...
    @X10Y11.setter
    def X10Y11(self, value: float) -> None: ...
    @property
    def X9Y12(self) -> float: ...
    @X9Y12.setter
    def X9Y12(self, value: float) -> None: ...
    @property
    def X8Y13(self) -> float: ...
    @X8Y13.setter
    def X8Y13(self, value: float) -> None: ...
    @property
    def X7Y14(self) -> float: ...
    @X7Y14.setter
    def X7Y14(self, value: float) -> None: ...
    @property
    def X6Y15(self) -> float: ...
    @X6Y15.setter
    def X6Y15(self, value: float) -> None: ...
    @property
    def X5Y16(self) -> float: ...
    @X5Y16.setter
    def X5Y16(self, value: float) -> None: ...
    @property
    def X4Y17(self) -> float: ...
    @X4Y17.setter
    def X4Y17(self, value: float) -> None: ...
    @property
    def X3Y18(self) -> float: ...
    @X3Y18.setter
    def X3Y18(self, value: float) -> None: ...
    @property
    def X2Y19(self) -> float: ...
    @X2Y19.setter
    def X2Y19(self, value: float) -> None: ...

class ISurfaceFresnel(ISurfaceNthEvenOrderTerms, ISurface):
    pass

class ISurfaceGeneralizedFresnel(ISurfaceXYPolynomial, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceGradient1(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr1Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def Nr2(self) -> float: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @property
    def Nr1(self) -> float: ...
    @Nr1.setter
    def Nr1(self, value: float) -> None: ...

class ISurfaceGradient10(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Ny1Cell(self) -> IEditorCell: ...
    @property
    def Ny2Cell(self) -> IEditorCell: ...
    @property
    def Ny3Cell(self) -> IEditorCell: ...
    @property
    def Ny4Cell(self) -> IEditorCell: ...
    @property
    def Ny5Cell(self) -> IEditorCell: ...
    @property
    def Ny6Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def Ny1(self) -> float: ...
    @Ny1.setter
    def Ny1(self, value: float) -> None: ...
    @property
    def Ny2(self) -> float: ...
    @Ny2.setter
    def Ny2(self, value: float) -> None: ...
    @property
    def Ny3(self) -> float: ...
    @Ny3.setter
    def Ny3(self, value: float) -> None: ...
    @property
    def Ny4(self) -> float: ...
    @Ny4.setter
    def Ny4(self, value: float) -> None: ...
    @property
    def Ny5(self) -> float: ...
    @Ny5.setter
    def Ny5(self, value: float) -> None: ...
    @property
    def Ny6(self) -> float: ...
    @Ny6.setter
    def Ny6(self, value: float) -> None: ...

class ISurfaceGradient12(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def Order(self) -> int: ...
    @Order.setter
    def Order(self, value: int) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    def GetNthNx(self, n: int) -> float: ...
    def GetNthNy(self, n: int) -> float: ...
    def GetNthNz(self, n: int) -> float: ...
    def NthNxCell(self, n: int) -> IEditorCell: ...
    def NthNyCell(self, n: int) -> IEditorCell: ...
    def NthNzCell(self, n: int) -> IEditorCell: ...
    def SetNthNx(self, n: int, Value: float) -> None: ...
    def SetNthNy(self, n: int, Value: float) -> None: ...
    def SetNthNz(self, n: int, Value: float) -> None: ...

class ISurfaceGradient2(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr4Cell(self) -> IEditorCell: ...
    @property
    def Nr6Cell(self) -> IEditorCell: ...
    @property
    def Nr8Cell(self) -> IEditorCell: ...
    @property
    def Nr10Cell(self) -> IEditorCell: ...
    @property
    def Nr12Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def Nr2(self) -> float: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @property
    def Nr4(self) -> float: ...
    @Nr4.setter
    def Nr4(self, value: float) -> None: ...
    @property
    def Nr6(self) -> float: ...
    @Nr6.setter
    def Nr6(self, value: float) -> None: ...
    @property
    def Nr8(self) -> float: ...
    @Nr8.setter
    def Nr8(self, value: float) -> None: ...
    @property
    def Nr10(self) -> float: ...
    @Nr10.setter
    def Nr10(self, value: float) -> None: ...
    @property
    def Nr12(self) -> float: ...
    @Nr12.setter
    def Nr12(self, value: float) -> None: ...

class ISurfaceGradient3(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr4Cell(self) -> IEditorCell: ...
    @property
    def Nr6Cell(self) -> IEditorCell: ...
    @property
    def Nz1Cell(self) -> IEditorCell: ...
    @property
    def Nz2Cell(self) -> IEditorCell: ...
    @property
    def Nz3Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def Nr2(self) -> float: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @property
    def Nr4(self) -> float: ...
    @Nr4.setter
    def Nr4(self, value: float) -> None: ...
    @property
    def Nr6(self) -> float: ...
    @Nr6.setter
    def Nr6(self, value: float) -> None: ...
    @property
    def Nz1(self) -> float: ...
    @Nz1.setter
    def Nz1(self, value: float) -> None: ...
    @property
    def Nz2(self) -> float: ...
    @Nz2.setter
    def Nz2(self, value: float) -> None: ...
    @property
    def Nz3(self) -> float: ...
    @Nz3.setter
    def Nz3(self, value: float) -> None: ...

class ISurfaceGradient4(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nx1Cell(self) -> IEditorCell: ...
    @property
    def Nx2Cell(self) -> IEditorCell: ...
    @property
    def Ny1Cell(self) -> IEditorCell: ...
    @property
    def Ny2Cell(self) -> IEditorCell: ...
    @property
    def Nz1Cell(self) -> IEditorCell: ...
    @property
    def Nz2Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def Nx1(self) -> float: ...
    @Nx1.setter
    def Nx1(self, value: float) -> None: ...
    @property
    def Nx2(self) -> float: ...
    @Nx2.setter
    def Nx2(self, value: float) -> None: ...
    @property
    def Ny1(self) -> float: ...
    @Ny1.setter
    def Ny1(self, value: float) -> None: ...
    @property
    def Ny2(self) -> float: ...
    @Ny2.setter
    def Ny2(self, value: float) -> None: ...
    @property
    def Nz1(self) -> float: ...
    @Nz1.setter
    def Nz1(self, value: float) -> None: ...
    @property
    def Nz2(self) -> float: ...
    @Nz2.setter
    def Nz2(self, value: float) -> None: ...

class ISurfaceGradient5(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr4Cell(self) -> IEditorCell: ...
    @property
    def Nz1Cell(self) -> IEditorCell: ...
    @property
    def Nz2Cell(self) -> IEditorCell: ...
    @property
    def Nz3Cell(self) -> IEditorCell: ...
    @property
    def Nz4Cell(self) -> IEditorCell: ...
    @property
    def X_TangentCell(self) -> IEditorCell: ...
    @property
    def Y_TangentCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def Nr2(self) -> float: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @property
    def Nr4(self) -> float: ...
    @Nr4.setter
    def Nr4(self, value: float) -> None: ...
    @property
    def Nz1(self) -> float: ...
    @Nz1.setter
    def Nz1(self, value: float) -> None: ...
    @property
    def Nz2(self) -> float: ...
    @Nz2.setter
    def Nz2(self, value: float) -> None: ...
    @property
    def Nz3(self) -> float: ...
    @Nz3.setter
    def Nz3(self, value: float) -> None: ...
    @property
    def Nz4(self) -> float: ...
    @Nz4.setter
    def Nz4(self, value: float) -> None: ...
    @property
    def X_Tangent(self) -> float: ...
    @X_Tangent.setter
    def X_Tangent(self, value: float) -> None: ...
    @property
    def Y_Tangent(self) -> float: ...
    @Y_Tangent.setter
    def Y_Tangent(self, value: float) -> None: ...

class ISurfaceGradient6(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...

class ISurfaceGradient7(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def RCell(self) -> IEditorCell: ...
    @property
    def AlphaCell(self) -> IEditorCell: ...
    @property
    def BetaCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def n0(self) -> float: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @property
    def R(self) -> float: ...
    @R.setter
    def R(self, value: float) -> None: ...
    @property
    def Alpha(self) -> float: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @property
    def Beta(self) -> float: ...
    @Beta.setter
    def Beta(self, value: float) -> None: ...

class ISurfaceGradient9(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def X_TangentCell(self) -> IEditorCell: ...
    @property
    def Y_TangentCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def X_Tangent(self) -> float: ...
    @X_Tangent.setter
    def X_Tangent(self, value: float) -> None: ...
    @property
    def Y_Tangent(self) -> float: ...
    @Y_Tangent.setter
    def Y_Tangent(self, value: float) -> None: ...

class ISurfaceGradium(ISurface):
    @property
    def BouleThicknessCell(self) -> IEditorCell: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def DeltaZCell(self) -> IEditorCell: ...
    @property
    def Ref_n_Cell(self) -> IEditorCell: ...
    @property
    def Dec_x_Cell(self) -> IEditorCell: ...
    @property
    def Dec_y_Cell(self) -> IEditorCell: ...
    @property
    def Tilt_x_Cell(self) -> IEditorCell: ...
    @property
    def Tilt_y_Cell(self) -> IEditorCell: ...
    @property
    def CappingCell(self) -> IEditorCell: ...
    @property
    def BouleThickness(self) -> float: ...
    @BouleThickness.setter
    def BouleThickness(self, value: float) -> None: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @property
    def DeltaZ(self) -> float: ...
    @DeltaZ.setter
    def DeltaZ(self, value: float) -> None: ...
    @property
    def Ref_n(self) -> float: ...
    @Ref_n.setter
    def Ref_n(self, value: float) -> None: ...
    @property
    def Dec_x(self) -> float: ...
    @Dec_x.setter
    def Dec_x(self, value: float) -> None: ...
    @property
    def Dec_y(self) -> float: ...
    @Dec_y.setter
    def Dec_y(self, value: float) -> None: ...
    @property
    def Tilt_x(self) -> float: ...
    @Tilt_x.setter
    def Tilt_x(self, value: float) -> None: ...
    @property
    def Tilt_y(self) -> float: ...
    @Tilt_y.setter
    def Tilt_y(self, value: float) -> None: ...
    @property
    def Capping(self) -> float: ...
    @Capping.setter
    def Capping(self, value: float) -> None: ...

class ISurfaceGridGradient(ISurface):
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...

class ISurfaceGridPhase(ISurface):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def ShearDistanceCell(self) -> IEditorCell: ...
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def ShearDistance(self) -> float: ...
    @ShearDistance.setter
    def ShearDistance(self, value: float) -> None: ...
    @property
    def Interpolate(self) -> InterpolationMethod: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolationMethod) -> None: ...

class ISurfaceGridSag(ISurfaceNthEvenOrderTerms, ISurface, ISurfaceNthZernike):
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def Interpolate(self) -> InterpolationMethod: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolationMethod) -> None: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceHologram1(ISurface):
    @property
    def Construct_X1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_X2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z2_Cell(self) -> IEditorCell: ...
    @property
    def ConstructWaveCell(self) -> IEditorCell: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def Construct_X1(self) -> float: ...
    @Construct_X1.setter
    def Construct_X1(self, value: float) -> None: ...
    @property
    def Construct_Y1(self) -> float: ...
    @Construct_Y1.setter
    def Construct_Y1(self, value: float) -> None: ...
    @property
    def Construct_Z1(self) -> float: ...
    @Construct_Z1.setter
    def Construct_Z1(self, value: float) -> None: ...
    @property
    def Construct_X2(self) -> float: ...
    @Construct_X2.setter
    def Construct_X2(self, value: float) -> None: ...
    @property
    def Construct_Y2(self) -> float: ...
    @Construct_Y2.setter
    def Construct_Y2(self, value: float) -> None: ...
    @property
    def Construct_Z2(self) -> float: ...
    @Construct_Z2.setter
    def Construct_Z2(self, value: float) -> None: ...
    @property
    def ConstructWave(self) -> float: ...
    @ConstructWave.setter
    def ConstructWave(self, value: float) -> None: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n1(self) -> float: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @property
    def n2(self) -> float: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...

class ISurfaceHologram2(ISurface):
    @property
    def Construct_X1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_X2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z2_Cell(self) -> IEditorCell: ...
    @property
    def ConstructWaveCell(self) -> IEditorCell: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def Construct_X1(self) -> float: ...
    @Construct_X1.setter
    def Construct_X1(self, value: float) -> None: ...
    @property
    def Construct_Y1(self) -> float: ...
    @Construct_Y1.setter
    def Construct_Y1(self, value: float) -> None: ...
    @property
    def Construct_Z1(self) -> float: ...
    @Construct_Z1.setter
    def Construct_Z1(self, value: float) -> None: ...
    @property
    def Construct_X2(self) -> float: ...
    @Construct_X2.setter
    def Construct_X2(self, value: float) -> None: ...
    @property
    def Construct_Y2(self) -> float: ...
    @Construct_Y2.setter
    def Construct_Y2(self, value: float) -> None: ...
    @property
    def Construct_Z2(self) -> float: ...
    @Construct_Z2.setter
    def Construct_Z2(self, value: float) -> None: ...
    @property
    def ConstructWave(self) -> float: ...
    @ConstructWave.setter
    def ConstructWave(self, value: float) -> None: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n1(self) -> float: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @property
    def n2(self) -> float: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...

class ISurfaceIrregular(ISurface):
    @property
    def Decenter_X_Cell(self) -> IEditorCell: ...
    @property
    def Decenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_X_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_Y_Cell(self) -> IEditorCell: ...
    @property
    def SphericalCell(self) -> IEditorCell: ...
    @property
    def AstigmatismCell(self) -> IEditorCell: ...
    @property
    def ComaCell(self) -> IEditorCell: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def Decenter_X(self) -> float: ...
    @Decenter_X.setter
    def Decenter_X(self, value: float) -> None: ...
    @property
    def Decenter_Y(self) -> float: ...
    @Decenter_Y.setter
    def Decenter_Y(self, value: float) -> None: ...
    @property
    def TiltAbout_X(self) -> float: ...
    @TiltAbout_X.setter
    def TiltAbout_X(self, value: float) -> None: ...
    @property
    def TiltAbout_Y(self) -> float: ...
    @TiltAbout_Y.setter
    def TiltAbout_Y(self, value: float) -> None: ...
    @property
    def Spherical(self) -> float: ...
    @Spherical.setter
    def Spherical(self, value: float) -> None: ...
    @property
    def Astigmatism(self) -> float: ...
    @Astigmatism.setter
    def Astigmatism(self, value: float) -> None: ...
    @property
    def Coma(self) -> float: ...
    @Coma.setter
    def Coma(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...

class ISurfaceJonesMatrix(ISurface):
    @property
    def Ar_Cell(self) -> IEditorCell: ...
    @property
    def Ai_Cell(self) -> IEditorCell: ...
    @property
    def Br_Cell(self) -> IEditorCell: ...
    @property
    def Bi_Cell(self) -> IEditorCell: ...
    @property
    def Cr_Cell(self) -> IEditorCell: ...
    @property
    def Ci_Cell(self) -> IEditorCell: ...
    @property
    def Dr_Cell(self) -> IEditorCell: ...
    @property
    def Di_Cell(self) -> IEditorCell: ...
    @property
    def Ar(self) -> float: ...
    @Ar.setter
    def Ar(self, value: float) -> None: ...
    @property
    def Ai(self) -> float: ...
    @Ai.setter
    def Ai(self, value: float) -> None: ...
    @property
    def Br(self) -> float: ...
    @Br.setter
    def Br(self, value: float) -> None: ...
    @property
    def Bi(self) -> float: ...
    @Bi.setter
    def Bi(self, value: float) -> None: ...
    @property
    def Cr(self) -> float: ...
    @Cr.setter
    def Cr(self, value: float) -> None: ...
    @property
    def Ci(self) -> float: ...
    @Ci.setter
    def Ci(self, value: float) -> None: ...
    @property
    def Dr(self) -> float: ...
    @Dr.setter
    def Dr(self, value: float) -> None: ...
    @property
    def Di(self) -> float: ...
    @Di.setter
    def Di(self, value: float) -> None: ...

class ISurfaceNonSequential(ISurface):
    @property
    def DrawPortsCell(self) -> IEditorCell: ...
    @property
    def ExitLocation_X_Cell(self) -> IEditorCell: ...
    @property
    def ExitLocation_Y_Cell(self) -> IEditorCell: ...
    @property
    def ExitLocation_Z_Cell(self) -> IEditorCell: ...
    @property
    def ExitTilt_X_Cell(self) -> IEditorCell: ...
    @property
    def ExitTilt_Y_Cell(self) -> IEditorCell: ...
    @property
    def ExitTilt_Z_Cell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def ReverseRaysCell(self) -> IEditorCell: ...
    @property
    def DrawPorts(self) -> int: ...
    @DrawPorts.setter
    def DrawPorts(self, value: int) -> None: ...
    @property
    def ExitLocation_X(self) -> float: ...
    @ExitLocation_X.setter
    def ExitLocation_X(self, value: float) -> None: ...
    @property
    def ExitLocation_Y(self) -> float: ...
    @ExitLocation_Y.setter
    def ExitLocation_Y(self, value: float) -> None: ...
    @property
    def ExitLocation_Z(self) -> float: ...
    @ExitLocation_Z.setter
    def ExitLocation_Z(self, value: float) -> None: ...
    @property
    def ExitTilt_X(self) -> float: ...
    @ExitTilt_X.setter
    def ExitTilt_X(self, value: float) -> None: ...
    @property
    def ExitTilt_Y(self) -> float: ...
    @ExitTilt_Y.setter
    def ExitTilt_Y(self, value: float) -> None: ...
    @property
    def ExitTilt_Z(self) -> float: ...
    @ExitTilt_Z.setter
    def ExitTilt_Z(self, value: float) -> None: ...
    @property
    def Order(self) -> int: ...
    @Order.setter
    def Order(self, value: int) -> None: ...
    @property
    def ReverseRays(self) -> int: ...
    @ReverseRays.setter
    def ReverseRays(self, value: int) -> None: ...

class ISurfaceNthEvenOrderTerms(ISurface):
    def GetNthEvenOrderTerm(self, n: int) -> float: ...
    def NthEvenOrderTermCell(self, n: int) -> IEditorCell: ...
    def SetNthEvenOrderTerm(self, n: int, Value: float) -> None: ...

class ISurfaceNthOrderTerms(ISurface):
    def GetNthOrderTerm(self, n: int) -> float: ...
    def NthOrderTermCell(self, n: int) -> IEditorCell: ...
    def SetNthOrderTerm(self, n: int, Value: float) -> None: ...

class ISurfaceNthThickness(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetNthThickness(self, n: int) -> float: ...
    def NthThicknessCell(self, n: int) -> IEditorCell: ...
    def SetNthThickness(self, n: int, Value: float) -> None: ...

class ISurfaceNthZernike(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetNthZernikeCoefficient(self, n: int) -> float: ...
    def NthZernikeCoefficientCell(self, n: int) -> IEditorCell: ...
    def SetNthZernikeCoefficient(self, n: int, Value: float) -> None: ...

class ISurfaceOddAsphere(ISurfaceNthOrderTerms, ISurface):
    pass

class ISurfaceOddCosine(ISurfaceCoeff_R_NthPower, ISurface, ISurfaceAPBC):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceOffAxisConicFreeform(ISurfaceXYPolynomial, ISurface):
    @property
    def OffsetCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Offset(self) -> float: ...
    @Offset.setter
    def Offset(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceOpticallyFabricatedHologram(ISurfaceXYPolynomial, ISurface):
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def HologramTypeCell(self) -> IEditorCell: ...
    @property
    def OPDModeCell(self) -> IEditorCell: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Rotation_R_Cell(self) -> IEditorCell: ...
    @property
    def aCell(self) -> IEditorCell: ...
    @property
    def bCell(self) -> IEditorCell: ...
    @property
    def cCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> int: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @property
    def HologramType(self) -> int: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @property
    def OPDMode(self) -> int: ...
    @OPDMode.setter
    def OPDMode(self, value: int) -> None: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def Curvature(self) -> float: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def Rotation_R(self) -> float: ...
    @Rotation_R.setter
    def Rotation_R(self, value: float) -> None: ...
    @property
    def a(self) -> float: ...
    @a.setter
    def a(self, value: float) -> None: ...
    @property
    def b(self) -> float: ...
    @b.setter
    def b(self, value: float) -> None: ...
    @property
    def c(self) -> float: ...
    @c.setter
    def c(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...

class ISurfaceParaxial(ISurface):
    @property
    def FocalLengthCell(self) -> IEditorCell: ...
    @property
    def OPDModeCell(self) -> IEditorCell: ...
    @property
    def FocalLength(self) -> float: ...
    @FocalLength.setter
    def FocalLength(self, value: float) -> None: ...
    @property
    def OPDMode(self) -> int: ...
    @OPDMode.setter
    def OPDMode(self, value: int) -> None: ...

class ISurfaceParaxialXY(ISurface):
    @property
    def X_PowerCell(self) -> IEditorCell: ...
    @property
    def Y_PowerCell(self) -> IEditorCell: ...
    @property
    def X_Power(self) -> float: ...
    @X_Power.setter
    def X_Power(self, value: float) -> None: ...
    @property
    def Y_Power(self) -> float: ...
    @Y_Power.setter
    def Y_Power(self, value: float) -> None: ...

class ISurfacePeriodic(ISurface):
    @property
    def AmplitudeCell(self) -> IEditorCell: ...
    @property
    def X_FrequencyCell(self) -> IEditorCell: ...
    @property
    def Y_FrequencyCell(self) -> IEditorCell: ...
    @property
    def Amplitude(self) -> float: ...
    @Amplitude.setter
    def Amplitude(self, value: float) -> None: ...
    @property
    def X_Frequency(self) -> float: ...
    @X_Frequency.setter
    def X_Frequency(self, value: float) -> None: ...
    @property
    def Y_Frequency(self) -> float: ...
    @Y_Frequency.setter
    def Y_Frequency(self, value: float) -> None: ...

class ISurfacePolynomial(ISurfaceCoeff_X_NthEvenPower_8, ISurface, ISurfaceCoeff_Y_NthEvenPower_8):
    pass

class ISurfaceQTypeAsphere(ISurface):
    @property
    def TypeCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def QType(self) -> QTypes: ...
    @QType.setter
    def QType(self, value: QTypes) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def AnCell(self, n: int) -> IEditorCell: ...
    def GetAn(self, n: int) -> float: ...
    def SetAn(self, n: int, Value: float) -> None: ...

class ISurfaceQTypeFreeform(ISurface):
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def MaxPolynomialPowerCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def DecenterX(self) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @property
    def DecenterY(self) -> float: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @property
    def MaxPolynomialPower(self) -> int: ...
    @MaxPolynomialPower.setter
    def MaxPolynomialPower(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def AmnCell(self, m: int, n: int) -> IEditorCell: ...
    def BmnCell(self, m: int, n: int) -> IEditorCell: ...
    def GetAmn(self, m: int, n: int) -> float: ...
    def GetBmn(self, m: int, n: int) -> float: ...
    def SetAmn(self, m: int, n: int, Value: float) -> None: ...
    def SetBmn(self, m: int, n: int, Value: float) -> None: ...

class ISurfaceRadialGrating(ISurfaceNthEvenOrderTerms, ISurface, ISurfaceCoeff_P_NthPower):
    @property
    def DeffractOrderCell(self) -> IEditorCell: ...
    @property
    def GratingModeCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def DeffractOrder(self) -> float: ...
    @DeffractOrder.setter
    def DeffractOrder(self, value: float) -> None: ...
    @property
    def GratingMode(self) -> int: ...
    @GratingMode.setter
    def GratingMode(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceRadialNurbs(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetWn(self, n: int) -> float: ...
    def GetYn(self, n: int) -> float: ...
    def GetZn(self, n: int) -> float: ...
    def SetWn(self, n: int, Value: float) -> None: ...
    def SetYn(self, n: int, Value: float) -> None: ...
    def SetZn(self, n: int, Value: float) -> None: ...
    def WnCell(self, n: int) -> IEditorCell: ...
    def YnCell(self, n: int) -> IEditorCell: ...
    def ZnCell(self, n: int) -> IEditorCell: ...

class ISurfaceRetroReflect(ISurface):
    pass

class ISurfaceScatteringABg(ISurfaceScatteringType):
    @property
    def ABgName(self) -> str: ...
    @ABgName.setter
    def ABgName(self, value: str) -> None: ...
    def GetAvailableABgNames(self) -> list[str]: ...

class ISurfaceScatteringABgFile(ISurfaceScatteringType):
    @property
    def FileName(self) -> str: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...
    def GetAvailableFileNames(self) -> list[str]: ...

class ISurfaceScatteringBSDF(ISurfaceScatteringType):
    @property
    def FileName(self) -> str: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    def GetAvailableFileNames(self) -> list[str]: ...

class ISurfaceScatteringCatalog(ISurfaceScatteringType):
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @property
    def SampleSide(self) -> SampleSides: ...
    @SampleSide.setter
    def SampleSide(self, value: SampleSides) -> None: ...
    @property
    def Sampling(self) -> Samplings: ...
    @Sampling.setter
    def Sampling(self, value: Samplings) -> None: ...
    def GetAvailableFiles(self) -> list[str]: ...
    def GetFile(self) -> str: ...
    def GetSampleSides(self) -> list[SampleSides]: ...
    def SetFile(self, File: str) -> ReflectTransmitCode: ...

class ISurfaceScatteringGaussian(ISurfaceScatteringType):
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @property
    def Sigma(self) -> float: ...
    @Sigma.setter
    def Sigma(self, value: float) -> None: ...

class ISurfaceScatteringLambertian(ISurfaceScatteringType):
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...

class ISurfaceScatteringNone(ISurfaceScatteringType):
    pass

class ISurfaceScatteringType:
    @property
    def Type(self) -> SurfaceScatteringTypes: ...
    @property
    def _S_None(self) -> ISurfaceScatteringNone: ...
    @property
    def _S_Lambertian(self) -> ISurfaceScatteringLambertian: ...
    @property
    def _S_Gaussian(self) -> ISurfaceScatteringGaussian: ...
    @property
    def _S_ABg(self) -> ISurfaceScatteringABg: ...
    @property
    def _S_ABgFile(self) -> ISurfaceScatteringABgFile: ...
    @property
    def _S_BSDF(self) -> ISurfaceScatteringBSDF: ...
    @property
    def _S_User(self) -> ISurfaceScatteringUser: ...
    @property
    def _S_Catalog(self) -> ISurfaceScatteringCatalog: ...

class ISurfaceScatteringUser(ISurfaceScatteringType):
    @property
    def DLLName(self) -> str: ...
    @DLLName.setter
    def DLLName(self, value: str) -> None: ...
    @property
    def NumberOfParameters(self) -> int: ...
    def GetAvailableDLLNames(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class ISurfaceSlide(ISurface):
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def X_HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y_HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Mode(self) -> int: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @property
    def X_HalfWidth(self) -> float: ...
    @X_HalfWidth.setter
    def X_HalfWidth(self, value: float) -> None: ...
    @property
    def Y_HalfWidth(self) -> float: ...
    @Y_HalfWidth.setter
    def Y_HalfWidth(self, value: float) -> None: ...

class ISurfaceStandard(ISurface):
    pass

class ISurfaceSuperconic(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetUn(self, n: int) -> float: ...
    def GetVn(self, n: int) -> float: ...
    def SetUn(self, n: int, Value: float) -> None: ...
    def SetVn(self, n: int, Value: float) -> None: ...
    def UnCell(self, n: int) -> IEditorCell: ...
    def VnCell(self, n: int) -> IEditorCell: ...

class ISurfaceTilted(ISurface):
    @property
    def X_TangentCell(self) -> IEditorCell: ...
    @property
    def Y_TangentCell(self) -> IEditorCell: ...
    @property
    def X_Tangent(self) -> float: ...
    @X_Tangent.setter
    def X_Tangent(self, value: float) -> None: ...
    @property
    def Y_Tangent(self) -> float: ...
    @Y_Tangent.setter
    def Y_Tangent(self, value: float) -> None: ...

class ISurfaceToroidal(ISurfaceNthEvenOrderTerms, ISurface, ISurfaceNthZernike):
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...

class ISurfaceToroidalGrat(ISurface):
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...

class ISurfaceToroidalHologram(ISurfaceNthEvenOrderTerms, ISurface):
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Const_X1_Cell(self) -> IEditorCell: ...
    @property
    def Const_Y1_Cell(self) -> IEditorCell: ...
    @property
    def Const_Z1_Cell(self) -> IEditorCell: ...
    @property
    def Const_X2_Cell(self) -> IEditorCell: ...
    @property
    def Const_Y2_Cell(self) -> IEditorCell: ...
    @property
    def Const_Z2_Cell(self) -> IEditorCell: ...
    @property
    def ConstWaveCell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def FlagCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @property
    def Const_X1(self) -> float: ...
    @Const_X1.setter
    def Const_X1(self, value: float) -> None: ...
    @property
    def Const_Y1(self) -> float: ...
    @Const_Y1.setter
    def Const_Y1(self, value: float) -> None: ...
    @property
    def Const_Z1(self) -> float: ...
    @Const_Z1.setter
    def Const_Z1(self, value: float) -> None: ...
    @property
    def Const_X2(self) -> float: ...
    @Const_X2.setter
    def Const_X2(self, value: float) -> None: ...
    @property
    def Const_Y2(self) -> float: ...
    @Const_Y2.setter
    def Const_Y2(self, value: float) -> None: ...
    @property
    def Const_Z2(self) -> float: ...
    @Const_Z2.setter
    def Const_Z2(self, value: float) -> None: ...
    @property
    def ConstWave(self) -> float: ...
    @ConstWave.setter
    def ConstWave(self, value: float) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def Flag(self) -> int: ...
    @Flag.setter
    def Flag(self, value: int) -> None: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n1(self) -> float: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @property
    def n2(self) -> float: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...

class ISurfaceToroidalNurbs(ISurface):
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Minimum_X_Cell(self) -> IEditorCell: ...
    @property
    def MinimumAngleCell(self) -> IEditorCell: ...
    @property
    def Maximum_X_Cell(self) -> IEditorCell: ...
    @property
    def MaximumAngleCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @property
    def Minimum_X(self) -> float: ...
    @Minimum_X.setter
    def Minimum_X(self, value: float) -> None: ...
    @property
    def MinimumAngle(self) -> float: ...
    @MinimumAngle.setter
    def MinimumAngle(self, value: float) -> None: ...
    @property
    def Maximum_X(self) -> float: ...
    @Maximum_X.setter
    def Maximum_X(self, value: float) -> None: ...
    @property
    def MaximumAngle(self) -> float: ...
    @MaximumAngle.setter
    def MaximumAngle(self, value: float) -> None: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetWn(self, n: int) -> float: ...
    def GetYn(self, n: int) -> float: ...
    def GetZn(self, n: int) -> float: ...
    def SetWn(self, n: int, Value: float) -> None: ...
    def SetYn(self, n: int, Value: float) -> None: ...
    def SetZn(self, n: int, Value: float) -> None: ...
    def WnCell(self, n: int) -> IEditorCell: ...
    def YnCell(self, n: int) -> IEditorCell: ...
    def ZnCell(self, n: int) -> IEditorCell: ...

class ISurfaceTrueFreeform(
    ISurfaceNthEvenOrderTerms, ISurface, ISurfaceFreeformNthZernike, ISurfaceFreeformXYPolynomial
):
    @property
    def NumVariablePointsCell(self) -> IEditorCell: ...
    @property
    def RadiusXCell(self) -> IEditorCell: ...
    @property
    def ConicXCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def RadiusX(self) -> float: ...
    @RadiusX.setter
    def RadiusX(self, value: float) -> None: ...
    @property
    def ConicX(self) -> float: ...
    @ConicX.setter
    def ConicX(self, value: float) -> None: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...
    @property
    def NumVariablePoints(self) -> int: ...

class ISurfaceTypeSettings:
    @property
    def IsValid(self) -> bool: ...
    @property
    def Type(self) -> SurfaceType: ...
    @property
    def RequiresFile(self) -> bool: ...
    @property
    def Filename(self) -> str: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...
    def GetFileNames(self) -> list[str]: ...

class ISurfaceVariableLineSpaceGrating(ISurface):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def FocalRadius_L_Cell(self) -> IEditorCell: ...
    @property
    def CosineAlphaCell(self) -> IEditorCell: ...
    @property
    def CosineBetaCell(self) -> IEditorCell: ...
    @property
    def LambdaZeroCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def FocalRadius_L(self) -> float: ...
    @FocalRadius_L.setter
    def FocalRadius_L(self, value: float) -> None: ...
    @property
    def CosineAlpha(self) -> float: ...
    @CosineAlpha.setter
    def CosineAlpha(self, value: float) -> None: ...
    @property
    def CosineBeta(self) -> float: ...
    @CosineBeta.setter
    def CosineBeta(self, value: float) -> None: ...
    @property
    def LambdaZero(self) -> float: ...
    @LambdaZero.setter
    def LambdaZero(self, value: float) -> None: ...

class ISurfaceXYPolynomial(ISurface):
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def X1Y0Cell(self) -> IEditorCell: ...
    @property
    def X0Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y0Cell(self) -> IEditorCell: ...
    @property
    def X1Y1Cell(self) -> IEditorCell: ...
    @property
    def X0Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y1Cell(self) -> IEditorCell: ...
    @property
    def X1Y2Cell(self) -> IEditorCell: ...
    @property
    def X0Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y0Cell(self) -> IEditorCell: ...
    @property
    def X3Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y3Cell(self) -> IEditorCell: ...
    @property
    def X0Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y0Cell(self) -> IEditorCell: ...
    @property
    def X4Y1Cell(self) -> IEditorCell: ...
    @property
    def X3Y2Cell(self) -> IEditorCell: ...
    @property
    def X2Y3Cell(self) -> IEditorCell: ...
    @property
    def X1Y4Cell(self) -> IEditorCell: ...
    @property
    def X0Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y0Cell(self) -> IEditorCell: ...
    @property
    def X5Y1Cell(self) -> IEditorCell: ...
    @property
    def X4Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y3Cell(self) -> IEditorCell: ...
    @property
    def X2Y4Cell(self) -> IEditorCell: ...
    @property
    def X1Y5Cell(self) -> IEditorCell: ...
    @property
    def X0Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y0Cell(self) -> IEditorCell: ...
    @property
    def X6Y1Cell(self) -> IEditorCell: ...
    @property
    def X5Y2Cell(self) -> IEditorCell: ...
    @property
    def X4Y3Cell(self) -> IEditorCell: ...
    @property
    def X3Y4Cell(self) -> IEditorCell: ...
    @property
    def X2Y5Cell(self) -> IEditorCell: ...
    @property
    def X1Y6Cell(self) -> IEditorCell: ...
    @property
    def X0Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y0Cell(self) -> IEditorCell: ...
    @property
    def X7Y1Cell(self) -> IEditorCell: ...
    @property
    def X6Y2Cell(self) -> IEditorCell: ...
    @property
    def X5Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y4Cell(self) -> IEditorCell: ...
    @property
    def X3Y5Cell(self) -> IEditorCell: ...
    @property
    def X2Y6Cell(self) -> IEditorCell: ...
    @property
    def X1Y7Cell(self) -> IEditorCell: ...
    @property
    def X0Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y0Cell(self) -> IEditorCell: ...
    @property
    def X8Y1Cell(self) -> IEditorCell: ...
    @property
    def X7Y2Cell(self) -> IEditorCell: ...
    @property
    def X6Y3Cell(self) -> IEditorCell: ...
    @property
    def X5Y4Cell(self) -> IEditorCell: ...
    @property
    def X4Y5Cell(self) -> IEditorCell: ...
    @property
    def X3Y6Cell(self) -> IEditorCell: ...
    @property
    def X2Y7Cell(self) -> IEditorCell: ...
    @property
    def X1Y8Cell(self) -> IEditorCell: ...
    @property
    def X0Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y0Cell(self) -> IEditorCell: ...
    @property
    def X9Y1Cell(self) -> IEditorCell: ...
    @property
    def X8Y2Cell(self) -> IEditorCell: ...
    @property
    def X7Y3Cell(self) -> IEditorCell: ...
    @property
    def X6Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y5Cell(self) -> IEditorCell: ...
    @property
    def X4Y6Cell(self) -> IEditorCell: ...
    @property
    def X3Y7Cell(self) -> IEditorCell: ...
    @property
    def X2Y8Cell(self) -> IEditorCell: ...
    @property
    def X1Y9Cell(self) -> IEditorCell: ...
    @property
    def X0Y10Cell(self) -> IEditorCell: ...
    @property
    def X11Y0Cell(self) -> IEditorCell: ...
    @property
    def X10Y1Cell(self) -> IEditorCell: ...
    @property
    def X9Y2Cell(self) -> IEditorCell: ...
    @property
    def X8Y3Cell(self) -> IEditorCell: ...
    @property
    def X7Y4Cell(self) -> IEditorCell: ...
    @property
    def X6Y5Cell(self) -> IEditorCell: ...
    @property
    def X5Y6Cell(self) -> IEditorCell: ...
    @property
    def X4Y7Cell(self) -> IEditorCell: ...
    @property
    def X3Y8Cell(self) -> IEditorCell: ...
    @property
    def X2Y9Cell(self) -> IEditorCell: ...
    @property
    def X1Y10Cell(self) -> IEditorCell: ...
    @property
    def X0Y11Cell(self) -> IEditorCell: ...
    @property
    def X12Y0Cell(self) -> IEditorCell: ...
    @property
    def X11Y1Cell(self) -> IEditorCell: ...
    @property
    def X10Y2Cell(self) -> IEditorCell: ...
    @property
    def X9Y3Cell(self) -> IEditorCell: ...
    @property
    def X8Y4Cell(self) -> IEditorCell: ...
    @property
    def X7Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y6Cell(self) -> IEditorCell: ...
    @property
    def X5Y7Cell(self) -> IEditorCell: ...
    @property
    def X4Y8Cell(self) -> IEditorCell: ...
    @property
    def X3Y9Cell(self) -> IEditorCell: ...
    @property
    def X2Y10Cell(self) -> IEditorCell: ...
    @property
    def X1Y11Cell(self) -> IEditorCell: ...
    @property
    def X0Y12Cell(self) -> IEditorCell: ...
    @property
    def X13Y0Cell(self) -> IEditorCell: ...
    @property
    def X12Y1Cell(self) -> IEditorCell: ...
    @property
    def X11Y2Cell(self) -> IEditorCell: ...
    @property
    def X10Y3Cell(self) -> IEditorCell: ...
    @property
    def X9Y4Cell(self) -> IEditorCell: ...
    @property
    def X8Y5Cell(self) -> IEditorCell: ...
    @property
    def X7Y6Cell(self) -> IEditorCell: ...
    @property
    def X6Y7Cell(self) -> IEditorCell: ...
    @property
    def X5Y8Cell(self) -> IEditorCell: ...
    @property
    def X4Y9Cell(self) -> IEditorCell: ...
    @property
    def X3Y10Cell(self) -> IEditorCell: ...
    @property
    def X2Y11Cell(self) -> IEditorCell: ...
    @property
    def X1Y12Cell(self) -> IEditorCell: ...
    @property
    def X0Y13Cell(self) -> IEditorCell: ...
    @property
    def X14Y0Cell(self) -> IEditorCell: ...
    @property
    def X13Y1Cell(self) -> IEditorCell: ...
    @property
    def X12Y2Cell(self) -> IEditorCell: ...
    @property
    def X11Y3Cell(self) -> IEditorCell: ...
    @property
    def X10Y4Cell(self) -> IEditorCell: ...
    @property
    def X9Y5Cell(self) -> IEditorCell: ...
    @property
    def X8Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y7Cell(self) -> IEditorCell: ...
    @property
    def X6Y8Cell(self) -> IEditorCell: ...
    @property
    def X5Y9Cell(self) -> IEditorCell: ...
    @property
    def X4Y10Cell(self) -> IEditorCell: ...
    @property
    def X3Y11Cell(self) -> IEditorCell: ...
    @property
    def X2Y12Cell(self) -> IEditorCell: ...
    @property
    def X1Y13Cell(self) -> IEditorCell: ...
    @property
    def X0Y14Cell(self) -> IEditorCell: ...
    @property
    def X15Y0Cell(self) -> IEditorCell: ...
    @property
    def X14Y1Cell(self) -> IEditorCell: ...
    @property
    def X13Y2Cell(self) -> IEditorCell: ...
    @property
    def X12Y3Cell(self) -> IEditorCell: ...
    @property
    def X11Y4Cell(self) -> IEditorCell: ...
    @property
    def X10Y5Cell(self) -> IEditorCell: ...
    @property
    def X9Y6Cell(self) -> IEditorCell: ...
    @property
    def X8Y7Cell(self) -> IEditorCell: ...
    @property
    def X7Y8Cell(self) -> IEditorCell: ...
    @property
    def X6Y9Cell(self) -> IEditorCell: ...
    @property
    def X5Y10Cell(self) -> IEditorCell: ...
    @property
    def X4Y11Cell(self) -> IEditorCell: ...
    @property
    def X3Y12Cell(self) -> IEditorCell: ...
    @property
    def X2Y13Cell(self) -> IEditorCell: ...
    @property
    def X1Y14Cell(self) -> IEditorCell: ...
    @property
    def X0Y15Cell(self) -> IEditorCell: ...
    @property
    def X16Y0Cell(self) -> IEditorCell: ...
    @property
    def X15Y1Cell(self) -> IEditorCell: ...
    @property
    def X14Y2Cell(self) -> IEditorCell: ...
    @property
    def X13Y3Cell(self) -> IEditorCell: ...
    @property
    def X12Y4Cell(self) -> IEditorCell: ...
    @property
    def X11Y5Cell(self) -> IEditorCell: ...
    @property
    def X10Y6Cell(self) -> IEditorCell: ...
    @property
    def X9Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y8Cell(self) -> IEditorCell: ...
    @property
    def X7Y9Cell(self) -> IEditorCell: ...
    @property
    def X6Y10Cell(self) -> IEditorCell: ...
    @property
    def X5Y11Cell(self) -> IEditorCell: ...
    @property
    def X4Y12Cell(self) -> IEditorCell: ...
    @property
    def X3Y13Cell(self) -> IEditorCell: ...
    @property
    def X2Y14Cell(self) -> IEditorCell: ...
    @property
    def X1Y15Cell(self) -> IEditorCell: ...
    @property
    def X0Y16Cell(self) -> IEditorCell: ...
    @property
    def X17Y0Cell(self) -> IEditorCell: ...
    @property
    def X16Y1Cell(self) -> IEditorCell: ...
    @property
    def X15Y2Cell(self) -> IEditorCell: ...
    @property
    def X14Y3Cell(self) -> IEditorCell: ...
    @property
    def X13Y4Cell(self) -> IEditorCell: ...
    @property
    def X12Y5Cell(self) -> IEditorCell: ...
    @property
    def X11Y6Cell(self) -> IEditorCell: ...
    @property
    def X10Y7Cell(self) -> IEditorCell: ...
    @property
    def X9Y8Cell(self) -> IEditorCell: ...
    @property
    def X8Y9Cell(self) -> IEditorCell: ...
    @property
    def X7Y10Cell(self) -> IEditorCell: ...
    @property
    def X6Y11Cell(self) -> IEditorCell: ...
    @property
    def X5Y12Cell(self) -> IEditorCell: ...
    @property
    def X4Y13Cell(self) -> IEditorCell: ...
    @property
    def X3Y14Cell(self) -> IEditorCell: ...
    @property
    def X2Y15Cell(self) -> IEditorCell: ...
    @property
    def X1Y16Cell(self) -> IEditorCell: ...
    @property
    def X0Y17Cell(self) -> IEditorCell: ...
    @property
    def X18Y0Cell(self) -> IEditorCell: ...
    @property
    def X17Y1Cell(self) -> IEditorCell: ...
    @property
    def X16Y2Cell(self) -> IEditorCell: ...
    @property
    def X15Y3Cell(self) -> IEditorCell: ...
    @property
    def X14Y4Cell(self) -> IEditorCell: ...
    @property
    def X13Y5Cell(self) -> IEditorCell: ...
    @property
    def X12Y6Cell(self) -> IEditorCell: ...
    @property
    def X11Y7Cell(self) -> IEditorCell: ...
    @property
    def X10Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y9Cell(self) -> IEditorCell: ...
    @property
    def X8Y10Cell(self) -> IEditorCell: ...
    @property
    def X7Y11Cell(self) -> IEditorCell: ...
    @property
    def X6Y12Cell(self) -> IEditorCell: ...
    @property
    def X5Y13Cell(self) -> IEditorCell: ...
    @property
    def X4Y14Cell(self) -> IEditorCell: ...
    @property
    def X3Y15Cell(self) -> IEditorCell: ...
    @property
    def X2Y16Cell(self) -> IEditorCell: ...
    @property
    def X1Y17Cell(self) -> IEditorCell: ...
    @property
    def X0Y18Cell(self) -> IEditorCell: ...
    @property
    def X19Y0Cell(self) -> IEditorCell: ...
    @property
    def X18Y1Cell(self) -> IEditorCell: ...
    @property
    def X17Y2Cell(self) -> IEditorCell: ...
    @property
    def X16Y3Cell(self) -> IEditorCell: ...
    @property
    def X15Y4Cell(self) -> IEditorCell: ...
    @property
    def X14Y5Cell(self) -> IEditorCell: ...
    @property
    def X13Y6Cell(self) -> IEditorCell: ...
    @property
    def X12Y7Cell(self) -> IEditorCell: ...
    @property
    def X11Y8Cell(self) -> IEditorCell: ...
    @property
    def X10Y9Cell(self) -> IEditorCell: ...
    @property
    def X9Y10Cell(self) -> IEditorCell: ...
    @property
    def X8Y11Cell(self) -> IEditorCell: ...
    @property
    def X7Y12Cell(self) -> IEditorCell: ...
    @property
    def X6Y13Cell(self) -> IEditorCell: ...
    @property
    def X5Y14Cell(self) -> IEditorCell: ...
    @property
    def X4Y15Cell(self) -> IEditorCell: ...
    @property
    def X3Y16Cell(self) -> IEditorCell: ...
    @property
    def X2Y17Cell(self) -> IEditorCell: ...
    @property
    def X1Y18Cell(self) -> IEditorCell: ...
    @property
    def X0Y19Cell(self) -> IEditorCell: ...
    @property
    def X20Y0Cell(self) -> IEditorCell: ...
    @property
    def X19Y1Cell(self) -> IEditorCell: ...
    @property
    def X18Y2Cell(self) -> IEditorCell: ...
    @property
    def X17Y3Cell(self) -> IEditorCell: ...
    @property
    def X16Y4Cell(self) -> IEditorCell: ...
    @property
    def X15Y5Cell(self) -> IEditorCell: ...
    @property
    def X14Y6Cell(self) -> IEditorCell: ...
    @property
    def X13Y7Cell(self) -> IEditorCell: ...
    @property
    def X12Y8Cell(self) -> IEditorCell: ...
    @property
    def X11Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y10Cell(self) -> IEditorCell: ...
    @property
    def X9Y11Cell(self) -> IEditorCell: ...
    @property
    def X8Y12Cell(self) -> IEditorCell: ...
    @property
    def X7Y13Cell(self) -> IEditorCell: ...
    @property
    def X6Y14Cell(self) -> IEditorCell: ...
    @property
    def X5Y15Cell(self) -> IEditorCell: ...
    @property
    def X4Y16Cell(self) -> IEditorCell: ...
    @property
    def X3Y17Cell(self) -> IEditorCell: ...
    @property
    def X2Y18Cell(self) -> IEditorCell: ...
    @property
    def X1Y19Cell(self) -> IEditorCell: ...
    @property
    def X0Y20Cell(self) -> IEditorCell: ...
    @property
    def X21Y0Cell(self) -> IEditorCell: ...
    @property
    def X20Y1Cell(self) -> IEditorCell: ...
    @property
    def X19Y2Cell(self) -> IEditorCell: ...
    @property
    def X18Y3Cell(self) -> IEditorCell: ...
    @property
    def X17Y4Cell(self) -> IEditorCell: ...
    @property
    def X16Y5Cell(self) -> IEditorCell: ...
    @property
    def X15Y6Cell(self) -> IEditorCell: ...
    @property
    def X14Y7Cell(self) -> IEditorCell: ...
    @property
    def X13Y8Cell(self) -> IEditorCell: ...
    @property
    def X12Y9Cell(self) -> IEditorCell: ...
    @property
    def X11Y10Cell(self) -> IEditorCell: ...
    @property
    def X10Y11Cell(self) -> IEditorCell: ...
    @property
    def X9Y12Cell(self) -> IEditorCell: ...
    @property
    def X8Y13Cell(self) -> IEditorCell: ...
    @property
    def X7Y14Cell(self) -> IEditorCell: ...
    @property
    def X6Y15Cell(self) -> IEditorCell: ...
    @property
    def X5Y16Cell(self) -> IEditorCell: ...
    @property
    def X4Y17Cell(self) -> IEditorCell: ...
    @property
    def X3Y18Cell(self) -> IEditorCell: ...
    @property
    def X2Y19Cell(self) -> IEditorCell: ...
    @property
    def X1Y0(self) -> float: ...
    @X1Y0.setter
    def X1Y0(self, value: float) -> None: ...
    @property
    def X0Y1(self) -> float: ...
    @X0Y1.setter
    def X0Y1(self, value: float) -> None: ...
    @property
    def X2Y0(self) -> float: ...
    @X2Y0.setter
    def X2Y0(self, value: float) -> None: ...
    @property
    def X1Y1(self) -> float: ...
    @X1Y1.setter
    def X1Y1(self, value: float) -> None: ...
    @property
    def X0Y2(self) -> float: ...
    @X0Y2.setter
    def X0Y2(self, value: float) -> None: ...
    @property
    def X3Y0(self) -> float: ...
    @X3Y0.setter
    def X3Y0(self, value: float) -> None: ...
    @property
    def X2Y1(self) -> float: ...
    @X2Y1.setter
    def X2Y1(self, value: float) -> None: ...
    @property
    def X1Y2(self) -> float: ...
    @X1Y2.setter
    def X1Y2(self, value: float) -> None: ...
    @property
    def X0Y3(self) -> float: ...
    @X0Y3.setter
    def X0Y3(self, value: float) -> None: ...
    @property
    def X4Y0(self) -> float: ...
    @X4Y0.setter
    def X4Y0(self, value: float) -> None: ...
    @property
    def X3Y1(self) -> float: ...
    @X3Y1.setter
    def X3Y1(self, value: float) -> None: ...
    @property
    def X2Y2(self) -> float: ...
    @X2Y2.setter
    def X2Y2(self, value: float) -> None: ...
    @property
    def X1Y3(self) -> float: ...
    @X1Y3.setter
    def X1Y3(self, value: float) -> None: ...
    @property
    def X0Y4(self) -> float: ...
    @X0Y4.setter
    def X0Y4(self, value: float) -> None: ...
    @property
    def X5Y0(self) -> float: ...
    @X5Y0.setter
    def X5Y0(self, value: float) -> None: ...
    @property
    def X4Y1(self) -> float: ...
    @X4Y1.setter
    def X4Y1(self, value: float) -> None: ...
    @property
    def X3Y2(self) -> float: ...
    @X3Y2.setter
    def X3Y2(self, value: float) -> None: ...
    @property
    def X2Y3(self) -> float: ...
    @X2Y3.setter
    def X2Y3(self, value: float) -> None: ...
    @property
    def X1Y4(self) -> float: ...
    @X1Y4.setter
    def X1Y4(self, value: float) -> None: ...
    @property
    def X0Y5(self) -> float: ...
    @X0Y5.setter
    def X0Y5(self, value: float) -> None: ...
    @property
    def X6Y0(self) -> float: ...
    @X6Y0.setter
    def X6Y0(self, value: float) -> None: ...
    @property
    def X5Y1(self) -> float: ...
    @X5Y1.setter
    def X5Y1(self, value: float) -> None: ...
    @property
    def X4Y2(self) -> float: ...
    @X4Y2.setter
    def X4Y2(self, value: float) -> None: ...
    @property
    def X3Y3(self) -> float: ...
    @X3Y3.setter
    def X3Y3(self, value: float) -> None: ...
    @property
    def X2Y4(self) -> float: ...
    @X2Y4.setter
    def X2Y4(self, value: float) -> None: ...
    @property
    def X1Y5(self) -> float: ...
    @X1Y5.setter
    def X1Y5(self, value: float) -> None: ...
    @property
    def X0Y6(self) -> float: ...
    @X0Y6.setter
    def X0Y6(self, value: float) -> None: ...
    @property
    def X7Y0(self) -> float: ...
    @X7Y0.setter
    def X7Y0(self, value: float) -> None: ...
    @property
    def X6Y1(self) -> float: ...
    @X6Y1.setter
    def X6Y1(self, value: float) -> None: ...
    @property
    def X5Y2(self) -> float: ...
    @X5Y2.setter
    def X5Y2(self, value: float) -> None: ...
    @property
    def X4Y3(self) -> float: ...
    @X4Y3.setter
    def X4Y3(self, value: float) -> None: ...
    @property
    def X3Y4(self) -> float: ...
    @X3Y4.setter
    def X3Y4(self, value: float) -> None: ...
    @property
    def X2Y5(self) -> float: ...
    @X2Y5.setter
    def X2Y5(self, value: float) -> None: ...
    @property
    def X1Y6(self) -> float: ...
    @X1Y6.setter
    def X1Y6(self, value: float) -> None: ...
    @property
    def X0Y7(self) -> float: ...
    @X0Y7.setter
    def X0Y7(self, value: float) -> None: ...
    @property
    def X8Y0(self) -> float: ...
    @X8Y0.setter
    def X8Y0(self, value: float) -> None: ...
    @property
    def X7Y1(self) -> float: ...
    @X7Y1.setter
    def X7Y1(self, value: float) -> None: ...
    @property
    def X6Y2(self) -> float: ...
    @X6Y2.setter
    def X6Y2(self, value: float) -> None: ...
    @property
    def X5Y3(self) -> float: ...
    @X5Y3.setter
    def X5Y3(self, value: float) -> None: ...
    @property
    def X4Y4(self) -> float: ...
    @X4Y4.setter
    def X4Y4(self, value: float) -> None: ...
    @property
    def X3Y5(self) -> float: ...
    @X3Y5.setter
    def X3Y5(self, value: float) -> None: ...
    @property
    def X2Y6(self) -> float: ...
    @X2Y6.setter
    def X2Y6(self, value: float) -> None: ...
    @property
    def X1Y7(self) -> float: ...
    @X1Y7.setter
    def X1Y7(self, value: float) -> None: ...
    @property
    def X0Y8(self) -> float: ...
    @X0Y8.setter
    def X0Y8(self, value: float) -> None: ...
    @property
    def X9Y0(self) -> float: ...
    @X9Y0.setter
    def X9Y0(self, value: float) -> None: ...
    @property
    def X8Y1(self) -> float: ...
    @X8Y1.setter
    def X8Y1(self, value: float) -> None: ...
    @property
    def X7Y2(self) -> float: ...
    @X7Y2.setter
    def X7Y2(self, value: float) -> None: ...
    @property
    def X6Y3(self) -> float: ...
    @X6Y3.setter
    def X6Y3(self, value: float) -> None: ...
    @property
    def X5Y4(self) -> float: ...
    @X5Y4.setter
    def X5Y4(self, value: float) -> None: ...
    @property
    def X4Y5(self) -> float: ...
    @X4Y5.setter
    def X4Y5(self, value: float) -> None: ...
    @property
    def X3Y6(self) -> float: ...
    @X3Y6.setter
    def X3Y6(self, value: float) -> None: ...
    @property
    def X2Y7(self) -> float: ...
    @X2Y7.setter
    def X2Y7(self, value: float) -> None: ...
    @property
    def X1Y8(self) -> float: ...
    @X1Y8.setter
    def X1Y8(self, value: float) -> None: ...
    @property
    def X0Y9(self) -> float: ...
    @X0Y9.setter
    def X0Y9(self, value: float) -> None: ...
    @property
    def X10Y0(self) -> float: ...
    @X10Y0.setter
    def X10Y0(self, value: float) -> None: ...
    @property
    def X9Y1(self) -> float: ...
    @X9Y1.setter
    def X9Y1(self, value: float) -> None: ...
    @property
    def X8Y2(self) -> float: ...
    @X8Y2.setter
    def X8Y2(self, value: float) -> None: ...
    @property
    def X7Y3(self) -> float: ...
    @X7Y3.setter
    def X7Y3(self, value: float) -> None: ...
    @property
    def X6Y4(self) -> float: ...
    @X6Y4.setter
    def X6Y4(self, value: float) -> None: ...
    @property
    def X5Y5(self) -> float: ...
    @X5Y5.setter
    def X5Y5(self, value: float) -> None: ...
    @property
    def X4Y6(self) -> float: ...
    @X4Y6.setter
    def X4Y6(self, value: float) -> None: ...
    @property
    def X3Y7(self) -> float: ...
    @X3Y7.setter
    def X3Y7(self, value: float) -> None: ...
    @property
    def X2Y8(self) -> float: ...
    @X2Y8.setter
    def X2Y8(self, value: float) -> None: ...
    @property
    def X1Y9(self) -> float: ...
    @X1Y9.setter
    def X1Y9(self, value: float) -> None: ...
    @property
    def X0Y10(self) -> float: ...
    @X0Y10.setter
    def X0Y10(self, value: float) -> None: ...
    @property
    def X11Y0(self) -> float: ...
    @X11Y0.setter
    def X11Y0(self, value: float) -> None: ...
    @property
    def X10Y1(self) -> float: ...
    @X10Y1.setter
    def X10Y1(self, value: float) -> None: ...
    @property
    def X9Y2(self) -> float: ...
    @X9Y2.setter
    def X9Y2(self, value: float) -> None: ...
    @property
    def X8Y3(self) -> float: ...
    @X8Y3.setter
    def X8Y3(self, value: float) -> None: ...
    @property
    def X7Y4(self) -> float: ...
    @X7Y4.setter
    def X7Y4(self, value: float) -> None: ...
    @property
    def X6Y5(self) -> float: ...
    @X6Y5.setter
    def X6Y5(self, value: float) -> None: ...
    @property
    def X5Y6(self) -> float: ...
    @X5Y6.setter
    def X5Y6(self, value: float) -> None: ...
    @property
    def X4Y7(self) -> float: ...
    @X4Y7.setter
    def X4Y7(self, value: float) -> None: ...
    @property
    def X3Y8(self) -> float: ...
    @X3Y8.setter
    def X3Y8(self, value: float) -> None: ...
    @property
    def X2Y9(self) -> float: ...
    @X2Y9.setter
    def X2Y9(self, value: float) -> None: ...
    @property
    def X1Y10(self) -> float: ...
    @X1Y10.setter
    def X1Y10(self, value: float) -> None: ...
    @property
    def X0Y11(self) -> float: ...
    @X0Y11.setter
    def X0Y11(self, value: float) -> None: ...
    @property
    def X12Y0(self) -> float: ...
    @X12Y0.setter
    def X12Y0(self, value: float) -> None: ...
    @property
    def X11Y1(self) -> float: ...
    @X11Y1.setter
    def X11Y1(self, value: float) -> None: ...
    @property
    def X10Y2(self) -> float: ...
    @X10Y2.setter
    def X10Y2(self, value: float) -> None: ...
    @property
    def X9Y3(self) -> float: ...
    @X9Y3.setter
    def X9Y3(self, value: float) -> None: ...
    @property
    def X8Y4(self) -> float: ...
    @X8Y4.setter
    def X8Y4(self, value: float) -> None: ...
    @property
    def X7Y5(self) -> float: ...
    @X7Y5.setter
    def X7Y5(self, value: float) -> None: ...
    @property
    def X6Y6(self) -> float: ...
    @X6Y6.setter
    def X6Y6(self, value: float) -> None: ...
    @property
    def X5Y7(self) -> float: ...
    @X5Y7.setter
    def X5Y7(self, value: float) -> None: ...
    @property
    def X4Y8(self) -> float: ...
    @X4Y8.setter
    def X4Y8(self, value: float) -> None: ...
    @property
    def X3Y9(self) -> float: ...
    @X3Y9.setter
    def X3Y9(self, value: float) -> None: ...
    @property
    def X2Y10(self) -> float: ...
    @X2Y10.setter
    def X2Y10(self, value: float) -> None: ...
    @property
    def X1Y11(self) -> float: ...
    @X1Y11.setter
    def X1Y11(self, value: float) -> None: ...
    @property
    def X0Y12(self) -> float: ...
    @X0Y12.setter
    def X0Y12(self, value: float) -> None: ...
    @property
    def X13Y0(self) -> float: ...
    @X13Y0.setter
    def X13Y0(self, value: float) -> None: ...
    @property
    def X12Y1(self) -> float: ...
    @X12Y1.setter
    def X12Y1(self, value: float) -> None: ...
    @property
    def X11Y2(self) -> float: ...
    @X11Y2.setter
    def X11Y2(self, value: float) -> None: ...
    @property
    def X10Y3(self) -> float: ...
    @X10Y3.setter
    def X10Y3(self, value: float) -> None: ...
    @property
    def X9Y4(self) -> float: ...
    @X9Y4.setter
    def X9Y4(self, value: float) -> None: ...
    @property
    def X8Y5(self) -> float: ...
    @X8Y5.setter
    def X8Y5(self, value: float) -> None: ...
    @property
    def X7Y6(self) -> float: ...
    @X7Y6.setter
    def X7Y6(self, value: float) -> None: ...
    @property
    def X6Y7(self) -> float: ...
    @X6Y7.setter
    def X6Y7(self, value: float) -> None: ...
    @property
    def X5Y8(self) -> float: ...
    @X5Y8.setter
    def X5Y8(self, value: float) -> None: ...
    @property
    def X4Y9(self) -> float: ...
    @X4Y9.setter
    def X4Y9(self, value: float) -> None: ...
    @property
    def X3Y10(self) -> float: ...
    @X3Y10.setter
    def X3Y10(self, value: float) -> None: ...
    @property
    def X2Y11(self) -> float: ...
    @X2Y11.setter
    def X2Y11(self, value: float) -> None: ...
    @property
    def X1Y12(self) -> float: ...
    @X1Y12.setter
    def X1Y12(self, value: float) -> None: ...
    @property
    def X0Y13(self) -> float: ...
    @X0Y13.setter
    def X0Y13(self, value: float) -> None: ...
    @property
    def X14Y0(self) -> float: ...
    @X14Y0.setter
    def X14Y0(self, value: float) -> None: ...
    @property
    def X13Y1(self) -> float: ...
    @X13Y1.setter
    def X13Y1(self, value: float) -> None: ...
    @property
    def X12Y2(self) -> float: ...
    @X12Y2.setter
    def X12Y2(self, value: float) -> None: ...
    @property
    def X11Y3(self) -> float: ...
    @X11Y3.setter
    def X11Y3(self, value: float) -> None: ...
    @property
    def X10Y4(self) -> float: ...
    @X10Y4.setter
    def X10Y4(self, value: float) -> None: ...
    @property
    def X9Y5(self) -> float: ...
    @X9Y5.setter
    def X9Y5(self, value: float) -> None: ...
    @property
    def X8Y6(self) -> float: ...
    @X8Y6.setter
    def X8Y6(self, value: float) -> None: ...
    @property
    def X7Y7(self) -> float: ...
    @X7Y7.setter
    def X7Y7(self, value: float) -> None: ...
    @property
    def X6Y8(self) -> float: ...
    @X6Y8.setter
    def X6Y8(self, value: float) -> None: ...
    @property
    def X5Y9(self) -> float: ...
    @X5Y9.setter
    def X5Y9(self, value: float) -> None: ...
    @property
    def X4Y10(self) -> float: ...
    @X4Y10.setter
    def X4Y10(self, value: float) -> None: ...
    @property
    def X3Y11(self) -> float: ...
    @X3Y11.setter
    def X3Y11(self, value: float) -> None: ...
    @property
    def X2Y12(self) -> float: ...
    @X2Y12.setter
    def X2Y12(self, value: float) -> None: ...
    @property
    def X1Y13(self) -> float: ...
    @X1Y13.setter
    def X1Y13(self, value: float) -> None: ...
    @property
    def X0Y14(self) -> float: ...
    @X0Y14.setter
    def X0Y14(self, value: float) -> None: ...
    @property
    def X15Y0(self) -> float: ...
    @X15Y0.setter
    def X15Y0(self, value: float) -> None: ...
    @property
    def X14Y1(self) -> float: ...
    @X14Y1.setter
    def X14Y1(self, value: float) -> None: ...
    @property
    def X13Y2(self) -> float: ...
    @X13Y2.setter
    def X13Y2(self, value: float) -> None: ...
    @property
    def X12Y3(self) -> float: ...
    @X12Y3.setter
    def X12Y3(self, value: float) -> None: ...
    @property
    def X11Y4(self) -> float: ...
    @X11Y4.setter
    def X11Y4(self, value: float) -> None: ...
    @property
    def X10Y5(self) -> float: ...
    @X10Y5.setter
    def X10Y5(self, value: float) -> None: ...
    @property
    def X9Y6(self) -> float: ...
    @X9Y6.setter
    def X9Y6(self, value: float) -> None: ...
    @property
    def X8Y7(self) -> float: ...
    @X8Y7.setter
    def X8Y7(self, value: float) -> None: ...
    @property
    def X7Y8(self) -> float: ...
    @X7Y8.setter
    def X7Y8(self, value: float) -> None: ...
    @property
    def X6Y9(self) -> float: ...
    @X6Y9.setter
    def X6Y9(self, value: float) -> None: ...
    @property
    def X5Y10(self) -> float: ...
    @X5Y10.setter
    def X5Y10(self, value: float) -> None: ...
    @property
    def X4Y11(self) -> float: ...
    @X4Y11.setter
    def X4Y11(self, value: float) -> None: ...
    @property
    def X3Y12(self) -> float: ...
    @X3Y12.setter
    def X3Y12(self, value: float) -> None: ...
    @property
    def X2Y13(self) -> float: ...
    @X2Y13.setter
    def X2Y13(self, value: float) -> None: ...
    @property
    def X1Y14(self) -> float: ...
    @X1Y14.setter
    def X1Y14(self, value: float) -> None: ...
    @property
    def X0Y15(self) -> float: ...
    @X0Y15.setter
    def X0Y15(self, value: float) -> None: ...
    @property
    def X16Y0(self) -> float: ...
    @X16Y0.setter
    def X16Y0(self, value: float) -> None: ...
    @property
    def X15Y1(self) -> float: ...
    @X15Y1.setter
    def X15Y1(self, value: float) -> None: ...
    @property
    def X14Y2(self) -> float: ...
    @X14Y2.setter
    def X14Y2(self, value: float) -> None: ...
    @property
    def X13Y3(self) -> float: ...
    @X13Y3.setter
    def X13Y3(self, value: float) -> None: ...
    @property
    def X12Y4(self) -> float: ...
    @X12Y4.setter
    def X12Y4(self, value: float) -> None: ...
    @property
    def X11Y5(self) -> float: ...
    @X11Y5.setter
    def X11Y5(self, value: float) -> None: ...
    @property
    def X10Y6(self) -> float: ...
    @X10Y6.setter
    def X10Y6(self, value: float) -> None: ...
    @property
    def X9Y7(self) -> float: ...
    @X9Y7.setter
    def X9Y7(self, value: float) -> None: ...
    @property
    def X8Y8(self) -> float: ...
    @X8Y8.setter
    def X8Y8(self, value: float) -> None: ...
    @property
    def X7Y9(self) -> float: ...
    @X7Y9.setter
    def X7Y9(self, value: float) -> None: ...
    @property
    def X6Y10(self) -> float: ...
    @X6Y10.setter
    def X6Y10(self, value: float) -> None: ...
    @property
    def X5Y11(self) -> float: ...
    @X5Y11.setter
    def X5Y11(self, value: float) -> None: ...
    @property
    def X4Y12(self) -> float: ...
    @X4Y12.setter
    def X4Y12(self, value: float) -> None: ...
    @property
    def X3Y13(self) -> float: ...
    @X3Y13.setter
    def X3Y13(self, value: float) -> None: ...
    @property
    def X2Y14(self) -> float: ...
    @X2Y14.setter
    def X2Y14(self, value: float) -> None: ...
    @property
    def X1Y15(self) -> float: ...
    @X1Y15.setter
    def X1Y15(self, value: float) -> None: ...
    @property
    def X0Y16(self) -> float: ...
    @X0Y16.setter
    def X0Y16(self, value: float) -> None: ...
    @property
    def X17Y0(self) -> float: ...
    @X17Y0.setter
    def X17Y0(self, value: float) -> None: ...
    @property
    def X16Y1(self) -> float: ...
    @X16Y1.setter
    def X16Y1(self, value: float) -> None: ...
    @property
    def X15Y2(self) -> float: ...
    @X15Y2.setter
    def X15Y2(self, value: float) -> None: ...
    @property
    def X14Y3(self) -> float: ...
    @X14Y3.setter
    def X14Y3(self, value: float) -> None: ...
    @property
    def X13Y4(self) -> float: ...
    @X13Y4.setter
    def X13Y4(self, value: float) -> None: ...
    @property
    def X12Y5(self) -> float: ...
    @X12Y5.setter
    def X12Y5(self, value: float) -> None: ...
    @property
    def X11Y6(self) -> float: ...
    @X11Y6.setter
    def X11Y6(self, value: float) -> None: ...
    @property
    def X10Y7(self) -> float: ...
    @X10Y7.setter
    def X10Y7(self, value: float) -> None: ...
    @property
    def X9Y8(self) -> float: ...
    @X9Y8.setter
    def X9Y8(self, value: float) -> None: ...
    @property
    def X8Y9(self) -> float: ...
    @X8Y9.setter
    def X8Y9(self, value: float) -> None: ...
    @property
    def X7Y10(self) -> float: ...
    @X7Y10.setter
    def X7Y10(self, value: float) -> None: ...
    @property
    def X6Y11(self) -> float: ...
    @X6Y11.setter
    def X6Y11(self, value: float) -> None: ...
    @property
    def X5Y12(self) -> float: ...
    @X5Y12.setter
    def X5Y12(self, value: float) -> None: ...
    @property
    def X4Y13(self) -> float: ...
    @X4Y13.setter
    def X4Y13(self, value: float) -> None: ...
    @property
    def X3Y14(self) -> float: ...
    @X3Y14.setter
    def X3Y14(self, value: float) -> None: ...
    @property
    def X2Y15(self) -> float: ...
    @X2Y15.setter
    def X2Y15(self, value: float) -> None: ...
    @property
    def X1Y16(self) -> float: ...
    @X1Y16.setter
    def X1Y16(self, value: float) -> None: ...
    @property
    def X0Y17(self) -> float: ...
    @X0Y17.setter
    def X0Y17(self, value: float) -> None: ...
    @property
    def X18Y0(self) -> float: ...
    @X18Y0.setter
    def X18Y0(self, value: float) -> None: ...
    @property
    def X17Y1(self) -> float: ...
    @X17Y1.setter
    def X17Y1(self, value: float) -> None: ...
    @property
    def X16Y2(self) -> float: ...
    @X16Y2.setter
    def X16Y2(self, value: float) -> None: ...
    @property
    def X15Y3(self) -> float: ...
    @X15Y3.setter
    def X15Y3(self, value: float) -> None: ...
    @property
    def X14Y4(self) -> float: ...
    @X14Y4.setter
    def X14Y4(self, value: float) -> None: ...
    @property
    def X13Y5(self) -> float: ...
    @X13Y5.setter
    def X13Y5(self, value: float) -> None: ...
    @property
    def X12Y6(self) -> float: ...
    @X12Y6.setter
    def X12Y6(self, value: float) -> None: ...
    @property
    def X11Y7(self) -> float: ...
    @X11Y7.setter
    def X11Y7(self, value: float) -> None: ...
    @property
    def X10Y8(self) -> float: ...
    @X10Y8.setter
    def X10Y8(self, value: float) -> None: ...
    @property
    def X9Y9(self) -> float: ...
    @X9Y9.setter
    def X9Y9(self, value: float) -> None: ...
    @property
    def X8Y10(self) -> float: ...
    @X8Y10.setter
    def X8Y10(self, value: float) -> None: ...
    @property
    def X7Y11(self) -> float: ...
    @X7Y11.setter
    def X7Y11(self, value: float) -> None: ...
    @property
    def X6Y12(self) -> float: ...
    @X6Y12.setter
    def X6Y12(self, value: float) -> None: ...
    @property
    def X5Y13(self) -> float: ...
    @X5Y13.setter
    def X5Y13(self, value: float) -> None: ...
    @property
    def X4Y14(self) -> float: ...
    @X4Y14.setter
    def X4Y14(self, value: float) -> None: ...
    @property
    def X3Y15(self) -> float: ...
    @X3Y15.setter
    def X3Y15(self, value: float) -> None: ...
    @property
    def X2Y16(self) -> float: ...
    @X2Y16.setter
    def X2Y16(self, value: float) -> None: ...
    @property
    def X1Y17(self) -> float: ...
    @X1Y17.setter
    def X1Y17(self, value: float) -> None: ...
    @property
    def X0Y18(self) -> float: ...
    @X0Y18.setter
    def X0Y18(self, value: float) -> None: ...
    @property
    def X19Y0(self) -> float: ...
    @X19Y0.setter
    def X19Y0(self, value: float) -> None: ...
    @property
    def X18Y1(self) -> float: ...
    @X18Y1.setter
    def X18Y1(self, value: float) -> None: ...
    @property
    def X17Y2(self) -> float: ...
    @X17Y2.setter
    def X17Y2(self, value: float) -> None: ...
    @property
    def X16Y3(self) -> float: ...
    @X16Y3.setter
    def X16Y3(self, value: float) -> None: ...
    @property
    def X15Y4(self) -> float: ...
    @X15Y4.setter
    def X15Y4(self, value: float) -> None: ...
    @property
    def X14Y5(self) -> float: ...
    @X14Y5.setter
    def X14Y5(self, value: float) -> None: ...
    @property
    def X13Y6(self) -> float: ...
    @X13Y6.setter
    def X13Y6(self, value: float) -> None: ...
    @property
    def X12Y7(self) -> float: ...
    @X12Y7.setter
    def X12Y7(self, value: float) -> None: ...
    @property
    def X11Y8(self) -> float: ...
    @X11Y8.setter
    def X11Y8(self, value: float) -> None: ...
    @property
    def X10Y9(self) -> float: ...
    @X10Y9.setter
    def X10Y9(self, value: float) -> None: ...
    @property
    def X9Y10(self) -> float: ...
    @X9Y10.setter
    def X9Y10(self, value: float) -> None: ...
    @property
    def X8Y11(self) -> float: ...
    @X8Y11.setter
    def X8Y11(self, value: float) -> None: ...
    @property
    def X7Y12(self) -> float: ...
    @X7Y12.setter
    def X7Y12(self, value: float) -> None: ...
    @property
    def X6Y13(self) -> float: ...
    @X6Y13.setter
    def X6Y13(self, value: float) -> None: ...
    @property
    def X5Y14(self) -> float: ...
    @X5Y14.setter
    def X5Y14(self, value: float) -> None: ...
    @property
    def X4Y15(self) -> float: ...
    @X4Y15.setter
    def X4Y15(self, value: float) -> None: ...
    @property
    def X3Y16(self) -> float: ...
    @X3Y16.setter
    def X3Y16(self, value: float) -> None: ...
    @property
    def X2Y17(self) -> float: ...
    @X2Y17.setter
    def X2Y17(self, value: float) -> None: ...
    @property
    def X1Y18(self) -> float: ...
    @X1Y18.setter
    def X1Y18(self, value: float) -> None: ...
    @property
    def X0Y19(self) -> float: ...
    @X0Y19.setter
    def X0Y19(self, value: float) -> None: ...
    @property
    def X20Y0(self) -> float: ...
    @X20Y0.setter
    def X20Y0(self, value: float) -> None: ...
    @property
    def X19Y1(self) -> float: ...
    @X19Y1.setter
    def X19Y1(self, value: float) -> None: ...
    @property
    def X18Y2(self) -> float: ...
    @X18Y2.setter
    def X18Y2(self, value: float) -> None: ...
    @property
    def X17Y3(self) -> float: ...
    @X17Y3.setter
    def X17Y3(self, value: float) -> None: ...
    @property
    def X16Y4(self) -> float: ...
    @X16Y4.setter
    def X16Y4(self, value: float) -> None: ...
    @property
    def X15Y5(self) -> float: ...
    @X15Y5.setter
    def X15Y5(self, value: float) -> None: ...
    @property
    def X14Y6(self) -> float: ...
    @X14Y6.setter
    def X14Y6(self, value: float) -> None: ...
    @property
    def X13Y7(self) -> float: ...
    @X13Y7.setter
    def X13Y7(self, value: float) -> None: ...
    @property
    def X12Y8(self) -> float: ...
    @X12Y8.setter
    def X12Y8(self, value: float) -> None: ...
    @property
    def X11Y9(self) -> float: ...
    @X11Y9.setter
    def X11Y9(self, value: float) -> None: ...
    @property
    def X10Y10(self) -> float: ...
    @X10Y10.setter
    def X10Y10(self, value: float) -> None: ...
    @property
    def X9Y11(self) -> float: ...
    @X9Y11.setter
    def X9Y11(self, value: float) -> None: ...
    @property
    def X8Y12(self) -> float: ...
    @X8Y12.setter
    def X8Y12(self, value: float) -> None: ...
    @property
    def X7Y13(self) -> float: ...
    @X7Y13.setter
    def X7Y13(self, value: float) -> None: ...
    @property
    def X6Y14(self) -> float: ...
    @X6Y14.setter
    def X6Y14(self, value: float) -> None: ...
    @property
    def X5Y15(self) -> float: ...
    @X5Y15.setter
    def X5Y15(self, value: float) -> None: ...
    @property
    def X4Y16(self) -> float: ...
    @X4Y16.setter
    def X4Y16(self, value: float) -> None: ...
    @property
    def X3Y17(self) -> float: ...
    @X3Y17.setter
    def X3Y17(self, value: float) -> None: ...
    @property
    def X2Y18(self) -> float: ...
    @X2Y18.setter
    def X2Y18(self, value: float) -> None: ...
    @property
    def X1Y19(self) -> float: ...
    @X1Y19.setter
    def X1Y19(self, value: float) -> None: ...
    @property
    def X0Y20(self) -> float: ...
    @X0Y20.setter
    def X0Y20(self, value: float) -> None: ...
    @property
    def X21Y0(self) -> float: ...
    @X21Y0.setter
    def X21Y0(self, value: float) -> None: ...
    @property
    def X20Y1(self) -> float: ...
    @X20Y1.setter
    def X20Y1(self, value: float) -> None: ...
    @property
    def X19Y2(self) -> float: ...
    @X19Y2.setter
    def X19Y2(self, value: float) -> None: ...
    @property
    def X18Y3(self) -> float: ...
    @X18Y3.setter
    def X18Y3(self, value: float) -> None: ...
    @property
    def X17Y4(self) -> float: ...
    @X17Y4.setter
    def X17Y4(self, value: float) -> None: ...
    @property
    def X16Y5(self) -> float: ...
    @X16Y5.setter
    def X16Y5(self, value: float) -> None: ...
    @property
    def X15Y6(self) -> float: ...
    @X15Y6.setter
    def X15Y6(self, value: float) -> None: ...
    @property
    def X14Y7(self) -> float: ...
    @X14Y7.setter
    def X14Y7(self, value: float) -> None: ...
    @property
    def X13Y8(self) -> float: ...
    @X13Y8.setter
    def X13Y8(self, value: float) -> None: ...
    @property
    def X12Y9(self) -> float: ...
    @X12Y9.setter
    def X12Y9(self, value: float) -> None: ...
    @property
    def X11Y10(self) -> float: ...
    @X11Y10.setter
    def X11Y10(self, value: float) -> None: ...
    @property
    def X10Y11(self) -> float: ...
    @X10Y11.setter
    def X10Y11(self, value: float) -> None: ...
    @property
    def X9Y12(self) -> float: ...
    @X9Y12.setter
    def X9Y12(self, value: float) -> None: ...
    @property
    def X8Y13(self) -> float: ...
    @X8Y13.setter
    def X8Y13(self, value: float) -> None: ...
    @property
    def X7Y14(self) -> float: ...
    @X7Y14.setter
    def X7Y14(self, value: float) -> None: ...
    @property
    def X6Y15(self) -> float: ...
    @X6Y15.setter
    def X6Y15(self, value: float) -> None: ...
    @property
    def X5Y16(self) -> float: ...
    @X5Y16.setter
    def X5Y16(self, value: float) -> None: ...
    @property
    def X4Y17(self) -> float: ...
    @X4Y17.setter
    def X4Y17(self, value: float) -> None: ...
    @property
    def X3Y18(self) -> float: ...
    @X3Y18.setter
    def X3Y18(self, value: float) -> None: ...
    @property
    def X2Y19(self) -> float: ...
    @X2Y19.setter
    def X2Y19(self, value: float) -> None: ...

class ISurfaceZernikeAnnularPhase(ISurfaceNthZernike, ISurface):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def ObscurationCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @property
    def Obscuration(self) -> float: ...
    @Obscuration.setter
    def Obscuration(self, value: float) -> None: ...

class ISurfaceZernikeFringePhase(ISurfaceNthZernike, ISurface):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...

class ISurfaceZernikeFringeSag(ISurfaceNthZernike, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceZernikeStandardPhase(ISurfaceNthZernike, ISurface):
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...

class ISurfaceZernikeStandardSag(ISurfaceNthZernike, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceZonePlate(ISurfaceNthThickness, ISurface):
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def Delta_R_Cell(self) -> IEditorCell: ...
    @property
    def ReferenceWaveCell(self) -> IEditorCell: ...
    @property
    def Mode(self) -> float: ...
    @Mode.setter
    def Mode(self, value: float) -> None: ...
    @property
    def Delta_R(self) -> float: ...
    @Delta_R.setter
    def Delta_R(self, value: float) -> None: ...
    @property
    def ReferenceWave(self) -> float: ...
    @ReferenceWave.setter
    def ReferenceWave(self, value: float) -> None: ...

class NodesDataType:
    SurfaceDeformationNoRBM = 1
    RefractiveIndex = 2
    TemperatureAndRefractiveIndex = 3
    SurfaceDeformation = 4

class PilotRadiusMode:
    BestFit = 0
    Shorter = 1
    Longer = 2
    X = 3
    Y = 4
    Plane = 5
    User = 6

class PointCloudFileFormat:
    ASCII = 0
    Binary = 1
    CompressedBinary = 2

class PupilApodizationType:
    # None = 0
    Gaussian = 1
    Tangential = 2

class QTypes:
    Qbfs = 0
    Qcon = 1

class STARDeformationOption:
    DeformationWithRBMs = 0
    DeformationWithoutRBMs = 1
    OnlyRBMs = 2
    NoDeformation = 3

class SubstrateType:
    # None = 0
    Flat = 1
    Curved = 2

class SurfaceApertureTypes:
    # None = 0
    CircularAperture = 1
    CircularObscuration = 2
    Spider = 3
    RectangularAperture = 4
    RectangularObscuration = 5
    EllipticalAperture = 6
    EllipticalObscuration = 7
    UserAperture = 8
    UserObscuration = 9
    FloatingAperture = 10

class SurfaceColumn:
    Comment = 1
    Radius = 2
    Thickness = 3
    Material = 4
    Coating = 5
    SemiDiameter = 6
    ChipZone = 7
    MechanicalSemiDiameter = 8
    Conic = 9
    TCE = 10
    Par0 = 11
    Par1 = 12
    Par2 = 13
    Par3 = 14
    Par4 = 15
    Par5 = 16
    Par6 = 17
    Par7 = 18
    Par8 = 19
    Par9 = 20
    Par10 = 21
    Par11 = 22
    Par12 = 23
    Par13 = 24
    Par14 = 25
    Par15 = 26
    Par16 = 27
    Par17 = 28
    Par18 = 29
    Par19 = 30
    Par20 = 31
    Par21 = 32
    Par22 = 33
    Par23 = 34
    Par24 = 35
    Par25 = 36
    Par26 = 37
    Par27 = 38
    Par28 = 39
    Par29 = 40
    Par30 = 41
    Par31 = 42
    Par32 = 43
    Par33 = 44
    Par34 = 45
    Par35 = 46
    Par36 = 47
    Par37 = 48
    Par38 = 49
    Par39 = 50
    Par40 = 51
    Par41 = 52
    Par42 = 53
    Par43 = 54
    Par44 = 55
    Par45 = 56
    Par46 = 57
    Par47 = 58
    Par48 = 59
    Par49 = 60
    Par50 = 61
    Par51 = 62
    Par52 = 63
    Par53 = 64
    Par54 = 65
    Par55 = 66
    Par56 = 67
    Par57 = 68
    Par58 = 69
    Par59 = 70
    Par60 = 71
    Par61 = 72
    Par62 = 73
    Par63 = 74
    Par64 = 75
    Par65 = 76
    Par66 = 77
    Par67 = 78
    Par68 = 79
    Par69 = 80
    Par70 = 81
    Par71 = 82
    Par72 = 83
    Par73 = 84
    Par74 = 85
    Par75 = 86
    Par76 = 87
    Par77 = 88
    Par78 = 89
    Par79 = 90
    Par80 = 91
    Par81 = 92
    Par82 = 93
    Par83 = 94
    Par84 = 95
    Par85 = 96
    Par86 = 97
    Par87 = 98
    Par88 = 99
    Par89 = 100
    Par90 = 101
    Par91 = 102
    Par92 = 103
    Par93 = 104
    Par94 = 105
    Par95 = 106
    Par96 = 107
    Par97 = 108
    Par98 = 109
    Par99 = 110
    Par100 = 111
    Par101 = 112
    Par102 = 113
    Par103 = 114
    Par104 = 115
    Par105 = 116
    Par106 = 117
    Par107 = 118
    Par108 = 119
    Par109 = 120
    Par110 = 121
    Par111 = 122
    Par112 = 123
    Par113 = 124
    Par114 = 125
    Par115 = 126
    Par116 = 127
    Par117 = 128
    Par118 = 129
    Par119 = 130
    Par120 = 131
    Par121 = 132
    Par122 = 133
    Par123 = 134
    Par124 = 135
    Par125 = 136
    Par126 = 137
    Par127 = 138
    Par128 = 139
    Par129 = 140
    Par130 = 141
    Par131 = 142
    Par132 = 143
    Par133 = 144
    Par134 = 145
    Par135 = 146
    Par136 = 147
    Par137 = 148
    Par138 = 149
    Par139 = 150
    Par140 = 151
    Par141 = 152
    Par142 = 153
    Par143 = 154
    Par144 = 155
    Par145 = 156
    Par146 = 157
    Par147 = 158
    Par148 = 159
    Par149 = 160
    Par150 = 161
    Par151 = 162
    Par152 = 163
    Par153 = 164
    Par154 = 165
    Par155 = 166
    Par156 = 167
    Par157 = 168
    Par158 = 169
    Par159 = 170
    Par160 = 171
    Par161 = 172
    Par162 = 173
    Par163 = 174
    Par164 = 175
    Par165 = 176
    Par166 = 177
    Par167 = 178
    Par168 = 179
    Par169 = 180
    Par170 = 181
    Par171 = 182
    Par172 = 183
    Par173 = 184
    Par174 = 185
    Par175 = 186
    Par176 = 187
    Par177 = 188
    Par178 = 189
    Par179 = 190
    Par180 = 191
    Par181 = 192
    Par182 = 193
    Par183 = 194
    Par184 = 195
    Par185 = 196
    Par186 = 197
    Par187 = 198
    Par188 = 199
    Par189 = 200
    Par190 = 201
    Par191 = 202
    Par192 = 203
    Par193 = 204
    Par194 = 205
    Par195 = 206
    Par196 = 207
    Par197 = 208
    Par198 = 209
    Par199 = 210
    Par200 = 211
    Par201 = 212
    Par202 = 213
    Par203 = 214
    Par204 = 215
    Par205 = 216
    Par206 = 217
    Par207 = 218
    Par208 = 219
    Par209 = 220
    Par210 = 221
    Par211 = 222
    Par212 = 223
    Par213 = 224
    Par214 = 225
    Par215 = 226
    Par216 = 227
    Par217 = 228
    Par218 = 229
    Par219 = 230
    Par220 = 231
    Par221 = 232
    Par222 = 233
    Par223 = 234
    Par224 = 235
    Par225 = 236
    Par226 = 237
    Par227 = 238
    Par228 = 239
    Par229 = 240
    Par230 = 241
    Par231 = 242
    Par232 = 243
    Par233 = 244
    Par234 = 245
    Par235 = 246
    Par236 = 247
    Par237 = 248
    Par238 = 249
    Par239 = 250
    Par240 = 251
    Par241 = 252
    Par242 = 253
    Par243 = 254
    Par244 = 255
    Par245 = 256
    Par246 = 257
    Par247 = 258
    Par248 = 259
    Par249 = 260
    Par250 = 261
    Par251 = 262
    Par252 = 263
    Par253 = 264
    Par254 = 265

class SurfaceEdgeDraw:
    Squared = 0
    Tapered = 1
    Flat = 2

class SurfaceScatteringTypes:
    # None = 0
    Lambertian = 1
    Gaussian = 2
    ABg = 3
    ABgFile = 4
    BSDF = 5
    User = 6
    ISScatterCatalog = 7

class SurfaceType:
    ABCD = 0
    AlternateEven = 1
    AlternateOdd = 2
    AnnularZernikeSag = 3
    Atmospheric = 4
    Biconic = 5
    BiconicZernike = 6
    Binary1 = 7
    Binary2 = 8
    Binary3 = 9
    Binary4 = 10
    BirefringentIn = 11
    BirefringentOut = 12
    BlackBoxLens = 13
    ChebyShv = 14
    Conjugate = 15
    CoordinateBreak = 16
    CubicSpline = 17
    CylinderFrensel = 18
    CylinderFresnel = 18
    Data = 19
    DiffractionGrating = 20
    EllipticalGrating1 = 21
    EllipticalGrating2 = 22
    EvenAspheric = 23
    ExtendedToroidalGrating = 24
    ExtendedAsphere = 25
    ExtendedCubicSpline = 26
    ExtendedFresnel = 27
    ExtendedOddAsphere = 28
    ExtendedPolynomial = 29
    Fresnel = 30
    GeneralizedFresnel = 31
    Gradient1 = 32
    Gradient2 = 33
    Gradient3 = 34
    Gradient4 = 35
    Gradient5 = 36
    Gradient6 = 37
    Gradient7 = 38
    Gradient9 = 39
    Gradient10 = 40
    Gradient12 = 41
    Gradium = 42
    GridGradient = 43
    GridPhase = 44
    GridSag = 45
    Hologram1 = 46
    Hologram2 = 47
    Irregular = 48
    JonesMatrix = 49
    NonSequential = 50
    OddAsphere = 51
    OddCosine = 52
    OffAxisConicFreeform = 53
    OpticallyFabricatedHologram = 54
    Paraxial = 55
    ParaxialXY = 56
    Periodic = 57
    Polynomial = 58
    QTypeAsphere = 59
    QTypeFreeform = 60
    RadialGrating = 61
    RadialNurbs = 62
    RetroReflect = 63
    SlideSurface = 64
    Standard = 65
    Superconic = 66
    Tilted = 67
    Toroidal = 68
    ToroidalGrat = 69
    ToroidalHologram = 70
    ToroidalNurbs = 71
    UserDefined = 72
    VariableLineSpaceGrating = 73
    ZernikeAnnularPhase = 74
    ZernikeFringePhase = 75
    ZernikeFringeSag = 76
    ZernikeStandardPhase = 77
    ZernikeStandardSag = 78
    ZonePlate = 79
    Freeform = 80

class TiltDecenterOrderType:
    Decenter_Tilt = 0
    Tilt_Decenter = 1

class TiltDecenterPickupType:
    Explicit = 0
    PickupSurface = 1
    ReverseSurface = 2

class TiltType:
    XTilt = 0
    YTilt = 1

class XYSampling:
    S32 = 0
    S64 = 1
    S128 = 2
    S256 = 3
    S512 = 4
    S1024 = 5
    S2048 = 6
    S4096 = 7
    S8192 = 8
    S16384 = 9
