"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import Iterable, overload

from zospy.api._ZOSAPI.Analysis import IMessage
from zospy.api._ZOSAPI.Editors import ISolveData, SolveStatus

__all__ = (
    "FieldColumn",
    "FieldNormalizationType",
    "FieldPattern",
    "FieldType",
    "FNumberComputationType",
    "HuygensIntegralSettings",
    "IField",
    "IFields",
    "ISDAdvancedData",
    "ISDApertureData",
    "ISDEnvironmentData",
    "ISDFiles",
    "ISDMaterialCatalogData",
    "ISDNamedFilters",
    "ISDNonSeqData",
    "ISDPolarizationData",
    "ISDRayAimingData",
    "ISDTitleNotes",
    "ISDUnitsData",
    "ISurfaceSelection",
    "ISystemData",
    "IWavelength",
    "IWavelengths",
    "ParaxialRaysSetting",
    "PolarizationMethod",
    "QuadratureSteps",
    "RayAimingMethod",
    "RayAimingType",
    "ReferenceOPDSetting",
    "WavelengthPreset",
    "ZemaxAfocalModeUnits",
    "ZemaxAnalysisUnits",
    "ZemaxApertureType",
    "ZemaxApodizationType",
    "ZemaxMTFUnits",
    "ZemaxSourceUnits",
    "ZemaxSystemUnits",
    "ZemaxUnitPrefix",
)

class FieldColumn:
    Comment = 0
    X = 1
    Y = 2
    Weight = 3
    VDX = 4
    VDY = 5
    VCX = 6
    VCY = 7
    TAN = 8
    VAN = 8

class FieldNormalizationType:
    Radial = 0
    Rectangular = 1

class FieldPattern:
    UniformY = 0
    EqualAreaY = 1
    UniformX = 2
    EqualAreaX = 3
    Grid = 4
    UniformRadial = 5
    EqualAreaRadial = 6

class FieldType:
    Angle = 0
    ObjectHeight = 1
    ParaxialImageHeight = 2
    RealImageHeight = 3
    TheodoliteAngle = 4

class FNumberComputationType:
    TracingRays = 0
    PupilSizePosition = 1

class HuygensIntegralSettings:
    Auto = 0
    Planar = 1
    Spherical = 2

class IField:
    @property
    def IsActive(self) -> bool: ...
    @property
    def FieldNumber(self) -> int: ...
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Weight(self) -> float: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...
    @property
    def VDX(self) -> float: ...
    @VDX.setter
    def VDX(self, value: float) -> None: ...
    @property
    def VDY(self) -> float: ...
    @VDY.setter
    def VDY(self, value: float) -> None: ...
    @property
    def VCX(self) -> float: ...
    @VCX.setter
    def VCX(self, value: float) -> None: ...
    @property
    def VCY(self) -> float: ...
    @VCY.setter
    def VCY(self, value: float) -> None: ...
    @property
    def VAN(self) -> float: ...
    @VAN.setter
    def VAN(self, value: float) -> None: ...
    @property
    def TAN(self) -> float: ...
    @TAN.setter
    def TAN(self, value: float) -> None: ...
    @property
    def Comment(self) -> str: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @property
    def XSolve(self) -> SolveType: ...
    @property
    def YSolve(self) -> SolveType: ...
    @property
    def Ignore(self) -> bool: ...
    @Ignore.setter
    def Ignore(self, value: bool) -> None: ...
    def GetSolveData(self, forColumn: FieldColumn) -> ISolveData: ...
    def GetXSolveData(self) -> ISolveData: ...
    def GetYSolveData(self) -> ISolveData: ...
    def SetFixed(self, forColumn: FieldColumn) -> SolveStatus: ...
    def SetPickup(
        self, forColumn: FieldColumn, fromField: int, fromColumn: FieldColumn, scale: float, offset: float
    ) -> SolveStatus: ...
    def SetXFixed(self) -> SolveStatus: ...
    def SetXPickup(self, fromField: int, fromColumn: FieldColumn, scale: float, offset: float) -> SolveStatus: ...
    def SetYFixed(self) -> SolveStatus: ...
    def SetYPickup(self, fromField: int, fromColumn: FieldColumn, scale: float, offset: float) -> SolveStatus: ...

class IFields:
    @property
    def NumberOfFields(self) -> int: ...
    @property
    def Normalization(self) -> FieldNormalizationType: ...
    @Normalization.setter
    def Normalization(self, value: FieldNormalizationType) -> None: ...
    def AddField(self, X: float, Y: float, Weight: float) -> IField: ...
    def ApplyFieldWizard(
        self,
        pattern: FieldPattern,
        numberOfYFields: int,
        maxFieldY: float,
        numberOfXFields: int,
        maxFieldX: float,
        startAt: int,
        overwrite: bool,
        includePickups: bool,
    ) -> IMessage: ...
    def ClearVignetting(self) -> None: ...
    def ConvertToFieldType(self, type: FieldType) -> IMessage: ...
    def DeleteAllFields(self) -> int: ...
    def DeleteFieldAt(self, fieldNumber: int) -> bool: ...
    def DeleteFieldsAt(self, fieldNumber: int, numberOfFields: int) -> int: ...
    def GetField(self, position: int) -> IField: ...
    def GetFieldType(self) -> FieldType: ...
    def InsertFieldAt(self, fieldNumber: int) -> IField: ...
    def RemoveField(self, position: int) -> bool: ...
    def SetFieldType(self, type: FieldType) -> None: ...
    def SetVignetting(self) -> None: ...

class ISDAdvancedData:
    @property
    def ReferenceOPD(self) -> ReferenceOPDSetting: ...
    @ReferenceOPD.setter
    def ReferenceOPD(self, value: ReferenceOPDSetting) -> None: ...
    @property
    def ParaxialRays(self) -> ParaxialRaysSetting: ...
    @ParaxialRays.setter
    def ParaxialRays(self, value: ParaxialRaysSetting) -> None: ...
    @property
    def FNumMethod(self) -> FNumberComputationType: ...
    @FNumMethod.setter
    def FNumMethod(self, value: FNumberComputationType) -> None: ...
    @property
    def DontPrintCoordinateBreakData(self) -> bool: ...
    @DontPrintCoordinateBreakData.setter
    def DontPrintCoordinateBreakData(self, value: bool) -> None: ...
    @property
    def TurnOffThreading(self) -> bool: ...
    @TurnOffThreading.setter
    def TurnOffThreading(self, value: bool) -> None: ...
    @property
    def OPDModulo2PI(self) -> bool: ...
    @OPDModulo2PI.setter
    def OPDModulo2PI(self, value: bool) -> None: ...
    @property
    def IncludeCalculatedDataInSessionFile(self) -> bool: ...
    @IncludeCalculatedDataInSessionFile.setter
    def IncludeCalculatedDataInSessionFile(self, value: bool) -> None: ...
    @property
    def IncludeToleranceDataInSessionFile(self) -> bool: ...
    @IncludeToleranceDataInSessionFile.setter
    def IncludeToleranceDataInSessionFile(self, value: bool) -> None: ...
    @property
    def HuygensIntegralMethod(self) -> HuygensIntegralSettings: ...
    @HuygensIntegralMethod.setter
    def HuygensIntegralMethod(self, value: HuygensIntegralSettings) -> None: ...

class ISDApertureData:
    @property
    def ApertureType(self) -> ZemaxApertureType: ...
    @ApertureType.setter
    def ApertureType(self, value: ZemaxApertureType) -> None: ...
    @property
    def ApertureValue(self) -> float: ...
    @ApertureValue.setter
    def ApertureValue(self, value: float) -> None: ...
    @property
    def ApodizationType(self) -> ZemaxApodizationType: ...
    @ApodizationType.setter
    def ApodizationType(self, value: ZemaxApodizationType) -> None: ...
    @property
    def ApodizationFactor(self) -> float: ...
    @ApodizationFactor.setter
    def ApodizationFactor(self, value: float) -> None: ...
    @property
    def ApodizationFactorIsUsed(self) -> bool: ...
    @property
    def SemiDiameterMargin(self) -> float: ...
    @SemiDiameterMargin.setter
    def SemiDiameterMargin(self, value: float) -> None: ...
    @property
    def SemiDiameterMarginPct(self) -> float: ...
    @SemiDiameterMarginPct.setter
    def SemiDiameterMarginPct(self, value: float) -> None: ...
    @property
    def GCRS(self) -> ISurfaceSelection: ...
    @property
    def TelecentricObjectSpace(self) -> bool: ...
    @TelecentricObjectSpace.setter
    def TelecentricObjectSpace(self, value: bool) -> None: ...
    @property
    def AFocalImageSpace(self) -> bool: ...
    @AFocalImageSpace.setter
    def AFocalImageSpace(self, value: bool) -> None: ...
    @property
    def IterateSolvesWhenUpdating(self) -> bool: ...
    @IterateSolvesWhenUpdating.setter
    def IterateSolvesWhenUpdating(self, value: bool) -> None: ...
    @property
    def FastSemiDiameters(self) -> bool: ...
    @FastSemiDiameters.setter
    def FastSemiDiameters(self, value: bool) -> None: ...
    @property
    def CheckGRINApertures(self) -> bool: ...
    @CheckGRINApertures.setter
    def CheckGRINApertures(self, value: bool) -> None: ...

class ISDEnvironmentData:
    @property
    def AdjustIndexToEnvironment(self) -> bool: ...
    @AdjustIndexToEnvironment.setter
    def AdjustIndexToEnvironment(self, value: bool) -> None: ...
    @property
    def Temperature(self) -> float: ...
    @Temperature.setter
    def Temperature(self, value: float) -> None: ...
    @property
    def Pressure(self) -> float: ...
    @Pressure.setter
    def Pressure(self, value: float) -> None: ...

class ISDFiles:
    @property
    def CoatingFile(self) -> str: ...
    @CoatingFile.setter
    def CoatingFile(self, value: str) -> None: ...
    @property
    def ScatterProfile(self) -> str: ...
    @ScatterProfile.setter
    def ScatterProfile(self, value: str) -> None: ...
    @property
    def ABgDataFile(self) -> str: ...
    @ABgDataFile.setter
    def ABgDataFile(self, value: str) -> None: ...
    @property
    def GradiumProfile(self) -> str: ...
    @GradiumProfile.setter
    def GradiumProfile(self, value: str) -> None: ...
    def GetABgDataFiles(self) -> list[str]: ...
    def GetCoatingFiles(self) -> list[str]: ...
    def GetGradiumProfiles(self) -> list[str]: ...
    def GetScatterProfiles(self) -> list[str]: ...
    def ReloadFiles(self) -> None: ...

class ISDMaterialCatalogData:
    def AddCatalog(self, catalog: str) -> bool: ...
    def GetAvailableCatalogs(self) -> list[str]: ...
    def GetCatalogsInUse(self) -> list[str]: ...
    def GetMaterialsInCatalog(self, catalog: str) -> list[str]: ...
    def IsCatalogInUse(self, catalog: str) -> bool: ...
    def RemoveCatalog(self, catalog: str) -> bool: ...

class ISDNamedFilters:
    @property
    def NamedFilters(self) -> str: ...
    @NamedFilters.setter
    def NamedFilters(self, value: str) -> None: ...

class ISDNonSeqData:
    @property
    def MaximumIntersectionsPerRay(self) -> int: ...
    @MaximumIntersectionsPerRay.setter
    def MaximumIntersectionsPerRay(self, value: int) -> None: ...
    @property
    def MaximumSegmentsPerRay(self) -> int: ...
    @MaximumSegmentsPerRay.setter
    def MaximumSegmentsPerRay(self, value: int) -> None: ...
    @property
    def MaximumNestedTouchingObjects(self) -> int: ...
    @MaximumNestedTouchingObjects.setter
    def MaximumNestedTouchingObjects(self, value: int) -> None: ...
    @property
    def MaximumSourceFileRaysInMemory(self) -> int: ...
    @MaximumSourceFileRaysInMemory.setter
    def MaximumSourceFileRaysInMemory(self, value: int) -> None: ...
    @property
    def MinimumRelativeRayIntensity(self) -> float: ...
    @MinimumRelativeRayIntensity.setter
    def MinimumRelativeRayIntensity(self, value: float) -> None: ...
    @property
    def MinimumAbsoluteRayIntensity(self) -> float: ...
    @MinimumAbsoluteRayIntensity.setter
    def MinimumAbsoluteRayIntensity(self, value: float) -> None: ...
    @property
    def GlueDistanceInLensUnits(self) -> float: ...
    @GlueDistanceInLensUnits.setter
    def GlueDistanceInLensUnits(self, value: float) -> None: ...
    @property
    def MissedRayDrawDistanceInLensUnits(self) -> float: ...
    @MissedRayDrawDistanceInLensUnits.setter
    def MissedRayDrawDistanceInLensUnits(self, value: float) -> None: ...
    @property
    def SimpleRaySplitting(self) -> bool: ...
    @SimpleRaySplitting.setter
    def SimpleRaySplitting(self, value: bool) -> None: ...
    @property
    def RetraceSourceRaysUponFileOpen(self) -> bool: ...
    @RetraceSourceRaysUponFileOpen.setter
    def RetraceSourceRaysUponFileOpen(self, value: bool) -> None: ...

class ISDPolarizationData:
    @property
    def ConvertThinFilmPhaseToRayEquivalent(self) -> bool: ...
    @ConvertThinFilmPhaseToRayEquivalent.setter
    def ConvertThinFilmPhaseToRayEquivalent(self, value: bool) -> None: ...
    @property
    def Unpolarized(self) -> bool: ...
    @Unpolarized.setter
    def Unpolarized(self, value: bool) -> None: ...
    @property
    def Jx(self) -> float: ...
    @Jx.setter
    def Jx(self, value: float) -> None: ...
    @property
    def Jy(self) -> float: ...
    @Jy.setter
    def Jy(self, value: float) -> None: ...
    @property
    def XPhase(self) -> float: ...
    @XPhase.setter
    def XPhase(self, value: float) -> None: ...
    @property
    def YPhase(self) -> float: ...
    @YPhase.setter
    def YPhase(self, value: float) -> None: ...
    @property
    def Method(self) -> PolarizationMethod: ...
    @Method.setter
    def Method(self, value: PolarizationMethod) -> None: ...

class ISDRayAimingData:
    @property
    def RayAiming(self) -> RayAimingMethod: ...
    @RayAiming.setter
    def RayAiming(self, value: RayAimingMethod) -> None: ...
    @property
    def Method(self) -> RayAimingType: ...
    @Method.setter
    def Method(self, value: RayAimingType) -> None: ...
    @property
    def UseRayAimingCache(self) -> bool: ...
    @UseRayAimingCache.setter
    def UseRayAimingCache(self, value: bool) -> None: ...
    @property
    def UseRobustRayAiming(self) -> bool: ...
    @UseRobustRayAiming.setter
    def UseRobustRayAiming(self, value: bool) -> None: ...
    @property
    def ScalePupilShiftFactorsByField(self) -> bool: ...
    @ScalePupilShiftFactorsByField.setter
    def ScalePupilShiftFactorsByField(self, value: bool) -> None: ...
    @property
    def AutomaticallyCalculatePupilShiftsIsChecked(self) -> bool: ...
    @AutomaticallyCalculatePupilShiftsIsChecked.setter
    def AutomaticallyCalculatePupilShiftsIsChecked(self, value: bool) -> None: ...
    @property
    def UseEnhancedRayAiming(self) -> bool: ...
    @UseEnhancedRayAiming.setter
    def UseEnhancedRayAiming(self, value: bool) -> None: ...
    @property
    def UseAdvancedConvergence(self) -> bool: ...
    @UseAdvancedConvergence.setter
    def UseAdvancedConvergence(self, value: bool) -> None: ...
    @property
    def UseFallBackSearchDuringCacheSetup(self) -> bool: ...
    @UseFallBackSearchDuringCacheSetup.setter
    def UseFallBackSearchDuringCacheSetup(self, value: bool) -> None: ...
    @property
    def PupilShiftX(self) -> float: ...
    @PupilShiftX.setter
    def PupilShiftX(self, value: float) -> None: ...
    @property
    def PupilShiftY(self) -> float: ...
    @PupilShiftY.setter
    def PupilShiftY(self, value: float) -> None: ...
    @property
    def PupilShiftZ(self) -> float: ...
    @PupilShiftZ.setter
    def PupilShiftZ(self, value: float) -> None: ...
    @property
    def PupilCompressX(self) -> float: ...
    @PupilCompressX.setter
    def PupilCompressX(self, value: float) -> None: ...
    @property
    def PupilCompressY(self) -> float: ...
    @PupilCompressY.setter
    def PupilCompressY(self, value: float) -> None: ...
    @property
    def NumStepsCacheSetup(self) -> int: ...
    @NumStepsCacheSetup.setter
    def NumStepsCacheSetup(self, value: int) -> None: ...

class ISDTitleNotes:
    @property
    def Title(self) -> str: ...
    @Title.setter
    def Title(self, value: str) -> None: ...
    @property
    def Notes(self) -> str: ...
    @Notes.setter
    def Notes(self, value: str) -> None: ...
    @property
    def Author(self) -> str: ...
    @Author.setter
    def Author(self, value: str) -> None: ...

class ISDUnitsData:
    @property
    def LensUnits(self) -> ZemaxSystemUnits: ...
    @LensUnits.setter
    def LensUnits(self, value: ZemaxSystemUnits) -> None: ...
    @property
    def SourceUnitPrefix(self) -> ZemaxUnitPrefix: ...
    @SourceUnitPrefix.setter
    def SourceUnitPrefix(self, value: ZemaxUnitPrefix) -> None: ...
    @property
    def SourceUnits(self) -> ZemaxSourceUnits: ...
    @SourceUnits.setter
    def SourceUnits(self, value: ZemaxSourceUnits) -> None: ...
    @property
    def AnalysisUnitPrefix(self) -> ZemaxUnitPrefix: ...
    @AnalysisUnitPrefix.setter
    def AnalysisUnitPrefix(self, value: ZemaxUnitPrefix) -> None: ...
    @property
    def AnalysisUnits(self) -> ZemaxAnalysisUnits: ...
    @AnalysisUnits.setter
    def AnalysisUnits(self, value: ZemaxAnalysisUnits) -> None: ...
    @property
    def AfocalModeUnits(self) -> ZemaxAfocalModeUnits: ...
    @AfocalModeUnits.setter
    def AfocalModeUnits(self, value: ZemaxAfocalModeUnits) -> None: ...
    @property
    def MTFUnits(self) -> ZemaxMTFUnits: ...
    @MTFUnits.setter
    def MTFUnits(self, value: ZemaxMTFUnits) -> None: ...

class ISurfaceSelection:
    @property
    def FirstAllowedSurface(self) -> int: ...
    @property
    def LastAllowedSurface(self) -> int: ...
    @property
    def ImageSurface(self) -> int: ...
    @property
    def StopSurface(self) -> int: ...
    def GetSelectedSurface(self) -> int: ...
    def SetSelectedSurface(self, Surface: int) -> bool: ...
    def UseImageSurface(self) -> bool: ...
    def UseObjectSurface(self) -> bool: ...
    def UseStopSurface(self) -> bool: ...

class ISystemData:
    @property
    def Aperture(self) -> ISDApertureData: ...
    @property
    def Wavelengths(self) -> IWavelengths: ...
    @property
    def Fields(self) -> IFields: ...
    @property
    def Environment(self) -> ISDEnvironmentData: ...
    @property
    def Polarization(self) -> ISDPolarizationData: ...
    @property
    def Advanced(self) -> ISDAdvancedData: ...
    @property
    def RayAiming(self) -> ISDRayAimingData: ...
    @property
    def MaterialCatalogs(self) -> ISDMaterialCatalogData: ...
    @property
    def TitleNotes(self) -> ISDTitleNotes: ...
    @property
    def Files(self) -> ISDFiles: ...
    @property
    def Units(self) -> ISDUnitsData: ...
    @property
    def NonSequentialData(self) -> ISDNonSeqData: ...
    @property
    def NamedFiltersData(self) -> ISDNamedFilters: ...

class IWavelength:
    @property
    def WavelengthNumber(self) -> int: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def IsPrimary(self) -> bool: ...
    @property
    def Wavelength(self) -> float: ...
    @Wavelength.setter
    def Wavelength(self, value: float) -> None: ...
    @property
    def Weight(self) -> float: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...
    def MakePrimary(self) -> None: ...

class IWavelengths:
    @property
    def NumberOfWavelengths(self) -> int: ...
    def AddWavelength(self, Wavelength: float, Weight: float) -> IWavelength: ...
    def GaussianQuadrature(self, minWave: float, maxWave: float, numSteps: QuadratureSteps) -> bool: ...
    def GetWavelength(self, position: int) -> IWavelength: ...
    def RemoveWavelength(self, position: int) -> bool: ...
    def SelectWavelengthPreset(self, preset: WavelengthPreset) -> bool: ...

class ParaxialRaysSetting:
    ConsiderCoordinateBreaks = 0
    IgnoreCoordinateBreaks = 1

class PolarizationMethod:
    XAxisMethod = 0
    YAxisMethod = 1
    ZAxisMethod = 2

class QuadratureSteps:
    S2 = 0
    S4 = 1
    S6 = 2
    S8 = 3
    S10 = 4
    S12 = 5

class RayAimingMethod:
    Off = 0
    Paraxial = 1
    Real = 2

class RayAimingType:
    Heuristic = 0
    Optimize = 1

class ReferenceOPDSetting:
    Absolute = 0
    Infinity = 1
    ExitPupil = 2
    Absolute2 = 3

class WavelengthPreset:
    FdC_Visible = 0
    Photopic_Bright = 1
    Scotopic_Dark = 2
    HeNe_0p6328 = 3
    HeNe_0p5438 = 4
    Argon_0p4880 = 5
    Argon_0p5145 = 6
    NDYAG_1p0641 = 7
    NDGlass_1p054 = 8
    CO2_10p60 = 9
    CrLiSAF_0p840 = 10
    TiAl203_0p760 = 11
    Ruby_0p6943 = 12
    HeCadmium_0p4416 = 13
    HeCadmium_0p3536 = 14
    HeCadmium_0p3250 = 15
    t_1p014 = 16
    r_0p707 = 17
    C_0p656 = 18
    d_0p587 = 19
    F_0p486 = 20
    g_0p436 = 21
    i_0p365 = 22
    Fp_0p365 = 23
    e_0p54607 = 24
    Cp_0p6438469 = 25
    FpeCp_Visible = 26
    THz_193p10 = 27

class ZemaxAfocalModeUnits:
    Microradians = 0
    Milliradians = 1
    Radians = 2
    ArcSeconds = 3
    ArcMinutes = 4
    Degrees = 5

class ZemaxAnalysisUnits:
    WattsPerMMSq = 0
    WattsPerCMSq = 1
    WattsPerinSq = 2
    WattsPerMSq = 3
    WattsPerftSq = 4

class ZemaxApertureType:
    EntrancePupilDiameter = 0
    ImageSpaceFNum = 1
    ObjectSpaceNA = 2
    FloatByStopSize = 3
    ParaxialWorkingFNum = 4
    ObjectConeAngle = 5

class ZemaxApodizationType:
    Uniform = 0
    Gaussian = 1
    CosineCubed = 2

class ZemaxMTFUnits:
    CyclesPerMillimeter = 0
    CyclesPerMilliradian = 1

class ZemaxSourceUnits:
    Watts = 0
    Lumens = 1
    Joules = 2

class ZemaxSystemUnits:
    Millimeters = 0
    Centimeters = 1
    Inches = 2
    Meters = 3

class ZemaxUnitPrefix:
    Femto = 0
    Pico = 1
    Nano = 2
    Micro = 3
    Milli = 4
    # None = 5
    Kilo = 6
    Mega = 7
    Giga = 8
    Tera = 9
