# -*- coding: utf-8 -*-
'''
Display salt-key output
=======================

The ``salt-key`` command makes use of this outputter to format its output.
'''

# Import salt libs
import salt.utils
import salt.output


def output(data):
    '''
    Read in the dict structure generated by the salt key API methods and
    print the structure.
    '''
    color = salt.utils.get_colors(__opts__.get('color'))
    strip_colors = __opts__.get('strip_colors', True)
    if __opts__['transport'] == 'zeromq':
        acc = 'minions'
        pend = 'minions_pre'
        rej = 'minions_rejected'
    else:
        acc = 'accepted'
        pend = 'pending'
        rej = 'rejected'

    cmap = {pend: color['RED'],
            acc: color['GREEN'],
            rej: color['BLUE'],
            'local': color['PURPLE']}

    trans = {pend: '{0}Unaccepted Keys:{1}'.format(
                                color['LIGHT_RED'],
                                color['ENDC']),
             acc: '{0}Accepted Keys:{1}'.format(
                                color['LIGHT_GREEN'],
                                color['ENDC']),
             rej: '{0}Rejected Keys:{1}'.format(
                                color['LIGHT_BLUE'],
                                color['ENDC']),
             'local': '{0}Local Keys:{1}'.format(
                                color['LIGHT_PURPLE'],
                                color['ENDC'])}

    ret = ''

    for status in sorted(data):
        ret += '{0}\n'.format(trans[status])
        for key in data[status]:
            skey = key
            if strip_colors:
                skey = salt.output.strip_esc_sequence(key)
            if isinstance(data[status], list):
                ret += '{0}{1}{2}\n'.format(
                        cmap[status],
                        skey,
                        color['ENDC'])
            if isinstance(data[status], dict):
                ret += '{0}{1}:  {2}{3}\n'.format(
                        cmap[status],
                        skey,
                        data[status][key],
                        color['ENDC'])
    return ret
