import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#allow_tracing ApiManagementSubscription#allow_tracing}.
     *
     * @stability stable
     */
    readonly allowTracing?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#api_id ApiManagementSubscription#api_id}.
     *
     * @stability stable
     */
    readonly apiId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#api_management_name ApiManagementSubscription#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#display_name ApiManagementSubscription#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#primary_key ApiManagementSubscription#primary_key}.
     *
     * @stability stable
     */
    readonly primaryKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#product_id ApiManagementSubscription#product_id}.
     *
     * @stability stable
     */
    readonly productId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#resource_group_name ApiManagementSubscription#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#secondary_key ApiManagementSubscription#secondary_key}.
     *
     * @stability stable
     */
    readonly secondaryKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#state ApiManagementSubscription#state}.
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#subscription_id ApiManagementSubscription#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#user_id ApiManagementSubscription#user_id}.
     *
     * @stability stable
     */
    readonly userId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#timeouts ApiManagementSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#create ApiManagementSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#delete ApiManagementSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#read ApiManagementSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#update ApiManagementSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementSubscriptionTimeoutsToTerraform(struct?: ApiManagementSubscriptionTimeoutsOutputReference | ApiManagementSubscriptionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApiManagementSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementSubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription azurerm_api_management_subscription}.
 *
 * @stability stable
 */
export declare class ApiManagementSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription azurerm_api_management_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementSubscriptionConfig);
    private _allowTracing?;
    /**
     * @stability stable
     */
    get allowTracing(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowTracing(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowTracing(): void;
    /**
     * @stability stable
     */
    get allowTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _apiId?;
    /**
     * @stability stable
     */
    get apiId(): string;
    /**
     * @stability stable
     */
    set apiId(value: string);
    /**
     * @stability stable
     */
    resetApiId(): void;
    /**
     * @stability stable
     */
    get apiIdInput(): string | undefined;
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _primaryKey?;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    set primaryKey(value: string);
    /**
     * @stability stable
     */
    resetPrimaryKey(): void;
    /**
     * @stability stable
     */
    get primaryKeyInput(): string | undefined;
    private _productId?;
    /**
     * @stability stable
     */
    get productId(): string;
    /**
     * @stability stable
     */
    set productId(value: string);
    /**
     * @stability stable
     */
    resetProductId(): void;
    /**
     * @stability stable
     */
    get productIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _secondaryKey?;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    /**
     * @stability stable
     */
    set secondaryKey(value: string);
    /**
     * @stability stable
     */
    resetSecondaryKey(): void;
    /**
     * @stability stable
     */
    get secondaryKeyInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    resetSubscriptionId(): void;
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
