import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#amount ConsumptionBudgetManagementGroup#amount}.
     *
     * @stability stable
     */
    readonly amount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#etag ConsumptionBudgetManagementGroup#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#management_group_id ConsumptionBudgetManagementGroup#management_group_id}.
     *
     * @stability stable
     */
    readonly managementGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#time_grain ConsumptionBudgetManagementGroup#time_grain}.
     *
     * @stability stable
     */
    readonly timeGrain?: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#filter ConsumptionBudgetManagementGroup#filter}
     *
     * @stability stable
     */
    readonly filter?: ConsumptionBudgetManagementGroupFilter;
    /**
     * notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#notification ConsumptionBudgetManagementGroup#notification}
     *
     * @stability stable
     */
    readonly notification: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable;
    /**
     * time_period block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#time_period ConsumptionBudgetManagementGroup#time_period}
     *
     * @stability stable
     */
    readonly timePeriod: ConsumptionBudgetManagementGroupTimePeriod;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#timeouts ConsumptionBudgetManagementGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ConsumptionBudgetManagementGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupFilterDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterDimensionToTerraform(struct?: ConsumptionBudgetManagementGroupFilterDimension | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupFilterNotDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterNotDimensionToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference | ConsumptionBudgetManagementGroupFilterNotDimension): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetManagementGroupFilterNotDimension | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNotDimension | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupFilterNotTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterNotTagToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotTagOutputReference | ConsumptionBudgetManagementGroupFilterNotTag): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroupFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetManagementGroupFilterNotTag | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNotTag | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupFilterNot {
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#dimension ConsumptionBudgetManagementGroup#dimension}
     *
     * @stability stable
     */
    readonly dimension?: ConsumptionBudgetManagementGroupFilterNotDimension;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#tag ConsumptionBudgetManagementGroup#tag}
     *
     * @stability stable
     */
    readonly tag?: ConsumptionBudgetManagementGroupFilterNotTag;
}
export declare function consumptionBudgetManagementGroupFilterNotToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotOutputReference | ConsumptionBudgetManagementGroupFilterNot): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroupFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetManagementGroupFilterNot | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNot | undefined);
    private _dimension;
    /**
     * @stability stable
     */
    get dimension(): ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference;
    /**
     * @stability stable
     */
    putDimension(value: ConsumptionBudgetManagementGroupFilterNotDimension): void;
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): ConsumptionBudgetManagementGroupFilterNotDimension | undefined;
    private _tag;
    /**
     * @stability stable
     */
    get tag(): ConsumptionBudgetManagementGroupFilterNotTagOutputReference;
    /**
     * @stability stable
     */
    putTag(value: ConsumptionBudgetManagementGroupFilterNotTag): void;
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): ConsumptionBudgetManagementGroupFilterNotTag | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupFilterTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterTagToTerraform(struct?: ConsumptionBudgetManagementGroupFilterTag | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupFilter {
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#dimension ConsumptionBudgetManagementGroup#dimension}
     *
     * @stability stable
     */
    readonly dimension?: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable;
    /**
     * not block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#not ConsumptionBudgetManagementGroup#not}
     *
     * @stability stable
     */
    readonly not?: ConsumptionBudgetManagementGroupFilterNot;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#tag ConsumptionBudgetManagementGroup#tag}
     *
     * @stability stable
     */
    readonly tag?: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable;
}
export declare function consumptionBudgetManagementGroupFilterToTerraform(struct?: ConsumptionBudgetManagementGroupFilterOutputReference | ConsumptionBudgetManagementGroupFilter): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetManagementGroupFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetManagementGroupFilter | undefined);
    private _dimension?;
    /**
     * @stability stable
     */
    get dimension(): ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dimension(value: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupFilterDimension[] | undefined;
    private _not;
    /**
     * @stability stable
     */
    get not(): ConsumptionBudgetManagementGroupFilterNotOutputReference;
    /**
     * @stability stable
     */
    putNot(value: ConsumptionBudgetManagementGroupFilterNot): void;
    /**
     * @stability stable
     */
    resetNot(): void;
    /**
     * @stability stable
     */
    get notInput(): ConsumptionBudgetManagementGroupFilterNot | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupFilterTag[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupNotification {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#contact_emails ConsumptionBudgetManagementGroup#contact_emails}.
     *
     * @stability stable
     */
    readonly contactEmails: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#enabled ConsumptionBudgetManagementGroup#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#threshold ConsumptionBudgetManagementGroup#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#threshold_type ConsumptionBudgetManagementGroup#threshold_type}.
     *
     * @stability stable
     */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetManagementGroupNotificationToTerraform(struct?: ConsumptionBudgetManagementGroupNotification | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupTimePeriod {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#end_date ConsumptionBudgetManagementGroup#end_date}.
     *
     * @stability stable
     */
    readonly endDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#start_date ConsumptionBudgetManagementGroup#start_date}.
     *
     * @stability stable
     */
    readonly startDate: string;
}
export declare function consumptionBudgetManagementGroupTimePeriodToTerraform(struct?: ConsumptionBudgetManagementGroupTimePeriodOutputReference | ConsumptionBudgetManagementGroupTimePeriod): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetManagementGroupTimePeriod | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetManagementGroupTimePeriod | undefined);
    private _endDate?;
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    set endDate(value: string);
    /**
     * @stability stable
     */
    resetEndDate(): void;
    /**
     * @stability stable
     */
    get endDateInput(): string | undefined;
    private _startDate?;
    /**
     * @stability stable
     */
    get startDate(): string;
    /**
     * @stability stable
     */
    set startDate(value: string);
    /**
     * @stability stable
     */
    get startDateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetManagementGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#create ConsumptionBudgetManagementGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#delete ConsumptionBudgetManagementGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#read ConsumptionBudgetManagementGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#update ConsumptionBudgetManagementGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function consumptionBudgetManagementGroupTimeoutsToTerraform(struct?: ConsumptionBudgetManagementGroupTimeoutsOutputReference | ConsumptionBudgetManagementGroupTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetManagementGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetManagementGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group azurerm_consumption_budget_management_group}.
 *
 * @stability stable
 */
export declare class ConsumptionBudgetManagementGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group azurerm_consumption_budget_management_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetManagementGroupConfig);
    private _amount?;
    /**
     * @stability stable
     */
    get amount(): number;
    /**
     * @stability stable
     */
    set amount(value: number);
    /**
     * @stability stable
     */
    get amountInput(): number | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    set etag(value: string);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _managementGroupId?;
    /**
     * @stability stable
     */
    get managementGroupId(): string;
    /**
     * @stability stable
     */
    set managementGroupId(value: string);
    /**
     * @stability stable
     */
    get managementGroupIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeGrain?;
    /**
     * @stability stable
     */
    get timeGrain(): string;
    /**
     * @stability stable
     */
    set timeGrain(value: string);
    /**
     * @stability stable
     */
    resetTimeGrain(): void;
    /**
     * @stability stable
     */
    get timeGrainInput(): string | undefined;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): ConsumptionBudgetManagementGroupFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: ConsumptionBudgetManagementGroupFilter): void;
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): ConsumptionBudgetManagementGroupFilter | undefined;
    private _notification?;
    /**
     * @stability stable
     */
    get notification(): ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set notification(value: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get notificationInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupNotification[] | undefined;
    private _timePeriod;
    /**
     * @stability stable
     */
    get timePeriod(): ConsumptionBudgetManagementGroupTimePeriodOutputReference;
    /**
     * @stability stable
     */
    putTimePeriod(value: ConsumptionBudgetManagementGroupTimePeriod): void;
    /**
     * @stability stable
     */
    get timePeriodInput(): ConsumptionBudgetManagementGroupTimePeriod | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ConsumptionBudgetManagementGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ConsumptionBudgetManagementGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ConsumptionBudgetManagementGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
